/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.tree.node;

import java.sql.Connection;
import java.text.Collator;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.integrator.disco.DiscoODMrGateway;

public class FolderNodeData
extends NodeData {
    public static final String CONNECTION = "CONNECTION";
    public static final String MODELS = "MODELS";
    public static final String ASSOCIATION_RULES_MODELS = "ASSOCIATION_RULES_MODELS";
    public static final String ATTRIBUTE_IMPORTANCE_MODELS = "ATTRIBUTE_IMPORTANCE_MODELS";
    public static final String CLASSIFICATION_MODELS = "CLASSIFICATION_MODELS";
    public static final String REGRESSION_MODELS = "REGRESSION_MODELS";
    public static final String FEATURE_EXTRACTION_MODELS = "FEATURE_EXTRACTION_MODELS";
    public static final String CLUSTERING_MODELS = "CLUSTERING_MODELS";
    public static final String ANOMALY_DETECTION_MODELS = "ANOMALY_DETECTION_MODELS";
    public static final String RESULTS = "RESULTS";
    public static final String BUILD_RESULTS = "BUILD_RESULTS";
    public static final String TEST_METRICS_RESULTS = "TEST_METRICS_RESULTS";
    public static final String APPLY_RESULTS = "APPLY_RESULTS";
    public static final String RESIDUAL_PLOT_RESULTS = "RESIDUAL_PLOT_RESULTS";
    public static final String PREDICT_RESULTS = "PREDICT_RESULTS";
    public static final String EXPLAIN_RESULTS = "EXPLAIN_RESULTS";
    public static final String SETTINGS = "SETTINGS";
    public static final String ASSOCIATION_RULES_SETTINGS = "ASSOCIATION_RULES_SETTINGS";
    public static final String ATTRIBUTE_IMPORTANCE_SETTINGS = "ATTRIBUTE_IMPORTANCE_SETTINGS";
    public static final String CLASSIFICATION_SETTINGS = "CLASSIFICATION_SETTINGS";
    public static final String REGRESSION_SETTINGS = "REGRESSION_SETTINGS";
    public static final String FEATURE_EXTRACTION_SETTINGS = "FEATURE_EXTRACTION_SETTINGS";
    public static final String CLUSTERING_SETTINGS = "CLUSTERING_SETTINGS";
    public static final String SCHEMAS = "SCHEMAS";
    public static final String SCHEMA = "SCHEMA";
    public static final String SCHEMA_TABLES = "TABLES_SCHEMA";
    public static final String SCHEMA_VIEWS = "VIEWS_SCHEMA";
    public static final String ACTIVITIES = "ACTIVITIES";
    public static final String ASSOCIATION_RULES_ACTIVITIES = "ASSOCIATION_RULES_ACTIVITIES";
    public static final String ATTRIBUTE_IMPORTANCE_ACTIVITIES = "ATTRIBUTE_IMPORTANCE_ACTIVITIES";
    public static final String CLASSIFICATION_ACTIVITIES = "CLASSIFICATION_ACTIVITIES";
    public static final String REGRESSION_ACTIVITIES = "REGRESSION_ACTIVITIES";
    public static final String FEATURE_EXTRACTION_ACTIVITIES = "FEATURE_EXTRACTION_ACTIVITIES";
    public static final String CLUSTERING_ACTIVITIES = "CLUSTERING_ACTIVITIES";
    public static final String ANOMALY_DETECTION_ACTIVITIES = "ANOMALY_DETECTION_ACTIVITIES";
    public static final String DISCOGW = "DISCOGW";

    public FolderNodeData(String string, String string2) throws Exception {
        super(string, string2);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        this.m_expandedIcon = this.m_icon = this.getIconResource(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void expandNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        String[] stringArray;
        Object object;
        FolderNodeData folderNodeData = (FolderNodeData)defaultMutableTreeNode.getUserObject();
        String string2 = folderNodeData.getNodeType();
        Connection connection = null;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        if (defaultMutableTreeNode.getChildCount() > 0 && (object = (stringArray = (String[])defaultMutableTreeNode.getFirstChild()).getUserObject()) instanceof Boolean) {
            defaultMutableTreeNode.remove((MutableTreeNode)stringArray);
        }
        try {
            connection = DM4JConnectionManager.getDbConnection();
        }
        catch (Exception exception) {
            object = dM4JListResourceBundle.getString("DMS_CONNECTION_NOCREATE");
            String string3 = dM4JListResourceBundle.getString("APPLICATION_TITLE");
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), object, string3, 0);
            exception.printStackTrace();
            return;
        }
        stringArray = null;
        object = Calendar.getInstance();
        ((Calendar)object).set(((Calendar)object).getMinimum(1), 1, 1);
        Date date = ((Calendar)object).getTime();
        ((Calendar)object).set(((Calendar)object).getMaximum(1), 1, 1);
        Date date2 = ((Calendar)object).getTime();
        if (string2.equals(ASSOCIATION_RULES_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "ASSOCIATION_RULES");
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "ASSOCIATION_RULES_MODEL");
        } else if (string2.equals(ATTRIBUTE_IMPORTANCE_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "ATTRIBUTE_IMPORTANCE");
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "ATTRIBUTE_IMPORTANCE_MODEL");
        } else if (string2.equals(CLASSIFICATION_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "ADAPTIVE_BAYES_NETWORK");
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "ABN_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "NAIVE_BAYES");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "NB_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "SUPPORT_VECTOR_MACHINES");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "SVM_CLASSIFICATION_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "DECISION_TREE");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "DT_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "GENERALIZED_LINEAR_MODEL");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "GLM_CLASSIFICATION_MODEL");
        } else if (string2.equals(REGRESSION_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "REGRESSION", "SUPPORT_VECTOR_MACHINES");
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "SVM_REGRESSION_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "REGRESSION", "GENERALIZED_LINEAR_MODEL");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "GLM_REGRESSION_MODEL");
        } else if (string2.equals(FEATURE_EXTRACTION_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "FEATURE_EXTRACTION");
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "NMF_MODEL");
        } else if (string2.equals(CLUSTERING_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "CLUSTERING", "KMEANS");
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "CLUSTERING_KMEANS_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "CLUSTERING", "O_CLUSTER");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "CLUSTERING_OCLUSTER_MODEL");
        } else if (string2.equals(ANOMALY_DETECTION_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "ANOMALY_DETECTION", "ONE_CLASS_SVM");
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "SVM_ONE_CLASS_MODEL");
        } else if (string2.equals(TEST_METRICS_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "TEST", string);
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "TEST_METRIC_RESULT");
        } else if (string2.equals(APPLY_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "APPLY", string);
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "APPLY_RESULT");
        } else if (string2.equals(RESIDUAL_PLOT_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "PLOT", string);
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "RESIDUAL_PLOT_RESULT");
        } else if (string2.equals(PREDICT_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "PRDCT", string);
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "PREDICT_RESULT");
        } else if (string2.equals(EXPLAIN_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "EXPLN", string);
            FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "EXPLAIN_RESULT");
        } else if (!(string2.equals(ASSOCIATION_RULES_SETTINGS) || string2.equals(ATTRIBUTE_IMPORTANCE_SETTINGS) || string2.equals(CLASSIFICATION_SETTINGS) || string2.equals(REGRESSION_SETTINGS) || string2.equals(FEATURE_EXTRACTION_SETTINGS) || string2.equals(CLUSTERING_SETTINGS))) {
            if (string2.equals(SCHEMAS)) {
                Vector vector = DatabaseMetadata.getAccessibleSchemas(connection);
                stringArray = new String[]{};
                stringArray = vector.toArray(stringArray);
                FolderNodeData.addSchemasToFolder(defaultMutableTreeNode, stringArray, SCHEMA);
            } else if (string2.equals(SCHEMA_TABLES)) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                FolderNodeData folderNodeData2 = (FolderNodeData)defaultMutableTreeNode2.getUserObject();
                String string4 = folderNodeData2.getName();
                Vector vector = DatabaseMetadata.getAccessableTables(connection, string4);
                stringArray = new String[]{};
                stringArray = vector.toArray(stringArray);
                FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "TABLE");
            } else if (string2.equals(SCHEMA_VIEWS)) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                FolderNodeData folderNodeData3 = (FolderNodeData)defaultMutableTreeNode3.getUserObject();
                String string5 = folderNodeData3.getName();
                stringArray = new String[]{};
                Vector vector = DatabaseMetadata.getAccessableViews(connection, string5);
                stringArray = vector.toArray(stringArray);
                FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "VIEW");
            } else if (string2.equals(ASSOCIATION_RULES_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.ASSOCIATION_RULES};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "ASSOCIATION_RULES_ACTIVITY");
            } else if (string2.equals(ATTRIBUTE_IMPORTANCE_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.ATTRIBUTE_IMPORTANCE};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "ATTRIBUTE_IMPORTANCE_ACTIVITY");
            } else if (string2.equals(CLASSIFICATION_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.DECISION_TREE, ActivityType.ADAPTIVE_NAIVE_BAYES, ActivityType.NAIVE_BAYES, ActivityType.SVM_CLASSIFICATION, ActivityType.GLM_CLASSIFICATION};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "CLASSIFICATION_ACTIVITY");
                ActivityType[] activityTypeArray2 = new ActivityType[]{ActivityType.DECISION_TREE_APPLY, ActivityType.ADAPTIVE_NAIVE_BAYES_APPLY, ActivityType.NAIVE_BAYES_APPLY, ActivityType.SVM_CLASSIFICATION_APPLY, ActivityType.GLM_CLASSIFICATION_APPLY};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray2);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "CLASSIFICATION_ACTIVITY_APPLY");
                ActivityType[] activityTypeArray3 = new ActivityType[]{ActivityType.DECISION_TREE_TEST, ActivityType.ADAPTIVE_NAIVE_BAYES_TEST, ActivityType.NAIVE_BAYES_TEST, ActivityType.SVM_CLASSIFICATION_TEST, ActivityType.GLM_CLASSIFICATION_TEST};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray3);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "CLASSIFICATION_ACTIVITY_TEST");
            } else if (string2.equals(REGRESSION_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.SVM_REGRESSION, ActivityType.GLM_REGRESSION};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "REGRESSION_ACTIVITY");
                ActivityType[] activityTypeArray4 = new ActivityType[]{ActivityType.SVM_REGRESSION_APPLY, ActivityType.GLM_REGRESSION_APPLY};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray4);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "REGRESSION_ACTIVITY_APPLY");
                ActivityType[] activityTypeArray5 = new ActivityType[]{ActivityType.SVM_REGRESSION_TEST, ActivityType.GLM_REGRESSION_TEST};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray5);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "REGRESSION_ACTIVITY_TEST");
            } else if (string2.equals(FEATURE_EXTRACTION_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "FEATURE_EXTRACTION_ACTIVITY");
                ActivityType[] activityTypeArray6 = new ActivityType[]{ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION_APPLY};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray6);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "FEATURE_EXTRACTION_ACTIVITY_APPLY");
            } else if (string2.equals(CLUSTERING_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.K_MEANS_CLUSTER, ActivityType.O_CLUSTER};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "CLUSTERING_ACTIVITY");
                ActivityType[] activityTypeArray7 = new ActivityType[]{ActivityType.K_MEANS_CLUSTER_APPLY, ActivityType.O_CLUSTER_APPLY};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray7);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "CLUSTERING_ACTIVITY_APPLY");
            } else if (string2.equals(ANOMALY_DETECTION_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.SVM_SINGLE_CLASS};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "ANOMALY_DETECTION_ACTIVITY");
                ActivityType[] activityTypeArray8 = new ActivityType[]{ActivityType.SVM_SINGLE_CLASS_APPLY};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray8);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "ANOMALY_DETECTION_ACTIVITY_APPLY");
            } else if (string2.equals(DISCOGW)) {
                Vector vector = DiscoODMrGateway.getGWObjectsList(connection);
                stringArray = new String[]{};
                stringArray = vector.toArray(stringArray);
                FolderNodeData.reloadFolder(defaultMutableTreeNode, stringArray, "DISCOGWOBJ");
            }
        }
        folderNodeData.updateTimestamp();
        Object var16_38 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("ERROR_LIST_FOLDER"), DM4JVersion.getFullBrowserName(), 0);
                exception.printStackTrace();
                Object var16_39 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var16_40 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void expandNodeOLD(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        String[] stringArray;
        Object object;
        FolderNodeData folderNodeData = (FolderNodeData)defaultMutableTreeNode.getUserObject();
        String string2 = folderNodeData.getNodeType();
        Connection connection = null;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        if (defaultMutableTreeNode.getChildCount() > 0 && (object = (stringArray = (String[])defaultMutableTreeNode.getFirstChild()).getUserObject()) instanceof Boolean) {
            defaultMutableTreeNode.remove((MutableTreeNode)stringArray);
        }
        try {
            connection = DM4JConnectionManager.getDbConnection();
        }
        catch (Exception exception) {
            object = dM4JListResourceBundle.getString("DMS_CONNECTION_NOCREATE");
            String string3 = dM4JListResourceBundle.getString("APPLICATION_TITLE");
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), object, string3, 0);
            exception.printStackTrace();
            return;
        }
        stringArray = null;
        object = Calendar.getInstance();
        ((Calendar)object).set(((Calendar)object).getMinimum(1), 1, 1);
        Date date = ((Calendar)object).getTime();
        ((Calendar)object).set(((Calendar)object).getMaximum(1), 1, 1);
        Date date2 = ((Calendar)object).getTime();
        if (string2.equals(ASSOCIATION_RULES_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "ASSOCIATION_RULES");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "ASSOCIATION_RULES_MODEL");
        } else if (string2.equals(ATTRIBUTE_IMPORTANCE_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "ATTRIBUTE_IMPORTANCE");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "ATTRIBUTE_IMPORTANCE_MODEL");
        } else if (string2.equals(CLASSIFICATION_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "ADAPTIVE_BAYES_NETWORK");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "ABN_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "NAIVE_BAYES");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "NB_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "SUPPORT_VECTOR_MACHINES");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "SVM_CLASSIFICATION_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "DECISION_TREE");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "DT_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "CLASSIFICATION", "GENERALIZED_LINEAR_MODEL");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "GLM_CLASSIFICATION_MODEL");
        } else if (string2.equals(REGRESSION_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "REGRESSION", "SUPPORT_VECTOR_MACHINES");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "SVM_REGRESSION_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "REGRESSION", "GENERALIZED_LINEAR_MODEL");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "GLM_REGRESSION_MODEL");
        } else if (string2.equals(FEATURE_EXTRACTION_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "FEATURE_EXTRACTION");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "NMF_MODEL");
        } else if (string2.equals(CLUSTERING_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "CLUSTERING", "KMEANS");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "CLUSTERING_KMEANS_MODEL");
            stringArray = dMEMetadata.getModelNames(connection, "CLUSTERING", "O_CLUSTER");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "CLUSTERING_OCLUSTER_MODEL");
        } else if (string2.equals(ANOMALY_DETECTION_MODELS)) {
            stringArray = dMEMetadata.getModelNames(connection, "ANOMALY_DETECTION", "ONE_CLASS_SVM");
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "SVM_ONE_CLASS_MODEL");
        } else if (string2.equals(TEST_METRICS_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "TEST", string);
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "TEST_METRIC_RESULT");
        } else if (string2.equals(APPLY_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "APPLY", string);
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "APPLY_RESULT");
        } else if (string2.equals(RESIDUAL_PLOT_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "PLOT", string);
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "RESIDUAL_PLOT_RESULT");
        } else if (string2.equals(PREDICT_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "PRDCT", string);
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "PREDICT_RESULT");
        } else if (string2.equals(EXPLAIN_RESULTS)) {
            stringArray = dMEMetadata.getResultNames(connection, "EXPLN", string);
            FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "EXPLAIN_RESULT");
        } else if (!(string2.equals(ASSOCIATION_RULES_SETTINGS) || string2.equals(ATTRIBUTE_IMPORTANCE_SETTINGS) || string2.equals(CLASSIFICATION_SETTINGS) || string2.equals(REGRESSION_SETTINGS) || string2.equals(FEATURE_EXTRACTION_SETTINGS) || string2.equals(CLUSTERING_SETTINGS))) {
            if (string2.equals(SCHEMAS)) {
                Vector vector = DatabaseMetadata.getAccessibleSchemas(connection);
                stringArray = new String[]{};
                stringArray = vector.toArray(stringArray);
                FolderNodeData.addSchemasToFolder(defaultMutableTreeNode, stringArray, SCHEMA);
            } else if (string2.equals(SCHEMA_TABLES)) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                FolderNodeData folderNodeData2 = (FolderNodeData)defaultMutableTreeNode2.getUserObject();
                String string4 = folderNodeData2.getName();
                Vector vector = DatabaseMetadata.getAccessableTables(connection, string4);
                stringArray = new String[]{};
                stringArray = vector.toArray(stringArray);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "TABLE");
            } else if (string2.equals(SCHEMA_VIEWS)) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                FolderNodeData folderNodeData3 = (FolderNodeData)defaultMutableTreeNode3.getUserObject();
                String string5 = folderNodeData3.getName();
                stringArray = new String[]{};
                Vector vector = DatabaseMetadata.getAccessableViews(connection, string5);
                stringArray = vector.toArray(stringArray);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "VIEW");
            } else if (string2.equals(ASSOCIATION_RULES_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.ASSOCIATION_RULES};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "ASSOCIATION_RULES_ACTIVITY");
            } else if (string2.equals(ATTRIBUTE_IMPORTANCE_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.ATTRIBUTE_IMPORTANCE};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "ATTRIBUTE_IMPORTANCE_ACTIVITY");
            } else if (string2.equals(CLASSIFICATION_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.DECISION_TREE, ActivityType.ADAPTIVE_NAIVE_BAYES, ActivityType.NAIVE_BAYES, ActivityType.SVM_CLASSIFICATION, ActivityType.GLM_CLASSIFICATION};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "CLASSIFICATION_ACTIVITY");
                ActivityType[] activityTypeArray2 = new ActivityType[]{ActivityType.DECISION_TREE_APPLY, ActivityType.ADAPTIVE_NAIVE_BAYES_APPLY, ActivityType.NAIVE_BAYES_APPLY, ActivityType.SVM_CLASSIFICATION_APPLY, ActivityType.GLM_CLASSIFICATION_APPLY};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray2);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "CLASSIFICATION_ACTIVITY_APPLY");
                ActivityType[] activityTypeArray3 = new ActivityType[]{ActivityType.DECISION_TREE_TEST, ActivityType.ADAPTIVE_NAIVE_BAYES_TEST, ActivityType.NAIVE_BAYES_TEST, ActivityType.SVM_CLASSIFICATION_TEST, ActivityType.GLM_CLASSIFICATION_TEST};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray3);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "CLASSIFICATION_ACTIVITY_TEST");
            } else if (string2.equals(REGRESSION_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.SVM_REGRESSION, ActivityType.GLM_REGRESSION};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "REGRESSION_ACTIVITY");
                ActivityType[] activityTypeArray4 = new ActivityType[]{ActivityType.SVM_REGRESSION_APPLY, ActivityType.GLM_REGRESSION_APPLY};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray4);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "REGRESSION_ACTIVITY_APPLY");
                ActivityType[] activityTypeArray5 = new ActivityType[]{ActivityType.SVM_REGRESSION_TEST, ActivityType.GLM_REGRESSION_TEST};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray5);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "REGRESSION_ACTIVITY_TEST");
            } else if (string2.equals(FEATURE_EXTRACTION_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "FEATURE_EXTRACTION_ACTIVITY");
                ActivityType[] activityTypeArray6 = new ActivityType[]{ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION_APPLY};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray6);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "FEATURE_EXTRACTION_ACTIVITY_APPLY");
            } else if (string2.equals(CLUSTERING_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.K_MEANS_CLUSTER, ActivityType.O_CLUSTER};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "CLUSTERING_ACTIVITY");
                ActivityType[] activityTypeArray7 = new ActivityType[]{ActivityType.K_MEANS_CLUSTER_APPLY, ActivityType.O_CLUSTER_APPLY};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray7);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "CLUSTERING_ACTIVITY_APPLY");
            } else if (string2.equals(ANOMALY_DETECTION_ACTIVITIES)) {
                ActivityType[] activityTypeArray = new ActivityType[]{ActivityType.SVM_SINGLE_CLASS};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "ANOMALY_DETECTION_ACTIVITY");
                ActivityType[] activityTypeArray8 = new ActivityType[]{ActivityType.SVM_SINGLE_CLASS_APPLY};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray8);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "ANOMALY_DETECTION_ACTIVITY_APPLY");
            } else if (string2.equals(DISCOGW)) {
                Vector vector = DiscoODMrGateway.getGWObjectsList(connection);
                stringArray = new String[]{};
                stringArray = vector.toArray(stringArray);
                FolderNodeData.addToFolder(defaultMutableTreeNode, stringArray, "DISCOGWOBJ");
            }
        }
        folderNodeData.updateTimestamp();
        Object var16_38 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("ERROR_LIST_FOLDER"), DM4JVersion.getFullBrowserName(), 0);
                exception.printStackTrace();
                Object var16_39 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var16_40 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static void insertNoCheck(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2) {
        try {
            LeafNodeData leafNodeData = new LeafNodeData(string, string2);
            if (string2.equals("VIEW") || string2.equals("TABLE")) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                String string3 = ((FolderNodeData)defaultMutableTreeNode2.getUserObject()).getName();
                leafNodeData.setSchemaName(string3);
            }
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(leafNodeData));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void insert(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2) {
        try {
            LeafNodeData leafNodeData = new LeafNodeData(string, string2);
            if (string2.equals("VIEW") || string2.equals("TABLE")) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                String string3 = ((FolderNodeData)defaultMutableTreeNode2.getUserObject()).getName();
                leafNodeData.setSchemaName(string3);
            }
            int n = 0;
            boolean bl = false;
            Collator collator = Collator.getInstance();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                Object object = defaultMutableTreeNode3.getUserObject();
                LeafNodeData leafNodeData2 = (LeafNodeData)object;
                String string4 = leafNodeData2.getName();
                if (collator.compare(string4, string) >= 0) {
                    defaultMutableTreeNode.insert(new DefaultMutableTreeNode(leafNodeData), n);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(leafNodeData));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void insertSchemaFolder(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        try {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new FolderNodeData(string, string2));
            int n = 0;
            boolean bl = false;
            Object var7_8 = null;
            Collator collator = Collator.getInstance();
            Object object = defaultMutableTreeNode.children();
            while (object.hasMoreElements()) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)object.nextElement();
                Object object2 = defaultMutableTreeNode2.getUserObject();
                FolderNodeData folderNodeData = (FolderNodeData)object2;
                String string3 = folderNodeData.getName();
                if (collator.compare(string3, string) >= 0) {
                    defaultMutableTreeNode.insert(defaultMutableTreeNode3, n);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                defaultMutableTreeNode.add(defaultMutableTreeNode3);
            }
            object = new DefaultMutableTreeNode(new FolderNodeData(dM4JListResourceBundle.getString("TREE_SCHEMA_TABLES"), SCHEMA_TABLES));
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new FolderNodeData(dM4JListResourceBundle.getString("TREE_SCHEMA_VIEWS"), SCHEMA_VIEWS));
            ((NodeData)((DefaultMutableTreeNode)object).getUserObject()).setSchemaName(string);
            ((NodeData)defaultMutableTreeNode2.getUserObject()).setSchemaName(string);
            ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(new Boolean(true)));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new Boolean(true)));
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            defaultMutableTreeNode3.add((MutableTreeNode)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void addToFolder(DefaultMutableTreeNode defaultMutableTreeNode, String[] stringArray, String string) {
        int n;
        int n2 = stringArray != null ? stringArray.length : 0;
        Vector<String> vector = new Vector<String>(n2);
        for (int i = 0; i < n2; ++i) {
            vector.add(stringArray[i]);
        }
        Vector<DefaultMutableTreeNode> vector2 = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode2.getUserObject();
            LeafNodeData leafNodeData = (LeafNodeData)object;
            String string2 = leafNodeData.getName();
            String string3 = leafNodeData.getNodeType();
            if (!string3.equals(string)) continue;
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                if (string2.compareToIgnoreCase(stringArray[i]) != 0) continue;
                bl = true;
                vector.remove(stringArray[i]);
                break;
            }
            if (bl) continue;
            vector2.add(defaultMutableTreeNode2);
        }
        int n3 = vector2.size();
        for (n = 0; n < n3; ++n) {
            defaultMutableTreeNode.remove((DefaultMutableTreeNode)vector2.elementAt(n));
        }
        n3 = vector.size();
        for (n = 0; n < n3; ++n) {
            FolderNodeData.insertNoCheck(defaultMutableTreeNode, (String)vector.elementAt(n), string);
        }
    }

    private static void reloadFolder(DefaultMutableTreeNode defaultMutableTreeNode, String[] stringArray, String string) {
        int n;
        int n2 = stringArray != null ? stringArray.length : 0;
        Vector<String> vector = new Vector<String>(n2);
        for (int i = 0; i < n2; ++i) {
            vector.add(stringArray[i]);
        }
        Vector<DefaultMutableTreeNode> vector2 = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            vector2.add(defaultMutableTreeNode2);
        }
        int n3 = vector2.size();
        for (n = 0; n < n3; ++n) {
            defaultMutableTreeNode.remove((DefaultMutableTreeNode)vector2.elementAt(n));
        }
        n3 = vector.size();
        for (n = 0; n < n3; ++n) {
            FolderNodeData.insertNoCheck(defaultMutableTreeNode, (String)vector.elementAt(n), string);
        }
    }

    private static void addSchemasToFolder(DefaultMutableTreeNode defaultMutableTreeNode, String[] stringArray, String string) {
        int n;
        int n2 = stringArray != null ? stringArray.length : 0;
        Vector<String> vector = new Vector<String>(n2);
        for (int i = 0; i < n2; ++i) {
            vector.add(stringArray[i]);
        }
        Vector<DefaultMutableTreeNode> vector2 = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode2.getUserObject();
            FolderNodeData folderNodeData = (FolderNodeData)object;
            String string2 = folderNodeData.getName();
            String string3 = folderNodeData.getNodeType();
            if (!string3.equals(string)) continue;
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                if (string2.compareToIgnoreCase(stringArray[i]) != 0) continue;
                bl = true;
                vector.remove(stringArray[i]);
                break;
            }
            if (bl) continue;
            vector2.add(defaultMutableTreeNode2);
        }
        int n3 = vector2.size();
        for (n = 0; n < n3; ++n) {
            defaultMutableTreeNode.remove((DefaultMutableTreeNode)vector2.elementAt(n));
        }
        n3 = vector.size();
        for (n = 0; n < n3; ++n) {
            FolderNodeData.insertSchemaFolder(defaultMutableTreeNode, (String)vector.elementAt(n), string);
        }
    }

    public static void refresh(DefaultTreeModel defaultTreeModel) {
        FolderNodeData.refresh(defaultTreeModel, null);
    }

    public static void refresh(DefaultTreeModel defaultTreeModel, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        Object object = defaultMutableTreeNode.getUserObject();
        FolderNodeData folderNodeData = (FolderNodeData)object;
        String string2 = null;
        if (folderNodeData.getNodeType().compareTo(RESULTS) == 0) {
            string2 = folderNodeData.getName();
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            FolderNodeData folderNodeData2;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object2 = defaultMutableTreeNode2.getUserObject();
            if (!(object2 instanceof FolderNodeData) || !(folderNodeData2 = (FolderNodeData)object2).isLeafContainer() || string != null && folderNodeData2.getNodeType().compareTo(string) != 0) continue;
            if (defaultMutableTreeNode2.getChildCount() > 0) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild();
                object2 = defaultMutableTreeNode3.getUserObject();
                if (object2 instanceof Boolean) continue;
                FolderNodeData.expandNode(defaultMutableTreeNode2, string2);
                defaultTreeModel.reload(defaultMutableTreeNode2);
                continue;
            }
            FolderNodeData.expandNode(defaultMutableTreeNode2, string2);
            defaultTreeModel.reload(defaultMutableTreeNode2);
        }
    }

    public static TreePath findComponent(DefaultTreeModel defaultTreeModel, String string, String string2, boolean bl) {
        TreePath treePath = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        Object object = defaultMutableTreeNode.getUserObject();
        FolderNodeData folderNodeData = (FolderNodeData)object;
        String string3 = null;
        String string4 = string2 = DM4JStringUtils.isDoubleQuotedString(string2) ? DM4JStringUtils.trimDoubleQuotes(string2) : string2;
        if (folderNodeData.getNodeType().compareTo(RESULTS) == 0) {
            string3 = folderNodeData.getName();
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            Object object2;
            NodeData nodeData;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object3 = defaultMutableTreeNode2.getUserObject();
            if (string.equals("TASKS") || string.equals("BUILD_TASK") || string.equals("APPLY_TASK") || string.equals("TEST_TASK") || string.equals("LIFT_TASK")) {
                if (!(object3 instanceof LeafNodeData) || !(nodeData = (LeafNodeData)object3).getNodeType().equals("TASKS")) continue;
                treePath = new TreePath(defaultMutableTreeNode2.getPath());
                break;
            }
            if (!(object3 instanceof FolderNodeData) || !(nodeData = (FolderNodeData)object3).getNodeType().equals(FolderNodeData.getFolderType(string))) continue;
            if (bl) {
                FolderNodeData.expandNode(defaultMutableTreeNode2, string3);
                defaultTreeModel.reload(defaultMutableTreeNode2);
            } else if (defaultMutableTreeNode2.getChildCount() > 0 && (object3 = ((DefaultMutableTreeNode)(object2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild())).getUserObject()) instanceof Boolean) {
                FolderNodeData.expandNode(defaultMutableTreeNode2, string3);
                defaultTreeModel.reload(defaultMutableTreeNode2);
            }
            object2 = defaultMutableTreeNode2.breadthFirstEnumeration();
            while (object2.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)object2.nextElement();
                object3 = defaultMutableTreeNode3.getUserObject();
                nodeData = (NodeData)object3;
                if (!nodeData.getName().equals(string2)) continue;
                treePath = new TreePath(defaultMutableTreeNode3.getPath());
                break;
            }
            return treePath;
        }
        return treePath;
    }

    public static TreePath findComponentOld(DefaultTreeModel defaultTreeModel, String string, String string2, boolean bl) {
        TreePath treePath = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        Object object = defaultMutableTreeNode.getUserObject();
        FolderNodeData folderNodeData = (FolderNodeData)object;
        String string3 = null;
        String string4 = string2 = DM4JStringUtils.isDoubleQuotedString(string2) ? DM4JStringUtils.trimDoubleQuotes(string2) : string2;
        if (folderNodeData.getNodeType().compareTo(RESULTS) == 0) {
            string3 = folderNodeData.getName();
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            Object object2;
            NodeData nodeData;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object3 = defaultMutableTreeNode2.getUserObject();
            if (string.equals("TASKS") || string.equals("BUILD_TASK") || string.equals("APPLY_TASK") || string.equals("TEST_TASK") || string.equals("LIFT_TASK")) {
                if (!(object3 instanceof LeafNodeData) || !(nodeData = (LeafNodeData)object3).getNodeType().equals("TASKS")) continue;
                treePath = new TreePath(defaultMutableTreeNode2.getPath());
                break;
            }
            if (!(object3 instanceof FolderNodeData) || !(nodeData = (FolderNodeData)object3).getNodeType().equals(FolderNodeData.getFolderType(string))) continue;
            if (bl) {
                FolderNodeData.expandNode(defaultMutableTreeNode2, string3);
                defaultTreeModel.reload(defaultMutableTreeNode2);
            } else if (defaultMutableTreeNode2.getChildCount() > 0 && (object3 = ((DefaultMutableTreeNode)(object2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild())).getUserObject()) instanceof Boolean) {
                FolderNodeData.expandNode(defaultMutableTreeNode2, string3);
                defaultTreeModel.reload(defaultMutableTreeNode2);
            }
            object2 = defaultMutableTreeNode2.breadthFirstEnumeration();
            while (object2.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)object2.nextElement();
                object3 = defaultMutableTreeNode3.getUserObject();
                nodeData = (NodeData)object3;
                if (!nodeData.getName().equals(string2)) continue;
                treePath = new TreePath(defaultMutableTreeNode3.getPath());
                break;
            }
            return treePath;
        }
        return treePath;
    }

    public static TreePath findSchemaObject(DefaultTreeModel defaultTreeModel, String string, String string2, String string3, boolean bl) {
        Object object;
        NodeData nodeData;
        Object object2;
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object3;
        Object object4;
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        TreePath treePath = null;
        Object object5 = null;
        string = DM4JStringUtils.isDoubleQuotedString(string) ? DM4JStringUtils.trimDoubleQuotes(string) : string;
        String string4 = string3 = DM4JStringUtils.isDoubleQuotedString(string3) ? DM4JStringUtils.trimDoubleQuotes(string3) : string3;
        if (string2.equals("DISCOGWOBJ")) {
            object5 = browserFrame.getNavigatorTree().getDiscoGWNode();
        } else {
            object4 = browserFrame.getNavigatorTree().getSchemasTreeNode();
            object3 = ((DefaultMutableTreeNode)object4).getUserObject();
            if (bl || object3 instanceof Boolean) {
                FolderNodeData.expandNode((DefaultMutableTreeNode)object4, null);
                defaultTreeModel.reload((TreeNode)object4);
            }
            for (int i = 0; i < ((DefaultMutableTreeNode)object4).getChildCount(); ++i) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object4).getChildAt(i);
                object2 = defaultMutableTreeNode.getUserObject();
                if (!(object2 instanceof FolderNodeData) || !(nodeData = (FolderNodeData)object2).getName().equals(string)) continue;
                defaultMutableTreeNode2 = defaultMutableTreeNode;
                break;
            }
            if (null == defaultMutableTreeNode2) {
                return null;
            }
            object = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild();
            defaultMutableTreeNode = ((DefaultMutableTreeNode)object).getNextSibling();
            object5 = string2.equalsIgnoreCase("VIEW") ? object : defaultMutableTreeNode;
        }
        if (bl) {
            FolderNodeData.expandNode((DefaultMutableTreeNode)object5, null);
            defaultTreeModel.reload((TreeNode)object5);
        }
        object4 = ((DefaultMutableTreeNode)object5).getUserObject();
        object3 = (FolderNodeData)object4;
        object = ((DefaultMutableTreeNode)object5).depthFirstEnumeration();
        while (object.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
            object2 = defaultMutableTreeNode.getUserObject();
            if (!(object2 instanceof LeafNodeData) || !(nodeData = (LeafNodeData)object2).getName().equals(string3)) continue;
            treePath = new TreePath(defaultMutableTreeNode.getPath());
            break;
        }
        return treePath;
    }

    public static String getFolderType(String string) {
        if (string.equals("ASSOCIATION_RULES_SETTING")) {
            return ASSOCIATION_RULES_SETTINGS;
        }
        if (string.equals("ATTRIBUTE_IMPORTANCE_SETTING")) {
            return ATTRIBUTE_IMPORTANCE_SETTINGS;
        }
        if (string.equals("CLASSIFICATION_ABN_SETTING") || string.equals("CLASSIFICATION_NB_SETTING") || string.equals("CLASSIFICATION_SVM_SETTING") || string.equals("CLASSIFICATION_MS_SETTING")) {
            return CLASSIFICATION_SETTINGS;
        }
        if (string.equals("REGRESSION_SVM_SETTING")) {
            return REGRESSION_SETTINGS;
        }
        if (string.equals("FEATURE_EXTRACTION_NMF_SETTING")) {
            return FEATURE_EXTRACTION_SETTINGS;
        }
        if (string.equals("CLUSTERING_KMEANS_SETTING") || string.equals("CLUSTERING_OCLUSTER_SETTING")) {
            return CLUSTERING_SETTINGS;
        }
        if (string.equals("ASSOCIATION_RULES_MODEL")) {
            return ASSOCIATION_RULES_MODELS;
        }
        if (string.equals("ATTRIBUTE_IMPORTANCE_MODEL")) {
            return ATTRIBUTE_IMPORTANCE_MODELS;
        }
        if (string.equals("ABN_MODEL") || string.equals("NB_MODEL") || string.equals("DT_MODEL") || string.equals("GLM_CLASSIFICATION_MODEL") || string.equals("SVM_CLASSIFICATION_MODEL")) {
            return CLASSIFICATION_MODELS;
        }
        if (string.equals("SVM_REGRESSION_MODEL") || string.equals("GLM_REGRESSION_MODEL")) {
            return REGRESSION_MODELS;
        }
        if (string.equals("SVM_ONE_CLASS_MODEL")) {
            return ANOMALY_DETECTION_MODELS;
        }
        if (string.equals("NMF_MODEL")) {
            return FEATURE_EXTRACTION_MODELS;
        }
        if (string.equals("CLUSTERING_OCLUSTER_MODEL") || string.equals("CLUSTERING_KMEANS_MODEL")) {
            return CLUSTERING_MODELS;
        }
        if (string.equals("BUILD_RESULT")) {
            return BUILD_RESULTS;
        }
        if (string.equals("TEST_METRIC_RESULT")) {
            return TEST_METRICS_RESULTS;
        }
        if (string.equals("APPLY_RESULT")) {
            return APPLY_RESULTS;
        }
        if (string.equals("RESIDUAL_PLOT_RESULT")) {
            return RESIDUAL_PLOT_RESULTS;
        }
        if (string.equals("PREDICT_RESULT")) {
            return PREDICT_RESULTS;
        }
        if (string.equals("EXPLAIN_RESULT")) {
            return EXPLAIN_RESULTS;
        }
        if (string.equals("ASSOCIATION_RULES_ACTIVITY")) {
            return ASSOCIATION_RULES_ACTIVITIES;
        }
        if (string.equals("ATTRIBUTE_IMPORTANCE_ACTIVITY")) {
            return ATTRIBUTE_IMPORTANCE_ACTIVITIES;
        }
        if (string.equals("CLASSIFICATION_ACTIVITY")) {
            return CLASSIFICATION_ACTIVITIES;
        }
        if (string.equals("REGRESSION_ACTIVITY")) {
            return REGRESSION_ACTIVITIES;
        }
        if (string.equals("FEATURE_EXTRACTION_ACTIVITY")) {
            return FEATURE_EXTRACTION_ACTIVITIES;
        }
        if (string.equals("CLUSTERING_ACTIVITY")) {
            return CLUSTERING_ACTIVITIES;
        }
        if (string.equals("ANOMALY_DETECTION_ACTIVITY")) {
            return ANOMALY_DETECTION_ACTIVITIES;
        }
        if (string.equals("CLASSIFICATION_ACTIVITY_APPLY")) {
            return CLASSIFICATION_ACTIVITIES;
        }
        if (string.equals("REGRESSION_ACTIVITY_APPLY")) {
            return REGRESSION_ACTIVITIES;
        }
        if (string.equals("FEATURE_EXTRACTION_ACTIVITY_APPLY")) {
            return FEATURE_EXTRACTION_ACTIVITIES;
        }
        if (string.equals("CLUSTERING_ACTIVITY_APPLY")) {
            return CLUSTERING_ACTIVITIES;
        }
        if (string.equals("ANOMALY_DETECTION_ACTIVITY_APPLY")) {
            return ANOMALY_DETECTION_ACTIVITIES;
        }
        if (string.equals("DISCOGWOBJ") || string.equals(DISCOGW)) {
            return DISCOGW;
        }
        if (string.equals("CLASSIFICATION_ACTIVITY_TEST")) {
            return CLASSIFICATION_ACTIVITIES;
        }
        if (string.equals("REGRESSION_ACTIVITY_TEST")) {
            return REGRESSION_ACTIVITIES;
        }
        if (string.equals(ANOMALY_DETECTION_ACTIVITIES) || string.equals(ATTRIBUTE_IMPORTANCE_ACTIVITIES) || string.equals(CLASSIFICATION_ACTIVITIES) || string.equals(CLUSTERING_ACTIVITIES) || string.equals(FEATURE_EXTRACTION_ACTIVITIES) || string.equals(REGRESSION_ACTIVITIES) || string.equals(ASSOCIATION_RULES_ACTIVITIES) || string.equals(ACTIVITIES)) {
            return ACTIVITIES;
        }
        if (string.equals(ANOMALY_DETECTION_MODELS) || string.equals(ATTRIBUTE_IMPORTANCE_MODELS) || string.equals(CLASSIFICATION_MODELS) || string.equals(CLUSTERING_MODELS) || string.equals(FEATURE_EXTRACTION_MODELS) || string.equals(REGRESSION_MODELS) || string.equals(ASSOCIATION_RULES_MODELS) || string.equals(MODELS)) {
            return MODELS;
        }
        if (string.equals(TEST_METRICS_RESULTS) || string.equals(RESIDUAL_PLOT_RESULTS) || string.equals(APPLY_RESULTS) || string.equals(PREDICT_RESULTS) || string.equals(EXPLAIN_RESULTS) || string.equals(RESULTS)) {
            return RESULTS;
        }
        if (string.equals(SCHEMAS) || string.equals(SCHEMA)) {
            return SCHEMAS;
        }
        if (string.equals(SCHEMA_TABLES) || string.equals("TABLE")) {
            return SCHEMA_TABLES;
        }
        if (string.equals(SCHEMA_VIEWS) || string.equals("VIEW")) {
            return SCHEMA_VIEWS;
        }
        return null;
    }

    public boolean isLeafContainer() {
        String string = this.getNodeType();
        return string.equals(ASSOCIATION_RULES_MODELS) || string.equals(ATTRIBUTE_IMPORTANCE_MODELS) || string.equals(CLASSIFICATION_MODELS) || string.equals(REGRESSION_MODELS) || string.equals(FEATURE_EXTRACTION_MODELS) || string.equals(CLUSTERING_MODELS) || string.equals(ANOMALY_DETECTION_MODELS) || string.equals(BUILD_RESULTS) || string.equals(TEST_METRICS_RESULTS) || string.equals(APPLY_RESULTS) || string.equals(RESIDUAL_PLOT_RESULTS) || string.equals(PREDICT_RESULTS) || string.equals(EXPLAIN_RESULTS) || string.equals(ASSOCIATION_RULES_SETTINGS) || string.equals(ATTRIBUTE_IMPORTANCE_SETTINGS) || string.equals(CLASSIFICATION_SETTINGS) || string.equals(REGRESSION_SETTINGS) || string.equals(FEATURE_EXTRACTION_SETTINGS) || string.equals(ANOMALY_DETECTION_MODELS) || string.equals(CLUSTERING_SETTINGS) || string.equals(SCHEMAS) || string.equals(SCHEMA) || string.equals(SCHEMA_TABLES) || string.equals(ASSOCIATION_RULES_ACTIVITIES) || string.equals(ATTRIBUTE_IMPORTANCE_ACTIVITIES) || string.equals(CLASSIFICATION_ACTIVITIES) || string.equals(REGRESSION_ACTIVITIES) || string.equals(FEATURE_EXTRACTION_ACTIVITIES) || string.equals(CLUSTERING_ACTIVITIES) || string.equals(ANOMALY_DETECTION_ACTIVITIES) || string.equals(SCHEMA_VIEWS) || string.equals(DISCOGW);
    }
}

