/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.tree;

import java.util.EventObject;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.tree.FindTreeNodeException;
import oracle.dmt.dm4j.browser.tree.SchemaNodeFoundListener;
import oracle.dmt.dm4j.browser.tree.node.FolderNodeData;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;

public class FindSchemaNodeWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private DefaultTreeModel m_model;
    private String m_schema;
    private String m_type;
    private String m_node;
    private boolean m_saveNavigation = false;

    public FindSchemaNodeWorker(WorkerThreadManager workerThreadManager, DefaultTreeModel defaultTreeModel, String string, String string2, String string3, boolean bl) {
        super(workerThreadManager);
        this.m_model = defaultTreeModel;
        this.m_schema = string;
        this.m_type = string2;
        this.m_node = string3;
        this.m_saveNavigation = bl;
    }

    public void addSchemaNodeFoundListener(SchemaNodeFoundListener schemaNodeFoundListener) {
        this.listenerList.add(SchemaNodeFoundListener.class, schemaNodeFoundListener);
    }

    public void removeSchemaNodeFoundListener(SchemaNodeFoundListener schemaNodeFoundListener) {
        this.listenerList.remove(SchemaNodeFoundListener.class, schemaNodeFoundListener);
    }

    public Object construct() {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        TreePath treePath = null;
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(16);
            }
            ++s_thread;
            treePath = FolderNodeData.findSchemaObject(this.m_model, this.m_schema, this.m_type, this.m_node, true);
        }
        catch (Exception exception) {
            return new FindTreeNodeException("Cannot find schema object", this.m_node, this.m_type, exception);
        }
        if (treePath != null && !this.m_saveNavigation) {
            browserFrame.addIgnoreNavigationHistory(this.m_schema, this.m_node, this.m_type);
        }
        if (null != treePath) {
            return treePath;
        }
        return new FindTreeNodeException("Cannot find schema object", this.m_node, this.m_type);
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(16);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SchemaNodeFoundListener.class) continue;
            ((SchemaNodeFoundListener)objectArray[i + 1]).nodeFound(this.getValue() != null ? new EventObject(this.getValue()) : null);
        }
    }
}

