/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.preferences;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.preferences.PreferencePanel;

public class TasksPanel
extends GriddedPanel
implements PreferencePanel {
    private UserPreferences m_preferences = null;
    private NumberTextField m_maxAge = new NumberTextField();
    private JLabel m_filler = new JLabel();

    public TasksPanel(UserPreferences userPreferences) {
        try {
            this.m_preferences = userPreferences;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.m_maxAge.setDataType(Integer.TYPE);
        this.m_maxAge.setNumber(new Integer(this.m_preferences.getFinishedTasksAge()));
        this.m_maxAge.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
        this.m_maxAge.setSigned(false);
        this.m_maxAge.setColumns(7);
        GriddedPanel griddedPanel = new GriddedPanel();
        griddedPanel.setBorder(BorderFactory.createTitledBorder(DM4JResourceUtilities.getUIString("PREF_TASKS_GROUP_TITLE")));
        int n = 0;
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("PREF_TASKS_MAX_AGE"));
        DM4JResourceUtilities.configureUILabel(jLabel, "PREF_TASKS_MAX_AGE", this.m_maxAge, dM4JListResourceBundle);
        griddedPanel.addFilledComponent(jLabel, MIDEDITLABELITEMINSETS, n, 0, 1, 1, 0);
        griddedPanel.addFilledComponent(this.m_maxAge, MIDEDITVALUEITEMINSETS, n++, 1, 1, 1, 0);
        griddedPanel.addFilledComponent(new JLabel(" "), MIDLABELITEMINSETS, n++, 1, 3, 3, 1);
        this.addFilledComponent(griddedPanel, TOPLABELITEMINSETS, 1, 0, 3, 2, 2);
        this.addFilledComponent(this.m_filler, TOPLABELITEMINSETS, 1, 0, 3, 2, 1);
    }

    public void applySettings() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = -1;
        try {
            Integer n2 = (Integer)this.m_maxAge.getNumber();
            if (n2 != null) {
                n = n2;
            }
            if (n < 0) {
                throw new Exception("Negative, or blank values not allowed");
            }
        }
        catch (Exception exception) {
            String string = DM4JResourceUtilities.getUIString("PREF_ERROR_NUM_VAL_REQ");
            JOptionPane.showMessageDialog(this, string, DM4JVersion.getFullBrowserName(), 0);
            this.m_maxAge.requestFocus();
            throw new Exception(string);
        }
        this.m_preferences.setFinishedTasksAge(n);
    }
}

