/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.preferences;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.preferences.PreferencePanel;

public class SamplingPanel
extends GriddedPanel
implements PreferencePanel {
    private UserPreferences m_preferences = null;
    private NumberTextField m_sampleSize = new NumberTextField();
    private JLabel m_filler = new JLabel();

    public SamplingPanel(UserPreferences userPreferences) {
        try {
            this.m_preferences = userPreferences;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.m_sampleSize.setDataType(Integer.TYPE);
        this.m_sampleSize.setSigned(false);
        this.m_sampleSize.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
        JLabel jLabel = new JLabel();
        DM4JResourceUtilities.configureUILabel(jLabel, "PREF_SAMPLING_SIZE", this.m_sampleSize, dM4JListResourceBundle);
        int n = 0;
        this.addFilledComponent(new JLabel(" "), MIDEDITLABELITEMINSETS, n++, 0, 1, 1, 1);
        this.addFilledComponent(jLabel, MIDEDITLABELITEMINSETS, n, 0, 1, 1, 1);
        this.addFilledComponent(this.m_sampleSize, MIDEDITVALUEITEMINSETS, n++, 1, 1, 1, 2);
        this.addFilledComponent(this.m_filler, TOPLABELITEMINSETS, n++, 0, 3, 2, 1);
        this.m_sampleSize.setNumber(new Integer(this.m_preferences.getSampleSize()));
        this.m_sampleSize.setColumns(7);
    }

    public void applySettings() throws Exception {
        Object object;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        int n = -1;
        try {
            object = (Integer)this.m_sampleSize.getNumber();
            if (object != null) {
                n = (Integer)object;
            }
            if (n < 0) {
                throw new Exception("Negative, or blank values not allowed");
            }
        }
        catch (Exception exception) {
            String string = DM4JResourceUtilities.getUIString("PREF_ERROR_NUM_VAL_REQ");
            JOptionPane.showMessageDialog(this, string, DM4JVersion.getFullBrowserName(), 0);
            throw new Exception(string);
        }
        if (n < UserPreferences.getMinimumSampleSize()) {
            object = DM4JResourceUtilities.getUIString("PREF_ERROR_SAMPLE_TOOSMALL") + " " + UserPreferences.getMinimumSampleSize();
            JOptionPane.showMessageDialog(this, object, DM4JVersion.getFullBrowserName(), 0);
            throw new Exception((String)object);
        }
        this.m_preferences.setSampleSize(n);
    }
}

