/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.preferences.ClusterModelViewerPanel;
import oracle.dmt.dm4j.browser.preferences.ConnectionsPanel;
import oracle.dmt.dm4j.browser.preferences.DataPanel;
import oracle.dmt.dm4j.browser.preferences.DiscretizingPanel;
import oracle.dmt.dm4j.browser.preferences.EnvironmentPanel;
import oracle.dmt.dm4j.browser.preferences.PreferencePanel;
import oracle.dmt.dm4j.browser.preferences.SamplingPanel;
import oracle.dmt.dm4j.browser.preferences.TasksPanel;
import oracle.help.CSHManager;
import oracle.help.Help;

public class PreferencesDialog
extends JDialog {
    private boolean m_isOk = false;
    private int m_tabIndex = 0;
    private JTabbedPane m_tabs = new JTabbedPane(1);
    private EnvironmentPanel m_environmentPanel = null;
    private DataPanel m_dataPanel = null;
    private SamplingPanel m_samplingPanel = null;
    private DiscretizingPanel m_discretizingPanel;
    private ConnectionsPanel m_connPanel = null;
    private TasksPanel m_tasksPanel = null;
    private ClusterModelViewerPanel m_clusterModelPanel = null;
    private UserPreferences m_preferences = null;

    public PreferencesDialog(Frame frame) {
        super(frame, true);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.setTitle(DM4JResourceUtilities.getUIString("PREF_TITLE"));
        this.m_preferences = UserPreferences.getInstance();
        this.m_environmentPanel = new EnvironmentPanel(this.m_preferences);
        this.m_dataPanel = new DataPanel(this.m_preferences);
        this.m_samplingPanel = new SamplingPanel(this.m_preferences);
        this.m_connPanel = new ConnectionsPanel();
        this.m_tasksPanel = new TasksPanel(this.m_preferences);
        this.m_discretizingPanel = new DiscretizingPanel(this.m_preferences);
        this.m_clusterModelPanel = new ClusterModelViewerPanel(this.m_preferences);
        this.m_tabs.add(DM4JResourceUtilities.getUIString("PREF_ENVIRONMENT"), this.m_environmentPanel);
        this.m_tabs.add(DM4JResourceUtilities.getUIString("PREF_SAMPLING"), this.m_samplingPanel);
        this.m_tabs.add(DM4JResourceUtilities.getUIString("PREF_DATA"), this.m_dataPanel);
        this.m_tabs.add(DM4JResourceUtilities.getUIString("PREF_CONNECTIONS"), this.m_connPanel);
        this.m_tabs.add(DM4JResourceUtilities.getUIString("PREF_TASKS"), this.m_tasksPanel);
        this.m_tabs.add(DM4JResourceUtilities.getUIString("PREF_DISCRETIZE"), this.m_discretizingPanel);
        this.m_tabs.add(DM4JResourceUtilities.getUIString("PREF_MODEL_VIEW"), this.m_clusterModelPanel);
        this.m_tabs.setSelectedIndex(this.m_tabIndex);
        GriddedPanel griddedPanel = new GriddedPanel();
        griddedPanel.addFilledComponent(this.m_tabs, new Insets(15, 15, 5, 15), 0, 0, 2, 2, 1);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)griddedPanel, "Center");
        GriddedPanel griddedPanel2 = new GriddedPanel();
        JButton jButton = new JButton(DM4JResourceUtilities.getUIString("COMMON_OK"));
        JButton jButton2 = new JButton(DM4JResourceUtilities.getUIString("COMMON_CANCEL"));
        JButton jButton3 = new JButton(DM4JResourceUtilities.getUIString("COMMON_HELP"));
        jButton3.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_HELP"));
        JLabel jLabel = new JLabel("");
        griddedPanel2.addFilledComponent(jButton3, GriddedPanel.DIALOG_BOTTOM_LEFTMOST_BUTTON, 0, 0, 1, 1, 2);
        griddedPanel2.addFilledComponent(jLabel, GriddedPanel.DIALOG_BOTTOM_MID_BUTTONS, 0, 1, 4, 1, 2);
        griddedPanel2.addFilledComponent(jButton, GriddedPanel.DIALOG_BOTTOM_MID_BUTTONS, 0, 5, 1, 1, 2);
        griddedPanel2.addFilledComponent(jButton2, GriddedPanel.DIALOG_BOTTOM_RIGHTMOST_BUTTON, 0, 6, 1, 1, 2);
        this.getContentPane().add((Component)griddedPanel2, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.cancel_actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.ok_actionPerformed(actionEvent);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.cancel_actionPerformed(actionEvent);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.help_ActionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PreferencesDialog.this.setVisible(false);
                PreferencesDialog.this.dispose();
            }
        });
        this.m_tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PreferencePanel preferencePanel = (PreferencePanel)((Object)PreferencesDialog.this.m_tabs.getComponentAt(PreferencesDialog.this.m_tabIndex));
                if (PreferencesDialog.this.m_tabs.getSelectedIndex() == PreferencesDialog.this.m_tabIndex) {
                    return;
                }
                try {
                    preferencePanel.applySettings();
                    PreferencesDialog.this.m_tabIndex = PreferencesDialog.this.m_tabs.getSelectedIndex();
                }
                catch (Exception exception) {
                    PreferencesDialog.this.m_tabs.setSelectedIndex(PreferencesDialog.this.m_tabIndex);
                }
            }
        });
        this.setSize(new Dimension(535, 400));
        WindowUtils.centerWindow(this);
    }

    private void ok_actionPerformed(ActionEvent actionEvent) {
        Object object;
        this.setCursor(Cursor.getPredefinedCursor(3));
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        boolean bl = false;
        try {
            for (int i = 0; i < this.m_tabs.getTabCount(); ++i) {
                object = (PreferencePanel)((Object)this.m_tabs.getComponentAt(i));
                object.applySettings();
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (bl) {
            return;
        }
        try {
            this.m_preferences.save();
        }
        catch (Exception exception) {
            object = DM4JResourceUtilities.getUIString("PREF_ERROR_SAVE");
            String string = DM4JVersion.getFullBrowserName();
            JOptionPane.showMessageDialog(this, object, string, 0);
        }
        this.m_isOk = true;
        this.setVisible(false);
        this.dispose();
    }

    private void cancel_actionPerformed(ActionEvent actionEvent) {
        this.m_isOk = false;
        this.setVisible(false);
        this.dispose();
    }

    protected void help_ActionPerformed(ActionEvent actionEvent) {
        Help.registerClientWindow(this);
        CSHManager cSHManager = BrowserFrame.getCSHManager();
        try {
            cSHManager.addComponent(this, "PREFERENCES_DLG", true, false);
            cSHManager.showTopic("PREFERENCES_DLG");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_ERROR_NO_HELP"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
        }
    }

    public boolean isOk() {
        return this.m_isOk;
    }
}

