/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser.disco;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Vector;
import javax.datamining.resource.Connection;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.FlexibleDocument;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public abstract class DGWPanel
extends GriddedPanel {
    protected java.sql.Connection m_dbConn = null;
    protected boolean m_isDefaultView = false;
    protected Map m_propMap = null;
    private JLabel m_lblDlgDesc = null;
    private JCheckBox[] m_chkGWs = null;
    private JLabel[] m_lblGWObjs = null;
    private JLabel[] m_lblGWObjDescs = null;
    private JTextField[] m_tfGWObjs = null;
    private JTextArea[] m_taGWObjDescs = null;
    private JRadioButton[] m_rbTable = null;
    private JRadioButton[] m_rbView = null;
    private JPanel[] m_pnlTableOrView = null;
    private JComboBox m_cmbDMObjs = null;
    private JLabel m_lblDMObjName = null;
    private JLabel m_lblDMObj = null;
    private String m_selectedDMObjName = null;
    private int m_numOfTables = 1;
    private boolean m_isMultipleTables = false;
    private String m_dmObjectName = null;
    private String[] m_dmObjectList = null;
    private boolean m_isTableOrView = true;
    JLabel lblFiller = new JLabel();
    public static final String PROP_DLG_DESC = "A";
    public static final String PROP_NUM_OF_TABLES = "B";
    public static final String PROP_CHECK_BOX_LABELS = "C";
    public static final String PROP_DM_OBJECT_LABEL = "D";
    public static final String PROP_DM_OBJECT_VALUE = "E";
    public static final String PROP_DM_OBJECT_CMB_VALUES = "F";
    public static final String PROP_DLG_HELP = "G";
    public static final String PROP_GW_OBJ_NAMES = "H";
    public static final String PROP_GW_OBJ_DESCS = "I";
    public static final String PROP_TAB_VIEW_FLAG = "J";
    public static final String PROP_GW_OBJ_PREFIXES = "K";
    public static final String PROP_GW_OBJ_SUFFIXES = "L";

    public DGWPanel() {
    }

    public DGWPanel(java.sql.Connection connection) {
        this.m_dbConn = connection;
    }

    protected void init() throws Exception {
        if (this.m_propMap != null) {
            Object object;
            int n = 0;
            this.m_lblDlgDesc = new JLabel(DM4JResourceUtilities.getUIString((String)this.m_propMap.get(PROP_DLG_DESC)));
            this.addFilledComponent(this.m_lblDlgDesc, INSTRUCTIONALLABELITEMINSETS, n, 0, 2, 2, 1);
            n += 2;
            String string = (String)this.m_propMap.get(PROP_DM_OBJECT_LABEL);
            this.m_lblDMObj = new JLabel(DM4JResourceUtilities.getUIString(string));
            this.m_lblDMObj.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic(string));
            this.m_dmObjectName = (String)this.m_propMap.get(PROP_DM_OBJECT_VALUE);
            this.m_isTableOrView = (Boolean)this.m_propMap.get(PROP_TAB_VIEW_FLAG);
            this.addFilledComponent(this.m_lblDMObj, MIDEDITLABELITEMINSETS, n, 0, 1, 1, 0);
            if (this.m_dmObjectName == null) {
                this.m_dmObjectList = (String[])this.m_propMap.get(PROP_DM_OBJECT_CMB_VALUES);
                object = new DefaultComboBoxModel<String>(this.m_dmObjectList);
                this.m_cmbDMObjs = new JComboBox<String>((ComboBoxModel<String>)object);
                this.m_cmbDMObjs.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DGWPanel.this.comboObjectSelecAction(actionEvent);
                    }
                });
                this.m_dmObjectName = (String)this.m_cmbDMObjs.getSelectedItem();
                this.addFilledComponent(this.m_cmbDMObjs, MIDEDITVALUEITEMINSETS, n++, 1, 1, 1, 2);
            } else {
                this.m_lblDMObjName = new JLabel(this.m_dmObjectName);
                this.addFilledComponent(this.m_lblDMObjName, MIDEDITLABELITEMINSETS, n++, 1, 1, 1, 2);
            }
            this.addFilledComponent(this.lblFiller, COL1_LABEL, n++, 0, 2, 2, 1);
            this.m_numOfTables = ((Number)this.m_propMap.get(PROP_NUM_OF_TABLES)).intValue();
            if (this.m_numOfTables > 1) {
                this.m_isMultipleTables = true;
            }
            object = DM4JResourceUtilities.getUIString("DISCOGW_OBJECT_NAME");
            String string2 = DM4JResourceUtilities.getUIString("DISCOGW_OBJECT_DESCRIPTION");
            int n2 = DM4JResourceUtilities.getUIMnemonic("DISCOGW_OBJECT_NAME");
            int n3 = DM4JResourceUtilities.getUIMnemonic("DISCOGW_OBJECT_NAME");
            String string3 = DM4JResourceUtilities.getUIString("STRING_TABLE");
            String string4 = DM4JResourceUtilities.getUIString("STRING_VIEW");
            int n4 = DM4JResourceUtilities.getUIMnemonic("STRING_TABLE");
            int n5 = DM4JResourceUtilities.getUIMnemonic("STRING_VIEW");
            if (this.m_isTableOrView) {
                this.m_rbTable = new JRadioButton[this.m_numOfTables];
                this.m_rbView = new JRadioButton[this.m_numOfTables];
                this.m_pnlTableOrView = new JPanel[this.m_numOfTables];
            }
            if (this.m_isMultipleTables) {
                this.m_lblGWObjs = new JLabel[this.m_numOfTables];
                this.m_lblGWObjDescs = new JLabel[this.m_numOfTables];
                this.m_tfGWObjs = new JTextField[this.m_numOfTables];
                this.m_taGWObjDescs = new JTextArea[this.m_numOfTables];
                this.m_chkGWs = new JCheckBox[this.m_numOfTables];
                String[] stringArray = (String[])this.m_propMap.get(PROP_CHECK_BOX_LABELS);
                for (int i = 0; i < this.m_numOfTables; ++i) {
                    this.m_chkGWs[i] = new JCheckBox(DM4JResourceUtilities.getUIString(stringArray[i]));
                    this.m_chkGWs[i].setMnemonic(DM4JResourceUtilities.getUIMnemonic(stringArray[i]));
                    this.m_chkGWs[i].setSelected(true);
                    this.m_lblGWObjs[i] = new JLabel((String)object);
                    this.m_lblGWObjs[i].setDisplayedMnemonic(n2);
                    this.m_tfGWObjs[i] = new JTextField(new FlexibleDocument(32, true), "", 32);
                    this.m_lblGWObjs[i].setLabelFor(this.m_tfGWObjs[i]);
                    this.m_lblGWObjDescs[i] = new JLabel(string2);
                    this.m_lblGWObjDescs[i].setDisplayedMnemonic(n3);
                    this.m_taGWObjDescs[i] = new JTextArea();
                    this.m_taGWObjDescs[i].setDocument(new FlexibleDocument(240));
                    this.m_lblGWObjDescs[i].setLabelFor(this.m_taGWObjDescs[i]);
                    n += 2;
                    this.addFilledComponent(this.m_chkGWs[i], MIDEDITLABELITEMINSETS, n++, 0, 1, 1, 1);
                    this.addFilledComponent(this.m_lblGWObjs[i], MIDINDENTEDEDITLABELITEMINSETS, n, 0, 1, 1, 0);
                    this.addFilledComponent(this.m_tfGWObjs[i], MIDEDITVALUEITEMINSETS, n++, 1, 1, 1, 2);
                    this.addFilledComponent(this.lblFiller, COL1_LABEL, n++, 0, 2, 2, 1);
                    this.addFilledComponent(this.m_lblGWObjDescs[i], MIDINDENTEDEDITLABELITEMINSETS, n, 0, 1, 1, 0);
                    this.addFilledComponent(this.m_taGWObjDescs[i], MIDEDITVALUEITEMINSETS, n++, 1, 1, 1, 2);
                    if (!this.m_isTableOrView) continue;
                    this.m_rbTable[i] = new JRadioButton(string3, true);
                    this.m_rbView[i] = new JRadioButton(string4, false);
                    this.m_rbTable[i].setMnemonic(n4);
                    this.m_rbView[i].setMnemonic(n5);
                    ButtonGroup buttonGroup = new ButtonGroup();
                    buttonGroup.add(this.m_rbTable[i]);
                    buttonGroup.add(this.m_rbView[i]);
                    this.m_pnlTableOrView[i] = new JPanel();
                    this.m_pnlTableOrView[i].add(this.m_rbTable[i]);
                    this.m_pnlTableOrView[i].add(this.m_rbView[i]);
                    this.addFilledComponent(this.m_pnlTableOrView[i], MIDINDENTEDEDITLABELITEMINSETS, n++, 0, 1, 1, 1);
                }
            } else {
                this.m_lblGWObjs = new JLabel[1];
                this.m_lblGWObjDescs = new JLabel[1];
                this.m_tfGWObjs = new JTextField[1];
                this.m_taGWObjDescs = new JTextArea[1];
                this.m_lblGWObjs[0] = new JLabel((String)object);
                this.m_lblGWObjs[0].setDisplayedMnemonic(n2);
                this.m_tfGWObjs[0] = new JTextField(new FlexibleDocument(30, true), "", 30);
                this.m_lblGWObjs[0].setLabelFor(this.m_tfGWObjs[0]);
                this.m_lblGWObjDescs[0] = new JLabel(string2);
                this.m_lblGWObjDescs[0].setDisplayedMnemonic(n3);
                this.m_taGWObjDescs[0] = new JTextArea();
                this.m_taGWObjDescs[0].setDocument(new FlexibleDocument(240));
                this.m_lblGWObjDescs[0].setLabelFor(this.m_taGWObjDescs[0]);
                this.addFilledComponent(this.m_lblGWObjs[0], MIDEDITLABELITEMINSETS, n, 0, 1, 1, 0);
                this.addFilledComponent(this.m_tfGWObjs[0], MIDEDITVALUEITEMINSETS, n++, 1, 1, 1, 2);
                this.addFilledComponent(this.lblFiller, COL1_LABEL, n++, 0, 2, 2, 1);
                this.addFilledComponent(this.m_lblGWObjDescs[0], MIDEDITLABELITEMINSETS, n, 0, 1, 1, 0);
                this.addFilledComponent(this.m_taGWObjDescs[0], MIDEDITVALUEITEMINSETS, n++, 1, 1, 1, 2);
                if (this.m_isTableOrView) {
                    this.m_rbTable[0] = new JRadioButton(string3, !this.m_isDefaultView);
                    this.m_rbView[0] = new JRadioButton(string4, this.m_isDefaultView);
                    this.m_rbTable[0].setMnemonic(n4);
                    this.m_rbView[0].setMnemonic(n5);
                    ButtonGroup buttonGroup = new ButtonGroup();
                    buttonGroup.add(this.m_rbTable[0]);
                    buttonGroup.add(this.m_rbView[0]);
                    this.m_pnlTableOrView[0] = new JPanel();
                    this.m_pnlTableOrView[0].add(this.m_rbTable[0]);
                    this.m_pnlTableOrView[0].add(this.m_rbView[0]);
                    this.addFilledComponent(this.m_pnlTableOrView[0], MIDEDITLABELITEMINSETS, n++, 0, 1, 1, 1);
                }
            }
            this.setDefaults();
            this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 2, 1);
        }
    }

    private void setDefaults() throws Exception {
        String[] stringArray = (String[])this.m_propMap.get(PROP_GW_OBJ_PREFIXES);
        String[] stringArray2 = (String[])this.m_propMap.get(PROP_GW_OBJ_SUFFIXES);
        String[] stringArray3 = new String[this.m_numOfTables];
        String[] stringArray4 = new String[this.m_numOfTables];
        String[] stringArray5 = (String[])this.m_propMap.get(PROP_GW_OBJ_DESCS);
        for (int i = 0; i < this.m_numOfTables; ++i) {
            stringArray3[i] = this.m_dmObjectName == null || this.m_dmObjectName.startsWith("\"") ? ValidationUtil.createUniqueTableName(stringArray[i], this.m_dbConn, "DGW") : ValidationUtil.createUniqueTableName(this.m_dmObjectName, this.m_dbConn, stringArray2[i]);
            stringArray4[i] = DM4JResourceUtilities.getUIString(stringArray5[i], new String[]{this.m_dmObjectName});
            this.m_tfGWObjs[i].setText(stringArray3[i]);
            this.m_taGWObjDescs[i].setText(stringArray4[i]);
            this.m_taGWObjDescs[i].setLineWrap(true);
            this.m_taGWObjDescs[i].setAutoscrolls(true);
        }
    }

    public String getDMObjectName() {
        return this.m_dmObjectName;
    }

    public String getGWObjectName(int n) {
        if (n < this.m_numOfTables) {
            return this.m_tfGWObjs[n].getText();
        }
        return null;
    }

    public String getGWObjectDesc(int n) {
        if (n < this.m_numOfTables) {
            return this.m_taGWObjDescs[n].getText();
        }
        return null;
    }

    public boolean isGWObjectTableType(int n) {
        if (n < this.m_numOfTables) {
            return this.m_rbTable[n].isSelected();
        }
        return true;
    }

    public boolean isGWObjectSelected(int n) {
        if (n < this.m_numOfTables) {
            return this.m_chkGWs[n].isSelected();
        }
        return true;
    }

    public Vector getGWObjectNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.m_numOfTables; ++i) {
            vector.add(this.m_tfGWObjs[i].getText());
        }
        return vector;
    }

    public Vector getGWObjectDescs() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.m_numOfTables; ++i) {
            vector.add(this.m_taGWObjDescs[i].getText());
        }
        return vector;
    }

    public Vector getGWObjectTypes() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.m_numOfTables; ++i) {
            if (this.m_rbTable[i].isSelected()) {
                vector.add("TABLE");
                continue;
            }
            vector.add("VIEW");
        }
        return vector;
    }

    public Vector getSelectedGWObjs() {
        Vector<Boolean> vector = new Vector<Boolean>();
        if (this.m_isMultipleTables) {
            for (int i = 0; i < this.m_numOfTables; ++i) {
                vector.add(new Boolean(this.m_chkGWs[i].isSelected()));
            }
        } else {
            vector.add(new Boolean(true));
        }
        return vector;
    }

    protected void comboObjectSelecAction(ActionEvent actionEvent) {
        this.m_dmObjectName = (String)this.m_cmbDMObjs.getSelectedItem();
        try {
            this.setDefaults();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract boolean execute(Connection var1) throws Exception;

    public String getGWObjectName() {
        if (this.m_chkGWs != null) {
            for (int i = 0; i < this.m_chkGWs.length; ++i) {
                if (!this.m_chkGWs[i].isSelected()) continue;
                return this.getGWObjectName(i);
            }
        }
        return this.getGWObjectName(0);
    }

    public String getGWObjectDescription() {
        if (this.m_chkGWs != null) {
            for (int i = 0; i < this.m_chkGWs.length; ++i) {
                if (!this.m_chkGWs[i].isSelected()) continue;
                return this.getGWObjectDesc(i);
            }
        }
        return this.getGWObjectDesc(0);
    }

    public String validatePanelInputs() {
        String string = null;
        boolean bl = false;
        if (this.m_chkGWs != null) {
            for (int i = 0; i < this.m_chkGWs.length; ++i) {
                if (!this.m_chkGWs[i].isSelected()) continue;
                bl = true;
                String string2 = this.m_tfGWObjs[i].getText();
                string2 = string2.startsWith("\"") ? string2.substring(1, string2.length() - 1) : string2.toUpperCase();
                string = this.validateTableName(string2);
                if (string == null) continue;
                return string;
            }
            if (!bl) {
                string = DM4JResourceUtilities.getUIString("DISCOGWOBJ_ERROR_ATLEAST_SELECT_ONE");
            }
        } else {
            String string3 = this.m_tfGWObjs[0].getText();
            if (string3.startsWith("\"")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            string = this.validateTableName(string3);
        }
        return string;
    }

    private String validateTableName(String string) {
        Object var2_2 = null;
        if (string.length() == 0) {
            return DM4JResourceUtilities.getUIString("COPY_ERROR_TABLE_EMPTY");
        }
        if (!ValidationUtil.checkStringLength(string, 30)) {
            return DM4JResourceUtilities.getUIString("COPY_ERROR_TABLE_TOOLONG");
        }
        if (ValidationUtil.containsDoubleQuote(string)) {
            // empty if block
        }
        if (ValidationUtil.isEqualToROWID(string)) {
            return DM4JResourceUtilities.getUIString("COPY_ERROR_TABLE_NAME_RESERVED");
        }
        if (ValidationUtil.isGreater32BytesInDB(string, this.m_dbConn)) {
            return DM4JResourceUtilities.getUIString("COPY_ERROR_TABLE_32");
        }
        if (!ValidationUtil.isTableNameUnique(string, this.m_dbConn)) {
            return DM4JResourceUtilities.getUIString("COPY_ERROR_TABLE_EXISTS_IN_SOURCE");
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 200 + 150 * this.m_numOfTables);
    }
}

