/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import oracle.dmt.dm4j.browser.LAFType;

public class UserPreferences {
    private static UserPreferences m_instance = null;
    private Properties m_properties = null;
    private static final String YES_VALUE = "yes";
    private static final String NO_VALUE = "no";
    public static final String PREF_WORKING_DIRECTORY = "WORKING_DIRECTORY";
    public static final String PREF_SQLLOADER_PATH = "SQLLOADER_PATH";
    private static final String DEFAULT_SQLLOADER_PATH = "";
    private static final String PREF_LAF = "LAF";
    private static final String DEFAULT_LAF = LAFType.ORACLE.toString();
    private static final String PREF_SAMPLE_ROW_COUNT = "PREF_SAMPLE_ROW_COUNT";
    private static final int DEFAULT_SAMPLE_ROW_COUNT = 1000;
    public static final int MIN_SAMPLE_ROWS = 1000;
    private static final String PREF_UNIQUE_PERCENTAGE = "PREF_UNIQUE_PERCENTAGE";
    private static final float DEFAULT_UNIQUE_PERCENTAGE = 0.97f;
    private static final String PREF_MAXIMUM_NUMERICAL_BIN = "PREF_MAXIMUM_NUMERICAL_BIN";
    private static final int DEFAULT_MAXIMUM_NUMERICAL_BIN = 250;
    private static final String PREF_MAXIMUM_CATEGORICAL_BIN = "PREF_MAXIMUM_CATEGORICAL_BIN";
    private static final int DEFAULT_MAXIMUM_CATEGORICAL_BIN = 125;
    private static final String PREF_MAXIMUM_ABN_CATEGORICAL_BIN = "PREF_MAXIMUM_ABN_CATEGORICAL_BIN";
    private static final int DEFAULT_MAXIMUM_ABN_CATEGORICAL_BIN = 5;
    private static final String PREF_MAXIMUM_ABN_NUMERICAL_BIN = "PREF_MAXIMUM_ABN_NUMERICAL_BIN";
    private static final int DEFAULT_MAXIMUM_ABN_NUMERICAL_BIN = 5;
    private static final String PREF_MAXIMUM_DISTINCT_CAT_CUTOFF = "PREF_MAXIMUM_DISTINCT_CAT_CUTOFF";
    private static final int DEFAULT_MAXIMUM_DISTINCT_CAT_CUTOFF = 60;
    private static final String PREF_PERCENTAGE_UNIQUE_THRESHOLD_CATEGORICAL = "PREF_PERCENTAGE_UNIQUE_THRESHOLD_CATEGORICAL";
    private static final float DEFAULT_PERCENTAGE_UNIQUE_THRESHOLD_CATEGORICAL = 0.8f;
    private static final String PREF_CUTOFF_FOR_NUMBER_FOR_CATEGORICAL = "PREF_CUTOFF_FOR_NUMBER_FOR_CATEGORICAL";
    private static final int DEFAULT_CUTOFF_FOR_NUMBER_FOR_CATEGORICAL = 5;
    private static final String PREF_FINISHED_TASKS_AGE = "PREF_FINISHED_TASKS_AGE";
    private static final int DEFAULT_FINISHED_TASKS_AGE = 60;
    private static final String PREF_SPARSITY_CUTOFF = "PREF_SPARSITY_CUTOFF";
    private static final double DEFAULT_SPARSITY_CUTOFF = 90.0;
    private static final String PREF_ACTIVITY_RUN_ON_FINISH = "PREF_ACTIVITY_RUN_ON_FINISH";
    private static final boolean DEFAULT_ACTIVITY_RUN_ON_FINISH = false;
    private static final String DEFAULT_ACTIVITY_RUN_ON_FINISH_STR = "yes";
    private static final String PREFERENCES_DIRECTORY = "ODMiner";
    private static final String PREFERENCES_FILE = "odminer10.2.properties";
    private static final String PREF_FILE_HEADER = "Oracle Data Miner Preferences file";
    private static final String KEY_PREFIX = "value$.";
    private static final String PREF_DISCO_ENABLE_GW = "PREF_DISCO_ENABLE_GW";
    private static final boolean DEFAULT_DISCO_ENABLE_GW = false;
    private static final String DEFAULT_DISCO_ENABLE_GW_STR = "yes";
    private static final String PREF_DISCO_EUL_USER_NAME = "PREF_DISCO_EUL_USER_NAME";
    private static final String DEFAULT_DISCO_EUL_USER_NAME = "";
    private static final String PREF_DISCO_EUL_PASSWD = "PREF_DISCO_EUL_PASSWD";
    private static final String DEFAULT_DISCO_EUL_PASSWD = "";
    private static final String PREF_DISCO_GW_DB_LINK = "PREF_DISCO_GW_DB_LINK";
    private static final String DEFAULT_DISCO_GW_DB_LINK = "";
    private static final String PREF_DISCO_BITOOLS_HOME = "PREF_DISCO_BITOOLS_HOME";
    private static final String DEFAULT_DISCO_BITOOLS_HOME = "";
    private static final String PREF_DISCO_JAVA_COMMAND_LINE = "PREF_DISCO_JAVA_COMMAND_LINE";
    private static final String DEFAULT_DISCO_JAVA_COMMAND_LINE = "";
    private static final String PREF_DEFAULT_DATA_DATA_SOURCE_SCHEMA = "PREF_DEFAULT_DATA_DATA_SOURCE_SCHEMA";
    private static final String PREF_DEFAULT_DATA_DATA_CASE_TABLE = "PREF_DEFAULT_DATA_DATA_CASE_TABLE";
    private static final String PREF_CLUSTER_DETAILS_PRECISION_OPTION = "PREF_CLUSTER_DETAILS_PRECISION_OPTION";
    private static final boolean DEFAULT_PREF_CLUSTER_DETAILS_PRECISION_OPTION = true;
    private static final String DEFAULT_PREF_CLUSTER_DETAILS_PRECISION_OPTION_STR = "yes";
    private static final String PREF_CLUSTER_DETAILS_PRECISION_DEGREE = "PREF_CLUSTER_DETAILS_PRECISION_DEGREE";
    private static final int DEFAULT_PREF_CLUSTER_DETAILS_PRECISION_DEGREE = 4;

    public static void init() throws Exception {
        try {
            if (null == m_instance) {
                m_instance = new UserPreferences(false);
            }
        }
        catch (Exception exception) {
            UserPreferences.initDefaultInstance();
            throw new Exception("Could not init preferences from file, using defaults");
        }
    }

    private static void initDefaultInstance() {
        try {
            m_instance = new UserPreferences(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static UserPreferences getInstance() {
        return m_instance;
    }

    private UserPreferences() throws Exception {
        throw new Exception("Default constructor not allowed");
    }

    private UserPreferences(boolean bl) throws Exception {
        this.m_properties = new Properties();
        if (bl) {
            this.initWithDefaultValues();
            return;
        }
        File file = new File(this.getFilePath());
        if (file.exists()) {
            this.load(file);
        } else {
            File file2 = new File(this.getApplicationDir());
            if (!file2.exists()) {
                file2.mkdir();
            }
            file.createNewFile();
            this.initWithDefaultValues();
            this.save();
        }
    }

    public String getUserHomeDir() {
        String string = System.getProperty("user.home", null);
        if (string == null) {
            string = "";
        }
        return string + "/";
    }

    public String getApplicationDir() {
        Object object;
        String string = System.getProperty("os.name");
        String string2 = "";
        if (string.startsWith("Windows")) {
            string2 = "Application Data";
            object = new File(this.getUserHomeDir() + string2);
            if (!((File)object).exists()) {
                string2 = "";
            }
        }
        object = this.getUserHomeDir() + string2 + "/" + PREFERENCES_DIRECTORY + "/";
        return object;
    }

    private String getFilePath() {
        return this.getApplicationDir() + PREFERENCES_FILE;
    }

    private void load(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.m_properties.load(fileInputStream);
        String string = (String)this.m_properties.get(PREF_SAMPLE_ROW_COUNT);
        this.fillMissingValues();
    }

    private void fillMissingValues() {
        boolean bl = false;
        String string = (String)this.m_properties.get(PREF_SAMPLE_ROW_COUNT);
        if (null == string) {
            this.setSampleSize(1000);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_WORKING_DIRECTORY))) {
            this.setWorkingDirectory(System.getProperty("user.dir", ""));
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_SQLLOADER_PATH))) {
            this.setSQLLoaderPath("");
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_UNIQUE_PERCENTAGE))) {
            this.setUniquePercentage(0.97f);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_MAXIMUM_NUMERICAL_BIN))) {
            this.setMaxNumericalBin(250);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_MAXIMUM_CATEGORICAL_BIN))) {
            this.setMaxCategoricalBin(125);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_MAXIMUM_ABN_CATEGORICAL_BIN))) {
            this.setMaxABNCategoricalBin(5);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_MAXIMUM_ABN_NUMERICAL_BIN))) {
            this.setMaxABNNumericalBin(5);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_MAXIMUM_DISTINCT_CAT_CUTOFF))) {
            this.setMaxDistinctCategoricalCutoff(60);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_PERCENTAGE_UNIQUE_THRESHOLD_CATEGORICAL))) {
            this.setPercentUniqueThresholdCategorical(0.8f);
            bl = true;
        } else if ((double)this.getPercentUniqueThresholdCategorical() > 1.0) {
            this.setPercentUniqueThresholdCategorical(0.8f);
            bl = true;
        }
        string = (String)this.m_properties.get(PREF_CUTOFF_FOR_NUMBER_FOR_CATEGORICAL);
        if (null == string) {
            this.setCutoffForNumberForCategorical(5);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_FINISHED_TASKS_AGE))) {
            this.setFinishedTasksAge(60);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_SPARSITY_CUTOFF))) {
            this.setSparsityCutoff(90.0);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_LAF))) {
            this.setLAF(DEFAULT_LAF);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_DISCO_ENABLE_GW))) {
            this.setDiscoEnableGW(false);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_ACTIVITY_RUN_ON_FINISH))) {
            this.setActivityRunOnFinish(false);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_CLUSTER_DETAILS_PRECISION_OPTION))) {
            this.setClusterDetailsPrecisionOption(true);
            bl = true;
        }
        if (null == (string = (String)this.m_properties.get(PREF_CLUSTER_DETAILS_PRECISION_DEGREE))) {
            this.setClusterDetailsPrecisionDegree(4);
            bl = true;
        }
        if (bl) {
            try {
                this.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initWithDefaultValues() {
        this.m_properties.put(PREF_SQLLOADER_PATH, "");
        this.m_properties.put(PREF_WORKING_DIRECTORY, System.getProperty("user.dir", ""));
        this.m_properties.put(PREF_LAF, DEFAULT_LAF);
        this.m_properties.put(PREF_SAMPLE_ROW_COUNT, "1000");
        this.m_properties.put(PREF_UNIQUE_PERCENTAGE, "0.97");
        this.m_properties.put(PREF_MAXIMUM_NUMERICAL_BIN, "250");
        this.m_properties.put(PREF_MAXIMUM_CATEGORICAL_BIN, "125");
        this.m_properties.put(PREF_MAXIMUM_ABN_NUMERICAL_BIN, "5");
        this.m_properties.put(PREF_MAXIMUM_DISTINCT_CAT_CUTOFF, "60");
        this.m_properties.put(PREF_MAXIMUM_ABN_CATEGORICAL_BIN, "5");
        this.m_properties.put(PREF_CUTOFF_FOR_NUMBER_FOR_CATEGORICAL, "5");
        this.m_properties.put(PREF_FINISHED_TASKS_AGE, "60");
        this.m_properties.put(PREF_SPARSITY_CUTOFF, "90.0");
        this.m_properties.put(PREF_ACTIVITY_RUN_ON_FINISH, "yes");
        this.m_properties.put(PREF_PERCENTAGE_UNIQUE_THRESHOLD_CATEGORICAL, "0.8");
        this.m_properties.put(PREF_CLUSTER_DETAILS_PRECISION_OPTION, "yes");
        this.m_properties.put(PREF_CLUSTER_DETAILS_PRECISION_DEGREE, "4");
    }

    public void save() throws Exception {
        String string = this.getFilePath();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.m_properties.store(fileOutputStream, PREF_FILE_HEADER);
    }

    public int getSampleSize() {
        String string = (String)this.m_properties.get(PREF_SAMPLE_ROW_COUNT);
        return Integer.parseInt(string);
    }

    public void setSampleSize(int n) {
        this.m_properties.put(PREF_SAMPLE_ROW_COUNT, "" + n);
    }

    public static int getMinimumSampleSize() {
        return 1000;
    }

    public String getWorkingDirectory() {
        return (String)this.m_properties.get(PREF_WORKING_DIRECTORY);
    }

    public void setWorkingDirectory(String string) {
        this.m_properties.put(PREF_WORKING_DIRECTORY, string);
    }

    public String getSQLLoaderPath() {
        return (String)this.m_properties.get(PREF_SQLLOADER_PATH);
    }

    public void setBooleanValue(String string, boolean bl) throws Exception {
        String string2 = bl ? "yes" : NO_VALUE;
        this.m_properties.put(KEY_PREFIX + string, string2);
        this.save();
    }

    public boolean getBooleanValue(String string) {
        String string2 = (String)this.m_properties.get(KEY_PREFIX + string);
        if (null == string2) {
            try {
                this.setBooleanValue(string, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        return string2.equalsIgnoreCase("yes");
    }

    public void setIntegerValue(String string, int n) throws Exception {
        String string2 = Integer.toString(n);
        this.m_properties.put(KEY_PREFIX + string, string2);
        this.save();
    }

    public Integer getIntegerValue(String string) {
        String string2 = (String)this.m_properties.get(KEY_PREFIX + string);
        if (null == string2) {
            return null;
        }
        return Integer.valueOf(string2);
    }

    public void setStringValue(String string, String string2) throws Exception {
        this.m_properties.put(KEY_PREFIX + string, string2);
        this.save();
    }

    public String getStringValue(String string) {
        String string2 = (String)this.m_properties.get(KEY_PREFIX + string);
        if (null == string2) {
            return null;
        }
        return string2;
    }

    public void setSQLLoaderPath(String string) {
        this.m_properties.put(PREF_SQLLOADER_PATH, string);
    }

    public void setUniquePercentage(float f) {
        this.m_properties.put(PREF_UNIQUE_PERCENTAGE, "" + f);
    }

    public float getUniquePercentage() {
        String string = (String)this.m_properties.get(PREF_UNIQUE_PERCENTAGE);
        return Float.parseFloat(string);
    }

    public void setMaxCategoricalBin(int n) {
        this.m_properties.put(PREF_MAXIMUM_CATEGORICAL_BIN, "" + n);
    }

    public int getMaxCategoricalBin() {
        String string = (String)this.m_properties.get(PREF_MAXIMUM_CATEGORICAL_BIN);
        return Integer.parseInt(string);
    }

    public void setMaxNumericalBin(int n) {
        this.m_properties.put(PREF_MAXIMUM_NUMERICAL_BIN, "" + n);
    }

    public int getMaxNumericalBin() {
        String string = (String)this.m_properties.get(PREF_MAXIMUM_NUMERICAL_BIN);
        return Integer.parseInt(string);
    }

    public void setMaxABNNumericalBin(int n) {
        this.m_properties.put(PREF_MAXIMUM_ABN_NUMERICAL_BIN, "" + n);
    }

    public int getMaxABNNumericalBin() {
        String string = (String)this.m_properties.get(PREF_MAXIMUM_ABN_NUMERICAL_BIN);
        return Integer.parseInt(string);
    }

    public void setMaxABNCategoricalBin(int n) {
        this.m_properties.put(PREF_MAXIMUM_ABN_CATEGORICAL_BIN, "" + n);
    }

    public int getMaxABNCategoricalBin() {
        String string = (String)this.m_properties.get(PREF_MAXIMUM_ABN_CATEGORICAL_BIN);
        return Integer.parseInt(string);
    }

    public void setCutoffForNumberForCategorical(int n) {
        this.m_properties.put(PREF_CUTOFF_FOR_NUMBER_FOR_CATEGORICAL, "" + n);
    }

    public int getCutoffForNumberForCategorical() {
        String string = (String)this.m_properties.get(PREF_CUTOFF_FOR_NUMBER_FOR_CATEGORICAL);
        return Integer.parseInt(string);
    }

    public void setMaxDistinctCategoricalCutoff(int n) {
        this.m_properties.put(PREF_MAXIMUM_DISTINCT_CAT_CUTOFF, "" + n);
    }

    public int getMaxDistinctCategoricalCutoff() {
        String string = (String)this.m_properties.get(PREF_MAXIMUM_DISTINCT_CAT_CUTOFF);
        return Integer.parseInt(string);
    }

    public void setPercentUniqueThresholdCategorical(float f) {
        this.m_properties.put(PREF_PERCENTAGE_UNIQUE_THRESHOLD_CATEGORICAL, "" + f);
    }

    public float getPercentUniqueThresholdCategorical() {
        String string = (String)this.m_properties.get(PREF_PERCENTAGE_UNIQUE_THRESHOLD_CATEGORICAL);
        return Float.parseFloat(string);
    }

    public void setFinishedTasksAge(int n) {
        this.m_properties.put(PREF_FINISHED_TASKS_AGE, "" + n);
    }

    public void setSparsityCutoff(double d) {
        this.m_properties.put(PREF_SPARSITY_CUTOFF, "" + d);
    }

    public int getFinishedTasksAge() {
        String string = (String)this.m_properties.get(PREF_FINISHED_TASKS_AGE);
        return Integer.parseInt(string);
    }

    public double getSparsityCutoff() {
        String string = (String)this.m_properties.get(PREF_SPARSITY_CUTOFF);
        return Double.parseDouble(string);
    }

    public String getLAF() {
        String string = (String)this.m_properties.get(PREF_LAF);
        return string;
    }

    public void setLAF(String string) {
        this.m_properties.put(PREF_LAF, string);
    }

    public boolean isKeyThere(String string) {
        String string2 = this.m_properties.getProperty(KEY_PREFIX + string);
        return null != string2;
    }

    public void setDiscoEnableGW(boolean bl) {
        String string = bl ? "yes" : NO_VALUE;
        this.m_properties.put(PREF_DISCO_ENABLE_GW, string);
    }

    public boolean getDiscoEnableGW() {
        String string = (String)this.m_properties.get(PREF_DISCO_ENABLE_GW);
        return string.equalsIgnoreCase("yes");
    }

    public void setClusterDetailsPrecisionOption(boolean bl) {
        String string = bl ? "yes" : NO_VALUE;
        this.m_properties.put(PREF_CLUSTER_DETAILS_PRECISION_OPTION, string);
    }

    public boolean getClusterDetailsPrecisionOption() {
        String string = (String)this.m_properties.get(PREF_CLUSTER_DETAILS_PRECISION_OPTION);
        return string.equalsIgnoreCase("yes");
    }

    public void setClusterDetailsPrecisionDegree(int n) {
        this.m_properties.put(PREF_CLUSTER_DETAILS_PRECISION_DEGREE, "" + n);
    }

    public int getClusterDetailsPrecisionDegree() {
        String string = this.m_properties.getProperty(PREF_CLUSTER_DETAILS_PRECISION_DEGREE);
        return Integer.parseInt(string);
    }

    public void setEULUserName(String string) {
        this.m_properties.put(PREF_DISCO_EUL_USER_NAME, string);
    }

    public String getEULUserName() {
        return this.m_properties.getProperty(PREF_DISCO_EUL_USER_NAME);
    }

    public void setEULPasswd(String string) {
        this.m_properties.put(PREF_DISCO_EUL_PASSWD, string);
    }

    public String getEULPasswd() {
        return this.m_properties.getProperty(PREF_DISCO_EUL_PASSWD);
    }

    public void setGWDBLinkName(String string) {
        this.m_properties.put(PREF_DISCO_GW_DB_LINK, string);
    }

    public String getGWDBLinkName() {
        return this.m_properties.getProperty(PREF_DISCO_GW_DB_LINK);
    }

    public void setBIToolsHome(String string) {
        this.m_properties.put(PREF_DISCO_BITOOLS_HOME, string);
    }

    public String getBIToolsHome() {
        return this.m_properties.getProperty(PREF_DISCO_BITOOLS_HOME);
    }

    public void setJavaCommandLineJar(String string) {
        this.m_properties.put(PREF_DISCO_JAVA_COMMAND_LINE, string);
    }

    public String getJavaCommandLineJar() {
        return this.m_properties.getProperty(PREF_DISCO_JAVA_COMMAND_LINE);
    }

    public void setDefaultDataSourceSchema(String string) {
        this.m_properties.put(PREF_DEFAULT_DATA_DATA_SOURCE_SCHEMA, string);
    }

    public String getDefaultDataSourceSchema() {
        return this.m_properties.getProperty(PREF_DEFAULT_DATA_DATA_SOURCE_SCHEMA);
    }

    public void setDefaultCaseTable(String string) {
        this.m_properties.put(PREF_DEFAULT_DATA_DATA_CASE_TABLE, string);
    }

    public String getDefaultCaseTable() {
        return this.m_properties.getProperty(PREF_DEFAULT_DATA_DATA_CASE_TABLE);
    }

    public boolean getActivityRunOnFinish() {
        String string = (String)this.m_properties.get(PREF_ACTIVITY_RUN_ON_FINISH);
        return string.equalsIgnoreCase("yes");
    }

    public void setActivityRunOnFinish(boolean bl) {
        String string = bl ? "yes" : NO_VALUE;
        this.m_properties.put(PREF_ACTIVITY_RUN_ON_FINISH, string);
    }
}

