/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.bali.ewt.busyBar.BusyBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.browser.viewer.table.ModelUtil;

public class ProgressBar
implements ActionListener,
Runnable {
    private Component _parent;
    private JLabel _progressLabel = new JLabel();
    private String _progressText;
    private JLabel _stepLabel = new JLabel();
    private String _stepText;
    private JProgressBar _progressBar;
    private BusyBar _busyBar;
    private boolean _useBusyBar;
    private JEWTDialog _statusDialog;
    private String _dialogTitle;
    private int _completionStatus;
    private Timer _labelTimer;
    private Timer _completionTimer;
    private boolean _userCancelled;
    private Runnable _runnable;
    private long _current = 0L;
    private long _lastPause = 0L;
    private boolean _done = false;
    private boolean _canCancel = true;
    private boolean _isSilent = false;
    private boolean _enableUserCancel = true;

    public ProgressBar(Component component, String string, Runnable runnable, boolean bl) {
        this(component, string, runnable, bl, false);
    }

    public ProgressBar(Component component, String string, Runnable runnable, boolean bl, boolean bl2) {
        this._parent = component;
        this._dialogTitle = string;
        this._runnable = runnable;
        this._useBusyBar = bl;
        this._isSilent = bl2;
    }

    public void setCancelable(boolean bl) {
        this._canCancel = bl;
    }

    public boolean isCancelable() {
        return this._canCancel;
    }

    public void setEnableUserCancel(boolean bl) {
        this._enableUserCancel = bl;
    }

    public void start(String string, String string2) {
        Object object;
        if (!this._isSilent) {
            this._progressText = string;
            this._stepText = string2;
            object = new JPanel(new GridBagLayout());
            this._progressLabel.setText(this._progressText);
            this._progressLabel.setLabelFor(this._progressBar);
            this._stepLabel.setText(this._stepText);
            if (this._useBusyBar) {
                this._busyBar = new BusyBar();
            } else {
                this._progressBar = new JProgressBar();
                this._progressBar.setValue(0);
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
            ((Container)object).add((Component)this._progressLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            if (this._useBusyBar) {
                ((Container)object).add((Component)this._busyBar, gridBagConstraints);
                this._busyBar.start();
            } else {
                ((Container)object).add((Component)this._progressBar, gridBagConstraints);
            }
            gridBagConstraints.gridy = 2;
            ((Container)object).add((Component)this._stepLabel, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            ((Container)object).add(Box.createHorizontalStrut(300), gridBagConstraints);
            this._labelTimer = new Timer(1, this);
            this._labelTimer.setRepeats(true);
            this._completionTimer = new Timer(1, this);
            this._completionTimer.setRepeats(false);
            this._userCancelled = false;
            try {
                this._statusDialog = ProgressDialog.createDialog(this._parent, this._dialogTitle, this._canCancel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this._statusDialog == null) {
                return;
            }
            this._statusDialog.setContent((Component)object);
        }
        object = new Thread(this);
        ((Thread)object).setPriority(5);
        ((Thread)object).start();
        if (!this._isSilent) {
            boolean bl = this._statusDialog.runDialog();
            if (bl) {
                this._userCancelled = false;
            } else {
                this._userCancelled = true;
                if (this._runnable instanceof Cancelable) {
                    ((Cancelable)((Object)this._runnable)).cancel();
                }
            }
        }
    }

    public void updateProgress(int n, String string, String string2) {
        if (this._isSilent) {
            return;
        }
        if (this._userCancelled) {
            return;
        }
        if (this._progressBar == null) {
            return;
        }
        this._completionStatus = n;
        if (ModelUtil.hasLength(string)) {
            this._progressText = string;
        }
        if (ModelUtil.hasLength(string2)) {
            this._stepText = string2;
        }
        this._labelTimer.start();
    }

    public void updateProgress(String string, String string2) {
        if (this._isSilent) {
            return;
        }
        if (!this._userCancelled) {
            if (ModelUtil.hasLength(string)) {
                this._progressText = string;
            }
            if (ModelUtil.hasLength(string2)) {
                this._stepText = string2;
            }
            this._labelTimer.start();
        }
    }

    public boolean hasUserCancelled() {
        if (!this._enableUserCancel) {
            return false;
        }
        if (this._userCancelled) {
            this.setDoneStatus();
        }
        return this._userCancelled;
    }

    public void sleepForUIToRepaint() {
        if (this._lastPause == 0L) {
            this._current = this._lastPause = System.currentTimeMillis();
        } else {
            this._current = System.currentTimeMillis();
            long l = this._current - this._lastPause;
            if (l > 1000L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this._lastPause = this._current;
            }
        }
    }

    public synchronized void waitUntilDone() {
        while (!this._done) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.notifyAll();
    }

    public synchronized void setDoneStatus() {
        this._done = true;
        this.notifyAll();
        this.end();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._labelTimer) {
            if (ModelUtil.hasLength(this._progressText)) {
                this._progressLabel.setText(this._progressText);
            }
            if (ModelUtil.hasLength(this._stepText)) {
                this._stepLabel.setText(this._stepText);
            }
            if (this._progressBar != null) {
                this._progressBar.setValue(this._completionStatus);
            }
        } else if (object == this._completionTimer) {
            if (this._useBusyBar) {
                this._busyBar.stop();
            }
            if (this._statusDialog.isVisible()) {
                this._statusDialog.setVisible(false);
                this._statusDialog.dispose();
            }
            if (this._labelTimer != null) {
                this._labelTimer.stop();
                this._labelTimer.removeActionListener(this);
                this._labelTimer = null;
            }
            this._completionTimer.stop();
            this._completionTimer.removeActionListener(this);
            this._completionTimer = null;
        }
    }

    public void run() {
        if (this._userCancelled) {
            return;
        }
        this._runnable.run();
    }

    private void end() {
        if (this._completionTimer != null) {
            this._completionTimer.start();
        }
    }

    public static Dialog getAncestorDialog(Component component) {
        return component != null ? (component instanceof Dialog ? (Dialog)component : (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, component)) : null;
    }

    public static Frame getAncestorFrame(Component component) {
        return component != null ? (component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component)) : null;
    }

    private static class ProgressDialog
    extends JEWTDialog {
        static ProgressDialog createDialog(Component component, String string, boolean bl) {
            ProgressDialog progressDialog = null;
            Dialog dialog = ProgressBar.getAncestorDialog(component);
            if (dialog != null) {
                progressDialog = new ProgressDialog(dialog, string, bl);
            } else {
                Frame frame = ProgressBar.getAncestorFrame(component);
                if (frame != null) {
                    progressDialog = new ProgressDialog(frame, string, bl);
                }
            }
            return progressDialog;
        }

        private static int _getButtonMask(boolean bl) {
            return bl ? 2 : 0;
        }

        private ProgressDialog(Dialog dialog, String string, boolean bl) {
            super(dialog, string, ProgressDialog._getButtonMask(bl));
            this._init(bl);
        }

        private ProgressDialog(Frame frame, String string, boolean bl) {
            super(frame, string, ProgressDialog._getButtonMask(bl));
            this._init(bl);
        }

        private void _init(boolean bl) {
            this.setDefaultButton(ProgressDialog._getButtonMask(bl));
            if (!bl) {
                this.setDefaultCloseOperation(0);
            }
        }

        protected void dismissDialog(boolean bl) {
            if (this.getDefaultCloseOperation() != 0) {
                super.dismissDialog(bl);
            }
        }
    }
}

