/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.ConnectionPersistence;
import oracle.dmt.dm4j.ConnectionPersistenceInfo;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.ConnectionEditDialog;
import oracle.dmt.dm4j.browser.GetSValueDialog;
import oracle.dmt.dm4j.browser.GetSValuePanel;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.help.CSHManager;
import oracle.help.Help;
import oracle.help.common.util.LocaleUtils;
import oracle.help.library.Book;
import oracle.help.library.helpset.HelpSet;

public class ConnectionDialog
extends JDialog {
    public static int RET_OK = 0;
    public static int RET_CANCEL = 1;
    private ConnectionPersistenceInfo[] _conns = null;
    private JComboBox jComboBoxConn;
    private JLabel jLabelText = new JLabel();
    private JLabel jLabelConn = new JLabel();
    private JButton OK = new JButton();
    private JButton Cancel = new JButton();
    private JButton btnEdit = new JButton();
    private JButton btnDelete = new JButton();
    private JButton btnNew = new JButton();
    private JButton btnHelp = new JButton();
    private JLabel jLabelBlank = new JLabel();
    private String m_username = null;
    private ConnectionPersistenceInfo m_connInfo = null;
    private int m_ret = RET_CANCEL;
    private Help m_help = null;
    private CSHManager m_helpCxtMgr = null;
    private char[] _se = null;

    public ConnectionDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 27) {
                    ConnectionDialog.this.cancel_actionPerformed(null);
                    keyEvent.consume();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
            }
        });
    }

    private void jbInit() throws Exception {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        try {
            serializable = this.getClass().getResource("/dm4j_help.hs");
            object3 = serializable.toString();
            object2 = ((String)object3).substring(0, ((String)object3).indexOf(".jar"));
            serializable = LocaleUtils.findLocalizedHelpSet((String)object2, ".jar!/dm4j_help.hs", Locale.getDefault());
            this.m_help = new Help(false, false, true);
            Help.registerClientWindow(this);
            this.m_helpCxtMgr = new CSHManager(this.m_help);
            object = new HelpSet((URL)serializable);
            this.m_helpCxtMgr.addBook((Book)object, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_helpCxtMgr.addComponent(this, "CONNECTION_DLG", true, false);
        serializable = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().getInputMap(1).put((KeyStroke)serializable, "CancelAction");
        this.getRootPane().getActionMap().put("CancelAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.cancel_actionPerformed(actionEvent);
            }
        });
        serializable = KeyStroke.getKeyStroke(10, 0, true);
        this.getRootPane().getInputMap(1).put((KeyStroke)serializable, "OKAction");
        this.getRootPane().getActionMap().put("OKAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.ok_actionPerformed(actionEvent);
            }
        });
        serializable = KeyStroke.getKeyStroke(112, 0, true);
        this.getRootPane().getInputMap(1).put((KeyStroke)serializable, "HelpAction");
        this.getRootPane().getActionMap().put("HelpAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.help_actionPerformed(actionEvent);
            }
        });
        this.setSize(new Dimension(350, 230));
        object3 = new GriddedPanel();
        ((JComponent)object3).setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.getContentPane().add("Center", (Component)object3);
        this.jLabelText.setText(DM4JResourceUtilities.getUIString("ADDIN_CONNECTION_DESC"));
        object2 = ConnectionPersistence.getInstance();
        this._conns = ((ConnectionPersistence)object2).getConnections();
        if (this._conns.length != 0) {
            this.jComboBoxConn = new JComboBox<ConnectionPersistenceInfo>(this._conns);
            object = ((ConnectionPersistence)object2).getDefaultConnectionName();
            for (int i = 0; i < this._conns.length; ++i) {
                if (!this._conns[i].getConnectionName().equalsIgnoreCase((String)object)) continue;
                this.jComboBoxConn.setSelectedItem(this._conns[i]);
                break;
            }
        } else {
            this.jComboBoxConn = new JComboBox();
            this.new_actionPerformed(null);
        }
        DM4JResourceUtilities.configureUILabel(this.jLabelConn, "CONN_CONNECTION", this.jComboBoxConn, dM4JListResourceBundle);
        this.jComboBoxConn.addActionListener(new ActionListener((ConnectionPersistence)object2){
            final /* synthetic */ ConnectionPersistence val$cp;
            {
                this.val$cp = connectionPersistence;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionPersistenceInfo connectionPersistenceInfo = (ConnectionPersistenceInfo)ConnectionDialog.this.jComboBoxConn.getSelectedItem();
                String string = "";
                if (connectionPersistenceInfo != null) {
                    string = connectionPersistenceInfo.getConnectionName();
                }
                try {
                    this.val$cp.storeDefaultConnectionName(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.OK.setText(DM4JResourceUtilities.getUIString("COMMON_OK"));
        this.OK.setActionCommand("OK");
        this.OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.ok_actionPerformed(actionEvent);
            }
        });
        this.Cancel.setText(DM4JResourceUtilities.getUIString("COMMON_CANCEL"));
        this.Cancel.setActionCommand("Cancel");
        this.Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.cancel_actionPerformed(actionEvent);
            }
        });
        this.btnHelp.setText(DM4JResourceUtilities.getUIString("COMMON_HELP"));
        this.btnHelp.setActionCommand("Help");
        this.btnHelp.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_HELP"));
        this.btnHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.help_actionPerformed(actionEvent);
            }
        });
        this.btnEdit.setText(DM4JResourceUtilities.getUIString("COMMON_EDIT"));
        this.btnEdit.setActionCommand("Edit");
        this.btnEdit.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_EDIT"));
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.edit_actionPerformed(actionEvent);
            }
        });
        this.btnDelete.setText(DM4JResourceUtilities.getUIString("COMMON_DELETE"));
        this.btnDelete.setActionCommand("Delete");
        this.btnDelete.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_DELETE"));
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.delete_actionPerformed(actionEvent);
            }
        });
        this.btnNew.setText(DM4JResourceUtilities.getUIString("COMMON_NEW"));
        this.btnNew.setActionCommand("New");
        this.btnNew.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_NEW"));
        this.btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.new_actionPerformed(actionEvent);
            }
        });
        ((GriddedPanel)object3).addFilledComponent(this.jLabelText, GriddedPanel.TOPLABELITEMINSETS, 1, 1, 6, 2, 1);
        ((GriddedPanel)object3).addFilledComponent(this.jLabelConn, GriddedPanel.MIDLABELITEMINSETS, 3, 1, 1, 1, 1);
        ((GriddedPanel)object3).addFilledComponent(this.jComboBoxConn, GriddedPanel.MIDVALUEITEMINSETS, 3, 2, 5, 1, 2);
        ((GriddedPanel)object3).addFilledComponent(this.btnNew, new Insets(5, 5, 0, 5), 4, 4, 1, 1, 0);
        ((GriddedPanel)object3).addFilledComponent(this.btnEdit, new Insets(5, 5, 0, 5), 4, 5, 1, 1, 0);
        ((GriddedPanel)object3).addFilledComponent(this.btnDelete, new Insets(5, 5, 0, 5), 4, 6, 1, 1, 0);
        ((GriddedPanel)object3).addFilledComponent(this.jLabelBlank, GriddedPanel.MIDLABELITEMINSETS, 5, 1, 4, 2, 1);
        ((GriddedPanel)object3).addFilledComponent(this.btnHelp, GriddedPanel.MIDVALUEITEMINSETS, 7, 1, 1, 1, 0);
        ((GriddedPanel)object3).addFilledComponent(new JLabel(), GriddedPanel.MIDLABELITEMINSETS, 7, 2, 2, 1, 1);
        ((GriddedPanel)object3).addFilledComponent(this.OK, GriddedPanel.MIDLABELITEMINSETS, 7, 5, 1, 1, 2);
        ((GriddedPanel)object3).addFilledComponent(this.Cancel, GriddedPanel.MIDVALUEITEMINSETS, 7, 6, 1, 1, 0);
        this.getRootPane().setDefaultButton(this.OK);
    }

    public String getUsername() {
        return this.m_username;
    }

    public int getUserAction() {
        return this.m_ret;
    }

    public ConnectionPersistenceInfo getConnectionPersistenceInfo() {
        return this.m_connInfo;
    }

    private void ok_actionPerformed(ActionEvent actionEvent) {
        if (this.jComboBoxConn.getItemCount() == 0) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("CONN_EMPTY"), DM4JVersion.getFullBrowserName(), 0, null);
            return;
        }
        this.setCursor(new Cursor(3));
        this.m_connInfo = (ConnectionPersistenceInfo)this.jComboBoxConn.getSelectedItem();
        try {
            this._se = this.m_connInfo.retrievePassword();
        }
        catch (Exception exception) {
            this._se = null;
        }
        this.setCursor(new Cursor(0));
        if (this._se == null || this._se != null && this._se.length == 0) {
            GetSValuePanel getSValuePanel = new GetSValuePanel();
            GetSValueDialog getSValueDialog = new GetSValueDialog(this, (JPanel)getSValuePanel, "Enter Connection Password", null);
            getSValueDialog.setNoHelp();
            getSValueDialog.setVisible(true);
            this._se = (char[])(getSValueDialog.isOk() ? getSValuePanel.getSValue() : null);
        }
        this.m_ret = RET_OK;
        Help.unregisterClientWindow(this);
        this.setVisible(false);
        this.dispose();
    }

    public char[] getSEValue() {
        return this._se;
    }

    private void cancel_actionPerformed(ActionEvent actionEvent) {
        this.m_ret = RET_CANCEL;
        Help.unregisterClientWindow(this);
        this.setVisible(false);
        this.dispose();
    }

    private void help_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            this.m_helpCxtMgr.showTopic("CONNECTION_DLG");
        }
        catch (Exception exception) {
            this.m_helpCxtMgr.showTopic("dm4j_introduction_html");
        }
        this.setCursor(new Cursor(0));
    }

    private void edit_actionPerformed(ActionEvent actionEvent) {
        ConnectionPersistenceInfo connectionPersistenceInfo = (ConnectionPersistenceInfo)this.jComboBoxConn.getSelectedItem();
        ConnectionEditDialog connectionEditDialog = new ConnectionEditDialog((Dialog)this, connectionPersistenceInfo, this._conns);
        WindowUtils.centerWindow(connectionEditDialog);
        connectionEditDialog.setVisible(true);
        if (connectionEditDialog.getUserAction() == ConnectionEditDialog.RET_CANCEL) {
            return;
        }
        this.jComboBoxConn.setSelectedItem(connectionPersistenceInfo);
        try {
            ConnectionPersistence connectionPersistence = ConnectionPersistence.getInstance();
            connectionPersistence.storeConnections(this._conns, connectionPersistenceInfo.getConnectionName());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("PREF_CONN_ERROR_SAVE"), DM4JVersion.getFullBrowserName(), 0, null);
        }
    }

    private void delete_actionPerformed(ActionEvent actionEvent) {
        String string = null;
        boolean bl = false;
        if (this._conns.length == 0) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("CONN_NOTHING_TO_DELETE"), DM4JVersion.getFullBrowserName(), 0, null);
            return;
        }
        if (1 == JOptionPane.showOptionDialog(this, DM4JResourceUtilities.getUIString("CONN_DELETE_WARN"), DM4JVersion.getFullBrowserName(), 0, 3, null, null, null)) {
            return;
        }
        ConnectionPersistence connectionPersistence = ConnectionPersistence.getInstance();
        ConnectionPersistenceInfo connectionPersistenceInfo = (ConnectionPersistenceInfo)this.jComboBoxConn.getSelectedItem();
        String string2 = connectionPersistenceInfo.getConnectionName();
        Vector<ConnectionPersistenceInfo> vector = new Vector<ConnectionPersistenceInfo>();
        for (int i = 0; i < this._conns.length; ++i) {
            if (string2.equals(this._conns[i].getConnectionName())) continue;
            vector.add(this._conns[i]);
        }
        this._conns = vector.toArray(new ConnectionPersistenceInfo[0]);
        ConnectionPersistenceInfo connectionPersistenceInfo2 = (ConnectionPersistenceInfo)this.jComboBoxConn.getSelectedItem();
        this.jComboBoxConn.removeItemAt(this.jComboBoxConn.getSelectedIndex());
        Vector<ConnectionPersistenceInfo> vector2 = new Vector<ConnectionPersistenceInfo>();
        vector2.add(connectionPersistenceInfo2);
        ConnectionPersistenceInfo connectionPersistenceInfo3 = (ConnectionPersistenceInfo)this.jComboBoxConn.getSelectedItem();
        string = this._conns.length != 0 ? connectionPersistenceInfo3.getConnectionName() : "";
        try {
            connectionPersistence.storeConnections(this._conns, string);
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this, DM4JResourceUtilities.getUIString("PREF_CONN_ERROR_SAVE"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
        }
        try {
            ConnectionPersistence.removeCredentials(vector2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void new_actionPerformed(ActionEvent actionEvent) {
        Object object;
        ConnectionPersistenceInfo[] connectionPersistenceInfoArray = null;
        try {
            object = ConnectionPersistence.getInstance();
            connectionPersistenceInfoArray = ((ConnectionPersistence)object).getConnections();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("PREF_CONN_ERROR_RETRIEVE"), DM4JVersion.getFullBrowserName(), 0, null);
            return;
        }
        object = new ConnectionEditDialog((Dialog)this, null, connectionPersistenceInfoArray);
        ((Dialog)object).setTitle(DM4JResourceUtilities.getUIString("PREF_CONN_NEW_TITLE"));
        WindowUtils.centerWindow((Window)object);
        ((Dialog)object).setVisible(true);
        if (((ConnectionEditDialog)object).getUserAction() == ConnectionEditDialog.RET_CANCEL) {
            return;
        }
        ConnectionPersistenceInfo connectionPersistenceInfo = ((ConnectionEditDialog)object).getConnectionInfo();
        this._conns = this.addConnectionItem(connectionPersistenceInfo);
        this.jComboBoxConn.addItem(connectionPersistenceInfo);
        this.jComboBoxConn.setSelectedItem(connectionPersistenceInfo);
        try {
            ConnectionPersistence connectionPersistence = ConnectionPersistence.getInstance();
            connectionPersistence.storeConnections(this._conns, connectionPersistenceInfo.getConnectionName());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, DM4JResourceUtilities.getUIString("PREF_CONN_ERROR_SAVE"), DM4JVersion.getFullBrowserName(), 0, null);
        }
    }

    private ConnectionPersistenceInfo[] addConnectionItem(ConnectionPersistenceInfo connectionPersistenceInfo) {
        ConnectionPersistenceInfo[] connectionPersistenceInfoArray = new ConnectionPersistenceInfo[this._conns.length + 1];
        int n = 0;
        for (n = 0; n < this._conns.length; ++n) {
            connectionPersistenceInfoArray[n] = this._conns[n];
        }
        connectionPersistenceInfoArray[n] = connectionPersistenceInfo;
        return connectionPersistenceInfoArray;
    }
}

