/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser;

import java.awt.Component;
import java.awt.Container;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.datamining.ComparisonOperator;
import javax.datamining.MiningAlgorithm;
import javax.datamining.NamedObject;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.AttributeType;
import javax.datamining.resource.Connection;
import javax.datamining.rule.BooleanOperator;
import javax.datamining.rule.CompoundPredicate;
import javax.datamining.rule.Predicate;
import javax.datamining.rule.SimplePredicate;
import javax.swing.JFrame;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.clustering.ODMrOraSimplePredicate;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.data.OraAttributeDataType;

public class BrowserUtils {
    private static DM4JListResourceBundle m_bundle = null;
    private static DM4JListResourceBundle m_activityBundle = null;
    public static final String algo_naive_bayes = "NAIVE_BAYES";
    public static final String algo_adaptive_bayes_network = "ADAPTIVE_BAYES_NETWORK";
    public static final String algo_support_vector_machines = "SUPPORT_VECTOR_MACHINES";
    public static final String algo_generalized_linear_model = "GENERALIZED_LINEAR_MODEL";
    public static final String algo_nonnegative_matrix_factor = "NONNEGATIVE_MATRIX_FACTOR";
    public static final String algo_apriori_association_rules = "APRIORI_ASSOCIATION_RULES";
    public static final String algo_kmeans = "KMEANS";
    public static final String algo_ocluster = "O_CLUSTER";
    public static final String algo_predictor_variance = "PREDICTOR_VARIANCE";
    public static final String algo_ai_mdl = "AI_MDL";
    public static final String algo_decision_tree = "DECISION_TREE";
    public static final String classification = "CLASSIFICATION";
    public static final String regression = "REGRESSION";
    public static final String clustering = "CLUSTERING";
    public static final String association = "ASSOCIATION";
    public static final String association_in_model = "ASSOCIATION_RULES";
    public static final String feature_extraction = "FEATURE_EXTRACTION";
    public static final String attribute_importance = "ATTRIBUTE_IMPORTANCE";

    public static String getDataTypeString(AttributeDataType attributeDataType) {
        String string = null;
        if (attributeDataType == null) {
            string = new String(DM4JResourceUtilities.getUIString("COMMON_UNKNOWN"));
            return string;
        }
        string = attributeDataType.equals(AttributeDataType.doubleType) ? new String(DM4JResourceUtilities.getUIString("DATATYPE_DOUBLE")) : (attributeDataType.equals(AttributeDataType.integerType) ? new String(DM4JResourceUtilities.getUIString("DATATYPE_INT")) : (attributeDataType.equals(AttributeDataType.stringType) ? new String(DM4JResourceUtilities.getUIString("DATATYPE_STRING")) : new String(DM4JResourceUtilities.getUIString("COMMON_UNKNOWN"))));
        return string;
    }

    public static String getOracleDataTypeString(AttributeDataType attributeDataType) {
        String string = null;
        if (attributeDataType == null) {
            string = new String(DM4JResourceUtilities.getUIString("COMMON_UNKNOWN"));
            return string;
        }
        string = attributeDataType.equals(AttributeDataType.doubleType) ? "NUMBER" : (attributeDataType.equals(AttributeDataType.integerType) ? "NUMBER" : (attributeDataType.equals(AttributeDataType.stringType) ? "VARCHAR2" : (attributeDataType.equals(OraAttributeDataType.nestedTable) ? "NESTED_TABLE" : new String(DM4JResourceUtilities.getUIString("COMMON_UNKNOWN")))));
        return string;
    }

    public static String getAttributeTypeString(AttributeType attributeType) {
        String string = null;
        if (attributeType == null) {
            string = new String(DM4JResourceUtilities.getUIString("COMMON_UNKNOWN"));
            return string;
        }
        string = attributeType.equals(AttributeType.categorical) ? new String(DM4JResourceUtilities.getUIString("MINING_CATEGORICAL")) : (attributeType.equals(AttributeType.numerical) ? new String(DM4JResourceUtilities.getUIString("MINING_NUMERICAL")) : new String(DM4JResourceUtilities.getUIString("COMMON_UNKNOWN")));
        return string;
    }

    public static String getAntecedentString(Predicate predicate, Hashtable hashtable) {
        return BrowserUtils.getPredicateString(predicate, 0, hashtable);
    }

    public static String getPredicateString(Predicate predicate, int n, Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (0 != n) {
            bl = true;
        }
        if (predicate instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
            String string = compoundPredicate.getOperator().name();
            Predicate[] predicateArray = compoundPredicate.getPredicates();
            if (predicateArray != null) {
                CharSequence charSequence;
                Object object;
                Vector vector;
                Object object2;
                TreeMap<String, Vector<Object>> treeMap = new TreeMap<String, Vector<Object>>();
                for (int i = 0; i < predicateArray.length; ++i) {
                    object2 = (SimplePredicate)predicateArray[i];
                    vector = (Vector)treeMap.get(object2.getAttributeName());
                    if (vector == null) {
                        vector = new Vector();
                        if (hashtable == null) {
                            treeMap.put(object2.getAttributeName(), vector);
                        } else {
                            object = object2 instanceof ODMrOraSimplePredicate ? ((ODMrOraSimplePredicate)object2).getSubAttrName() : object2.getAttributeName();
                            charSequence = (String)hashtable.get(object);
                            if (charSequence != null) {
                                treeMap.put((String)charSequence, vector);
                            } else {
                                treeMap.put(object2.getAttributeName(), vector);
                            }
                        }
                    }
                    vector.add(object2);
                }
                Set set = treeMap.keySet();
                object2 = set.iterator();
                while (object2.hasNext()) {
                    vector = (String)object2.next();
                    object = (Vector)treeMap.get(vector);
                    charSequence = null;
                    boolean bl2 = false;
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        Object object3;
                        SimplePredicate simplePredicate = (SimplePredicate)((Vector)object).elementAt(i);
                        if (simplePredicate.isNumericalValue()) {
                            if (ComparisonOperator.in.equals(simplePredicate.getComparisonOperator())) {
                                if (!bl2) {
                                    stringBuffer.append(vector + " " + simplePredicate.getComparisonOperator().name() + " (");
                                    bl2 = true;
                                }
                                stringBuffer.append(simplePredicate.getNumericalValue());
                                if (i < ((Vector)object).size() - 1) {
                                    stringBuffer.append(",");
                                }
                            } else {
                                String string2;
                                String string3;
                                if (bl2) {
                                    bl2 = false;
                                    stringBuffer.append(") " + string + " ");
                                }
                                object3 = simplePredicate.toString();
                                if (hashtable != null && (string3 = (String)hashtable.get(string2 = simplePredicate instanceof ODMrOraSimplePredicate ? ((ODMrOraSimplePredicate)simplePredicate).getSubAttrName() : simplePredicate.getAttributeName())) != null) {
                                    try {
                                        object3 = BrowserUtils.getFirstReplacedString((String)object3, string2 + " ", string3 + " ");
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                stringBuffer.append((String)object3);
                            }
                            if (!bl2 && i < ((Vector)object).size() - 1) {
                                stringBuffer.append(" " + string + " ");
                            }
                        } else if (BrowserUtils.isRange(simplePredicate.getCategoryValues())) {
                            stringBuffer.append(BrowserUtils.processRangeValues(vector, simplePredicate));
                            if (i < ((Vector)object).size() - 1) {
                                stringBuffer.append(" " + BooleanOperator.and.name() + " ");
                            }
                        } else if (!bl2) {
                            if (charSequence == null) {
                                charSequence = new StringBuffer(vector + " " + simplePredicate.getComparisonOperator().name() + " (");
                            }
                            object3 = simplePredicate.getCategoryValues();
                            for (int j = 0; j < ((Object[])object3).length; ++j) {
                                ((StringBuffer)charSequence).append(object3[j]);
                                if (j >= ((Object[])object3).length - 1) continue;
                                ((StringBuffer)charSequence).append(", ");
                            }
                        } else {
                            object3 = simplePredicate.getCategoryValues();
                            for (int j = 0; j < ((Object[])object3).length; ++j) {
                                stringBuffer.append(object3[j]);
                                if (j >= ((Object[])object3).length - 1) continue;
                                stringBuffer.append(", ");
                            }
                        }
                        if (charSequence == null || i >= ((Vector)object).size() - 1) continue;
                        ((StringBuffer)charSequence).append(", ");
                    }
                    if (bl2) {
                        stringBuffer.append(")");
                    }
                    if (charSequence != null) {
                        ((StringBuffer)charSequence).append(")");
                        stringBuffer.append(((StringBuffer)charSequence).toString());
                    }
                    if (object2.hasNext()) {
                        stringBuffer.append(" " + string + " ");
                    }
                    if (!bl || stringBuffer.length() <= n) continue;
                    stringBuffer.setLength(n - 3);
                    stringBuffer.append("...");
                    break;
                }
            }
        } else if (predicate instanceof SimplePredicate) {
            Object object;
            SimplePredicate simplePredicate = (SimplePredicate)predicate;
            StringBuffer stringBuffer2 = null;
            if (!simplePredicate.isNumericalValue()) {
                if (stringBuffer2 == null) {
                    stringBuffer2 = new StringBuffer("(");
                }
                object = simplePredicate.getCategoryValues();
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    stringBuffer2.append(object[i]);
                    if (i >= ((Object[])object).length - 1) continue;
                    stringBuffer2.append(", ");
                }
            }
            if (stringBuffer2 != null) {
                stringBuffer2.append(")");
                stringBuffer.append(stringBuffer2.toString());
            } else {
                String string;
                String string4;
                object = simplePredicate.toString();
                if (hashtable != null && (string4 = (String)hashtable.get(string = simplePredicate instanceof ODMrOraSimplePredicate ? ((ODMrOraSimplePredicate)simplePredicate).getSubAttrName() : simplePredicate.getAttributeName())) != null) {
                    try {
                        object = BrowserUtils.getFirstReplacedString((String)object, string + " ", string4 + " ");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                stringBuffer.append(simplePredicate.toString());
            }
            if (bl && stringBuffer.length() > n) {
                stringBuffer.setLength(n - 3);
                stringBuffer.append("...");
            }
        } else {
            stringBuffer.append("Unexpected predicate");
        }
        return stringBuffer.toString();
    }

    public static String getConsequentString(Predicate predicate, Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        if (predicate instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
            String string = compoundPredicate.getOperator().name();
            Predicate[] predicateArray = compoundPredicate.getPredicates();
            if (predicateArray != null) {
                SimplePredicate simplePredicate = (SimplePredicate)predicateArray[0];
                String string2 = simplePredicate.getAttributeName();
                if (hashtable != null) {
                    String string3 = string2;
                    String string4 = string2;
                    string4 = (String)hashtable.get(string3);
                    if (string4 != null) {
                        string2 = string4;
                    }
                }
                stringBuffer.append(string2 + " " + simplePredicate.getComparisonOperator().name() + " " + simplePredicate.getNumericalValue().intValue());
            }
        }
        return stringBuffer.toString();
    }

    public static DM4JListResourceBundle getBundleInstance() {
        if (null == m_bundle) {
            m_bundle = (DM4JListResourceBundle)ResourceBundle.getBundle("oracle.dmt.dm4j.browser.resource.BrowserBundle", Locale.getDefault());
        }
        return m_bundle;
    }

    public static DM4JListResourceBundle getActivityBundleInstance() {
        if (null == m_activityBundle) {
            m_activityBundle = (DM4JListResourceBundle)ResourceBundle.getBundle("oracle.dmt.dm4j.activity.resource.ActivityBundle", Locale.getDefault());
        }
        return m_activityBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getModelType(java.sql.Connection connection, String string) throws Exception {
        Exception exception3;
        String string2;
        String string3;
        String string4;
        PreparedStatement preparedStatement;
        block16: {
            preparedStatement = null;
            ResultSet resultSet = null;
            string4 = null;
            string3 = null;
            if (null == string) {
                throw new Exception("Cannot determine model type, model name cannot be null.");
            }
            try {
                string2 = "SELECT ALGORITHM_NAME, FUNCTION_NAME FROM DM_USER_MODELS WHERE NAME=?";
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                int n = 1;
                if (resultSet.next()) {
                    string4 = resultSet.getString(n++);
                    string3 = resultSet.getString(n++);
                    if (null == string4) {
                        throw new Exception("Failed to determine model type.");
                    }
                } else {
                    throw new Exception("Failed to determine model type because model does not exist.");
                }
                Object var9_8 = null;
                if (resultSet == null) break block16;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var9_9 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception22) {
                        exception22.printStackTrace();
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception22) {
                        exception22.printStackTrace();
                    }
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (Exception exception3) {
                exception3.printStackTrace();
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception3) {
                exception3.printStackTrace();
            }
        }
        if (null == (string2 = BrowserUtils.mapJDMToLocalModelType(string3, string4))) {
            throw new Exception("Cannot determine model type");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean modelExists(java.sql.Connection connection, String string) {
        boolean bl;
        block15: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block14: {
                preparedStatement = null;
                resultSet = null;
                bl = false;
                String string2 = null;
                string2 = "SELECT NAME FROM DM_USER_MODELS WHERE NAME = ?";
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block14;
                bl = true;
            }
            Object var7_7 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block15;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block15;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var7_8 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        break block15;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return bl;
    }

    public static boolean resultExists(Connection connection, String string) {
        boolean bl = false;
        try {
            bl = connection.doesObjectExist(string, NamedObject.testMetrics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTaskNameForMiningObject(java.sql.Connection connection, String string, String string2) throws Exception {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        String string3 = null;
        try {
            String string4 = BrowserUtils.getArgumentTaskName(string, string2);
            String string5 = "select t.name from dm_task t, dm_task_arguments args where obj_id = args.task_id and args.name = ? and args.str_value = ? order by t.creation_date DESC ";
            preparedStatement = connection.prepareStatement(string5);
            int n = 1;
            preparedStatement.setString(n++, string4);
            preparedStatement.setString(n++, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new Exception("Task not found");
            }
            string3 = resultSet.getString(1);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (null != preparedStatement) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (null != resultSet) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (null != preparedStatement) {
                preparedStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (null != resultSet) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getTaskNamesForMiningObject(java.sql.Connection connection, String string, String string2) throws Exception {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        String string3 = null;
        Vector<String> vector = new Vector<String>();
        try {
            String string4 = BrowserUtils.getArgumentTaskName(string, string2);
            String string5 = "select t.name from dm_task t, dm_task_arguments args where obj_id = args.task_id and args.name = ? and args.str_value = ? order by t.creation_date DESC ";
            preparedStatement = connection.prepareStatement(string5);
            int n = 1;
            preparedStatement.setString(n++, string4);
            preparedStatement.setString(n++, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string3 = resultSet.getString(1);
                vector.add(string3);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (null != preparedStatement) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (null != resultSet) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (null != preparedStatement) {
                preparedStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (null != resultSet) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (vector.isEmpty()) {
            throw new Exception("Task not found");
        }
        return vector;
    }

    private static String getArgumentTaskName(String string, String string2) {
        if (string2.equalsIgnoreCase("build")) {
            return "m_resultModelName";
        }
        if (string2.equalsIgnoreCase("lift")) {
            return "m_liftResultName";
        }
        if (string2.equalsIgnoreCase("test") || string2.equalsIgnoreCase("crossValidate")) {
            return "m_testResultName";
        }
        if (string2.equalsIgnoreCase("regressionTest")) {
            return "m_regressionTestResultName";
        }
        if (string2.equalsIgnoreCase("apply")) {
            return "m_applyResultName";
        }
        return null;
    }

    public static String getFunctionSettingType(MiningAlgorithm miningAlgorithm) {
        if (miningAlgorithm.equals(OraMiningAlgorithm.adaptiveBayesNetwork)) {
            return "CLASSIFICATION_ABN_SETTING";
        }
        if (miningAlgorithm.equals(MiningAlgorithm.naiveBayes)) {
            return "CLASSIFICATION_NB_SETTING";
        }
        if (miningAlgorithm.equals(OraMiningAlgorithm.aprioriAssociationRules)) {
            return "ASSOCIATION_RULES_SETTING";
        }
        if (miningAlgorithm.equals(MiningAlgorithm.kMeans)) {
            return "CLUSTERING_KMEANS_SETTING";
        }
        if (miningAlgorithm.equals(OraMiningAlgorithm.oCluster)) {
            return "CLUSTERING_OCLUSTER_SETTING";
        }
        if (miningAlgorithm.equals(OraMiningAlgorithm.minimumDescriptionLength)) {
            return "ATTRIBUTE_IMPORTANCE_SETTING";
        }
        if (miningAlgorithm.equals(OraMiningAlgorithm.minimumDescriptionLength)) {
            return "ATTRIBUTE_IMPORTANCE_SETTING";
        }
        if (miningAlgorithm.equals(MiningAlgorithm.svmClassification)) {
            return "CLASSIFICATION_SVM_SETTING";
        }
        if (miningAlgorithm.equals(MiningAlgorithm.svmRegression)) {
            return "REGRESSION_SVM_SETTING";
        }
        if (miningAlgorithm.equals(OraMiningAlgorithm.nonNegativeMatrixFactorization)) {
            return "FEATURE_EXTRACTION_NMF_SETTING";
        }
        return null;
    }

    public static String getDuration(long l) {
        String string = new String("" + (int)((l *= 1000L) / 3600000L));
        long l2 = l - l / 3600000L * 3600000L;
        String string2 = new String("" + (int)(l2 / 60000L));
        l2 -= l2 / 60000L * 60000L;
        String string3 = new String("" + (int)(l2 / 1000L));
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        String string4 = string + ":" + string2 + ":" + string3;
        return string4;
    }

    public static JFrame getParentFrame(Component component) {
        JFrame jFrame = null;
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JFrame)) continue;
            jFrame = (JFrame)container;
            break;
        }
        return jFrame;
    }

    public static Vector getVectorData(java.sql.Connection connection, String string) throws Exception {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int n2 = 0;
            Vector<String[]> vector = new Vector<String[]>();
            while (resultSet.next()) {
                ++n2;
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    String string2;
                    stringArray[i] = string2 = resultSet.getString(i + 1);
                }
                vector.addElement(stringArray);
            }
            resultSet.close();
            resultSet = null;
            statement.close();
            statement = null;
            return vector;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getReplacedString(String string, String string2, String string3) throws Exception {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.length() > 0) {
            while ((n2 = string.indexOf(string2, n)) >= 0) {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string3);
                n = n2 + string2.length();
            }
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String getFirstReplacedString(String string, String string2, String string3) throws Exception {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.length() > 0 && (n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String getFormattedMessage(String string, String[] stringArray) {
        return MessageFormat.format(string, stringArray);
    }

    public static String getLeafNodeDisplayName(LeafNodeData leafNodeData) {
        String string = null;
        if (leafNodeData.getNodeType().equals("ABN_MODEL") || leafNodeData.getNodeType().equals("NB_MODEL") || leafNodeData.getNodeType().equals("GLM_CLASSIFICATION_MODEL") || leafNodeData.getNodeType().equals("SVM_CLASSIFICATION_MODEL")) {
            string = DM4JResourceUtilities.getUIString("TREE_CLASSIFICATION_MODELS");
        } else if (leafNodeData.getNodeType().equals("SVM_REGRESSION_MODEL") || leafNodeData.getNodeType().equals("GLM_REGRESSION_MODEL")) {
            string = DM4JResourceUtilities.getUIString("TREE_REGRESSION_MODELS");
        } else if (leafNodeData.getNodeType().equals("NMF_MODEL")) {
            string = DM4JResourceUtilities.getUIString("TREE_FEATURE_EXTRACTION_MODELS");
        } else if (leafNodeData.getNodeType().equals("ATTRIBUTE_IMPORTANCE_MODEL")) {
            string = DM4JResourceUtilities.getUIString("TREE_ATTRIBUTE_IMPORTANCE_MODELS");
        } else if (leafNodeData.getNodeType().equals("ASSOCIATION_RULES_MODEL")) {
            string = DM4JResourceUtilities.getUIString("TREE_ASSOCIATION_RULES_MODELS");
        } else if (leafNodeData.getNodeType().equals("CLUSTERING_KMEANS_MODEL") || leafNodeData.getNodeType().equals("CLUSTERING_OCLUSTER_MODEL")) {
            string = DM4JResourceUtilities.getUIString("TREE_CLUSTERING_MODELS");
        } else if (leafNodeData.getNodeType().equals("TEST_RESULT")) {
            string = DM4JResourceUtilities.getUIString("TREE_TEST_RESULTS");
        } else if (leafNodeData.getNodeType().equals("RESIDUAL_PLOT_RESULT")) {
            string = DM4JResourceUtilities.getUIString("TREE_RESIDUAL_PLOT_RESULTS");
        } else if (leafNodeData.getNodeType().equals("LIFT_RESULT")) {
            string = DM4JResourceUtilities.getUIString("TREE_LIFT_RESULTS");
        } else if (leafNodeData.getNodeType().equals("APPLY_RESULT")) {
            string = DM4JResourceUtilities.getUIString("TREE_APPLY_RESULTS");
        } else if (leafNodeData.getNodeType().equals("PREDICT_RESULT")) {
            string = DM4JResourceUtilities.getUIString("TREE_PREDICT_RESULTS");
        } else if (leafNodeData.getNodeType().equals("EXPLAIN_RESULT")) {
            string = DM4JResourceUtilities.getUIString("TREE_EXPLAIN_RESULTS");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String mapJDMToLocalModelType(String string, String string2) throws Exception {
        String string3 = null;
        if (string.equalsIgnoreCase(classification)) {
            if (string2.equalsIgnoreCase(algo_naive_bayes)) {
                return "NB_MODEL";
            }
            if (string2.equalsIgnoreCase(algo_adaptive_bayes_network)) {
                return "ABN_MODEL";
            }
            if (string2.equalsIgnoreCase(algo_decision_tree)) {
                return "DT_MODEL";
            }
            if (string2.equalsIgnoreCase(algo_support_vector_machines)) {
                return "SVM_CLASSIFICATION_MODEL";
            }
            if (!string2.equalsIgnoreCase(algo_generalized_linear_model)) throw new Exception("Unsupported algorithm type encountered");
            return "GLM_CLASSIFICATION_MODEL";
        }
        if (string.equalsIgnoreCase(regression)) {
            if (string2.equalsIgnoreCase(algo_support_vector_machines)) {
                return "SVM_REGRESSION_MODEL";
            }
            if (!string2.equalsIgnoreCase(algo_generalized_linear_model)) return string3;
            return "GLM_REGRESSION_MODEL";
        }
        if (string.equalsIgnoreCase(clustering)) {
            if (string2.equalsIgnoreCase(algo_ocluster)) {
                return "CLUSTERING_OCLUSTER_MODEL";
            }
            if (!string2.equalsIgnoreCase(algo_kmeans)) throw new Exception("Unsupported algorithm type encountered");
            return "CLUSTERING_KMEANS_MODEL";
        }
        if (string.equalsIgnoreCase(association_in_model)) {
            return "ASSOCIATION_RULES_MODEL";
        }
        if (!string.equalsIgnoreCase(feature_extraction)) return string3;
        return "NMF_MODEL";
    }

    private static boolean isRange(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        boolean bl = false;
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                if ((!string.startsWith("(") || !string.endsWith("]")) && (!string.startsWith("[") || !string.endsWith("]"))) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private static StringBuffer processRangeValues(String string, SimplePredicate simplePredicate) {
        ComparisonOperator comparisonOperator = simplePredicate.getComparisonOperator();
        StringBuffer stringBuffer = new StringBuffer(string + " " + OraPLSQLMappings.getComparisonOperatorValue(comparisonOperator) + " ");
        Object[] objectArray = simplePredicate.getCategoryValues();
        String string2 = (String)objectArray[0];
        string2 = string2.substring(1, string2.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        double d = 0.0;
        double d2 = 0.0;
        try {
            if (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                d = Double.parseDouble(string3);
                string3 = stringTokenizer.nextToken();
                d2 = Double.parseDouble(string3);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        if (ComparisonOperator.lessOrEqual.equals(comparisonOperator)) {
            stringBuffer.append(String.valueOf(d2));
        } else {
            stringBuffer.append(String.valueOf(d));
        }
        return stringBuffer;
    }
}

