/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser;

import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ConnectionDialog;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.LAFType;
import oracle.dmt.dm4j.browser.UserPreferences;

public class BrowserMain {
    public BrowserMain(String[] stringArray) {
        String string = null;
        String string2 = null;
        JFrame jFrame = new JFrame();
        ConnectionDialog connectionDialog = null;
        BrowserFrame browserFrame = null;
        if (stringArray.length != 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase("-ignore") || stringArray[n].equalsIgnoreCase("-ignoreversion")) {
                    BrowserFrame.setIgnoreVersionCheck(true);
                    ++n;
                    continue;
                }
                if (stringArray[n].startsWith("-language")) {
                    int n2 = ++n;
                    ++n;
                    string = stringArray[n2];
                    continue;
                }
                if (!stringArray[n].startsWith("-country")) continue;
                int n3 = ++n;
                ++n;
                string2 = stringArray[n3];
            }
            if (string != null && string2 != null) {
                Locale.setDefault(new Locale(string, string2));
            } else if (string != null) {
                Locale.setDefault(new Locale(string));
            }
        }
        ImageIcon imageIcon = (ImageIcon)IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/client.gif");
        jFrame.setIconImage(imageIcon.getImage());
        connectionDialog = new ConnectionDialog(jFrame, DM4JResourceUtilities.getUIString("CONNECTION_DLG_TITLE"), true);
        boolean bl = true;
        while (bl) {
            WindowUtils.centerWindow(connectionDialog);
            connectionDialog.setVisible(true);
            if (connectionDialog.getUserAction() == ConnectionDialog.RET_CANCEL) {
                System.exit(0);
            }
            try {
                char[] cArray = connectionDialog.getSEValue();
                if (cArray != null) {
                    browserFrame = BrowserFrame.getBrowserInstance(connectionDialog.getConnectionPersistenceInfo(), cArray);
                }
                if (browserFrame == null) continue;
                WindowUtils.centerWindow(browserFrame);
                browserFrame.setVisible(true);
                bl = false;
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] stringArray) {
        try {
            UserPreferences.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            UserPreferences userPreferences = UserPreferences.getInstance();
            String string = userPreferences.getLAF();
            LAFType lAFType = LAFType.getInstance(string);
            if (lAFType == LAFType.NATIVE) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(new OracleLookAndFeel());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new BrowserMain(stringArray);
    }
}

