/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.browser;

import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;

public class BrowserContext {
    private NodeData m_selectedNodeData = null;
    private LaunchPoint m_launchPoint;
    private AbstractActivity m_activity;
    private String m_schemaName = null;
    private String m_dataSourceName = null;
    private ComplexDataStructure m_inputDataDescriptor = null;
    private ComplexDataStructure m_sampledInputDataDescriptor = null;
    private String m_activityName = null;
    private boolean m_isTransactional = false;
    private String m_sequenceID = null;
    private String m_sequenceAttrib = null;
    private String m_sequenceValue = null;
    private String m_miningObjectName = null;
    private AbstractStepOptions m_options = null;
    private Vector m_validations = new Vector();

    public BrowserContext(NodeData nodeData, LaunchPoint launchPoint) {
        this.m_selectedNodeData = nodeData;
        this.m_launchPoint = launchPoint;
        if (null != nodeData && nodeData instanceof LeafNodeData) {
            this.m_schemaName = ((LeafNodeData)nodeData).getSchemaName();
            LeafNodeData leafNodeData = (LeafNodeData)nodeData;
            if (leafNodeData.isSchemaObject()) {
                this.m_dataSourceName = ((LeafNodeData)nodeData).getName();
            } else if (leafNodeData.isMiningObject()) {
                this.m_miningObjectName = ((LeafNodeData)nodeData).getName();
            } else if (leafNodeData.isActivityObject()) {
                this.m_activityName = ((LeafNodeData)nodeData).getName();
            }
        }
    }

    public BrowserContext(LaunchPoint launchPoint, AbstractActivity abstractActivity, ComplexDataStructure complexDataStructure, ComplexDataStructure complexDataStructure2, String string) {
        this.m_launchPoint = launchPoint;
        this.m_activity = abstractActivity;
        this.m_inputDataDescriptor = complexDataStructure;
        this.m_sampledInputDataDescriptor = complexDataStructure2;
        this.m_miningObjectName = string;
    }

    public NodeData getSelectedNode() {
        return this.m_selectedNodeData;
    }

    public LeafNodeData getSelectedLeafNode() {
        if (this.m_selectedNodeData != null) {
            if (this.m_selectedNodeData instanceof LeafNodeData) {
                return (LeafNodeData)this.m_selectedNodeData;
            }
            return null;
        }
        return null;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public void setSchemaName(String string) {
        this.m_schemaName = string;
    }

    public void setDataSourceTransaction(boolean bl) {
        this.m_isTransactional = bl;
    }

    public boolean isDataSourceTransaction() {
        return this.m_isTransactional;
    }

    public String getDataSourceName() {
        return this.m_dataSourceName;
    }

    public ComplexDataStructure getInputDataDescriptor() {
        return this.m_inputDataDescriptor;
    }

    public void setInputDataDescriptor(ComplexDataStructure complexDataStructure) {
        this.m_inputDataDescriptor = complexDataStructure;
    }

    public String getActivityName() {
        return this.m_activityName;
    }

    public void setDataSourceName(String string) {
        this.m_dataSourceName = string;
    }

    public String getMiningObjectName() {
        return this.m_miningObjectName;
    }

    public void setMiningObjectName(String string) {
        this.m_miningObjectName = string;
    }

    public LaunchPoint getLaunchPoint() {
        return this.m_launchPoint;
    }

    public AbstractActivity getActivity() {
        return this.m_activity;
    }

    public void setSequenceID(String string) {
        this.m_sequenceID = string;
    }

    public String getSequenceID() {
        return this.m_sequenceID;
    }

    public void setSequenceAttribute(String string) {
        this.m_sequenceAttrib = string;
    }

    public String getSequenceAttribute() {
        return this.m_sequenceAttrib;
    }

    public void setSequenceValue(String string) {
        this.m_sequenceValue = string;
    }

    public String getSequenceValue() {
        return this.m_sequenceValue;
    }

    public void setStepOptions(AbstractStepOptions abstractStepOptions) {
        this.m_options = abstractStepOptions;
    }

    public AbstractStepOptions getOptions() {
        return this.m_options;
    }

    public Vector getValidations() {
        return this.m_validations;
    }

    public void setValidations(Vector vector) {
        this.m_validations = vector;
    }

    public void setSampledInputDataDescriptor(ComplexDataStructure complexDataStructure) {
        this.m_sampledInputDataDescriptor = complexDataStructure;
    }

    public ComplexDataStructure getSampledInputDataDescriptor() {
        return this.m_sampledInputDataDescriptor;
    }
}

