/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.Collator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.activity.wizard.state.ActivityState;
import oracle.dmt.dm4j.activity.wizard.state.ApplyActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.datasources.TableColumnsDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.commonsteps.MultiRecordCaseData;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.commonsteps.MRCFormatDialog;
import oracle.dmt.dm4j.wizard.table.ComponentSpreadTable;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;

public class TxnDataPanel
extends DM4JStep {
    DataSourceState m_state;
    MultiRecordCaseData m_mrcState;
    String m_panelDescriptionResourceKey;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblSchemaName = new JLabel();
    JLabel lblSchemaNameValue = new JLabel();
    JComboBox comboSchema = new JComboBox();
    DefaultComboBoxModel schemaModel;
    JLabel lblTableName = new JLabel();
    JLabel lblTableNameValue = new JLabel();
    JComboBox comboTable = new JComboBox();
    DefaultComboBoxModel tableModel;
    JLabel lblTableTitle = new JLabel("Case Columns:");
    JScrollPane spreadScroll = new JScrollPane();
    ComponentSpreadTable spreadTable = new ComponentSpreadTable(null);
    IncludeAction includeAction = new IncludeAction();
    MultiLineLabel mlblFormatDescription = new MultiLineLabel();
    JRadioButton optMRCFormatYes = new JRadioButton();
    JRadioButton optMRCFormatNo = new JRadioButton();
    ButtonGroup groupMRCFormat = new ButtonGroup();
    JButton butFormatDetails = new JButton();
    JLabel lblFiller = new JLabel();
    boolean m_ignoreSchemaComboEvent = false;
    boolean m_ignoreTableComboEvent = false;

    public TxnDataPanel(DataSourceState dataSourceState, String string) throws Exception {
        super(dataSourceState);
        this.m_state = dataSourceState;
        this.m_panelDescriptionResourceKey = string;
        this.setState();
        this.jbInit();
    }

    private void setState() throws Exception {
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel(this.m_panelDescriptionResourceKey));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblSchemaName.setText(ResourceUtilities.getUILabel("SCHEMA_NAME"));
        this.lblSchemaName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("SCHEMA_NAME"));
        this.lblSchemaName.setLabelFor(this.comboSchema);
        this.addComponent(this.lblSchemaName, COL1_LABEL, n, 0);
        this.comboSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TxnDataPanel.this.comboSchema_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.comboSchema, COL_VALUE, n++, 1);
        this.lblTableName.setText(ResourceUtilities.getUILabel("TABLE_NAME"));
        this.lblTableName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("TABLE_NAME"));
        this.lblTableName.setLabelFor(this.comboTable);
        this.addComponent(this.lblTableName, COL1_LABEL, n, 0);
        this.comboTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TxnDataPanel.this.comboTable_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.comboTable, COL_VALUE, n++, 1);
        this.addFilledComponent(this.lblTableTitle, COL1_LABEL, n, 0);
        this.spreadScroll.getViewport().add((Component)this.spreadTable, null);
        this.addFilledComponent(this.spreadScroll, COL_VALUE, n++, 1, 2, 5, 1);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 2, 1);
    }

    protected void setSpread() throws Exception {
        this.spreadTable.setModels2(this.m_state.getTableColumnsDataSource(), this.m_state.getTableColumnsDataSource().getColumnDataSource(), null);
        Grid grid = this.spreadTable.getGrid();
        grid.setColumnPainter(0, CheckPainter.getPainter());
        this.spreadTable.getGrid().setColumnCellInputHandler(0, BooleanInputHandler.getCellInputHandler());
        this.spreadTable.addEditListener(this.includeAction);
        Header header = this.spreadTable.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        TableColumnsDataSource tableColumnsDataSource = this.m_state.getTableColumnsDataSource();
        header.setItemInputHandler(new MySortInputHandler(tableColumnsDataSource));
        tableColumnsDataSource.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        tableColumnsDataSource.setColumnComparator(1, new StringComparator(Collator.getInstance()));
        header.setHeaderKeyHandler(new KeyHandler());
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        this.spreadTable.getGrid().setGridSelectionManager(generalGridSelectionManager);
        int[] nArray = new int[]{15, 85};
        this.spreadTable.setColumnWidths(nArray, true);
        this.spreadTable.setResize(false);
    }

    private void comboSchema_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreSchemaComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                String string2 = this.m_state.getSelectedSchemaName();
                if (!string2.equals(string)) {
                    this.m_state.setSelectedSchemaName(string);
                    this.loadTableCombo(this);
                    this.invalidateActivityState();
                }
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void comboTable_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreTableComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                String string2 = this.m_state.getSelectedTableName();
                if (!string2.equals(string)) {
                    this.m_state.setSelectedTableName(string);
                    this.invalidateActivityState();
                    this.m_state.loadColumnsDataSource(this);
                    this.setSpread();
                }
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void invalidateActivityState() {
        ActivityState activityState;
        StepStateType stepStateType;
        WizardState wizardState = this.getparentWizardState();
        if (wizardState instanceof ApplyActivityWizardState && (stepStateType = (activityState = (ActivityState)wizardState.getStep(ActivityStepType.ACTIVITY_STEP)).getState()) == StepStateType.VALIDATED) {
            activityState.setState(StepStateType.DIRTY);
        }
    }

    public void init() throws Exception {
        this.loadSchemaCombo();
        this.loadTableCombo(null);
        this.loadDefaultValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    private void loadSchemaCombo() {
        this.m_ignoreSchemaComboEvent = true;
        this.schemaModel = new DefaultComboBoxModel(this.m_state.getSchemaNames());
        this.schemaModel.setSelectedItem(this.m_state.getSelectedSchemaName());
        this.comboSchema.setModel(this.schemaModel);
        this.comboSchema.setSelectedItem(this.m_state.getSelectedSchemaName());
        this.m_ignoreSchemaComboEvent = false;
    }

    private void loadTableCombo(Component component) throws Exception {
        this.m_ignoreTableComboEvent = true;
        this.tableModel = new DefaultComboBoxModel(this.m_state.getTableNames());
        this.tableModel.setSelectedItem(this.m_state.getSelectedTableName());
        this.comboTable.setModel(this.tableModel);
        this.comboTable.setSelectedItem(this.m_state.getSelectedTableName());
        this.m_state.loadColumnsDataSource(component);
        this.setSpread();
        this.m_ignoreTableComboEvent = false;
    }

    private void loadDefaultValues() {
    }

    private void optMRCFormat_actionPerformed(ActionEvent actionEvent) {
        if (this.optMRCFormatYes.isSelected()) {
            this.m_mrcState.setMultipleRecordCaseFormat(true);
            this.butFormatDetails.setEnabled(true);
        } else {
            this.m_mrcState.setMultipleRecordCaseFormat(false);
            this.butFormatDetails.setEnabled(false);
        }
        this.invalidateActivityState();
    }

    private void butFormatDetails_actionPerformed(ActionEvent actionEvent) {
        try {
            MRCFormatDialog mRCFormatDialog = new MRCFormatDialog(this.getparentWizardState().getDialog(), this.m_mrcState, true);
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
        this.invalidateActivityState();
    }

    private class MySortInputHandler
    extends SortInputHandler {
        public MySortInputHandler(SortableTwoDModel sortableTwoDModel) {
            super(sortableTwoDModel);
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
            super.mouseReleased(mouseEvent, header, n);
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 32) {
                SortInputHandler sortInputHandler = (SortInputHandler)header.getItemInputHandler();
                sortInputHandler.sort(header.getFocusItem());
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }

    private class IncludeAction
    implements TableEditListener {
        private IncludeAction() {
        }

        public void cellEditing(TableEvent tableEvent) {
        }

        public void cellEdited(TableEvent tableEvent) {
        }
    }
}

