/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JSimpleDialogPanel;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Mapping;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.state.BuildActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.state.ModelState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.UpperCaseTextField;

public class EditMappingPanel
extends GriddedPanel
implements DM4JSimpleDialogPanel {
    private JLabel _instructions = new JLabel();
    private JLabel _lblValueColumn = new JLabel();
    private JComboBox _valueColumn = new JComboBox();
    private JLabel _lblMiningType = new JLabel();
    private JComboBox _miningType = new JComboBox();
    private JLabel _lblGroupBy = new JLabel();
    private JComboBox _groupBy = new JComboBox();
    private JLabel _lblAggregation = new JLabel();
    private JComboBox _aggregation = new JComboBox();
    private JLabel _lblPrefix = new JLabel();
    private JLabel _prefix = new JLabel();
    private JCheckBox _chkAutoMapping = new JCheckBox();
    private JLabel _lblMappingName = new JLabel();
    private UpperCaseTextField _mappingName = new UpperCaseTextField();
    private JLabel _lblSparsity = new JLabel();
    private JCheckBox _chkSparse = new JCheckBox();
    private Table _table;
    private Mapping _mapping;
    private boolean _isEditing;
    private BuildActivityWizardState _parentState;

    public EditMappingPanel(Table table, Mapping mapping, BuildActivityWizardState buildActivityWizardState) {
        this._parentState = buildActivityWizardState;
        this._table = table;
        if (mapping != null) {
            this._mapping = mapping;
            this._isEditing = true;
        } else {
            this._mapping = new Mapping();
            this._isEditing = false;
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Mapping getMapping() {
        return this._mapping;
    }

    private void jbInit() throws Exception {
        Column column;
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 1;
        int n5 = 3;
        this.addFilledComponent(this._instructions, TOPLABELITEMINSETS, n++, n2, 4, 1, 2);
        this.addFilledComponent(new JLabel(""), TOPLABELITEMINSETS, n++, 0, 3, 1, 2);
        this.addFilledComponent(this._lblValueColumn, MIDEDITLABELITEMINSETS, n, n2, n3, 1, 0);
        this.addFilledComponent(this._valueColumn, MIDEDITVALUEITEMINSETS, n++, n4, n5, 1, 2);
        this.addFilledComponent(this._lblMappingName, MIDEDITLABELITEMINSETS, n, n2, n3, 1, 0);
        this.addFilledComponent(this._mappingName, MIDEDITVALUEITEMINSETS, n, n4, 2, 1, 2);
        this.addComponent(this._chkAutoMapping, MIDEDITVALUEITEMINSETS, n++, 3, 1, 1, 13, 0);
        this.addFilledComponent(this._lblMiningType, MIDEDITLABELITEMINSETS, n, n2, n3, 1, 0);
        this.addFilledComponent(this._miningType, MIDEDITVALUEITEMINSETS, n++, n4, n5, 1, 2);
        this.addFilledComponent(this._lblGroupBy, MIDEDITLABELITEMINSETS, n, n2, n3, 1, 0);
        this.addFilledComponent(this._groupBy, MIDEDITVALUEITEMINSETS, n++, n4, n5, 1, 2);
        this.addFilledComponent(this._lblAggregation, MIDEDITLABELITEMINSETS, n, n2, n3, 1, 0);
        this.addFilledComponent(this._aggregation, MIDEDITVALUEITEMINSETS, n++, n4, n5, 1, 2);
        this.addFilledComponent(this._lblPrefix, new Insets(6, 5, 0, 10), n, n2, n3, 1, 0);
        this.addFilledComponent(this._prefix, new Insets(6, 0, 0, 10), n++, n4, n5, 1, 2);
        this.addFilledComponent(this._lblSparsity, MIDEDITLABELITEMINSETS, n, n2, n3, 1, 0);
        this.addFilledComponent(this._chkSparse, MIDEDITVALUEITEMINSETS, n++, n4, n5, 1, 2);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, n++, 0, 3, 2, 1);
        String string = DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_INTRO");
        string = DM4JResourceUtilities.wrapInHTML(string);
        this._instructions.setText(string);
        this._lblValueColumn.setText(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_VALCOL"));
        this._lblMiningType.setText(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_MININGTYPE"));
        this._lblGroupBy.setText(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_GROUPBY"));
        this._lblAggregation.setText(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_AGGR"));
        this._lblPrefix.setText(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_PREFX"));
        this._chkAutoMapping.setText(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_AUTO"));
        this._lblSparsity.setText(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_SPARSITY"));
        this._chkSparse.setText(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_ISSPARSE"));
        this._chkSparse.setSelected(this._mapping.getIsSparse());
        this._chkAutoMapping.setSelected(true);
        this._mappingName.setEnabled(false);
        this._chkAutoMapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditMappingPanel.this.chkAutoMapping_actionPerformed(actionEvent);
            }
        });
        this._lblMappingName.setText(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_MAPNAME"));
        this._valueColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditMappingPanel.this.valueColumn_actionPerformed(actionEvent);
            }
        });
        this._miningType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditMappingPanel.this.miningType_actionPerformed(actionEvent);
            }
        });
        this._aggregation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditMappingPanel.this.aggregation_actionPerformed(actionEvent);
            }
        });
        LinkedHashMap linkedHashMap = this._table.getColumns();
        Iterator iterator = linkedHashMap.entrySet().iterator();
        this._valueColumn.addItem(DM4JResourceUtilities.getActivityUIString("COMMON_COMBOSELECT"));
        while (iterator.hasNext()) {
            object = iterator.next();
            column = (Column)object.getValue();
            this._valueColumn.addItem(column);
        }
        iterator = linkedHashMap.entrySet().iterator();
        this._groupBy.addItem(DM4JResourceUtilities.getActivityUIString("COMMON_CASE"));
        while (iterator.hasNext()) {
            object = iterator.next();
            column = (Column)object.getValue();
            this._groupBy.addItem(column);
        }
        if (this._isEditing) {
            this._valueColumn.setSelectedItem(this._mapping.getValueColumn());
            this._mappingName.setText(this._mapping.getAlias().toUpperCase());
            if (!this._mapping.getAlias().equals(this._mapping.getValueColumn().getName())) {
                this._chkAutoMapping.setSelected(false);
                this._mappingName.setEnabled(true);
            }
            this.loadMiningType(this._mapping.getValueColumn().getDataType(), this._mapping.getMiningType());
            object = this._mapping.getNameColumn();
            if (object != null) {
                this._groupBy.setSelectedItem(object);
            } else {
                this._groupBy.setSelectedIndex(0);
            }
            this.loadAggregation(this._mapping.getAggregation(), this._mapping.getMiningType());
            this._prefix.setText(this._mapping.getSuffix());
        } else {
            this._valueColumn.setSelectedIndex(0);
            this._groupBy.setSelectedIndex(0);
            this._prefix.setText(Mapping.peekNextSuffixIndex() + Mapping.getSuffixBase());
        }
    }

    private void chkAutoMapping_actionPerformed(ActionEvent actionEvent) {
        this._mappingName.setEnabled(!this._chkAutoMapping.isSelected());
        Object object = this._valueColumn.getSelectedItem();
        if (object instanceof Column) {
            Column column = (Column)this._valueColumn.getSelectedItem();
            String string = column.getName();
            this._mappingName.setText(string.toUpperCase());
        }
    }

    private void aggregation_actionPerformed(ActionEvent actionEvent) {
    }

    private void miningType_actionPerformed(ActionEvent actionEvent) {
        String string = (String)this._miningType.getSelectedItem();
        if (string == null) {
            return;
        }
        Object object = this._aggregation.getSelectedItem();
        if (object != null && object instanceof AggregationItem) {
            AggregationItem aggregationItem = (AggregationItem)this._aggregation.getSelectedItem();
            this.loadAggregation(aggregationItem.toString(), string);
        } else {
            this.loadAggregation(null, string);
        }
    }

    private void loadAggregation(String string, String string2) {
        this._aggregation.removeAllItems();
        if (string2.equals("numerical") || string2.equals("categorical")) {
            if (string2.equals("numerical")) {
                this._aggregation.addItem(new AggregationItem(0));
                this._aggregation.addItem(new AggregationItem(1));
                this._aggregation.addItem(new AggregationItem(2));
                this._aggregation.addItem(new AggregationItem(3));
            }
            this._aggregation.addItem(new AggregationItem(4));
            this._aggregation.addItem(new AggregationItem(5));
            this._aggregation.addItem(new AggregationItem(6));
            if (string != null) {
                this.selectAggregationItem(string);
            }
            this._aggregation.setEnabled(true);
            this._groupBy.setEnabled(true);
        } else if (string2.equals("text")) {
            this._aggregation.addItem(DM4JResourceUtilities.getActivityUIString("COMMON_COMBONONE"));
            this._groupBy.setSelectedIndex(0);
            this._aggregation.setEnabled(false);
            this._groupBy.setEnabled(false);
        }
    }

    private void selectAggregationItem(String string) {
        for (int i = 0; i < this._aggregation.getItemCount(); ++i) {
            AggregationItem aggregationItem = (AggregationItem)this._aggregation.getItemAt(i);
            if (!aggregationItem.toString().equals(string)) continue;
            this._aggregation.setSelectedIndex(i);
            break;
        }
    }

    private void valueColumn_actionPerformed(ActionEvent actionEvent) {
        Object object = this._valueColumn.getSelectedItem();
        if (object instanceof Column) {
            Column column = (Column)object;
            this.loadDefaultMiningType(column);
            if (this._chkAutoMapping.isSelected()) {
                String string = column.getName();
                this._mappingName.setText(string.toUpperCase());
            }
        }
    }

    private void loadDefaultMiningType(Column column) {
        this.loadMiningType(column.getDataType(), null);
    }

    private void loadMiningType(String string, String string2) {
        this._miningType.removeAllItems();
        if (ActivityUtils.isNumericDataType(string)) {
            this._miningType.addItem("numerical");
            this._miningType.addItem("categorical");
            if (string2 != null) {
                this._miningType.setSelectedItem(string2);
            }
        } else if (string.equals("CHAR") || string.equals("VARCHAR2")) {
            this._miningType.addItem("categorical");
            if (this.supportsText()) {
                this._miningType.addItem("text");
            }
            if (string2 != null) {
                this._miningType.setSelectedItem(string2);
            } else {
                this._miningType.setSelectedIndex(0);
            }
        } else if (ActivityUtils.isTextDataType(string) && this.supportsText()) {
            this._miningType.addItem("text");
        } else {
            this._miningType.addItem(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_NOTALLOWED"));
        }
    }

    private boolean supportsText() {
        return ActivityType.supportsTextData(this._parentState.getActivityType());
    }

    public boolean doValidation() {
        ModelState modelState;
        Object object;
        Object object2;
        Object object3 = this._valueColumn.getSelectedItem();
        if (!(object3 instanceof Column)) {
            this.showValidationError(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_VALCOLINVALID"));
            return false;
        }
        Column column = (Column)object3;
        String string = column.getName();
        this._mapping.setValueColumn(column);
        String string2 = this._mappingName.getText().toUpperCase();
        if (string2 == null || string2.length() == 0) {
            this.showValidationError(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_MAPNAMEMISSING"));
            return false;
        }
        if (string2.length() > 30) {
            this.showValidationError(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_MAPNAMELENGTH"));
            return false;
        }
        this._mapping.setAlias(string2);
        this._mapping.setName(string2);
        String string3 = (String)this._miningType.getSelectedItem();
        if (string3.equals(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_NOTALLOWED"))) {
            this.showValidationError(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_VALDATATYPEINVAL") + column.getDataType());
            return false;
        }
        if (string3.equals("text") && (object2 = ((DataSourceState)(object = (DataSourceState)this._parentState.getStep(ActivityStepType.DATA_STEP))).getUniqueIdentifier()) != null && !ActivityUtils.isNumericDataType(((Column)object2).getDataType())) {
            this.showValidationError(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_TEXTINPUTERROR_P1") + ((Column)object2).getName() + DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_TEXTINPUTERROR_P2") + ((Column)object2).getDataType());
            return false;
        }
        this._mapping.setMiningType(string3);
        column.setMiningType(string3);
        object3 = this._groupBy.getSelectedItem();
        if (object3 instanceof Column) {
            this._mapping.setNameColumn((Column)object3);
            object = ((Column)object3).getName();
        } else {
            this._mapping.setNameColumn(null);
            object = "";
        }
        object2 = this._aggregation.getSelectedItem();
        if (object2 instanceof AggregationItem) {
            AggregationItem aggregationItem = (AggregationItem)object2;
            this._mapping.setAggregation(aggregationItem.getName());
        } else {
            this._mapping.setAggregation((String)object2);
        }
        boolean bl = this._chkSparse.isSelected();
        this._mapping.setIsSparse(bl);
        if (bl && !ActivityUtils.isHandlesSparse((modelState = (ModelState)this._parentState.getStep(ActivityStepType.MODEL_STEP)).getActivityType())) {
            this.showValidationError(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_NOSPARSEALLOWED"));
            return false;
        }
        if (string.equals(object)) {
            this.showValidationError(DM4JResourceUtilities.getActivityUIString("EDIT_MAPPING_GROUP_SAME_AS_VALUE"));
            return false;
        }
        return true;
    }

    private void showValidationError(String string) {
        JOptionPane.showOptionDialog(this, string, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
    }

    private class AggregationItem {
        private String uiName;
        private int id;

        public AggregationItem(int n) {
            this.uiName = Mapping.getAggregationName(n);
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.uiName;
        }

        public String toString() {
            return this.uiName;
        }
    }
}

