/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.ComboBoxInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.ProxyPainter;
import oracle.bali.ewt.grid.RadioPainter;
import oracle.bali.ewt.grid.TextFieldInputHandler;
import oracle.bali.ewt.grid.hGrid.HCellHandler;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.WrappingTextPainter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Mapping;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.state.BuildActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.state.DataUsageState;
import oracle.dmt.dm4j.activity.wizard.state.ModelState;
import oracle.dmt.dm4j.activity.wizard.state.RelatedDataSourceState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.steps.CDSStatsViewerDialog;
import oracle.dmt.dm4j.activity.wizard.steps.CDSStatsViewerPanel;
import oracle.dmt.dm4j.activity.wizard.steps.DataUsageTableModel;
import oracle.dmt.dm4j.activity.wizard.steps.ValidationException;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.HyperlinkButton;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.table.DefaultDm4jSpreadTable;
import oracle.dmt.dm4j.datasources.CDSStatsDataSource;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;

public class DataUsagePanel
extends DM4JStep {
    private DataUsageState m_state;
    private JLabel lbllStepDescription = new JLabel();
    private String m_panelDescriptionResourceKey;
    private JScrollPane scroller = new JScrollPane();
    private DefaultDm4jSpreadTable m_table = new DefaultDm4jSpreadTable(null);
    private ArrayOneDModel m_colModel = null;
    private JButton butSelectAll = new JButton();
    private JButton butExcludeAll = new JButton();

    public DataUsagePanel(DataUsageState dataUsageState, String string) throws Exception {
        super(dataUsageState);
        this.m_state = dataUsageState;
        this.m_panelDescriptionResourceKey = string;
        this.jbInit();
    }

    private boolean requiresTarget() {
        ModelState modelState = (ModelState)this.getparentWizardState().getStep(ActivityStepType.MODEL_STEP);
        return modelState.requiresTarget();
    }

    private void jbInit() throws Exception {
        int n = 0;
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        this.addFilledComponent(this.lbllStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        final String string = dM4JListResourceBundle.getString("DATA_USAGE_STEP_SUMMARY");
        HyperlinkButton hyperlinkButton = new HyperlinkButton("Data Summary");
        this.addAnchoredComponent(hyperlinkButton, new Insets(1, 1, 1, 1), n++, 2, 1, 1, 13);
        this.scroller.getViewport().add(this.m_table);
        int n2 = 10;
        this.addFilledComponent(this.scroller, new Insets(1, 1, 1, 1), n, 0, 3, n2, 1);
        this.butSelectAll.setText(dM4JListResourceBundle.getStringNoMnemonic("DATA_USAGE_SELECT_ALL"));
        this.butSelectAll.setMnemonic(dM4JListResourceBundle.getMnemonic("DATA_USAGE_SELECT_ALL"));
        this.butSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataUsagePanel.this.butSelectAll_actionPerformed(actionEvent);
            }
        });
        this.addAnchoredComponent(this.butSelectAll, BOTTOM_RELATED_CONTROL, n + n2, 1, 13);
        this.butExcludeAll.setText(dM4JListResourceBundle.getStringNoMnemonic("DATA_USAGE_UNSELECT_ALL"));
        this.butExcludeAll.setMnemonic(dM4JListResourceBundle.getMnemonic("DATA_USAGE_UNSELECT_ALL"));
        this.butExcludeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataUsagePanel.this.butExcludeAll_actionPerformed(actionEvent);
            }
        });
        this.addAnchoredComponent(this.butExcludeAll, BOTTOM_RELATED_CONTROL, n + n2, 2, 13);
        hyperlinkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object2;
                DataUsageTableModel dataUsageTableModel = DataUsagePanel.this.m_state.getDataUsageTableModel();
                if (dataUsageTableModel.isHistogramDataDirty()) {
                    try {
                        object2 = (BuildActivityWizardState)DataUsagePanel.this.getparentWizardState();
                        object = (DataSourceState)((WizardState)object2).getStep(ActivityStepType.DATA_STEP);
                        RelatedDataSourceState relatedDataSourceState = (RelatedDataSourceState)((WizardState)object2).getStep(ActivityStepType.RELATED_TABLES_STEP);
                        Vector<Table> vector = new Vector<Table>(relatedDataSourceState.getRelatedTables());
                        Table table = new Table(((DataSourceState)object).getCaseTable(), false);
                        table.setName(((DataSourceState)object).getSampledCaseTable().getName());
                        table.setSchema(((DataSourceState)object).getSampledCaseTable().getSchema());
                        vector.add(table);
                        GetTableStatsThread getTableStatsThread = new GetTableStatsThread(DataUsagePanel.this.m_state, ((DataSourceState)object).getSampledCaseTable(), vector, ((DataSourceState)object).getUniqueIdentifier());
                        ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), "Getting Statistics", getTableStatsThread, true);
                        getTableStatsThread.setProgressBar(progressBar);
                        progressBar.start("Sampling the case table", null);
                        if (getTableStatsThread.getException() != null) {
                            throw getTableStatsThread.getException();
                        }
                        CDSStatsDataSource cDSStatsDataSource = getTableStatsThread.getStats();
                        DataUsagePanel.this.m_state.setStatsDataSource(cDSStatsDataSource);
                        dataUsageTableModel.updateStatistics(cDSStatsDataSource);
                        dataUsageTableModel.setHistogramDataDirty(false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
                try {
                    object2 = new CDSStatsViewerPanel(DataUsagePanel.this.m_state);
                    object = new CDSStatsViewerDialog((JPanel)object2, string, "dm4j_show_summary_html");
                    ((CDSStatsViewerDialog)object).loadDefaultValues();
                    ((Dialog)object).setModal(true);
                    ((Dialog)object).setVisible(true);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        });
    }

    protected void butSelectAll_actionPerformed(ActionEvent actionEvent) {
        try {
            DataUsageTableModel dataUsageTableModel = this.m_state.getDataUsageTableModel();
            dataUsageTableModel.inputSelectionAll(true, this.m_table);
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    protected void butExcludeAll_actionPerformed(ActionEvent actionEvent) {
        try {
            DataUsageTableModel dataUsageTableModel = this.m_state.getDataUsageTableModel();
            dataUsageTableModel.inputSelectionAll(false, this.m_table);
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    protected void processUserInput() {
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() throws Exception {
        this.setPageDescription();
        this.setSpread();
    }

    private void setPageDescription() {
        String string = this.requiresTarget() ? DM4JResourceUtilities.getActivityUIString("DATA_USAGE_DESCRIPTION") : DM4JResourceUtilities.getActivityUIString("DATA_USAGE_DESCRIPTION_NOTARGET");
        string = DM4JResourceUtilities.wrapInHTML(string);
        this.lbllStepDescription.setText(string);
    }

    public void refresh() throws Exception {
        this.reinit();
    }

    public void reinit() throws Exception {
        this.init();
    }

    public void clear() {
    }

    protected void setSpread() throws Exception {
        Object object;
        BuildActivityWizardState buildActivityWizardState = (BuildActivityWizardState)this.m_state.getparentWizardState();
        CDSStatsDataSource cDSStatsDataSource = this.m_state.getStatsDataSource();
        DataSourceState dataSourceState = (DataSourceState)buildActivityWizardState.getStep(ActivityStepType.DATA_STEP);
        RelatedDataSourceState relatedDataSourceState = (RelatedDataSourceState)buildActivityWizardState.getStep(ActivityStepType.RELATED_TABLES_STEP);
        Vector<Table> vector = new Vector<Table>(relatedDataSourceState.getRelatedTables());
        vector.add(dataSourceState.getCaseTable());
        DataUsageTableModel dataUsageTableModel = new DataUsageTableModel(0, vector, cDSStatsDataSource, this.getActivityType(), this.m_state);
        this.m_state.setDataUsageTableModel(dataUsageTableModel);
        try {
            dataUsageTableModel.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Object[] objectArray = new String[DataUsageTableModel.COLUMN_COUNT];
        objectArray[DataUsageTableModel.NAME_COLUMN] = "Name";
        objectArray[DataUsageTableModel.ALIAS_COLUMN] = "Alias";
        objectArray[DataUsageTableModel.TARGET_COLUMN] = "Target";
        objectArray[DataUsageTableModel.INPUT_COLUMN] = "Input";
        objectArray[DataUsageTableModel.DATA_TYPE_COLUMN] = "Data Type";
        objectArray[DataUsageTableModel.MINING_TYPE_COLUMN] = "Mining Type";
        objectArray[DataUsageTableModel.SPARSITY_COLUMN] = "Sparsity";
        try {
            if (objectArray.length != dataUsageTableModel.getColumnCount()) {
                throw new Exception("Column count not in sync");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_colModel = new ArrayOneDModel(objectArray);
        this.m_table.setModels((TwoDModel)dataUsageTableModel, this.m_colModel, null);
        Grid grid = this.m_table.getGrid();
        Painter painter = grid.getColumnPainter(0);
        HCellHandler hCellHandler = new HCellHandler(painter);
        grid.setColumnPainter(DataUsageTableModel.NAME_COLUMN, hCellHandler);
        grid.setColumnPainter(DataUsageTableModel.DATA_TYPE_COLUMN, painter);
        grid.setColumnPainter(DataUsageTableModel.MINING_TYPE_COLUMN, painter);
        grid.setColumnCellInputHandler(DataUsageTableModel.NAME_COLUMN, hCellHandler);
        grid.setColumnCellInputHandler(DataUsageTableModel.DATA_TYPE_COLUMN, hCellHandler);
        CustomProxyPainter customProxyPainter = new CustomProxyPainter();
        grid.setColumnPainter(DataUsageTableModel.ALIAS_COLUMN, customProxyPainter);
        grid.setColumnPainter(DataUsageTableModel.TARGET_COLUMN, customProxyPainter);
        grid.setColumnPainter(DataUsageTableModel.INPUT_COLUMN, customProxyPainter);
        grid.setColumnPainter(DataUsageTableModel.SPARSITY_COLUMN, customProxyPainter);
        CustomProxyInputHandler customProxyInputHandler = new CustomProxyInputHandler();
        grid.setColumnCellInputHandler(DataUsageTableModel.ALIAS_COLUMN, customProxyInputHandler);
        grid.setColumnCellInputHandler(DataUsageTableModel.TARGET_COLUMN, customProxyInputHandler);
        grid.setColumnCellInputHandler(DataUsageTableModel.INPUT_COLUMN, customProxyInputHandler);
        grid.setColumnCellInputHandler(DataUsageTableModel.MINING_TYPE_COLUMN, customProxyInputHandler);
        grid.setColumnCellInputHandler(DataUsageTableModel.SPARSITY_COLUMN, customProxyInputHandler);
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 1, 0);
        grid.setGridSelectionManager(generalGridSelectionManager);
        boolean bl = this.m_state.isTargetRequired(buildActivityWizardState);
        if (!bl) {
            grid.setColumnVisible(DataUsageTableModel.TARGET_COLUMN, false);
        }
        if (dataUsageTableModel.getRowCount() != 0) {
            object = new TwoDSelection(0, true);
            try {
                this.m_table.setSelection((TwoDSelection)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = new int[DataUsageTableModel.COLUMN_COUNT];
        object[DataUsageTableModel.NAME_COLUMN] = 25;
        object[DataUsageTableModel.ALIAS_COLUMN] = 20;
        object[DataUsageTableModel.TARGET_COLUMN] = 8;
        object[DataUsageTableModel.INPUT_COLUMN] = 8;
        object[DataUsageTableModel.DATA_TYPE_COLUMN] = 15;
        object[DataUsageTableModel.MINING_TYPE_COLUMN] = 14;
        object[DataUsageTableModel.SPARSITY_COLUMN] = 5;
        if (!bl) {
            object[DataUsageTableModel.TARGET_COLUMN] = 0;
            object[DataUsageTableModel.NAME_COLUMN] = object[DataUsageTableModel.NAME_COLUMN] + 5;
            object[DataUsageTableModel.ALIAS_COLUMN] = object[DataUsageTableModel.ALIAS_COLUMN] + 5;
        }
        try {
            this.m_table.setColumnWidths((int[])object, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ActivityType getActivityType() {
        BuildActivityWizardState buildActivityWizardState = (BuildActivityWizardState)this.getparentWizardState();
        return buildActivityWizardState.getActivityType();
    }

    private CDSStatsDataSource getStatsDataSource() {
        return this.m_state.getStatsDataSource();
    }

    private boolean showValidations(Vector vector, Component component) {
        boolean bl = false;
        if (!vector.isEmpty()) {
            int n;
            ValidationException validationException = null;
            String string = "";
            for (n = 0; n < vector.size(); ++n) {
                validationException = (ValidationException)vector.get(n);
                string = string + validationException.getMessage();
                if (validationException.isError()) {
                    bl = true;
                }
                if (n == vector.size() - 1) continue;
                string = string + "\n";
            }
            n = bl ? 0 : 2;
            JOptionPane.showMessageDialog(component, string, DM4JVersion.getFullBrowserName(), n);
        }
        return bl;
    }

    class GetTableStatsThread
    extends LongRunningProcess {
        private Table sampledTable = null;
        private Column uniqueIdentifier = null;
        private Vector tables = null;
        private DataUsageState duState = null;
        private CDSStatsDataSource stats = null;

        public GetTableStatsThread(DataUsageState dataUsageState, Table table, Vector vector, Column column) {
            this.sampledTable = table;
            this.duState = dataUsageState;
            this.tables = vector;
            this.uniqueIdentifier = column;
        }

        public CDSStatsDataSource getStats() {
            return this.stats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    this.stats = this.duState.createHeuristicsDataSource(DataUsagePanel.this.getparentWizardState().getConnection(), this.tables, this.sampledTable, this.uniqueIdentifier);
                }
                catch (Exception exception) {
                    this.setException(exception);
                    Object var3_2 = null;
                    this.getProgressBar().setDoneStatus();
                }
                Object var3_1 = null;
                this.getProgressBar().setDoneStatus();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.getProgressBar().setDoneStatus();
                throw throwable;
            }
        }
    }

    private class ChooseSparsityInputHandler
    extends BooleanInputHandler {
        private ChooseSparsityInputHandler() {
        }

        protected Object getNewValue(Grid grid, int n, int n2, Object object) {
            Boolean bl = (Boolean)super.getNewValue(grid, n, n2, object);
            DataUsageTableModel dataUsageTableModel = DataUsagePanel.this.m_state.getDataUsageTableModel();
            Column column = dataUsageTableModel.getColumnAtIndex(n2);
            BuildActivityWizardState buildActivityWizardState = (BuildActivityWizardState)DataUsagePanel.this.m_state.getparentWizardState();
            ModelState modelState = (ModelState)buildActivityWizardState.getStep(ActivityStepType.MODEL_STEP);
            boolean bl2 = (Boolean)object;
            if (!bl2 && !ActivityUtils.isHandlesSparse(modelState.getActivityType()) && column instanceof Mapping) {
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), "This activity type does not support mappings to sparse data.\nIf this data is sparse, exclude it from the activity by clearing the input check box.", DM4JVersion.getFullBrowserName(), 0);
                return object;
            }
            boolean bl3 = dataUsageTableModel.setSparseAtIndex(n2, bl);
            return bl3;
        }
    }

    private class SelectColumnInputHandler
    extends BooleanInputHandler {
        private SelectColumnInputHandler() {
        }

        protected Object getNewValue(Grid grid, int n, int n2, Object object) {
            Serializable serializable;
            DataUsageTableModel dataUsageTableModel = DataUsagePanel.this.m_state.getDataUsageTableModel();
            Object object2 = false;
            Boolean bl = (Boolean)object;
            boolean bl2 = false;
            if (!bl.booleanValue() && !(serializable = dataUsageTableModel.validateInput(n2)).isEmpty()) {
                bl2 = DataUsagePanel.this.showValidations(serializable, BrowserFrame.getMainFrame());
            }
            if (!bl2) {
                object2 = super.getNewValue(grid, n, n2, object);
                serializable = (Boolean)object2;
                dataUsageTableModel.setInputAtIndex(n2, (Boolean)serializable);
            }
            return object2;
        }
    }

    private class TargetInputHandler
    extends BooleanInputHandler {
        private TargetInputHandler() {
        }

        protected Object getNewValue(Grid grid, int n, int n2, Object object) {
            DataUsageTableModel dataUsageTableModel = DataUsagePanel.this.m_state.getDataUsageTableModel();
            if (dataUsageTableModel.getTargetIndex() == n2) {
                return true;
            }
            Vector vector = dataUsageTableModel.validateTarget(n2);
            Object object2 = false;
            boolean bl = false;
            if (!vector.isEmpty()) {
                bl = DataUsagePanel.this.showValidations(vector, BrowserFrame.getMainFrame());
            }
            if (!bl) {
                dataUsageTableModel.setTargetAtIndex(n2);
                DataUsagePanel.this.m_state.setTargetTable(dataUsageTableModel.getTargetTable());
                DataUsagePanel.this.m_state.setTargetColumn(dataUsageTableModel.getTargetColumn());
                object2 = super.getNewValue(grid, n, n2, object);
            }
            return object2;
        }
    }

    private class AliasInputHandler
    extends TextFieldInputHandler {
        private AliasInputHandler() {
        }

        public Object commitEdit(Grid grid, int n, int n2) {
            JTextField jTextField = (JTextField)this.getEditControl(grid, n, n2);
            String string = jTextField.getText();
            DataUsageTableModel dataUsageTableModel = DataUsagePanel.this.m_state.getDataUsageTableModel();
            Column column = dataUsageTableModel.getColumnAtIndex(n2);
            String string2 = column.getAlias();
            Vector vector = dataUsageTableModel.validateAlias(string);
            boolean bl = false;
            if (!vector.isEmpty()) {
                bl = DataUsagePanel.this.showValidations(vector, BrowserFrame.getMainFrame());
            }
            if (bl) {
                return string2;
            }
            String string3 = dataUsageTableModel.setAliasAtIndex(n2, string);
            if (string3.equals(string2)) {
                return string2;
            }
            DataUsagePanel.this.m_state.setState(StepStateType.DIRTY);
            return string3;
        }
    }

    private class MiningTypeInputHandler
    extends ComboBoxInputHandler {
        private MiningTypeInputHandler() {
        }

        public Object commitEdit(Grid grid, int n, int n2) {
            boolean bl;
            Vector vector;
            JComboBox jComboBox = (JComboBox)this.getEditControl(grid, n, n2);
            String string = (String)jComboBox.getSelectedItem();
            DataUsageTableModel dataUsageTableModel = DataUsagePanel.this.m_state.getDataUsageTableModel();
            Column column = dataUsageTableModel.getColumnAtIndex(n2);
            String string2 = column.getMiningType();
            column.setMiningType(string);
            if (column.getIsInput()) {
                vector = dataUsageTableModel.validateInput(n2);
                bl = false;
                if (!vector.isEmpty()) {
                    bl = DataUsagePanel.this.showValidations(vector, BrowserFrame.getMainFrame());
                }
                if (bl) {
                    column.setMiningType(string2);
                    return column.getMiningType();
                }
            }
            if (column.getIsTarget()) {
                vector = dataUsageTableModel.validateTarget(n2);
                bl = false;
                if (!vector.isEmpty()) {
                    bl = DataUsagePanel.this.showValidations(vector, BrowserFrame.getMainFrame());
                }
                if (bl) {
                    column.setMiningType(string2);
                    return column.getMiningType();
                }
            }
            column.setMiningType(string2);
            dataUsageTableModel.setMiningTypeAtIndex(n2, string);
            return string;
        }
    }

    private class CustomProxyInputHandler
    extends ProxyInputHandler {
        private String[] numCatMiningTypeValues = new String[]{"categorical", "numerical"};
        private String[] catTxtMiningTypeValues = new String[]{"categorical", "text"};
        private CellInputHandler _nullInputHandler = NullInputHandler.getCellInputHandler();
        private CellInputHandler _aliasInputHandler;
        private CellInputHandler _targetInputHandler;
        private CellInputHandler _booleanInputHandler;
        private CellInputHandler _chooseInputHandler;
        private CellInputHandler _sparsityInputHandler;

        public CustomProxyInputHandler() {
            this._aliasInputHandler = new AliasInputHandler();
            this._targetInputHandler = new TargetInputHandler();
            this._chooseInputHandler = new SelectColumnInputHandler();
            this._booleanInputHandler = BooleanInputHandler.getCellInputHandler();
            this._sparsityInputHandler = new ChooseSparsityInputHandler();
        }

        public CellInputHandler getCellInputHandler(Grid grid, int n, int n2) {
            DataUsageTableModel dataUsageTableModel = DataUsagePanel.this.m_state.getDataUsageTableModel();
            HDataObject hDataObject = (HDataObject)dataUsageTableModel.getExpandedData(0, n2);
            Object object = hDataObject.getData();
            if (object instanceof Table) {
                return this._nullInputHandler;
            }
            if (n == DataUsageTableModel.ALIAS_COLUMN) {
                return this._aliasInputHandler;
            }
            if (n == DataUsageTableModel.INPUT_COLUMN) {
                return this._chooseInputHandler;
            }
            if (n == DataUsageTableModel.SPARSITY_COLUMN) {
                return this._sparsityInputHandler;
            }
            if (object instanceof Mapping) {
                if (n == DataUsageTableModel.TARGET_COLUMN) {
                    return this._nullInputHandler;
                }
                if (n == DataUsageTableModel.MINING_TYPE_COLUMN) {
                    return this._nullInputHandler;
                }
                return this._nullInputHandler;
            }
            if (object instanceof Column) {
                if (n == DataUsageTableModel.TARGET_COLUMN) {
                    return this._targetInputHandler;
                }
                if (n == DataUsageTableModel.MINING_TYPE_COLUMN) {
                    if (dataUsageTableModel.isOptionalCategoricalAtIndex(n2)) {
                        MiningTypeInputHandler miningTypeInputHandler = new MiningTypeInputHandler();
                        miningTypeInputHandler.setItems(this.numCatMiningTypeValues);
                        return miningTypeInputHandler;
                    }
                    if (dataUsageTableModel.isOptionalTextDataTypeAtIndex(n2, DataUsagePanel.this.getActivityType())) {
                        MiningTypeInputHandler miningTypeInputHandler = new MiningTypeInputHandler();
                        miningTypeInputHandler.setItems(this.catTxtMiningTypeValues);
                        return miningTypeInputHandler;
                    }
                    return this._nullInputHandler;
                }
                return this._nullInputHandler;
            }
            new Exception("Unexpected type encountered").printStackTrace();
            return this._nullInputHandler;
        }
    }

    private class CustomProxyPainter
    extends ProxyPainter {
        private Painter _textFieldPainter = new WrappingTextPainter();
        private Painter _radioPainter = RadioPainter.getPainter();
        private Painter _checkPainter = CheckPainter.getPainter();

        public Painter getPainter(Grid grid, int n, int n2) {
            DataUsageTableModel dataUsageTableModel = DataUsagePanel.this.m_state.getDataUsageTableModel();
            HDataObject hDataObject = (HDataObject)dataUsageTableModel.getExpandedData(0, n2);
            Object object = hDataObject.getData();
            if (object instanceof Table) {
                return this._textFieldPainter;
            }
            if (n == DataUsageTableModel.INPUT_COLUMN || n == DataUsageTableModel.SPARSITY_COLUMN) {
                return this._checkPainter;
            }
            if (n == DataUsageTableModel.ALIAS_COLUMN || n == DataUsageTableModel.DATA_TYPE_COLUMN || n == DataUsageTableModel.MINING_TYPE_COLUMN) {
                return this._textFieldPainter;
            }
            if (object instanceof Mapping) {
                if (n == DataUsageTableModel.TARGET_COLUMN) {
                    return this._textFieldPainter;
                }
                new Exception("Unexpected Mapping object type encountered").printStackTrace();
                return this._textFieldPainter;
            }
            if (object instanceof Column) {
                if (n == DataUsageTableModel.TARGET_COLUMN) {
                    return this._radioPainter;
                }
                new Exception("Unexpected Column object type encountered").printStackTrace();
                return this._textFieldPainter;
            }
            new Exception("Unexpected type encountered").printStackTrace();
            return this._textFieldPainter;
        }
    }
}

