/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.sql.Connection;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.data.RelationshipType;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.SwingWorkerBasic;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;

public class DataSourceTree
extends JScrollPane
implements TreeExpansionListener {
    private JTree _tree = new JTree();
    private DefaultTreeModel _treeModel = null;
    private String _exclSchema = "";
    private String _exclTable = "";

    public DataSourceTree() {
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setExcludeCaseTable(String string, String string2) {
        this._exclSchema = string;
        this._exclTable = string2;
    }

    public JTree getTreeComponent() {
        return this._tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new RootFolder(DM4JResourceUtilities.getUIString("TREE_CONNECTION")));
        Connection connection = null;
        Vector vector = null;
        this._tree.removeTreeExpansionListener(this);
        try {
            try {
                connection = DM4JConnectionManager.getDbConnection();
                vector = DatabaseMetadata.getAccessibleSchemas(connection);
                for (String string : vector) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new SchemaFolder(string));
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new Boolean(true));
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                Object var9_9 = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var9_10 = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            throw throwable;
        }
        this._treeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this._tree.setModel(this._treeModel);
        this._tree.addTreeExpansionListener(this);
        this._tree.putClientProperty("JTree.lineStyle", "Angled");
        DataTreeCellRenderer dataTreeCellRenderer = new DataTreeCellRenderer();
        this._tree.setCellRenderer(dataTreeCellRenderer);
        this._tree.setEditable(false);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this.getViewport().add((Component)this._tree, null);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof SchemaFolder) {
            SchemaFolder schemaFolder = (SchemaFolder)object;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
            Object object2 = defaultMutableTreeNode2.getUserObject();
            if (object2 instanceof Boolean) {
                defaultMutableTreeNode.remove(defaultMutableTreeNode2);
                LoadTablesWorker loadTablesWorker = new LoadTablesWorker(defaultMutableTreeNode, schemaFolder.getName(), this._treeModel);
                loadTablesWorker.start();
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void addItems(Vector vector) throws Exception {
        for (Table table : vector) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.findSchemaNode(table.getSchema());
            this.insertTableNode(defaultMutableTreeNode, new DefaultMutableTreeNode(new TableNode(table)));
            this._treeModel.reload(defaultMutableTreeNode);
        }
    }

    private void insertTableNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        int n = 0;
        boolean bl = false;
        Collator collator = Collator.getInstance();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            TableNode tableNode = (TableNode)defaultMutableTreeNode3.getUserObject();
            TableNode tableNode2 = (TableNode)defaultMutableTreeNode2.getUserObject();
            String string = tableNode.getName();
            if (collator.compare(string, tableNode2.getName()) >= 0) {
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, n);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private DefaultMutableTreeNode findSchemaNode(String string) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            SchemaFolder schemaFolder = (SchemaFolder)defaultMutableTreeNode3.getUserObject();
            if (!schemaFolder.getName().equals(string)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        return defaultMutableTreeNode2;
    }

    private class DataTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        private Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        private Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        private Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        private Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        private boolean m_bSelected;

        public DataTreeCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof SchemaFolder) {
                SchemaFolder schemaFolder = (SchemaFolder)object2;
                this.setText(schemaFolder.getName());
                if (bl2) {
                    this.setIcon(schemaFolder.getExpandedIcon());
                } else {
                    this.setIcon(schemaFolder.getIcon());
                }
                this.setToolTipText(schemaFolder.getName());
            } else if (object2 instanceof TableNode) {
                TableNode tableNode = (TableNode)object2;
                this.setText(tableNode.getName());
                this.setIcon(tableNode.getIcon());
                this.setToolTipText(tableNode.getName());
            } else {
                String string = dM4JListResourceBundle.getString("COMMON_LOADING");
                this.setText(string);
                this.setToolTipText(string);
                this.setIcon(null);
            }
            this.setForeground(bl ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(bl ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_bSelected = bl;
            return this;
        }

        public void paintComponent(Graphics graphics) {
            Color color = this.getBackground();
            Icon icon = this.getIcon();
            graphics.setColor(color);
            int n = 0;
            if (icon != null && this.getText() != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
            }
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            if (this.m_bSelected) {
                graphics.setColor(this.m_borderSelectionColor);
                graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
            super.paintComponent(graphics);
        }
    }

    public class LoadTablesWorker
    extends SwingWorkerBasic {
        private DefaultTreeModel _model;
        private DefaultMutableTreeNode _parent;
        private String _schemaName = null;

        LoadTablesWorker(DefaultMutableTreeNode defaultMutableTreeNode, String string, DefaultTreeModel defaultTreeModel) {
            this._model = defaultTreeModel;
            this._parent = defaultMutableTreeNode;
            this._schemaName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public Object construct() {
            Vector vector;
            block11: {
                vector = null;
                Connection connection = null;
                connection = DM4JConnectionManager.getDbConnection();
                vector = DatabaseMetadata.getAccessableTablesAndViews(connection, this._schemaName);
                Object var5_3 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    break block11;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block11;
                {
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var5_4 = null;
                        try {
                            if (connection != null) {
                                connection.close();
                            }
                            break block11;
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    throw throwable;
                }
            }
            return vector;
        }

        public void finished() {
            Vector vector = (Vector)this.getValue();
            if (vector == null) {
                return;
            }
            try {
                for (String string : vector) {
                    if (DataSourceTree.this._exclSchema.equals(this._schemaName) && DataSourceTree.this._exclTable.equals(string)) continue;
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new TableNode(this._schemaName, string));
                    this._parent.add(defaultMutableTreeNode);
                }
                this._model.reload(this._parent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public class NavigatorCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        private Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        private Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        private Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        private Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        private boolean m_bSelected;

        public NavigatorCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof RootFolder) {
                RootFolder rootFolder = (RootFolder)object2;
                this.setText(rootFolder.getName());
                if (bl2) {
                    this.setIcon(rootFolder.getExpandedIcon());
                } else {
                    this.setIcon(rootFolder.getIcon());
                }
                this.setToolTipText(rootFolder.getName());
            } else if (object2 instanceof SchemaFolder) {
                SchemaFolder schemaFolder = (SchemaFolder)object2;
                this.setText(schemaFolder.getName());
                this.setIcon(schemaFolder.getIcon());
                this.setToolTipText(schemaFolder.getName());
            } else {
                String string = dM4JListResourceBundle.getString("COMMON_LOADING");
                this.setText(string);
                this.setToolTipText(string);
                this.setIcon(null);
            }
            this.setForeground(bl ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(bl ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_bSelected = bl;
            return this;
        }

        public void paintComponent(Graphics graphics) {
            Color color = this.getBackground();
            Icon icon = this.getIcon();
            graphics.setColor(color);
            int n = 0;
            if (icon != null && this.getText() != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
            }
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            if (this.m_bSelected) {
                graphics.setColor(this.m_borderSelectionColor);
                graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
            super.paintComponent(graphics);
        }
    }

    private class RootFolder
    extends NodeData {
        public RootFolder(String string) throws Exception {
            super(string, "SCHEMAS");
        }
    }

    class TableNode
    extends NodeData {
        private Table _table;

        public TableNode(String string, String string2) throws Exception {
            super(string2, "TABLE");
            this._table = null;
            this.m_expandedIcon = this.m_icon = this.getIconResource("TABLE");
            this._table = new Table();
            this._table.setSchema(string);
            this._table.setName(string2);
            this._table.setRelationship(RelationshipType.getRelationship(1));
        }

        public TableNode(Table table) throws Exception {
            super(table.getName(), "TABLE");
            this._table = null;
            this.m_expandedIcon = this.m_icon = this.getIconResource("TABLE");
            this._table = table;
        }

        public Table getTable() {
            return this._table;
        }
    }

    private class SchemaFolder
    extends NodeData {
        public SchemaFolder(String string) throws Exception {
            super(string, "TABLES_SCHEMA");
            this.m_expandedIcon = this.m_icon = this.getIconResource("TABLES_SCHEMA");
        }
    }
}

