/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import oracle.dmt.dm4j.activity.wizard.state.ApplyActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.BuildActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.state.TestActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.steps.DataSourcePanel;
import oracle.dmt.dm4j.wizard.DM4JWizardHelp;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class DataSourcePage
extends DM4JPage {
    private DataSourcePanel m_panel;
    private DataSourceState m_state;

    public DataSourcePage(WizardState wizardState, StepType stepType) throws Exception {
        super(wizardState);
        this.setStepType(stepType);
        this.create(wizardState);
        this.m_stepPanel = this.m_panel;
        this.setWizardStepState(this.m_state);
        if (this.getparentWizardState() instanceof BuildActivityWizardState) {
            DM4JWizardHelp.registerTopic(this.getContent(), "dm4j_mining_activity_data_html");
        } else {
            DM4JWizardHelp.registerTopic(this.getContent(), "dm4j_mining_activity_apply_data_html");
        }
    }

    private void create(WizardState wizardState) throws Exception {
        this.setLabel(ResourceUtilities.getUILabel("DATA_STEP_NAME"));
        this.setImage(wizardState.getImage());
        if (this.getparentWizardState() instanceof BuildActivityWizardState) {
            this.setTitle(ResourceUtilities.getUILabel("BUILD_ACTIVITY_DATA_STEP_DESC"));
        } else if (this.getparentWizardState() instanceof ApplyActivityWizardState) {
            this.setTitle(ResourceUtilities.getUILabel("APPLY_ACTIVITY_DATA_STEP_DESC"));
        } else if (this.getparentWizardState() instanceof TestActivityWizardState) {
            this.setTitle(ResourceUtilities.getUILabel("TEST_ACTIVITY_DATA_STEP_DESC"));
        }
        this.m_state = new DataSourceState(wizardState, "DATA_STEP_NAME", this.getStepType());
        wizardState.addStep(this.getStepType(), this.m_state);
        String string = this.m_state.getparentWizardState() instanceof BuildActivityWizardState ? "BUILD_ACTIVITY_DATA_STEP_DETAIL_DESC_BASIC" : "BUILD_ACTIVITY_DATA_STEP_DETAIL_STANDALONE_DESC_BASIC";
        this.m_panel = new DataSourcePanel(this.m_state, string);
        this.setInteractiveArea(this.m_panel);
        DataSourcePanel dataSourcePanel = (DataSourcePanel)this.getInteractiveArea();
        this.addWizardValidateListener(dataSourcePanel);
    }
}

