/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.sql.Connection;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.SwingWorkerBasic;
import oracle.dmt.dm4j.browser.tree.node.NodeData;

public class ChooseBuildActivityTree
extends JScrollPane
implements TreeExpansionListener {
    private JTree _tree = new JTree();
    private DefaultTreeModel _treeModel = null;
    private boolean _isTestActivity;

    public ChooseBuildActivityTree(boolean bl) {
        try {
            this._isTestActivity = bl;
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JTree getTreeComponent() {
        return this._tree;
    }

    public void init() throws Exception {
        this._tree.removeTreeExpansionListener(this);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new RootFolder(DM4JResourceUtilities.getUIString("TREE_ACTIVITIES")));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ActivityFolder(DM4JResourceUtilities.getUIString("TREE_CLASSIFICATION_MODELS"), "CLASSIFICATION_ACTIVITIES"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new ActivityFolder(DM4JResourceUtilities.getUIString("TREE_REGRESSION_MODELS"), "REGRESSION_ACTIVITIES"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new ActivityFolder(DM4JResourceUtilities.getUIString("TREE_FEATURE_EXTRACTION_MODELS"), "FEATURE_EXTRACTION_ACTIVITIES"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new ActivityFolder(DM4JResourceUtilities.getUIString("TREE_CLUSTERING_MODELS"), "CLUSTERING_ACTIVITIES"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new ActivityFolder(DM4JResourceUtilities.getUIString("TREE_ANOMALY_MODELS"), "ANOMALY_DETECTION_ACTIVITIES"));
        if (!this._isTestActivity) {
            defaultMutableTreeNode.add(defaultMutableTreeNode6);
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new Boolean(true)));
        if (!this._isTestActivity) {
            defaultMutableTreeNode.add(defaultMutableTreeNode5);
            defaultMutableTreeNode5.add(new DefaultMutableTreeNode(new Boolean(true)));
            defaultMutableTreeNode.add(defaultMutableTreeNode4);
            defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new Boolean(true)));
        this._treeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this._tree.setModel(this._treeModel);
        this._tree.addTreeExpansionListener(this);
        this._tree.putClientProperty("JTree.lineStyle", "Angled");
        DataTreeCellRenderer dataTreeCellRenderer = new DataTreeCellRenderer();
        this._tree.setCellRenderer(dataTreeCellRenderer);
        this._tree.setEditable(false);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this._tree.setSelectionModel(defaultTreeSelectionModel);
        this.getViewport().add((Component)this._tree, null);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof ActivityFolder) {
            ActivityFolder activityFolder = (ActivityFolder)object;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
            Object object2 = defaultMutableTreeNode2.getUserObject();
            if (object2 instanceof Boolean) {
                defaultMutableTreeNode.remove(defaultMutableTreeNode2);
                LoadActivitiesWorker loadActivitiesWorker = new LoadActivitiesWorker(defaultMutableTreeNode, this._treeModel);
                loadActivitiesWorker.start();
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public String getFolderType(String string) {
        if (string.equals("CLASSIFICATION_ACTIVITY")) {
            return "CLASSIFICATION_ACTIVITIES";
        }
        if (string.equals("ANOMALY_DETECTION_ACTIVITY")) {
            return "ANOMALY_DETECTION_ACTIVITIES";
        }
        if (string.equals("CLUSTERING_ACTIVITY")) {
            return "CLUSTERING_ACTIVITIES";
        }
        if (string.equals("FEATURE_EXTRACTION_ACTIVITY")) {
            return "FEATURE_EXTRACTION_ACTIVITIES";
        }
        if (string.equals("REGRESSION_ACTIVITY")) {
            return "REGRESSION_ACTIVITIES";
        }
        return "";
    }

    public TreePath findComponent(String string, String string2) {
        TreePath treePath = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._treeModel.getRoot();
        Object object = defaultMutableTreeNode.getUserObject();
        string2 = DM4JStringUtils.isDoubleQuotedString(string2) ? DM4JStringUtils.trimDoubleQuotes(string2) : string2;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            Object object2;
            Object object3;
            NodeData nodeData;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object4 = defaultMutableTreeNode2.getUserObject();
            if (!(object4 instanceof ActivityFolder) || !(nodeData = (ActivityFolder)object4).getNodeType().equals(this.getFolderType(string))) continue;
            if (defaultMutableTreeNode2.getChildCount() > 0 && (object4 = ((DefaultMutableTreeNode)(object3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild())).getUserObject()) instanceof Boolean) {
                defaultMutableTreeNode2.remove((MutableTreeNode)object3);
                object2 = new LoadActivitiesWorker(defaultMutableTreeNode2, this._treeModel);
                Vector vector = (Vector)((LoadActivitiesWorker)object2).construct();
                ((LoadActivitiesWorker)object2).finished(vector);
            }
            object3 = defaultMutableTreeNode2.children();
            while (object3.hasMoreElements()) {
                object2 = (DefaultMutableTreeNode)object3.nextElement();
                object4 = ((DefaultMutableTreeNode)object2).getUserObject();
                nodeData = (NodeData)object4;
                if (!nodeData.getName().equals(string2)) continue;
                treePath = new TreePath(((DefaultMutableTreeNode)object2).getPath());
                break;
            }
            return treePath;
        }
        return treePath;
    }

    public void selectActivityLeafNode(String string, String string2) {
        TreePath treePath = this.findComponent(string2, string);
        if (treePath != null) {
            this._tree.scrollPathToVisible(treePath);
            this._tree.setSelectionPath(treePath);
        }
    }

    private class DataTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        private Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        private Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        private Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        private Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        private boolean m_bSelected;

        public DataTreeCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof ActivityFolder) {
                ActivityFolder activityFolder = (ActivityFolder)object2;
                this.setText(activityFolder.getName());
                if (bl2) {
                    this.setIcon(activityFolder.getExpandedIcon());
                } else {
                    this.setIcon(activityFolder.getIcon());
                }
                this.setToolTipText(activityFolder.getName());
            } else if (object2 instanceof ActivityNode) {
                ActivityNode activityNode = (ActivityNode)object2;
                this.setText(activityNode.getName());
                this.setIcon(activityNode.getIcon());
                this.setToolTipText(activityNode.getName());
            } else {
                String string = dM4JListResourceBundle.getString("COMMON_LOADING");
                this.setText(string);
                this.setToolTipText(string);
                this.setIcon(null);
            }
            this.setForeground(bl ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(bl ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_bSelected = bl;
            return this;
        }

        public void paintComponent(Graphics graphics) {
            Color color = this.getBackground();
            Icon icon = this.getIcon();
            graphics.setColor(color);
            int n = 0;
            if (icon != null && this.getText() != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
            }
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            if (this.m_bSelected) {
                graphics.setColor(this.m_borderSelectionColor);
                graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
            super.paintComponent(graphics);
        }
    }

    public class LoadActivitiesWorker
    extends SwingWorkerBasic {
        private DefaultTreeModel _model;
        private DefaultMutableTreeNode _parent;

        public LoadActivitiesWorker(DefaultMutableTreeNode defaultMutableTreeNode, DefaultTreeModel defaultTreeModel) {
            this._model = defaultTreeModel;
            this._parent = defaultMutableTreeNode;
        }

        public Object construct() {
            Vector vector = this.getBuildActivities((ActivityFolder)this._parent.getUserObject());
            return vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Vector getBuildActivities(ActivityFolder activityFolder) {
            ActivityType[] activityTypeArray;
            Connection connection = null;
            String[] stringArray = null;
            String string = activityFolder.getType();
            Vector<ActivityNode> vector = new Vector<ActivityNode>();
            connection = DM4JConnectionManager.getDbConnection();
            if (string.equals("CLASSIFICATION_ACTIVITIES")) {
                activityTypeArray = new ActivityType[]{ActivityType.ADAPTIVE_NAIVE_BAYES, ActivityType.NAIVE_BAYES, ActivityType.SVM_CLASSIFICATION, ActivityType.GLM_CLASSIFICATION, ActivityType.DECISION_TREE};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
            } else if (string.equals("REGRESSION_ACTIVITIES")) {
                activityTypeArray = new ActivityType[]{ActivityType.SVM_REGRESSION, ActivityType.GLM_REGRESSION};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
            } else if (string.equals("FEATURE_EXTRACTION_ACTIVITIES")) {
                activityTypeArray = new ActivityType[]{ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
            } else if (string.equals("CLUSTERING_ACTIVITIES")) {
                activityTypeArray = new ActivityType[]{ActivityType.K_MEANS_CLUSTER, ActivityType.O_CLUSTER};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
            } else if (string.equals("ANOMALY_DETECTION_ACTIVITIES")) {
                activityTypeArray = new ActivityType[]{ActivityType.SVM_SINGLE_CLASS};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
            }
            vector.setSize(0);
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(new ActivityNode(stringArray[i], "CLASSIFICATION_ACTIVITY"));
            }
            Object var8_9 = null;
            if (connection == null) return vector;
            try {
                connection.close();
                return vector;
            }
            catch (Exception exception) {}
            return vector;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var8_10 = null;
                    if (connection == null) return vector;
                    try {
                        connection.close();
                        return vector;
                    }
                    catch (Exception exception2) {}
                    return vector;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (connection == null) throw throwable;
                try {
                    connection.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        public void setActivitiesValue(Vector vector) {
        }

        public void finished(Vector vector) {
            try {
                for (ActivityNode activityNode : vector) {
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(activityNode);
                    this.insert(this._parent, defaultMutableTreeNode);
                }
                this._model.reload(this._parent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void finished() {
            Vector vector = (Vector)this.getValue();
            if (vector == null) {
                return;
            }
            this.finished(vector);
        }

        private void insert(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
            Collator collator = Collator.getInstance();
            int n = 0;
            boolean bl = false;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                NodeData nodeData = (NodeData)defaultMutableTreeNode3.getUserObject();
                NodeData nodeData2 = (NodeData)defaultMutableTreeNode2.getUserObject();
                String string = nodeData.getName();
                if (collator.compare(string, nodeData2.getName()) >= 0) {
                    defaultMutableTreeNode.insert(defaultMutableTreeNode2, n);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
    }

    public class NavigatorCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        private Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        private Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        private Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        private Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        private boolean m_bSelected;

        public NavigatorCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof RootFolder) {
                RootFolder rootFolder = (RootFolder)object2;
                this.setText(rootFolder.getName());
                if (bl2) {
                    this.setIcon(rootFolder.getExpandedIcon());
                } else {
                    this.setIcon(rootFolder.getIcon());
                }
                this.setToolTipText(rootFolder.getName());
            } else if (object2 instanceof ActivityFolder) {
                ActivityFolder activityFolder = (ActivityFolder)object2;
                this.setText(activityFolder.getName());
                this.setIcon(activityFolder.getIcon());
                this.setToolTipText(activityFolder.getName());
            } else {
                String string = dM4JListResourceBundle.getString("COMMON_LOADING");
                this.setText(string);
                this.setToolTipText(string);
                this.setIcon(null);
            }
            this.setForeground(bl ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(bl ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_bSelected = bl;
            return this;
        }

        public void paintComponent(Graphics graphics) {
            Color color = this.getBackground();
            Icon icon = this.getIcon();
            graphics.setColor(color);
            int n = 0;
            if (icon != null && this.getText() != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
            }
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            if (this.m_bSelected) {
                graphics.setColor(this.m_borderSelectionColor);
                graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
            super.paintComponent(graphics);
        }
    }

    private class RootFolder
    extends NodeData {
        public RootFolder(String string) throws Exception {
            super(string, "ACTIVITIES");
        }
    }

    public class ActivityNode
    extends NodeData {
        public ActivityNode(String string, String string2) throws Exception {
            super(string, string2);
            this.m_expandedIcon = this.m_icon = this.getIconResource(string2);
        }
    }

    private class ActivityFolder
    extends NodeData {
        private String _type;

        public ActivityFolder(String string, String string2) throws Exception {
            super(string, string2);
            this._type = string2;
            this.m_expandedIcon = this.m_icon = this.getIconResource(string2);
        }

        public String getType() {
            return this._type;
        }
    }
}

