/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.Collator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.ProxyPainter;
import oracle.bali.ewt.grid.TextFieldInputHandler;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.WrappingTextPainter;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.activity.wizard.state.ApplyOutputOptionState;
import oracle.dmt.dm4j.activity.wizard.state.ClassificationApplyOutputOptionState;
import oracle.dmt.dm4j.activity.wizard.state.ClusteringApplyOutputOptionState;
import oracle.dmt.dm4j.activity.wizard.state.FeatureExtractionApplyOutputOptionState;
import oracle.dmt.dm4j.datasources.ClassificationTargetSource;
import oracle.dmt.dm4j.datasources.ClusteringClusterNumberSource;
import oracle.dmt.dm4j.datasources.FeatureIdSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.table.ComponentSpreadTable;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;

public class ApplyOutputOptionPanel
extends DM4JStep {
    ApplyOutputOptionState m_state;
    ClassificationApplyOutputOptionState m_classificationState;
    ClusteringApplyOutputOptionState m_clusteringState;
    FeatureExtractionApplyOutputOptionState m_featureExtractionState;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblTargetName = new JLabel();
    JLabel lblTargetNameValue = new JLabel();
    JLabel lblTargetDataType = new JLabel();
    JLabel lblTargetDataTypeValue = new JLabel();
    JRadioButton optProbablePrediction = new JRadioButton();
    JRadioButton optSpecificPredictionValues = new JRadioButton();
    JRadioButton optTopNPredictions = new JRadioButton();
    ButtonGroup groupApplyOptions = new ButtonGroup();
    JLabel lblTargetValuesCountName = new JLabel();
    JLabel lblTargetValuesCountValue = new JLabel();
    JScrollPane paneSpread = new JScrollPane();
    ComponentSpreadTable spreadTable = new ComponentSpreadTable(null);
    JLabel lblClusterIdsCountName = new JLabel();
    JLabel lblClusterIdsCountValue = new JLabel();
    JLabel lblFeatureIdsCountName = new JLabel();
    JLabel lblFeatureIdsCountValue = new JLabel();
    JLabel lblTopNValue = new JLabel();
    DM4JNumberTextField txtTopNValue = new DM4JNumberTextField();
    String m_panelDescriptionResourceKey;
    MultiLineLabel mlblFormatDescription = new MultiLineLabel();
    private int[] m_colWidths = new int[]{10, 45, 45};
    JLabel lblFiller = new JLabel();

    public ApplyOutputOptionPanel(ApplyOutputOptionState applyOutputOptionState, String string) throws Exception {
        super(applyOutputOptionState);
        this.m_state = applyOutputOptionState;
        this.setState();
        this.m_panelDescriptionResourceKey = string;
        this.jbInit();
    }

    private void setState() throws Exception {
        Class<ClassificationApplyOutputOptionState> clazz = ClassificationApplyOutputOptionState.class;
        this.m_classificationState = clazz.isInstance(this.m_state) ? (ClassificationApplyOutputOptionState)this.m_state : null;
        Class<ClusteringApplyOutputOptionState> clazz2 = ClusteringApplyOutputOptionState.class;
        this.m_clusteringState = clazz2.isInstance(this.m_state) ? (ClusteringApplyOutputOptionState)this.m_state : null;
        Class<FeatureExtractionApplyOutputOptionState> clazz3 = FeatureExtractionApplyOutputOptionState.class;
        this.m_featureExtractionState = clazz3.isInstance(this.m_state) ? (FeatureExtractionApplyOutputOptionState)this.m_state : null;
    }

    private void jbInit() throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 10;
        int n5 = 0;
        int n6 = 10;
        int n7 = 0;
        int n8 = 0;
        int n9 = 24;
        int n10 = 10;
        int n11 = 10;
        int n12 = 60;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel(this.m_panelDescriptionResourceKey));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setPreferredColumns(n12);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 1.0, 0.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        if (this.m_classificationState != null) {
            ++n;
            n2 = 0;
            this.lblTargetName.setText(ResourceUtilities.getUILabel("APPLY_OPTION_PRIORS_TARGET_COUNT"));
            this.lblTargetName.setLabelFor(this.lblTargetNameValue);
            this.add((Component)this.lblTargetName, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4 + n9, n5, n6), n7, n8));
            n2 = 1;
            this.add((Component)this.lblTargetNameValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        }
        if (this.m_clusteringState != null) {
            ++n;
            n2 = 0;
            this.lblClusterIdsCountName.setText(ResourceUtilities.getUILabel("APPLY_OPTION_CLUSTERING_LEAF_ID_COUNT"));
            this.lblClusterIdsCountName.setLabelFor(this.lblClusterIdsCountValue);
            this.add((Component)this.lblClusterIdsCountName, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4 + n9, n5, n6), n7, n8));
            n2 = 1;
            this.add((Component)this.lblClusterIdsCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n4, n5, n6), n7, n8));
        }
        if (this.m_featureExtractionState != null) {
            ++n;
            n2 = 0;
            this.lblFeatureIdsCountName.setText(ResourceUtilities.getUILabel("APPLY_OPTION_NMF_FEATURE_ID_COUNT"));
            this.lblFeatureIdsCountName.setLabelFor(this.lblFeatureIdsCountValue);
            this.add((Component)this.lblFeatureIdsCountName, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4 + n9, n5, n6), n7, n8));
            n2 = 1;
            this.add((Component)this.lblFeatureIdsCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n4, n5, n6), n7, n8));
        }
        ++n;
        n2 = 0;
        if (this.m_classificationState != null) {
            this.optProbablePrediction.setText(ResourceUtilities.getUILabel("APPLY_OPTION_PROBABLE_OPTION"));
            this.optProbablePrediction.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_PROBABLE_OPTION"));
        } else if (this.m_clusteringState != null) {
            this.optProbablePrediction.setText(ResourceUtilities.getUILabel("APPLY_OPTION_CLUSTERING_PROBABLE_OPTION"));
            this.optProbablePrediction.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_CLUSTERING_PROBABLE_OPTION"));
        } else {
            this.optProbablePrediction.setText(ResourceUtilities.getUILabel("APPLY_OPTION_FEATURE_PROBABLE_OPTION"));
            this.optProbablePrediction.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_FEATURE_PROBABLE_OPTION"));
        }
        this.groupApplyOptions.add(this.optProbablePrediction);
        this.optProbablePrediction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ApplyOutputOptionPanel.this.optApplyOptions_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.optProbablePrediction, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        if (this.m_classificationState != null) {
            this.optSpecificPredictionValues.setText(ResourceUtilities.getUILabel("APPLY_OPTION_SPECIFIC_OPTION"));
            this.optSpecificPredictionValues.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_SPECIFIC_OPTION"));
        } else if (this.m_clusteringState != null) {
            this.optSpecificPredictionValues.setText(ResourceUtilities.getUILabel("APPLY_OPTION_CLUSTERING_SPECIFIC_OPTION"));
            this.optSpecificPredictionValues.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_CLUSTERING_SPECIFIC_OPTION"));
        } else {
            this.optSpecificPredictionValues.setText(ResourceUtilities.getUILabel("APPLY_OPTION_FEATURE_EXTRACTION_SPECIFIC_OPTION"));
            this.optSpecificPredictionValues.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_FEATURE_EXTRACTION_SPECIFIC_OPTION"));
        }
        this.groupApplyOptions.add(this.optSpecificPredictionValues);
        this.optSpecificPredictionValues.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ApplyOutputOptionPanel.this.optApplyOptions_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.optSpecificPredictionValues, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        if (this.m_classificationState != null || this.m_clusteringState != null || this.m_featureExtractionState != null) {
            ++n;
            n2 = 0;
            this.paneSpread.getViewport().add((Component)this.spreadTable, null);
            this.add((Component)this.paneSpread, new GridBagConstraints(n2, n, 2, 1, 1.0, 1.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        }
        ++n;
        n2 = 0;
        if (this.m_classificationState != null) {
            this.optTopNPredictions.setText(ResourceUtilities.getUILabel("APPLY_OPTION_TOPN_OPTION"));
            this.optTopNPredictions.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_TOPN_OPTION"));
        } else if (this.m_clusteringState != null) {
            this.optTopNPredictions.setText(ResourceUtilities.getUILabel("APPLY_OPTION_CLUSTERING_TOPN_OPTION"));
            this.optTopNPredictions.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_CLUSTERING_TOPN_OPTION"));
        } else {
            this.optTopNPredictions.setText(ResourceUtilities.getUILabel("APPLY_OPTION_FEATURE_EXTRACTION_TOPN_OPTION"));
            this.optTopNPredictions.setMnemonic(ResourceUtilities.getUIMnemonic("APPLY_OPTION_FEATURE_EXTRACTION_TOPN_OPTION"));
        }
        this.groupApplyOptions.add(this.optTopNPredictions);
        this.optTopNPredictions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ApplyOutputOptionPanel.this.optApplyOptions_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.optTopNPredictions, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        this.txtTopNValue.setLocale(Locale.getDefault());
        this.txtTopNValue.setDataType(Integer.TYPE);
        this.txtTopNValue.setSigned(false);
        n2 = 1;
        this.add((Component)this.txtTopNValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n4, n5, n6), n7, n8));
    }

    protected void optApplyOptions_actionPerformed(ActionEvent actionEvent) {
        if (this.optProbablePrediction.isSelected()) {
            this.enableProbablePrediction();
            this.m_state.setMostProbable(true);
        } else if (this.optSpecificPredictionValues.isSelected()) {
            this.enableSelectedPredications();
            this.m_state.setSpecificPredictions(true);
        } else if (this.optTopNPredictions.isSelected()) {
            this.enableTopN();
            this.m_state.setTopNPredictions(true);
        }
    }

    protected void enableProbablePrediction() {
        this.spreadTable.setEnabled(false);
        this.txtTopNValue.setEnabled(false);
    }

    protected void enableTopN() {
        this.spreadTable.setEnabled(false);
        this.txtTopNValue.setEnabled(true);
    }

    protected void enableSelectedPredications() {
        this.spreadTable.setEnabled(true);
        this.txtTopNValue.setEnabled(false);
    }

    protected void setClassificationSpread() throws Exception {
        this.spreadTable.setModels2(this.m_classificationState.getTargetValues(), this.m_classificationState.getTargetValues().getColumnDataSource(), null);
        this.spreadTable.setColumnWidths(this.m_colWidths, true);
        this.spreadTable.getGrid().setColumnPainter(0, CheckPainter.getPainter());
        this.spreadTable.getGrid().setColumnCellInputHandler(0, BooleanInputHandler.getCellInputHandler());
        CustomProxyPainter customProxyPainter = new CustomProxyPainter();
        this.spreadTable.getGrid().setColumnPainter(2, customProxyPainter);
        ClassCustomProxyInputHandler classCustomProxyInputHandler = new ClassCustomProxyInputHandler();
        this.spreadTable.getGrid().setColumnCellInputHandler(2, classCustomProxyInputHandler);
        Header header = this.spreadTable.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        ClassificationTargetSource classificationTargetSource = this.m_classificationState.getTargetValues();
        header.setItemInputHandler(new SortInputHandler(classificationTargetSource));
        classificationTargetSource.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        classificationTargetSource.setColumnComparator(1, new StringComparator(Collator.getInstance()));
        header.setHeaderKeyHandler(new KeyHandler());
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 1);
        this.spreadTable.getGrid().setGridSelectionManager(generalGridSelectionManager);
    }

    protected void setClusteringSpread() throws Exception {
        this.spreadTable.setModels2(this.m_clusteringState.getClusterNumbers(), this.m_clusteringState.getClusterNumbers().getColumnDataSource(), null);
        this.spreadTable.setColumnWidths(this.m_colWidths, true);
        this.spreadTable.getGrid().setColumnPainter(0, CheckPainter.getPainter());
        this.spreadTable.getGrid().setColumnCellInputHandler(0, BooleanInputHandler.getCellInputHandler());
        CustomProxyPainter customProxyPainter = new CustomProxyPainter();
        this.spreadTable.getGrid().setColumnPainter(2, customProxyPainter);
        ClustAliasInputHandler clustAliasInputHandler = new ClustAliasInputHandler();
        this.spreadTable.getGrid().setColumnCellInputHandler(2, clustAliasInputHandler);
        Header header = this.spreadTable.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        ClusteringClusterNumberSource clusteringClusterNumberSource = this.m_clusteringState.getClusterNumbers();
        header.setItemInputHandler(new SortInputHandler(clusteringClusterNumberSource));
        clusteringClusterNumberSource.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        clusteringClusterNumberSource.setColumnComparator(1, new StringComparator(Collator.getInstance()));
        header.setHeaderKeyHandler(new KeyHandler());
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 1);
        this.spreadTable.getGrid().setGridSelectionManager(generalGridSelectionManager);
    }

    protected void setFeatureExtractionSpread() throws Exception {
        this.spreadTable.setModels2(this.m_featureExtractionState.getFeatureIds(), this.m_featureExtractionState.getFeatureIds().getColumnDataSource(), null);
        this.spreadTable.setColumnWidths(this.m_colWidths, true);
        this.spreadTable.getGrid().setColumnPainter(0, CheckPainter.getPainter());
        this.spreadTable.getGrid().setColumnCellInputHandler(0, BooleanInputHandler.getCellInputHandler());
        CustomProxyPainter customProxyPainter = new CustomProxyPainter();
        this.spreadTable.getGrid().setColumnPainter(2, customProxyPainter);
        FeatCustomProxyInputHandler featCustomProxyInputHandler = new FeatCustomProxyInputHandler();
        this.spreadTable.getGrid().setColumnCellInputHandler(2, featCustomProxyInputHandler);
        Header header = this.spreadTable.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        FeatureIdSource featureIdSource = this.m_featureExtractionState.getFeatureIds();
        header.setItemInputHandler(new SortInputHandler(featureIdSource));
        featureIdSource.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        featureIdSource.setColumnComparator(1, new StringComparator(Collator.getInstance()));
        header.setHeaderKeyHandler(new KeyHandler());
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 1);
        this.spreadTable.getGrid().setGridSelectionManager(generalGridSelectionManager);
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() throws Exception {
        if (this.m_state.isMostProbable()) {
            this.optProbablePrediction.setSelected(true);
            this.enableProbablePrediction();
        } else if (this.m_state.isSpecificPredictions()) {
            this.optSpecificPredictionValues.setSelected(true);
            this.enableSelectedPredications();
        } else if (this.m_state.isTopNPredictions()) {
            this.optTopNPredictions.setSelected(true);
            this.enableTopN();
        }
        if (this.m_classificationState != null) {
            this.setClassificationSpread();
            this.lblTargetNameValue.setText(DM4JNumericFormat.format(this.m_classificationState.getTargetValueCountInteger()));
        }
        if (this.m_clusteringState != null) {
            this.setClusteringSpread();
            this.lblClusterIdsCountValue.setText(DM4JNumericFormat.format(this.m_clusteringState.getLeafClusterIDCountInteger()));
        }
        if (this.m_featureExtractionState != null) {
            this.setFeatureExtractionSpread();
            this.lblFeatureIdsCountValue.setText(DM4JNumericFormat.format(this.m_featureExtractionState.getFeatureIDCountInteger()));
        }
        this.txtTopNValue.setNumber(this.m_state.getNumberOfTopNPredictions());
    }

    public void reinit() throws Exception {
        this.init();
    }

    public void clear() {
    }

    protected void processUserInput() {
        this.m_state.setNumberOfTopNPredictions((Integer)this.txtTopNValue.getNumber());
    }

    private class FeatAliasInputHandler
    extends TextFieldInputHandler {
        private FeatAliasInputHandler() {
        }

        public Object commitEdit(Grid grid, int n, int n2) {
            JTextField jTextField = (JTextField)this.getEditControl(grid, n, n2);
            String string = jTextField.getText();
            FeatureIdSource featureIdSource = ApplyOutputOptionPanel.this.m_featureExtractionState.getFeatureIds();
            String string2 = featureIdSource.setFeaturePredictionAtIndex(n2, string);
            return string2;
        }
    }

    private class FeatCustomProxyInputHandler
    extends ProxyInputHandler {
        private CellInputHandler _aliasInputHandler;

        public FeatCustomProxyInputHandler() {
            this._aliasInputHandler = new FeatAliasInputHandler();
        }

        public CellInputHandler getCellInputHandler(Grid grid, int n, int n2) {
            return this._aliasInputHandler;
        }
    }

    private class ClustAliasInputHandler
    extends TextFieldInputHandler {
        private ClustAliasInputHandler() {
        }

        public Object commitEdit(Grid grid, int n, int n2) {
            JTextField jTextField = (JTextField)this.getEditControl(grid, n, n2);
            String string = jTextField.getText();
            ClusteringClusterNumberSource clusteringClusterNumberSource = ApplyOutputOptionPanel.this.m_clusteringState.getClusterNumbers();
            String string2 = clusteringClusterNumberSource.setClusterPredictionAtIndex(n2, string);
            return string2;
        }
    }

    private class ClustCustomProxyInputHandler
    extends ProxyInputHandler {
        private CellInputHandler _aliasInputHandler;

        public ClustCustomProxyInputHandler() {
            this._aliasInputHandler = new ClustAliasInputHandler();
        }

        public CellInputHandler getCellInputHandler(Grid grid, int n, int n2) {
            return this._aliasInputHandler;
        }
    }

    private class ClassAliasInputHandler
    extends TextFieldInputHandler {
        private ClassAliasInputHandler() {
        }

        public Object commitEdit(Grid grid, int n, int n2) {
            JTextField jTextField = (JTextField)this.getEditControl(grid, n, n2);
            String string = jTextField.getText();
            ClassificationTargetSource classificationTargetSource = ApplyOutputOptionPanel.this.m_classificationState.getTargetValues();
            String string2 = classificationTargetSource.setTargetPredictionAtIndex(n2, string);
            return string2;
        }
    }

    private class ClassCustomProxyInputHandler
    extends ProxyInputHandler {
        private CellInputHandler _aliasInputHandler;

        public ClassCustomProxyInputHandler() {
            this._aliasInputHandler = new ClassAliasInputHandler();
        }

        public CellInputHandler getCellInputHandler(Grid grid, int n, int n2) {
            return this._aliasInputHandler;
        }
    }

    private class CustomProxyPainter
    extends ProxyPainter {
        private Painter _textFieldPainter = new WrappingTextPainter();

        public Painter getPainter(Grid grid, int n, int n2) {
            return this._textFieldPainter;
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 32) {
                SortInputHandler sortInputHandler = (SortInputHandler)header.getItemInputHandler();
                sortInputHandler.sort(header.getFocusItem());
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }
}

