/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.steps;

import java.awt.Insets;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.state.ApplyDataSourceState;
import oracle.dmt.dm4j.activity.wizard.state.ChooseBuildActivityState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.steps.ApplySourceTable;
import oracle.dmt.dm4j.activity.wizard.steps.ApplySourceTableModel;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedApplyTableDescriptor;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.commonsteps.TableSorter;

public class ApplyDataSourcePanel
extends DM4JStep {
    private ApplyDataSourceState m_state;
    private String m_panelDescriptionResourceKey;
    private JLabel lblStepDescription = new JLabel();
    private ApplySourceTable _table;
    private ApplySourceTableModel _model;
    private JScrollPane _tableScroller = new JScrollPane();

    public ApplyDataSourcePanel(ApplyDataSourceState applyDataSourceState, String string) throws Exception {
        super(applyDataSourceState);
        this.m_state = applyDataSourceState;
        this.m_panelDescriptionResourceKey = string;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this._model = new ApplySourceTableModel();
        TableSorter tableSorter = new TableSorter(this._model);
        this._table = new ApplySourceTable((TableModel)tableSorter, this);
        tableSorter.setTableHeader(this._table.getTableHeader());
        this.m_state.setDataSource(this._model);
        String string = DM4JResourceUtilities.getActivityUIString(this.m_panelDescriptionResourceKey);
        string = DM4JResourceUtilities.wrapInHTML(string);
        this.lblStepDescription.setText(string);
        this.addFilledComponent(this.lblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this._tableScroller.getViewport().add(this._table);
        this.addFilledComponent(this._tableScroller, new Insets(1, 1, 1, 1), n++, 1, 2, 20, 1);
    }

    public void init() throws Exception {
        this.loadDefaultValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    private void loadDefaultValues() {
        WizardState wizardState = this.getparentWizardState();
        this._model = new ApplySourceTableModel();
        TableSorter tableSorter = new TableSorter(this._model);
        this._table.setModel(tableSorter);
        tableSorter.setTableHeader(this._table.getTableHeader());
        this.m_state.setDataSource(this._model);
        ChooseBuildActivityState chooseBuildActivityState = (ChooseBuildActivityState)wizardState.getStep(ActivityStepType.ACTIVITY_STEP);
        AbstractActivity abstractActivity = chooseBuildActivityState.getBuildActivity();
        Vector<RelatedApplyTableDescriptor> vector = new Vector<RelatedApplyTableDescriptor>();
        LinkedHashSet linkedHashSet = abstractActivity.getTables();
        for (Table table : linkedHashSet) {
            Table table2 = new Table(table, false);
            RelatedApplyTableDescriptor relatedApplyTableDescriptor = new RelatedApplyTableDescriptor(table, table2);
            vector.add(relatedApplyTableDescriptor);
        }
        this._model.addTables(vector);
        this.m_state.setDataSource(this._model);
    }

    public ApplyDataSourceState getPageState() {
        return this.m_state;
    }
}

