/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Mapping;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.BuildActivityWizard;
import oracle.dmt.dm4j.activity.wizard.state.BuildActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.state.DataUsageState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedSourceModel;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedTableDescriptor;
import oracle.dmt.dm4j.activity.wizard.validation.RelatedSourceStateError;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CDSStatsDataSource;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class RelatedDataSourceState
extends WizardStepState {
    private RelatedSourceModel m_dataSource;
    private Vector _relatedTables = new Vector();
    private boolean m_hidePage = true;

    public RelatedDataSourceState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public RelatedDataSourceState(WizardState wizardState, String string, StepType stepType, boolean bl) {
        super(wizardState, string, stepType);
        this.m_hidePage = bl;
    }

    public void invalidateDataUsageState() {
        WizardState wizardState = this.getparentWizardState();
        DataUsageState dataUsageState = (DataUsageState)wizardState.getStep(ActivityStepType.DATA_USAGE_STEP);
        dataUsageState.setState(StepStateType.INCONSISTENT);
    }

    public void validate(Vector vector) throws Exception {
        if (vector.isEmpty()) {
            this.validateTables(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void validateTables(Vector vector) {
        this._relatedTables.clear();
        Vector vector2 = this.m_dataSource.getTables();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            RelatedTableDescriptor relatedTableDescriptor = (RelatedTableDescriptor)vector2.get(i);
            if (!relatedTableDescriptor.isDefined()) {
                try {
                    vector.add(new StateValidation(RelatedSourceStateError.RELATED_TABLES_NOT_DEFINED));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            Table table = relatedTableDescriptor.getTable();
            this._relatedTables.add(table);
        }
    }

    public void refresh() throws Exception {
        this.load();
        this.setState(StepStateType.LOADED);
    }

    public void load() throws Exception {
        BuildActivityWizardState buildActivityWizardState = (BuildActivityWizardState)this.getparentWizardState();
        DataUsageState dataUsageState = (DataUsageState)buildActivityWizardState.getStep(ActivityStepType.DATA_USAGE_STEP);
        dataUsageState.resetAliasMappings();
        this.setState(StepStateType.LOADED);
    }

    public Vector getRelatedTables() {
        return this._relatedTables;
    }

    public RelatedSourceModel getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(RelatedSourceModel relatedSourceModel) {
        this.m_dataSource = relatedSourceModel;
    }

    public boolean postValidate(Vector vector) throws Exception {
        Object object;
        Object object2;
        BuildActivityWizardState buildActivityWizardState = (BuildActivityWizardState)this.getparentWizardState();
        BuildActivityWizard buildActivityWizard = (BuildActivityWizard)this.getparentWizardState().getWizard();
        DataUsageState dataUsageState = (DataUsageState)buildActivityWizardState.getStep(ActivityStepType.DATA_USAGE_STEP);
        DataSourceState dataSourceState = (DataSourceState)buildActivityWizardState.getStep(ActivityStepType.DATA_STEP);
        Integer n = new Integer(1);
        boolean bl = true;
        Vector<Table> vector2 = new Vector<Table>();
        Table table = dataSourceState.getCaseTable();
        vector2.add(table);
        vector2.addAll(this._relatedTables);
        dataUsageState.resetAliasMappings();
        boolean bl2 = false;
        for (int i = 0; i < vector2.size(); ++i) {
            object2 = (Table)vector2.get(i);
            if (((Table)object2).isTransactionalRelationship()) {
                object = ((Table)object2).getTxnMappings();
                for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                    Mapping mapping = (Mapping)((ArrayList)object).get(j);
                    ActivityUtils.generateUniqueAlias(mapping, dataUsageState.getAliasMappings(), n);
                    if (!mapping.getMiningType().equals("text")) continue;
                    if (!bl2) {
                        bl2 = true;
                        continue;
                    }
                    mapping.setIsInput(false);
                }
                continue;
            }
            object = ((Table)object2).getColumns();
            for (Map.Entry entry : ((LinkedHashMap)object).entrySet()) {
                Column column = (Column)entry.getValue();
                ActivityUtils.generateUniqueAlias(column, dataUsageState.getAliasMappings(), n);
            }
        }
        vector2 = new Vector();
        Table table2 = new Table(table, false);
        table2.setName(dataSourceState.getSampledCaseTable().getName());
        table2.setSchema(dataSourceState.getSampledCaseTable().getSchema());
        vector2.add(table2);
        vector2.addAll(this._relatedTables);
        object2 = new GetTableStatsThread(dataUsageState, dataSourceState.getSampledCaseTable(), vector2, dataSourceState.getUniqueIdentifier());
        object = new ProgressBar(BrowserFrame.getMainFrame(), "Calculating Statistics", (Runnable)object2, true);
        ((LongRunningProcess)object2).setProgressBar((ProgressBar)object);
        ((ProgressBar)object).start("Calculating Statistics", null);
        if (((LongRunningProcess)object2).getException() != null) {
            bl = false;
            throw ((LongRunningProcess)object2).getException();
        }
        if (((ProgressBar)object).hasUserCancelled()) {
            this.setState(StepStateType.DIRTY);
            dataUsageState.resetAliasMappings();
            dataUsageState.setState(StepStateType.UNLOADED);
            return false;
        }
        dataUsageState.setStatsDataSource(((GetTableStatsThread)object2).getStats());
        return bl;
    }

    protected void enablePage(boolean bl) {
        DM4JWizard dM4JWizard = this.getparentWizardState().getWizard();
        int n = dM4JWizard.getPageCount();
        Class<DM4JPage> clazz = DM4JPage.class;
        DM4JPage dM4JPage = null;
        WizardPage wizardPage = null;
        for (int i = 0; i < n; ++i) {
            wizardPage = dM4JWizard.getPageAt(i);
            if (!clazz.isInstance(wizardPage) || !(dM4JPage = (DM4JPage)wizardPage).getStepType().equals(StepType.DATA_STEP)) continue;
            dM4JPage.setEnabled(bl);
            dM4JPage.setVisible(bl);
        }
    }

    class GetTableStatsThread
    extends LongRunningProcess {
        private Table sampledTable = null;
        private Column uniqueIdentifier = null;
        private Vector tables = null;
        private DataUsageState duState = null;
        private CDSStatsDataSource stats = null;

        public GetTableStatsThread(DataUsageState dataUsageState, Table table, Vector vector, Column column) {
            this.sampledTable = table;
            this.duState = dataUsageState;
            this.tables = vector;
            this.uniqueIdentifier = column;
        }

        public CDSStatsDataSource getStats() {
            return this.stats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    if (this.getProgressBar().hasUserCancelled()) {
                        Object var3_1 = null;
                        this.getProgressBar().setDoneStatus();
                        return;
                    }
                    this.stats = this.duState.createHeuristicsDataSource(RelatedDataSourceState.this.getparentWizardState().getConnection(), this.tables, this.sampledTable, this.uniqueIdentifier);
                }
                catch (Exception exception) {
                    this.setException(exception);
                    Object var3_3 = null;
                    this.getProgressBar().setDoneStatus();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.getProgressBar().setDoneStatus();
                throw throwable;
            }
            Object var3_2 = null;
            this.getProgressBar().setDoneStatus();
        }
    }
}

