/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.awt.Component;
import java.sql.Connection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.datamining.supervised.regression.RegressionModel;
import javax.swing.JOptionPane;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JUnableToFindTargetAttributeException;
import oracle.dmt.dm4j.DM4JUserHasCanceledException;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.BuildActivityWizard;
import oracle.dmt.dm4j.activity.wizard.state.ApplyActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.BuildActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.ChooseBuildActivityState;
import oracle.dmt.dm4j.activity.wizard.state.DataUsageState;
import oracle.dmt.dm4j.activity.wizard.state.ModelState;
import oracle.dmt.dm4j.activity.wizard.state.SupplementalsState;
import oracle.dmt.dm4j.activity.wizard.state.TargetValueState;
import oracle.dmt.dm4j.activity.wizard.state.TestActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.steps.RelatedDataSourcePage;
import oracle.dmt.dm4j.activity.wizard.steps.SupplementalsTableModel;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.CDSStatsDataSource;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TableColumnsDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class DataSourceState
extends DataState {
    private StringBuffer _schemaName = new StringBuffer(0);
    private StringBuffer _tableName = new StringBuffer(0);
    private StringBuffer _tableComment = new StringBuffer(0);
    private Vector _schemaNames = new Vector();
    private Vector _tableNames = new Vector();
    private Table _caseTable = null;
    private Table _sampledCaseTable = null;
    private Column _uniqueIdentifier = null;
    private boolean _isUsingUniqueIdentifier = true;
    private int _samplingType;
    private int _samplingSize;
    private Vector _applyTables = null;
    private Vector _supplementalTables = null;
    private TableColumnsDataSource m_columnsDataSource;
    private boolean m_hidePage = true;

    public DataSourceState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public DataSourceState(WizardState wizardState, String string, StepType stepType, boolean bl) {
        super(wizardState, string, stepType);
        this.m_hidePage = bl;
    }

    public Vector getApplyTables() {
        return this._applyTables;
    }

    public Vector getSupplementalTables() {
        return this._supplementalTables;
    }

    public void validate(Vector vector) throws Exception {
        this.validateSchemaName(vector);
        if (vector.isEmpty()) {
            this.validateTableName(vector);
        }
        WizardState wizardState = this.getparentWizardState();
        boolean bl = false;
        if (wizardState instanceof BuildActivityWizardState) {
            ModelState modelState = (ModelState)this.getparentWizardState().getStep(ActivityStepType.MODEL_STEP);
            ActivityType activityType = modelState.getActivityType();
            if (activityType == ActivityType.ASSOCIATION_RULES) {
                bl = true;
            }
            if (vector.isEmpty() && !bl) {
                this.validateUniqueIdentifier(vector);
            }
            if (vector.isEmpty()) {
                this.validateSelectedColumns(vector, bl);
            }
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
        this.setCaseTable(this.m_columnsDataSource.getTable());
    }

    private void validateUniqueIdentifier(Vector vector) throws Exception {
        Column column = this.getUniqueIdentifier();
        Column column2 = null;
        LinkedHashMap linkedHashMap = this.m_columnsDataSource.getTable().getColumns();
        for (Map.Entry object : linkedHashMap.entrySet()) {
            Column column3 = (Column)object.getValue();
            if (!column3.getName().equalsIgnoreCase(ActivityUtils.getCaseIdName())) continue;
            column2 = column3;
            break;
        }
        if (this.getUsingUniqueIdentifier()) {
            if (column == null) {
                vector.add(new StateValidation(DataStateError.DATA_NO_CASEID_SELECTED));
                return;
            }
            if (column2 != null && !column.getName().equalsIgnoreCase(column2.getName())) {
                vector.add(new StateValidation(DataStateError.DATA_CASEID_NAME_CONFLICT));
                return;
            }
            ModelState modelState = (ModelState)this.getparentWizardState().getStep(ActivityStepType.MODEL_STEP);
            if (modelState.getActivityType().equals(ActivityType.O_CLUSTER) && !ActivityUtils.isIntegerDataType(column.getDataType())) {
                vector.add(new StateValidation(DataStateError.DATA_NUMBER_REQUIRED));
                return;
            }
            if (column.getDataLength() > 128) {
                vector.add(new StateValidation(DataStateError.CASE_ID_GREATER_THAN_128));
            }
        } else if (column2 != null) {
            vector.add(new StateValidation(DataStateError.DATA_CASEID_NAME_CONFLICT));
            return;
        }
    }

    protected void setCaseTable(Table table) {
        this._caseTable = table;
    }

    public Table getCaseTable() {
        return this._caseTable;
    }

    public void setUniqueIdentifier(Column column) {
        this._uniqueIdentifier = column;
    }

    public Column getUniqueIdentifier() {
        return this._uniqueIdentifier;
    }

    public void setUsingUniqueIdentifier(boolean bl) {
        this._isUsingUniqueIdentifier = bl;
    }

    public boolean getUsingUniqueIdentifier() {
        return this._isUsingUniqueIdentifier;
    }

    protected void validateSelectedColumns(Vector vector, boolean bl) {
        LinkedHashMap linkedHashMap = this.m_columnsDataSource.getAllAttributes();
        Iterator iterator = linkedHashMap.entrySet().iterator();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = "";
        if (!bl && this.getUsingUniqueIdentifier()) {
            string = this.getUniqueIdentifier().getName();
        }
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Column column = (Column)entry.getValue();
            if (column.getIsVisible()) {
                bl2 = true;
            }
            if (ActivityUtils.isNestedDataType(column.getDataType())) {
                bl3 = true;
            }
            if (string.equals(column.getName()) && column.getIsVisible()) {
                bl4 = true;
            }
            if (!bl3 || !bl2 || !bl4) continue;
            break;
        }
        if (!bl2) {
            try {
                vector.add(new StateValidation(DataStateError.DATA_NO_COLUMNS_SELECTED));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl4 && !bl && this.getUsingUniqueIdentifier()) {
            try {
                vector.add(new StateValidation(DataStateError.CASE_ID_MUST_BE_SELECTED));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void refresh() throws Exception {
        this.load();
    }

    public void load() throws Exception {
        DataSourceLoadThread dataSourceLoadThread = new DataSourceLoadThread();
        ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("DATA_SOURCE_EXTRACT_DIALOG_TITLE"), dataSourceLoadThread, true);
        progressBar.setCancelable(false);
        dataSourceLoadThread.setProgressBar(progressBar);
        progressBar.start(DM4JResourceUtilities.getActivityUIString("DATA_SOURCE_EXTRACT_DESCRIPTION"), null);
        if (dataSourceLoadThread.getException() != null) {
            throw dataSourceLoadThread.getException();
        }
        if (progressBar.hasUserCancelled()) {
            this.setState(StepStateType.UNLOADED);
            throw new DM4JUserHasCanceledException("User canceled load next step processing.");
        }
        UserPreferences userPreferences = UserPreferences.getInstance();
        this._samplingSize = userPreferences.getSampleSize();
        this._samplingType = 0;
        this.setState(StepStateType.LOADED);
    }

    protected void loadSchemaNames() throws Exception {
        this._schemaNames = DatabaseMetadata.getAccessibleSchemas(this.getparentWizardState().getConnection());
    }

    protected void loadDefaultSelectedSchemaName() throws Exception {
        if (this._schemaNames.isEmpty()) {
            return;
        }
        if (this.getparentWizardState().getBrowserContext().getSchemaName() != null) {
            this.setSelectedSchemaName(this.getparentWizardState().getBrowserContext().getSchemaName());
        } else {
            UserPreferences userPreferences = UserPreferences.getInstance();
            String string = userPreferences.getDefaultDataSourceSchema();
            if (string != null) {
                this.setSelectedSchemaName(string);
            } else {
                this.setSelectedSchemaName(DM4JConnectionManager.getUser());
            }
        }
    }

    protected void loadTableNames() throws Exception {
        this._tableNames = DatabaseMetadata.getAccessableTablesAndViews(this.getparentWizardState().getConnection(), this._schemaName.toString());
    }

    protected void loadDefaultSelectedTableName() throws Exception {
        if (this._tableNames.isEmpty()) {
            this.setSelectedTableName("");
            return;
        }
        if (this.getparentWizardState().getBrowserContext().getDataSourceName() != null) {
            this.setSelectedTableName(this.getparentWizardState().getBrowserContext().getDataSourceName());
            if (this.m_hidePage && this.getparentWizardState().getBrowserContext().getLaunchPoint().equals(LaunchPoint.CONTEXT_MENU)) {
                this.enablePage(false);
            }
        } else {
            UserPreferences userPreferences = UserPreferences.getInstance();
            String string = userPreferences.getDefaultCaseTable();
            if (string != null) {
                this.setSelectedTableName(string);
            } else {
                this.setSelectedTableName((String)this._tableNames.firstElement());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadColumnsDataSource(Component component) throws Exception {
        this.m_columnsDataSource = null;
        class LoadDataSourceThread
        extends LongRunningProcess {
            private boolean ui = false;

            LoadDataSourceThread(boolean bl) {
                this.ui = bl;
            }

            public void run() {
                block4: {
                    try {
                        Connection connection = DM4JConnectionManager.getDbConnection();
                        DataSourceState.this.m_columnsDataSource = new TableColumnsDataSource(connection, DataSourceState.this._schemaName.toString(), DataSourceState.this._tableName.toString());
                        if (!(DataSourceState.this.getparentWizardState() instanceof BuildActivityWizardState)) {
                            DataSourceState.this.m_columnsDataSource.setIgnoreNested(false);
                        }
                        Thread thread = new Thread(DataSourceState.this.m_columnsDataSource);
                        thread.start();
                        thread.join();
                        if (this.ui) {
                            this.getProgressBar().setDoneStatus();
                        }
                    }
                    catch (Exception exception) {
                        this.setException(exception);
                        if (!this.ui) break block4;
                        this.getProgressBar().setDoneStatus();
                    }
                }
            }
        }
        LoadDataSourceThread loadDataSourceThread = new LoadDataSourceThread(component != null);
        if (component != null) {
            ProgressBar progressBar = new ProgressBar(component, "Getting Table Details", loadDataSourceThread, true);
            progressBar.setCancelable(false);
            loadDataSourceThread.setProgressBar(progressBar);
            progressBar.start("", null);
            if (loadDataSourceThread.getException() != null) {
                JOptionPane.showMessageDialog(component, "Unable to get table information", DM4JVersion.getFullBrowserName(), 0);
                throw loadDataSourceThread.getException();
            }
            if (!progressBar.hasUserCancelled()) return;
        }
        Thread thread = new Thread(loadDataSourceThread);
        thread.start();
        thread.join();
    }

    public Vector getSchemaNames() {
        return (Vector)this._schemaNames.clone();
    }

    public Vector getTableNames() {
        return (Vector)this._tableNames.clone();
    }

    public String getSelectedSchemaName() {
        return this._schemaName.toString();
    }

    public void setSelectedSchemaName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this._schemaName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this._schemaName = new StringBuffer(string);
            this.loadTableNames();
            this.loadDefaultSelectedTableName();
        }
    }

    public TableColumnsDataSource getTableColumnsDataSource() {
        return this.m_columnsDataSource;
    }

    public String getSelectedTableName() {
        return this._tableName.toString();
    }

    public void setSelectedTableName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this._tableName.toString())) {
            this._tableName = new StringBuffer(string);
            this.loadTableComment();
            this.loadColumnNames();
        }
    }

    private void loadTableComment() throws Exception {
        this._tableComment = new StringBuffer(DatabaseMetadata.getTableComment(this.getparentWizardState().getConnection(), this._schemaName.toString(), this._tableName.toString()));
    }

    protected void validateSchemaName(Vector vector) throws Exception {
        String string = this._schemaName.toString();
        if (!this.isSchemaNameValid(string)) {
            String[] stringArray = new String[]{string};
            vector.add(new StateValidation((ValidationType)DataStateError.SCHEMA_NOT_IN_DB, stringArray));
        }
    }

    protected void validateTableName(Vector vector) throws Exception {
        String string = this._tableName.toString();
        if (!this.isTableNameValid(string)) {
            String[] stringArray = new String[]{string};
            vector.add(new StateValidation((ValidationType)DataStateError.TABLE_NOT_IN_DB, stringArray));
        }
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        UserPreferences userPreferences = UserPreferences.getInstance();
        userPreferences.setDefaultDataSourceSchema(this._schemaName.toString());
        userPreferences.setDefaultCaseTable(this._tableName.toString());
        userPreferences.save();
        WizardState wizardState = this.getparentWizardState();
        if (wizardState instanceof BuildActivityWizardState) {
            boolean bl2;
            BuildActivityWizard buildActivityWizard = (BuildActivityWizard)this.getparentWizardState().getWizard();
            RelatedDataSourcePage relatedDataSourcePage = buildActivityWizard.getRelatedDataSourcePage();
            BuildActivityWizardState buildActivityWizardState = (BuildActivityWizardState)this.getparentWizardState();
            DataUsageState dataUsageState = (DataUsageState)buildActivityWizardState.getStep(ActivityStepType.DATA_USAGE_STEP);
            boolean bl3 = bl2 = !relatedDataSourcePage.isVisible();
            boolean bl4 = this.getUsingUniqueIdentifier() ? !this.isUniqueIDPrimaryKey(this.getUniqueIdentifier()) || bl2 : bl2;
            CreateSampledTableThread createSampledTableThread = new CreateSampledTableThread(bl4, dataUsageState);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), "Processing Case Table", createSampledTableThread, true);
            createSampledTableThread.setProgressBar(progressBar);
            progressBar.start("", null);
            if (createSampledTableThread.getException() != null) {
                bl = false;
                throw createSampledTableThread.getException();
            }
            if (this.getSampledCaseTable() != null) {
                this.cleanUp();
            }
            if (progressBar.hasUserCancelled()) {
                this.setState(StepStateType.DIRTY);
                bl = false;
                return false;
            }
            this.setSampledCaseTable(createSampledTableThread.getSampledTable());
            if (bl2) {
                dataUsageState.setStatsDataSource(createSampledTableThread.getStats());
            }
            if (this.getUsingUniqueIdentifier() && !this.isUniqueIDPrimaryKey(this.getUniqueIdentifier()) && !createSampledTableThread.isCaseIDUnique()) {
                bl = false;
                this.setState(StepStateType.DIRTY);
                JOptionPane.showOptionDialog(null, "Unique Identifier is not a primary key and does not appear to be unique.", DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            }
        } else if (wizardState instanceof TestActivityWizardState) {
            TargetValuesThread targetValuesThread = new TargetValuesThread();
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("TARGET_VALUE_EXTRACT_DIALOG_TITLE"), targetValuesThread, true);
            targetValuesThread.setProgressBar(progressBar);
            progressBar.start(DM4JResourceUtilities.getActivityUIString("TARGET_VALUE_EXTRACT_DESCRIPTION"), null);
            if (targetValuesThread.getException() != null) {
                bl = false;
                if (targetValuesThread.getException() instanceof DM4JUnableToFindTargetAttributeException) {
                    this.setState(StepStateType.DIRTY);
                    JOptionPane.showOptionDialog(null, "Unable to find target attribute in selected table.", DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
                    return false;
                }
                throw targetValuesThread.getException();
            }
            if (progressBar.hasUserCancelled()) {
                this.setState(StepStateType.DIRTY);
                return false;
            }
        } else if (wizardState instanceof ApplyActivityWizardState) {
            ApplyActivityWizardState applyActivityWizardState = (ApplyActivityWizardState)this.getparentWizardState();
            SupplementalsState supplementalsState = (SupplementalsState)applyActivityWizardState.getStep(ActivityStepType.SUPPLEMENTALS_STEP);
            GetTablesThread getTablesThread = new GetTablesThread();
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("APPLY_SUPPLEMENTALS_PROGRESS_TEXT"), getTablesThread, true);
            getTablesThread.setProgressBar(progressBar);
            progressBar.start(DM4JResourceUtilities.getActivityUIString("TARGET_VALUE_EXTRACT_DESCRIPTION"), null);
            if (getTablesThread.getException() != null) {
                bl = false;
                throw getTablesThread.getException();
            }
            if (progressBar.hasUserCancelled()) {
                this.setState(StepStateType.DIRTY);
                return false;
            }
            this._supplementalTables = getTablesThread.getSupplementalTables();
            this._applyTables = getTablesThread.getApplyTables();
            SupplementalsTableModel supplementalsTableModel = new SupplementalsTableModel(0, this._supplementalTables);
            supplementalsState.setSupplementalsTableModel(supplementalsTableModel);
        }
        return bl;
    }

    private boolean isUniqueIDPrimaryKey(Column column) {
        Column column2 = this.getTableColumnsDataSource().getPrimaryKey();
        return column2 != null && column2.getName().equals(column.getName());
    }

    private boolean isUniqueIDUnique(CDSStatsDataSource cDSStatsDataSource) throws Exception {
        boolean bl = true;
        Column column = this.getUniqueIdentifier();
        String string = ActivityUtils.getCaseIdName();
        if (0 == string.compareTo(column.getName())) {
            return true;
        }
        if (!this.isUniqueIDPrimaryKey(column)) {
            int n = cDSStatsDataSource.getAttributeDistinctCount(column.getName());
            int n2 = cDSStatsDataSource.getTotalTableRowCount(this.getparentWizardState().getConnection());
            if (n2 != n) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isSchemaNameValid(String string) {
        Iterator iterator = this._schemaNames.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isTableNameValid(String string) {
        Iterator iterator = this._tableNames.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    protected void enablePage(boolean bl) {
        DM4JWizard dM4JWizard = this.getparentWizardState().getWizard();
        int n = dM4JWizard.getPageCount();
        Class<DM4JPage> clazz = DM4JPage.class;
        DM4JPage dM4JPage = null;
        WizardPage wizardPage = null;
        for (int i = 0; i < n; ++i) {
            wizardPage = dM4JWizard.getPageAt(i);
            if (!clazz.isInstance(wizardPage) || !(dM4JPage = (DM4JPage)wizardPage).getStepType().equals(StepType.DATA_STEP)) continue;
            dM4JPage.setEnabled(bl);
            dM4JPage.setVisible(bl);
        }
    }

    public boolean allowDataSelection() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        return (!browserContext.getLaunchPoint().equals(LaunchPoint.CONTEXT_MENU) || browserContext.getDataSourceName() == null) && !browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
    }

    public void setSampledCaseTable(Table table) {
        this._sampledCaseTable = table;
    }

    public Table getSampledCaseTable() {
        return this._sampledCaseTable;
    }

    public void setSamplingType(int n) {
        this._samplingType = n;
    }

    public int getSamplingType() {
        return this._samplingType;
    }

    public void setSamplingSize(int n) {
        this._samplingSize = n;
    }

    public int getSamplingSize() {
        return this._samplingSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cleanUp() {
        if (this._sampledCaseTable == null) return;
        Connection connection = null;
        connection = DM4JConnectionManager.getDbConnection();
        DatabaseMetadata.dropTable(connection, this._sampledCaseTable.getSchema(), this._sampledCaseTable.getName());
        Object var4_2 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                Object var4_3 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static boolean isRandomSampling(int n) {
        return n == 0;
    }

    static /* synthetic */ Table access$300(DataSourceState dataSourceState) {
        return dataSourceState._caseTable;
    }

    class CreateSampledTableThread
    extends LongRunningProcess {
        private Table sampledTable;
        private boolean getStats;
        private DataUsageState duState;
        private CDSStatsDataSource stats;
        private boolean caseIDUnique = false;

        public CreateSampledTableThread(boolean bl, DataUsageState dataUsageState) {
            this.getStats = bl;
            this.duState = dataUsageState;
        }

        public Table getSampledTable() {
            return this.sampledTable;
        }

        public CDSStatsDataSource getStats() {
            return this.stats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Connection connection = DataSourceState.this.getparentWizardState().getConnection();
            try {
                try {
                    this.getProgressBar().updateProgress("", "Validating Uniqueness of Case ID");
                    this.caseIDUnique = DataSourceState.this.getUniqueIdentifier() != null ? ActivityUtils.isCaseIDUnique(connection, DataSourceState.this.getCaseTable(), DataSourceState.this.getUniqueIdentifier()) : true;
                    this.getProgressBar().updateProgress("", "Sampling Case Table");
                    this.sampledTable = ActivityUtils.createSampledTable(connection, DataSourceState.this.getCaseTable(), DataSourceState.this.getSamplingType(), DataSourceState.this.getSamplingSize());
                    if (this.getProgressBar().hasUserCancelled()) {
                        DataSourceState.this.cleanUp();
                        Object var4_2 = null;
                        this.getProgressBar().setDoneStatus();
                        return;
                    }
                    if (this.getStats) {
                        this.getProgressBar().updateProgress("", "Calculating Statistics");
                        Vector<Table> vector = new Vector<Table>();
                        vector.add(this.sampledTable);
                        this.stats = this.duState.createHeuristicsDataSource(connection, vector, this.sampledTable, DataSourceState.this.getUniqueIdentifier());
                    }
                }
                catch (Exception exception) {
                    this.setException(exception);
                    Object var4_4 = null;
                    this.getProgressBar().setDoneStatus();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.getProgressBar().setDoneStatus();
                throw throwable;
            }
            Object var4_3 = null;
            this.getProgressBar().setDoneStatus();
        }

        public boolean isCaseIDUnique() {
            return this.caseIDUnique;
        }
    }

    class GetTablesThread
    extends LongRunningProcess {
        Vector _suppTables = new Vector();
        Vector _applTables = new Vector();

        GetTablesThread() {
        }

        public Vector getSupplementalTables() {
            return this._suppTables;
        }

        public Vector getApplyTables() {
            return this._applTables;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block24: {
                block18: {
                    block23: {
                        block17: {
                            block22: {
                                block16: {
                                    block21: {
                                        block15: {
                                            var1_1 = null;
                                            try {
                                                try {
                                                    var1_1 = DM4JConnectionManager.getDbConnection();
                                                    var2_2 = DataSourceState.access$300(DataSourceState.this);
                                                    this._applTables.add(var2_2);
                                                    if (this.getProgressBar().hasUserCancelled()) {
                                                        var5_4 = null;
                                                        break block15;
                                                    }
                                                    var3_16 = ActivityUtils.getTableDescriptor(var1_1, var2_2.getSchema(), var2_2.getName());
                                                    if (this.getProgressBar().hasUserCancelled()) {
                                                        break block16;
                                                    }
                                                    var3_16.clearAllInputs();
                                                    if (this.getProgressBar().hasUserCancelled()) {
                                                        break block17;
                                                    }
                                                    this._suppTables.add(var3_16);
                                                    break block18;
                                                }
                                                catch (Exception var2_3) {
                                                    this.setException(var2_3);
                                                    var5_8 = null;
                                                    try {
                                                        var1_1.close();
                                                    }
                                                    catch (Exception var6_14) {
                                                        // empty catch block
                                                    }
                                                    this.getProgressBar().setDoneStatus();
                                                    return;
                                                }
                                            }
                                            catch (Throwable var4_17) {
                                                block20: {
                                                    var5_9 = null;
                                                    ** try [egrp 2[TRYBLOCK] [10 : 119->128)] { 
lbl39:
                                                    // 1 sources

                                                    var1_1.close();
                                                    break block20;
lbl41:
                                                    // 1 sources

                                                    catch (Exception var6_15) {
                                                        // empty catch block
                                                    }
                                                }
                                                this.getProgressBar().setDoneStatus();
                                                throw var4_17;
                                            }
                                        }
                                        ** try [egrp 2[TRYBLOCK] [10 : 119->128)] { 
lbl48:
                                        // 1 sources

                                        var1_1.close();
                                        break block21;
lbl50:
                                        // 1 sources

                                        catch (Exception var6_10) {
                                            // empty catch block
                                        }
                                    }
                                    this.getProgressBar().setDoneStatus();
                                    return;
                                }
                                var5_5 = null;
                                ** try [egrp 2[TRYBLOCK] [10 : 119->128)] { 
lbl58:
                                // 1 sources

                                var1_1.close();
                                break block22;
lbl60:
                                // 1 sources

                                catch (Exception var6_11) {
                                    // empty catch block
                                }
                            }
                            this.getProgressBar().setDoneStatus();
                            return;
                        }
                        var5_6 = null;
                        ** try [egrp 2[TRYBLOCK] [10 : 119->128)] { 
lbl68:
                        // 1 sources

                        var1_1.close();
                        break block23;
lbl70:
                        // 1 sources

                        catch (Exception var6_12) {
                            // empty catch block
                        }
                    }
                    this.getProgressBar().setDoneStatus();
                    return;
                }
                var5_7 = null;
                ** try [egrp 2[TRYBLOCK] [10 : 119->128)] { 
lbl78:
                // 1 sources

                var1_1.close();
                break block24;
lbl80:
                // 1 sources

                catch (Exception var6_13) {
                    // empty catch block
                }
            }
            this.getProgressBar().setDoneStatus();
        }
    }

    class TargetValuesThread
    extends LongRunningProcess {
        TargetValuesThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block27: {
                block22: {
                    block26: {
                        block21: {
                            block25: {
                                block20: {
                                    var1_1 = null;
                                    var2_2 = (TestActivityWizardState)DataSourceState.this.getparentWizardState();
                                    if (this.getProgressBar().hasUserCancelled()) {
                                        return;
                                    }
                                    var3_3 = (ChooseBuildActivityState)var2_2.getStep(ActivityStepType.ACTIVITY_STEP);
                                    var4_4 = null;
                                    var5_5 = var3_3.getMiningModel();
                                    if (this.getProgressBar().hasUserCancelled()) {
                                        return;
                                    }
                                    if (var5_5 instanceof ClassificationModel) {
                                        var6_6 = (ClassificationModel)var5_5;
                                        var4_4 = var6_6.getTargetAttributeName();
                                    } else if (var5_5 instanceof RegressionModel) {
                                        var6_6 = (RegressionModel)var5_5;
                                        var4_4 = var6_6.getTargetAttributeName();
                                    }
                                    var6_6 = DataSourceState.this.getSelectedSchemaName();
                                    var7_7 = DataSourceState.this.getSelectedTableName();
                                    if (this.getProgressBar().hasUserCancelled()) {
                                        return;
                                    }
                                    try {
                                        try {
                                            var1_1 = DM4JConnectionManager.getConnection();
                                            if (this.getProgressBar().hasUserCancelled()) {
                                                var11_8 = null;
                                                break block20;
                                            }
                                            var8_18 = new TargetValueDataSource(var1_1, (String)var6_6, var7_7, var4_4);
                                            var8_18.run();
                                            if (this.getProgressBar().hasUserCancelled()) {
                                                break block21;
                                            }
                                            if (var8_18.getException() != null) {
                                                throw var8_18.getException();
                                            }
                                            var9_20 = (TargetValueState)DataSourceState.this.getparentWizardState().getStep(ActivityStepType.TARGET_VALUE_STEP);
                                            var9_20.setTargetValues(var8_18);
                                            break block22;
                                        }
                                        catch (Exception var8_19) {
                                            this.setException(var8_19);
                                            var11_11 = null;
                                            try {
                                                var1_1.close();
                                            }
                                            catch (Exception var12_16) {
                                                // empty catch block
                                            }
                                            this.getProgressBar().setDoneStatus();
                                            return;
                                        }
                                    }
                                    catch (Throwable var10_21) {
                                        block24: {
                                            var11_12 = null;
                                            ** try [egrp 2[TRYBLOCK] [8 : 257->266)] { 
lbl54:
                                            // 1 sources

                                            var1_1.close();
                                            break block24;
lbl56:
                                            // 1 sources

                                            catch (Exception var12_17) {
                                                // empty catch block
                                            }
                                        }
                                        this.getProgressBar().setDoneStatus();
                                        throw var10_21;
                                    }
                                }
                                ** try [egrp 2[TRYBLOCK] [8 : 257->266)] { 
lbl63:
                                // 1 sources

                                var1_1.close();
                                break block25;
lbl65:
                                // 1 sources

                                catch (Exception var12_13) {
                                    // empty catch block
                                }
                            }
                            this.getProgressBar().setDoneStatus();
                            return;
                        }
                        var11_9 = null;
                        ** try [egrp 2[TRYBLOCK] [8 : 257->266)] { 
lbl73:
                        // 1 sources

                        var1_1.close();
                        break block26;
lbl75:
                        // 1 sources

                        catch (Exception var12_14) {
                            // empty catch block
                        }
                    }
                    this.getProgressBar().setDoneStatus();
                    return;
                }
                var11_10 = null;
                ** try [egrp 2[TRYBLOCK] [8 : 257->266)] { 
lbl83:
                // 1 sources

                var1_1.close();
                break block27;
lbl85:
                // 1 sources

                catch (Exception var12_15) {
                    // empty catch block
                }
            }
            this.getProgressBar().setDoneStatus();
        }
    }

    class DataSourceLoadThread
    extends LongRunningProcess {
        DataSourceLoadThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    DataSourceState.this.loadSchemaNames();
                    DataSourceState.this.loadDefaultSelectedSchemaName();
                    DataSourceState.this.loadDefaultSelectedTableName();
                    DataSourceState.this.loadColumnsDataSource(null);
                }
                catch (Exception exception) {
                    this.setException(exception);
                    Object var3_2 = null;
                    this.getProgressBar().setDoneStatus();
                }
                Object var3_1 = null;
                this.getProgressBar().setDoneStatus();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.getProgressBar().setDoneStatus();
                throw throwable;
            }
        }
    }
}

