/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.util.Vector;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.datamining.supervised.regression.RegressionModel;
import javax.swing.JOptionPane;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JUserHasCanceledException;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.BuildStep;
import oracle.dmt.dm4j.activity.wizard.state.ApplyActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.state.ApplyCostMatrixState;
import oracle.dmt.dm4j.activity.wizard.state.TestActivityWizardState;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.validation.ChooseBuildActivityStateError;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionModel;
import oracle.dmt.jdm.supervised.classification.OraClassificationModel;

public class ChooseBuildActivityState
extends WizardStepState {
    private AbstractActivity _buildActivity;
    private MiningObject _miningModel;
    private boolean _sourceIsActivity;
    private String _miningModelName = null;
    private String _miningModelSignature = null;
    private String _buildActivityName = null;
    private LeafNodeData _leafNodeData = null;
    private boolean m_hidePage = true;

    public ChooseBuildActivityState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public ChooseBuildActivityState(WizardState wizardState, String string, StepType stepType, boolean bl) {
        super(wizardState, string, stepType);
        this.m_hidePage = bl;
    }

    public void clearSourceName() {
        this._buildActivityName = null;
        this._miningModelName = null;
        this._miningModelSignature = null;
    }

    public AbstractActivity getBuildActivity() {
        return this._buildActivity;
    }

    public String getBuildActivityName() {
        return this._buildActivityName;
    }

    public MiningObject getMiningModel() {
        return this._miningModel;
    }

    public String getMiningModelName() {
        return this._miningModelName;
    }

    public String getMiningModelSignature() {
        return this._miningModelSignature;
    }

    public boolean getSourceIsActivity() {
        return this._sourceIsActivity;
    }

    public void setSourceName(String string, boolean bl) {
        this._sourceIsActivity = bl;
        if (bl) {
            this._buildActivityName = string;
            this._miningModelName = null;
        } else {
            this._buildActivityName = null;
            this._miningModelName = string;
        }
        this.setState(StepStateType.DIRTY);
    }

    public void validate(Vector vector) throws Exception {
        if (vector.isEmpty()) {
            this.validateSelection(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void validateSelection(final Vector vector) throws Exception {
        if (this._buildActivityName == null && this._miningModelName == null) {
            try {
                vector.add(new StateValidation(ChooseBuildActivityStateError.SOURCE_SELECTION_EMPTY));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        if (this._sourceIsActivity) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LoadDataSourceThread
            extends LongRunningProcess {
                LoadDataSourceThread() {
                }

                @Override
                public void run() {
                    try {
                        this.getProgressBar().updateProgress("", "Getting build activity details");
                        ChooseBuildActivityState.this._buildActivity = AbstractActivity.restore(ChooseBuildActivityState.this._buildActivityName);
                        BuildStep buildStep = ChooseBuildActivityState.this._buildActivity.findBuildStep();
                        ChooseBuildActivityState.this._miningModelName = buildStep.getOutputMiningName();
                        ChooseBuildActivityState.this._miningModelSignature = buildStep.getModelSignature();
                        if (!buildStep.getIsComplete() || ChooseBuildActivityState.this._miningModelName == null) {
                            try {
                                vector.add(new StateValidation(ChooseBuildActivityStateError.SOURCE_NO_MODEL_EXISTS));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            this.getProgressBar().setDoneStatus();
                            return;
                        }
                        this.getProgressBar().updateProgress("", "Getting mining model details");
                        Connection connection = DM4JConnectionManager.getConnection();
                        try {
                            ChooseBuildActivityState.this._miningModel = connection.retrieveObject(ChooseBuildActivityState.this._miningModelName, NamedObject.model);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (ChooseBuildActivityState.this._miningModel == null) {
                            try {
                                vector.add(new StateValidation(ChooseBuildActivityStateError.SOURCE_NO_MODEL_EXISTS));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            this.getProgressBar().setDoneStatus();
                            return;
                        }
                        this.getProgressBar().setDoneStatus();
                    }
                    catch (Exception exception) {
                        this.setException(exception);
                        this.getProgressBar().setDoneStatus();
                    }
                }
            }
            LoadDataSourceThread loadDataSourceThread = new LoadDataSourceThread();
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), "Getting Build Activity Detail", loadDataSourceThread, true);
            loadDataSourceThread.setProgressBar(progressBar);
            progressBar.start("", null);
            if (loadDataSourceThread.getException() != null) {
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), "Unable to get Build Activity Detail", DM4JVersion.getFullBrowserName(), 0);
            } else if (progressBar.hasUserCancelled()) {
                throw new DM4JUserHasCanceledException("User canceled load operation.");
            }
            return;
        }
        class LoadDataSourceThread
        extends LongRunningProcess {
            LoadDataSourceThread() {
            }

            public void run() {
                try {
                    Connection connection = DM4JConnectionManager.getConnection();
                    ChooseBuildActivityState.this._miningModel = connection.retrieveObject(ChooseBuildActivityState.this._miningModelName, NamedObject.model);
                    ChooseBuildActivityState.this._miningModelName = ChooseBuildActivityState.this._miningModel.getName();
                    this.getProgressBar().setDoneStatus();
                }
                catch (Exception exception) {
                    this.setException(exception);
                    this.getProgressBar().setDoneStatus();
                }
            }
        }
        LoadDataSourceThread loadDataSourceThread = new LoadDataSourceThread();
        ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), "Getting Model Detail", loadDataSourceThread, true);
        loadDataSourceThread.setProgressBar(progressBar);
        progressBar.start("", null);
        if (loadDataSourceThread.getException() != null) {
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), "Unable to get Model Detail", DM4JVersion.getFullBrowserName(), 0);
        } else if (progressBar.hasUserCancelled()) {
            throw new DM4JUserHasCanceledException("User canceled load operation.");
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
        this.setState(StepStateType.LOADED);
    }

    public void load() throws Exception {
        this.loadDefaults();
        this.setState(StepStateType.LOADED);
    }

    private String getBuildActivityName(LeafNodeData leafNodeData) {
        String string = null;
        if (leafNodeData != null && leafNodeData.isBuildActivityObject()) {
            this._leafNodeData = leafNodeData;
            string = leafNodeData.getName();
        }
        return string;
    }

    public LeafNodeData getDefaultLeafNodeData() {
        return this._leafNodeData;
    }

    public void loadDefaults() {
        String string = null;
        if (this.getparentWizardState() instanceof ApplyActivityWizardState) {
            ApplyActivityWizardState applyActivityWizardState = (ApplyActivityWizardState)this.getparentWizardState();
            if (applyActivityWizardState.getBrowserContext().getLaunchPoint().equals(LaunchPoint.CONTEXT_MENU)) {
                string = applyActivityWizardState.getActivityName();
            } else if (applyActivityWizardState.getBrowserContext().getLaunchPoint().equals(LaunchPoint.MENU)) {
                string = this.getBuildActivityName(applyActivityWizardState.getBrowserContext().getSelectedLeafNode());
            }
        } else if (this.getparentWizardState() instanceof TestActivityWizardState) {
            TestActivityWizardState testActivityWizardState = (TestActivityWizardState)this.getparentWizardState();
            if (testActivityWizardState.getBrowserContext().getLaunchPoint().equals(LaunchPoint.CONTEXT_MENU)) {
                string = testActivityWizardState.getActivityName();
            } else if (testActivityWizardState.getBrowserContext().getLaunchPoint().equals(LaunchPoint.MENU)) {
                string = this.getBuildActivityName(testActivityWizardState.getBrowserContext().getSelectedLeafNode());
            }
        }
        if (string != null && string.length() > 0) {
            this.setSourceName(string, true);
        }
    }

    public boolean postValidate(Vector vector) throws Exception {
        if (this.getparentWizardState() instanceof ApplyActivityWizardState) {
            boolean bl;
            MiningObject miningObject = this.getMiningModel();
            if (miningObject instanceof ClassificationModel) {
                OraClassificationModel oraClassificationModel = (OraClassificationModel)miningObject;
                boolean bl2 = bl = oraClassificationModel.getTargetAttributeName() == null;
                if (!bl) {
                    ApplyCostMatrixState applyCostMatrixState = (ApplyCostMatrixState)this.getparentWizardState().getStep(ActivityStepType.COST_MATRIX_STEP);
                    this.enablePage(applyCostMatrixState.showCostMatrixStep(), ActivityStepType.COST_MATRIX_STEP);
                    this.enablePage(true, ActivityStepType.APPLY_CLASS_OPTION_STEP);
                } else {
                    this.enablePage(false, ActivityStepType.COST_MATRIX_STEP);
                    this.enablePage(false, ActivityStepType.APPLY_CLASS_OPTION_STEP);
                }
            } else {
                this.enablePage(false, ActivityStepType.COST_MATRIX_STEP);
                this.enablePage(false, ActivityStepType.APPLY_CLASS_OPTION_STEP);
            }
            boolean bl3 = miningObject instanceof ClusteringModel;
            this.enablePage(bl3, ActivityStepType.APPLY_CLUST_OPTION_STEP);
            bl = miningObject instanceof OraFeatureExtractionModel;
            this.enablePage(bl, ActivityStepType.APPLY_FEAT_OPTION_STEP);
        } else if (this.getparentWizardState() instanceof TestActivityWizardState) {
            MiningObject miningObject = this.getMiningModel();
            if (miningObject instanceof ClassificationModel) {
                this.enablePage(true, ActivityStepType.TARGET_VALUE_STEP);
            } else if (miningObject instanceof RegressionModel) {
                this.enablePage(false, ActivityStepType.TARGET_VALUE_STEP);
            }
        }
        this.enablePage(this._sourceIsActivity, ActivityStepType.APPLY_TABLES_STEP);
        this.enablePage(!this._sourceIsActivity, ActivityStepType.DATA_STEP);
        return true;
    }

    protected void enablePage(boolean bl, StepType stepType) {
        DM4JWizard dM4JWizard = this.getparentWizardState().getWizard();
        int n = dM4JWizard.getPageCount();
        Class<DM4JPage> clazz = DM4JPage.class;
        DM4JPage dM4JPage = null;
        WizardPage wizardPage = null;
        for (int i = 0; i < n; ++i) {
            wizardPage = dM4JWizard.getPageAt(i);
            if (!clazz.isInstance(wizardPage) || !(dM4JPage = (DM4JPage)wizardPage).getStepType().equals(stepType)) continue;
            dM4JPage.setEnabled(bl);
            dM4JPage.setVisible(bl);
        }
    }
}

