/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.sql.Connection;
import java.util.Vector;
import javax.swing.JOptionPane;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.wizard.validation.BuildActivityNameStateError;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.dialogs.MissingAttributesDialog;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class ActivityState
extends WizardStepState {
    private StringBuffer m_modelType = new StringBuffer(0);
    private StringBuffer m_buildActivity = new StringBuffer(0);
    private Vector m_modelTypes = new Vector();
    private Vector m_buildActivities = new Vector();
    private String m_ctxtActivity = null;
    private String CLASSIFICATION_MODELS;
    private String CLUSTERING_MODELS;
    private String FEATURE_EXTRACTION_MODELS;
    private String REGRESSION_MODELS;

    public ActivityState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.CLASSIFICATION_MODELS = dM4JListResourceBundle.getString("TREE_CLASSIFICATION_MODELS");
        this.CLUSTERING_MODELS = dM4JListResourceBundle.getString("TREE_CLUSTERING_MODELS");
        this.FEATURE_EXTRACTION_MODELS = dM4JListResourceBundle.getString("TREE_FEATURE_EXTRACTION_MODELS");
        this.REGRESSION_MODELS = dM4JListResourceBundle.getString("TREE_REGRESSION_MODELS");
    }

    public void refresh() throws Exception {
        this.loadDefaultSelectedModelType();
    }

    public void load() throws Exception {
        this.loadModelTypes();
        this.loadDefaultSelectedModelType();
    }

    protected void loadModelTypes() throws Exception {
        this.m_modelTypes.add(this.CLASSIFICATION_MODELS);
        this.m_modelTypes.add(this.CLUSTERING_MODELS);
        this.m_modelTypes.add(this.FEATURE_EXTRACTION_MODELS);
        this.m_modelTypes.add(this.REGRESSION_MODELS);
    }

    protected void loadDefaultSelectedModelType() throws Exception {
        if (this.m_modelTypes.isEmpty()) {
            return;
        }
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        LeafNodeData leafNodeData = browserContext.getSelectedLeafNode();
        if (leafNodeData != null) {
            String string = leafNodeData.getNodeType();
            if (string.compareTo("CLASSIFICATION_ACTIVITY") == 0) {
                this.m_ctxtActivity = leafNodeData.getName();
                this.setSelectedModelType(this.CLASSIFICATION_MODELS);
            } else if (string.compareTo("CLUSTERING_ACTIVITY") == 0) {
                this.m_ctxtActivity = leafNodeData.getName();
                this.setSelectedModelType(this.CLUSTERING_MODELS);
            } else if (string.compareTo("REGRESSION_ACTIVITY") == 0) {
                this.m_ctxtActivity = leafNodeData.getName();
                this.setSelectedModelType(this.REGRESSION_MODELS);
            } else if (string.compareTo("FEATURE_EXTRACTION_ACTIVITY") == 0) {
                this.m_ctxtActivity = leafNodeData.getName();
                this.setSelectedModelType(this.FEATURE_EXTRACTION_MODELS);
            } else {
                this.setSelectedModelType((String)this.m_modelTypes.get(0));
            }
        } else {
            this.setSelectedModelType((String)this.m_modelTypes.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBuildActivities() throws Exception {
        Connection connection = null;
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        String[] stringArray = null;
        try {
            ActivityType[] activityTypeArray;
            connection = DM4JConnectionManager.getDbConnection();
            if (this.getSelectedModelType().equals(dM4JListResourceBundle.getString("TREE_CLASSIFICATION_MODELS"))) {
                activityTypeArray = new ActivityType[]{ActivityType.ADAPTIVE_NAIVE_BAYES, ActivityType.NAIVE_BAYES, ActivityType.SVM_CLASSIFICATION, ActivityType.GLM_CLASSIFICATION};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
            } else if (this.getSelectedModelType().equals(dM4JListResourceBundle.getString("TREE_REGRESSION_MODELS"))) {
                activityTypeArray = new ActivityType[]{ActivityType.SVM_REGRESSION, ActivityType.GLM_REGRESSION};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
            } else if (this.getSelectedModelType().equals(dM4JListResourceBundle.getString("TREE_FEATURE_EXTRACTION_MODELS"))) {
                activityTypeArray = new ActivityType[]{ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
            } else if (this.getSelectedModelType().equals(dM4JListResourceBundle.getString("TREE_CLUSTERING_MODELS"))) {
                activityTypeArray = new ActivityType[]{ActivityType.K_MEANS_CLUSTER, ActivityType.O_CLUSTER};
                stringArray = AbstractActivity.getNames(connection, activityTypeArray);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        this.m_buildActivities.setSize(0);
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_buildActivities.add(stringArray[i]);
        }
    }

    protected void loadDefaultSelectedBuildActivity() throws Exception {
        if (this.m_buildActivities.isEmpty()) {
            this.setSelectedBuildActivity("");
            return;
        }
        if (this.m_ctxtActivity != null) {
            this.setSelectedBuildActivity(this.m_ctxtActivity);
            this.m_ctxtActivity = null;
        } else {
            this.setSelectedBuildActivity((String)this.m_buildActivities.get(0));
        }
    }

    public Vector getModelTypes() {
        return this.m_modelTypes;
    }

    public Vector getBuildActivities() {
        return this.m_buildActivities;
    }

    public String getSelectedModelType() {
        return this.m_modelType.toString();
    }

    public void setSelectedModelType(String string) {
        try {
            String string2;
            if (string != null && !string.equals(string2 = this.m_modelType.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_modelType.setLength(0);
                this.m_modelType.append(string);
                this.loadBuildActivities();
                this.loadDefaultSelectedBuildActivity();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSelectedBuildActivity() {
        return this.m_buildActivity.toString();
    }

    public void setSelectedBuildActivity(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_buildActivity.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_buildActivity.setLength(0);
            this.m_buildActivity.append(string);
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateBuildActivityName(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void validateBuildActivityName(Vector vector) throws Exception {
        String string = this.getSelectedBuildActivity();
        if (string == null) {
            vector.add(new StateValidation(BuildActivityNameStateError.BUILD_ACTIVITY_NAME_EMPTY));
        }
        if (string.length() == 0) {
            vector.add(new StateValidation(BuildActivityNameStateError.BUILD_ACTIVITY_NAME_EMPTY));
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        String string = this.getSelectedBuildActivity();
        String string2 = this.getSelectedModelType();
        class ValidateApplyDataToModelThread
        extends LongRunningProcess {
            LDSDataSource m_modelLDS = null;
            Vector m_missingAttributes = null;
            boolean m_success = true;

            ValidateApplyDataToModelThread() {
            }

            public void run() {
                Object var1_1 = null;
            }

            boolean getSuccess() {
                return this.m_success;
            }

            LDSDataSource getModelLDSDataSource() {
                return this.m_modelLDS;
            }

            Vector getMissingAttributes() {
                return this.m_missingAttributes;
            }
        }
        ValidateApplyDataToModelThread validateApplyDataToModelThread = new ValidateApplyDataToModelThread();
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), dM4JListResourceBundle.getString("ACTIVITY_DATA_VALIDATION"), validateApplyDataToModelThread, true);
        validateApplyDataToModelThread.setProgressBar(progressBar);
        progressBar.start(dM4JListResourceBundle.getString("ACTIVITY_VALIDATE_APPLY_DATA"), null);
        Exception exception = validateApplyDataToModelThread.getException();
        if (exception != null) {
            class ModelNotBuiltException
            extends Exception {
                ModelNotBuiltException() {
                }
            }
            if (exception instanceof ModelNotBuiltException) {
                DM4JListResourceBundle dM4JListResourceBundle2 = BrowserUtils.getActivityBundleInstance();
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), dM4JListResourceBundle2.getString("MODEL_NOT_BUILT"), DM4JVersion.getFullBrowserName(), 0);
                bl = false;
                this.setState(StepStateType.DIRTY);
            } else {
                this.getparentWizardState().doAbortCancel(validateApplyDataToModelThread.getException());
            }
        } else if (progressBar.hasUserCancelled()) {
            bl = false;
            this.setState(StepStateType.DIRTY);
        } else if (!validateApplyDataToModelThread.getSuccess()) {
            LDSDataSource lDSDataSource = validateApplyDataToModelThread.getModelLDSDataSource();
            Vector vector2 = validateApplyDataToModelThread.getMissingAttributes();
            MissingAttributesDialog missingAttributesDialog = new MissingAttributesDialog(this.getparentWizardState().getDialog(), lDSDataSource, vector2);
            bl = false;
            this.setState(StepStateType.DIRTY);
        }
        return bl;
    }
}

