/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.wizard.state;

import java.util.Vector;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.wizard.BuildActivityWizard;
import oracle.dmt.dm4j.activity.wizard.state.DataSourceState;
import oracle.dmt.dm4j.activity.wizard.state.ModelState;
import oracle.dmt.dm4j.activity.wizard.steps.ARMappingCaseIDPage;
import oracle.dmt.dm4j.activity.wizard.steps.ActivityStepType;
import oracle.dmt.dm4j.activity.wizard.steps.DataUsagePage;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TableColumnsModel;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class ARDataSourceState
extends DataSourceState {
    private boolean m_bLookupTable = false;
    private Column m_ItemID;
    private String m_lookupTableName;
    private String m_lookupSchemaName;
    private String m_lookupItemName;
    private String m_lookupItemDescription;
    private Vector m_lookupSchemaNames = new Vector();
    private Vector m_lookupTableNames = new Vector();
    private TableColumnsModel m_lookupcolumnModel;
    private Table m_txData;

    public ARDataSourceState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public boolean isLookupTable() {
        return this.m_bLookupTable;
    }

    public void setUseLookupTable(boolean bl) {
        this.m_bLookupTable = bl;
    }

    public void setItemID(Column column) {
        this.m_ItemID = column;
    }

    public Column getItemID() {
        return this.m_ItemID;
    }

    public String getLookupTableName() {
        return this.m_lookupTableName;
    }

    public void setLookupTableName(String string) throws Exception {
        this.m_lookupTableName = string;
        this.loadLookupColumnNames();
        if (this.getState() == StepStateType.VALIDATED) {
            this.setState(StepStateType.DIRTY);
        }
    }

    public String getLookupItemName() {
        return this.m_lookupItemName;
    }

    public void setLookupItemName(String string) {
        this.m_lookupItemName = string;
    }

    public String getLookupItemDesciption() {
        return this.m_lookupItemDescription;
    }

    public void setLookupItemDesciption(String string) {
        this.m_lookupItemDescription = string;
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
    }

    public boolean postValidate(Vector vector) throws Exception {
        BuildActivityWizard buildActivityWizard = (BuildActivityWizard)this.getparentWizardState().getWizard();
        ModelState modelState = (ModelState)this.getparentWizardState().getStep(ActivityStepType.MODEL_STEP);
        ActivityType activityType = modelState.getActivityType();
        if (activityType == ActivityType.ASSOCIATION_RULES) {
            DataUsagePage dataUsagePage = buildActivityWizard.getDataUsagePage();
            dataUsagePage.setEnabled(false);
            dataUsagePage.setVisible(false);
            ARMappingCaseIDPage aRMappingCaseIDPage = buildActivityWizard.getARMappingCaseIDPage();
            aRMappingCaseIDPage.load();
        }
        return true;
    }

    public void setSelectedLookupSchemaName(String string) throws Exception {
        if (!(string == null || this.m_lookupSchemaName != null && string.equals(this.m_lookupSchemaName))) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_lookupSchemaName = string;
            this.loadLookupTableNames();
        }
    }

    protected void loadDefaultSelectedLookupSchemaName() throws Exception {
        if (this.m_lookupSchemaNames.isEmpty()) {
            return;
        }
        this.setSelectedLookupSchemaName(this.getSelectedSchemaName());
    }

    public void loadDefaultSelectedLookupTableName() throws Exception {
        if (this.m_lookupTableNames != null && !this.m_lookupTableNames.isEmpty()) {
            String string = (String)this.m_lookupTableNames.elementAt(0);
            if (this.m_lookupTableName == null || !this.m_lookupTableName.equals(string)) {
                this.setLookupTableName(string);
            }
        }
    }

    public void refresh() throws Exception {
        super.refresh();
        this.loadLookupSchemaNames();
        this.loadDefaultSelectedLookupSchemaName();
        this.loadDefaultSelectedLookupTableName();
    }

    public void load() throws Exception {
        super.load();
        this.loadLookupSchemaNames();
        this.loadDefaultSelectedLookupSchemaName();
        this.loadDefaultSelectedLookupTableName();
    }

    protected void loadLookupSchemaNames() throws Exception {
        this.m_lookupSchemaNames = DatabaseMetadata.getAccessibleSchemas(this.getparentWizardState().getConnection());
    }

    public Vector getLookupSchemaNames() {
        return this.m_lookupSchemaNames;
    }

    public void loadLookupColumnNames() throws Exception {
        this.m_lookupcolumnModel = new TableColumnsModel(this.getparentWizardState().getConnection(), this.m_lookupSchemaName, this.m_lookupTableName);
    }

    protected void loadLookupTableNames() throws Exception {
        this.m_lookupTableNames = DatabaseMetadata.getAccessableTablesAndViews(this.getparentWizardState().getConnection(), this.m_lookupSchemaName);
    }

    public String getLookupSchemaName() {
        return this.m_lookupSchemaName;
    }

    public void setLookupSchemaName(String string) throws Exception {
        this.m_lookupSchemaName = string;
        this.loadLookupTableNames();
    }

    public TableColumnsModel getLookupColumnsModel() {
        return this.m_lookupcolumnModel;
    }

    public Vector getLookupTables() {
        return this.m_lookupTableNames;
    }

    public void setTxData(Table table) {
        this.m_txData = table;
    }

    public Table getTxData() {
        return this.m_txData;
    }
}

