/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.task;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.task.ActivityTask;
import oracle.dmt.dm4j.browser.UserPreferences;

public class ActivityTaskManager {
    private static ActivityTaskManager _instance = null;
    private Map _threads = Collections.synchronizedMap(new CustomLinkedHashMap());

    private ActivityTaskManager() {
    }

    public static ActivityTaskManager getInstance() {
        if (_instance == null) {
            _instance = new ActivityTaskManager();
        }
        return _instance;
    }

    public boolean isRunningTasks() {
        Vector vector = this.getTasks();
        for (ActivityTask activityTask : vector) {
            if (!activityTask.getIsRunning()) continue;
            return true;
        }
        return false;
    }

    public Vector getRunningTasks() {
        Vector vector = this.getTasks();
        Vector<ActivityTask> vector2 = new Vector<ActivityTask>();
        for (ActivityTask activityTask : vector) {
            if (!activityTask.getIsRunning()) continue;
            vector2.add(activityTask);
        }
        return vector2;
    }

    public Vector getTasks() {
        Vector<ActivityTask> vector = new Vector<ActivityTask>();
        Set set = this._threads.entrySet();
        for (Map.Entry entry : set) {
            ActivityTask activityTask = (ActivityTask)entry.getValue();
            vector.add(activityTask);
        }
        return vector;
    }

    public ActivityTask getTask(AbstractActivity abstractActivity) {
        return (ActivityTask)this._threads.get(abstractActivity.getName());
    }

    public ActivityTask getTask(String string) {
        return (ActivityTask)this._threads.get(string);
    }

    public void start(AbstractActivity abstractActivity) {
        ActivityTask activityTask = new ActivityTask(abstractActivity);
        this._threads.remove(abstractActivity.getName());
        this._threads.put(abstractActivity.getName(), activityTask);
        activityTask.start();
    }

    public int getTaskProgress(String string) {
        ActivityTask activityTask = this.getTask(string);
        return activityTask.getProgress();
    }

    public void stop(String string) {
        ActivityTask activityTask = this.getTask(string);
        activityTask.interrupt();
    }

    public boolean remove(String string) {
        ActivityTask activityTask = this.getTask(string);
        if (activityTask.getIsRunning()) {
            return false;
        }
        this._threads.remove(string);
        return true;
    }

    class CustomLinkedHashMap
    extends LinkedHashMap {
        CustomLinkedHashMap() {
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            ActivityTask activityTask = (ActivityTask)entry.getValue();
            if (!activityTask.getHasRun()) {
                return false;
            }
            Date date = activityTask.getEndTimeStamp();
            Calendar calendar = Calendar.getInstance();
            UserPreferences userPreferences = UserPreferences.getInstance();
            int n = userPreferences.getFinishedTasksAge();
            calendar.add(12, n);
            Date date2 = calendar.getTime();
            return date.compareTo(date2) > 0;
        }
    }
}

