/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.task;

import java.awt.Component;
import java.util.Date;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.steps.AbstractMiningStep;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.activity.steps.AbstractTransformationStep;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.SwingWorkerBasic;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityStepPanel;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityViewer;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.resource.OraConnection;

public class ActivityTask
extends SwingWorkerBasic {
    private AbstractActivity _activity;
    private int _state;
    private Date _endTimeStamp;
    private int _beginIndex;
    private int _stepsToRunCount;
    private int _stepsAlreadyRun;
    private int _lastStepRun;
    private Object _syncObj = new Object();
    public static final int IDLE = 2;
    public static final int STARTING = 4;
    public static final int RUNNING = 8;
    public static final int CANCELLING = 16;
    public static final int CANCELLED = 32;
    public static final int FINISHED = 64;
    public static final int FAILED = 128;

    public ActivityTask(AbstractActivity abstractActivity) {
        this._activity = abstractActivity;
        this.setState(12);
        this._stepsAlreadyRun = 0;
        this._lastStepRun = -1;
        this._endTimeStamp = null;
        AbstractStep abstractStep = this._activity.findLastCompletedStep();
        this._beginIndex = abstractStep == null ? 0 : this._activity.findStepIndex(abstractStep) + 1;
        int n = this._activity.getSteps().size();
        for (int i = this._beginIndex; i < n; ++i) {
            AbstractStep abstractStep2 = this._activity.getStep(i);
            if (!abstractStep2.getIsEnabled()) continue;
            ++this._stepsToRunCount;
        }
    }

    public void interrupt() {
        super.interrupt();
        this.setState(24);
    }

    public Object construct() {
        Thread.currentThread().setName("DMR$ActivityTask: " + this._activity.getName());
        this.setState(8);
        return this.runSteps();
    }

    public void finished() {
        boolean bl = (Boolean)this.getValue();
        if (!bl) {
            this.setState(130);
        } else if (this.isState(16)) {
            this.setState(34);
        } else {
            this.setState(66);
        }
        this._endTimeStamp = new Date();
    }

    private boolean runSteps() {
        int n = this._activity.getSteps().size();
        for (int i = this._beginIndex; i < n; ++i) {
            AbstractStep abstractStep = this._activity.getStep(i);
            if (!abstractStep.getIsEnabled()) {
                this.updateUI(abstractStep, ActivityStepPanel.SKIPPED);
                continue;
            }
            if (Thread.currentThread().isInterrupted() || this.isState(16)) {
                this.interrupt();
                return true;
            }
            this.updateUI(abstractStep, ActivityStepPanel.RUNNING);
            boolean bl = abstractStep.launchWizard(this._activity, false);
            if (bl) {
                if (abstractStep instanceof AbstractMiningStep) {
                    this.updateUI(abstractStep, ActivityStepPanel.RUNNING);
                    if (!this.waitForTaskToFinish((AbstractMiningStep)abstractStep)) {
                        return false;
                    }
                }
                if (abstractStep instanceof AbstractTransformationStep) {
                    this.updateUI(abstractStep, ActivityStepPanel.COMPLETE);
                }
            } else {
                this.setLastStepRun(i);
                this.updateUI(abstractStep, ActivityStepPanel.FAILED);
                return false;
            }
            this.setLastStepRun(i);
            ++this._stepsAlreadyRun;
        }
        return true;
    }

    private void updateUI(AbstractStep abstractStep, int n) {
        Component component = BrowserFrame.getMainFrame().getViewerComponent();
        if (component instanceof ActivityViewer) {
            ActivityViewer activityViewer = (ActivityViewer)component;
            if (!activityViewer.getActivity().getName().equals(this._activity.getName())) {
                return;
            }
            ActivityStepPanel activityStepPanel = activityViewer.getStepPanelFor(abstractStep);
            activityStepPanel.updateStatus(n);
            if (abstractStep instanceof AbstractMiningStep && n != ActivityStepPanel.SKIPPED) {
                activityStepPanel.startAsyncStepMonitor((AbstractMiningStep)abstractStep);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForTaskToFinish(AbstractMiningStep var1_1) {
        var2_2 = false;
        if (var1_1.getOutputMiningName() == null) return false;
        if (var1_1.getOutputMiningName().length() == 0) {
            return false;
        }
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        try {
            block26: {
                block28: {
                    block27: {
                        block25: {
                            block24: {
                                if (!Thread.currentThread().isInterrupted()) break block24;
                                var6_6 = true;
                                var13_9 = null;
                                if (var4_4 == null) return var6_6;
                                ** GOTO lbl98
                            }
                            var4_4 = (OraConnection)DM4JConnectionManager.getConnection();
                            var3_3 = var4_4.getDatabaseConnection();
                            var5_5 = DMEMetadata.getInstance();
                            var6_7 = ActivityUtils.mapStepToTaskType(var1_1);
                            var7_25 = var1_1.getOutputMiningName();
                            if (!Thread.currentThread().isInterrupted()) break block25;
                            var8_26 = true;
                            ** GOTO lbl104
                        }
                        var8_27 = false;
                        var9_28 = null;
                        var9_28 = var5_5.getTaskNameForMiningObject(var3_3, var6_7, var7_25);
                        if (null != var9_28) {
                            var8_27 = true;
                        } else {
                            System.out.println("Did not find task name for mining object: " + var7_25);
                            System.out.println("Waiting for 20 seconds for task");
                            Thread.sleep(20000L);
                            var9_28 = var5_5.getTaskNameForMiningObject(var3_3, var6_7, var7_25);
                            if (var9_28 != null) {
                                var8_27 = true;
                            }
                        }
                        if (!var8_27) break block26;
                        if (!Thread.currentThread().isInterrupted()) break block27;
                        var10_29 = true;
                        ** GOTO lbl112
                    }
                    if (!var5_5.isTaskSuccessful(var3_3, var9_28)) break block28;
                    var10_30 = true;
                    ** GOTO lbl120
                }
                while (var5_5.isTaskRunning(var3_3, var9_28)) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException var10_31) {
                        var11_32 = true;
                        var13_13 = null;
                        if (var4_4 == null) return var11_32;
                        try {
                            var4_4.close();
                            return var11_32;
                        }
                        catch (Exception var14_21) {
                            var14_21.printStackTrace();
                        }
                        return var11_32;
                    }
                }
                var2_2 = var5_5.isTaskSuccessful(var3_3, var9_28);
                if (!var2_2) {
                    System.out.println("isTaskSuccessful returned false: Task name: " + var9_28);
                    System.out.println("Waiting for 5 seconds before checking again");
                    Thread.sleep(5000L);
                    var2_2 = var5_5.isTaskSuccessful(var3_3, var9_28);
                }
            }
            if (!var2_2) {
                var2_2 = ActivityUtils.miningObjectExists(var4_4, var1_1, var7_25);
            }
            if (!var2_2) {
                System.out.println("ActivityUtils.miningObjectExists returned false. MiningName: " + var7_25);
            }
            ** GOTO lbl128
        }
        catch (Exception var6_8) {
            var6_8.printStackTrace();
            var13_15 = null;
            if (var4_4 == null) return var2_2;
            try {}
            catch (Exception var14_23) {
                var14_23.printStackTrace();
                return var2_2;
            }
            var4_4.close();
            return var2_2;
        }
        {
            catch (Throwable var12_33) {
                var13_16 = null;
                if (var4_4 == null) throw var12_33;
                ** try [egrp 3[TRYBLOCK] [15 : 399->407)] { 
lbl93:
                // 1 sources

                var4_4.close();
                throw var12_33;
lbl95:
                // 1 sources

                catch (Exception var14_24) {
                    var14_24.printStackTrace();
                }
                throw var12_33;
            }
lbl98:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [15 : 399->407)] { 
lbl99:
            // 1 sources

            var4_4.close();
            return var6_6;
lbl101:
            // 1 sources

            catch (Exception var14_17) {
                var14_17.printStackTrace();
            }
            return var6_6;
lbl104:
            // 1 sources

            var13_10 = null;
            if (var4_4 == null) return var8_26;
            ** try [egrp 3[TRYBLOCK] [15 : 399->407)] { 
lbl107:
            // 1 sources

            var4_4.close();
            return var8_26;
lbl109:
            // 1 sources

            catch (Exception var14_18) {
                var14_18.printStackTrace();
            }
            return var8_26;
lbl112:
            // 1 sources

            var13_11 = null;
            if (var4_4 == null) return var10_29;
            ** try [egrp 3[TRYBLOCK] [15 : 399->407)] { 
lbl115:
            // 1 sources

            var4_4.close();
            return var10_29;
lbl117:
            // 1 sources

            catch (Exception var14_19) {
                var14_19.printStackTrace();
            }
            return var10_29;
lbl120:
            // 1 sources

            var13_12 = null;
            if (var4_4 == null) return var10_30;
            ** try [egrp 3[TRYBLOCK] [15 : 399->407)] { 
lbl123:
            // 1 sources

            var4_4.close();
            return var10_30;
lbl125:
            // 1 sources

            catch (Exception var14_20) {
                var14_20.printStackTrace();
            }
            return var10_30;
lbl128:
            // 1 sources

            var13_14 = null;
            if (var4_4 == null) return var2_2;
            try {}
            catch (Exception var14_22) {}
            var14_22.printStackTrace();
            return var2_2;
            var4_4.close();
            return var2_2;
        }
    }

    public AbstractActivity getActivity() {
        return this._activity;
    }

    public String getName() {
        return this._activity.getName();
    }

    public String toString() {
        return this.getName();
    }

    public String getStateString() {
        if (this.isState(4)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_STARTING");
        }
        if (this.isState(16)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_CANCELLING");
        }
        if (this.isState(32)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_CANCELLED");
        }
        if (this.isState(8)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_RUNNING");
        }
        if (this.isState(64)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_SUCCESS");
        }
        if (this.isState(128)) {
            return DM4JResourceUtilities.getActivityUIString("ACTIVITY_ERROR");
        }
        new Exception("Inconsistent activity task state!").printStackTrace();
        return DM4JResourceUtilities.getActivityUIString("ACTIVITY_ERROR");
    }

    public boolean getHasRun() {
        return this.isState(32) || this.isState(64) || this.isState(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsRunning() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsIdle() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsStarting() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsCancelling() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsCancelled() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsSuccessful() {
        Object object = this._syncObj;
        synchronized (object) {
            return this.isState(64);
        }
    }

    private boolean isState(int n) {
        return (this._state & n) == n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int n) {
        Object object = this._syncObj;
        synchronized (object) {
            this._state = n;
        }
    }

    public Date getEndTimeStamp() {
        return this._endTimeStamp;
    }

    public int getLastStepRun() {
        return this._lastStepRun;
    }

    private void setLastStepRun(int n) {
        this._lastStepRun = n;
    }

    public int getProgress() {
        if (this._stepsToRunCount == 0) {
            return 100;
        }
        if (this._stepsAlreadyRun == 0) {
            return 0;
        }
        return 100 / this._stepsToRunCount * this._stepsAlreadyRun;
    }

    public int getStepsToRun() {
        return this._stepsToRunCount;
    }

    public int getStepsCompleted() {
        return this._stepsAlreadyRun;
    }
}

