/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.transformsteps.SplitSettingsStateError;

public class SplitStepOptions
extends AbstractStepOptions {
    private ActivityType at;
    private int caseCount;
    private boolean createTable = true;
    private Integer buildTablePercentage = new Integer(60);
    private Integer testTablePercentage = new Integer(40);
    private boolean randomizeBeforeSplit = true;
    private boolean stratifiedSplit = false;

    public SplitStepOptions() {
    }

    public SplitStepOptions(SplitStepOptions splitStepOptions) {
        this.init(splitStepOptions.getActivityType(), splitStepOptions.getCaseCount(), splitStepOptions.isCreateTable(), splitStepOptions.getBuildTablePercentage(), splitStepOptions.getTestTablePercentage(), splitStepOptions.isRandomizeBeforeSplit(), splitStepOptions.isStratifiedSplit());
    }

    public void init(ActivityType activityType) {
        boolean bl = activityType == ActivityType.NAIVE_BAYES || activityType == ActivityType.DECISION_TREE || activityType == ActivityType.ADAPTIVE_NAIVE_BAYES || activityType == ActivityType.GLM_CLASSIFICATION || activityType == ActivityType.SVM_CLASSIFICATION;
        if (this.caseCount > 10000) {
            this.init(activityType, this.caseCount, true, new Integer("50"), new Integer("50"), true, bl);
        } else {
            this.init(activityType, this.caseCount, true, new Integer("60"), new Integer("40"), true, bl);
        }
    }

    private void init(ActivityType activityType, int n, boolean bl, Integer n2, Integer n3, boolean bl2, boolean bl3) {
        this.at = activityType;
        this.caseCount = n;
        this.createTable = bl;
        this.buildTablePercentage = n2;
        this.testTablePercentage = n3;
        this.randomizeBeforeSplit = bl2;
        this.stratifiedSplit = bl3;
    }

    public void restoreSettings(SplitStepOptions splitStepOptions) {
        this.setActivityType(splitStepOptions.getActivityType());
        this.setCaseCount(splitStepOptions.getCaseCount());
        this.setCreateTable(splitStepOptions.isCreateTable());
        this.setBuildTablePercentage(splitStepOptions.getBuildTablePercentage());
        this.setTestTablePercentage(splitStepOptions.getTestTablePercentage());
        this.setRandomizeBeforeSplit(splitStepOptions.isRandomizeBeforeSplit());
        this.setStratifiedSplit(splitStepOptions.isStratifiedSplit());
    }

    public void setActivityType(ActivityType activityType) {
        this.at = activityType;
    }

    public ActivityType getActivityType() {
        return this.at;
    }

    public void setStratifiedSplit(boolean bl) {
        this.stratifiedSplit = bl;
    }

    public boolean isStratifiedSplit() {
        return this.stratifiedSplit;
    }

    public void setCaseCount(int n) {
        this.caseCount = n;
    }

    public int getCaseCount() {
        return this.caseCount;
    }

    public void setCreateTable(boolean bl) {
        this.createTable = bl;
    }

    public boolean isCreateTable() {
        return this.createTable;
    }

    public void setBuildTablePercentage(Integer n) {
        this.buildTablePercentage = n;
    }

    public Integer getBuildTablePercentage() {
        return this.buildTablePercentage;
    }

    public void setTestTablePercentage(Integer n) {
        this.testTablePercentage = n;
    }

    public Integer getTestTablePercentage() {
        return this.testTablePercentage;
    }

    public void setRandomizeBeforeSplit(boolean bl) {
        this.randomizeBeforeSplit = bl;
    }

    public boolean isRandomizeBeforeSplit() {
        return this.randomizeBeforeSplit;
    }

    public void validate(Vector vector) throws Exception {
        String string;
        int n = 0;
        int n2 = 0;
        if (this.buildTablePercentage == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            vector.add(new StateValidation(SplitSettingsStateError.SPLIT_BUILD_INVALID_PERCENTAGE));
        }
        if (this.testTablePercentage == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            vector.add(new StateValidation(SplitSettingsStateError.SPLIT_BUILD_INVALID_PERCENTAGE));
        }
        try {
            n = this.buildTablePercentage;
            if (n <= 0 || n >= 100) {
                vector.add(new StateValidation(SplitSettingsStateError.SPLIT_BUILD_INVALID_PERCENTAGE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(SplitSettingsStateError.SPLIT_BUILD_INVALID_PERCENTAGE));
        }
        try {
            n2 = this.testTablePercentage;
            if (n2 <= 0 || n2 >= 100) {
                vector.add(new StateValidation(SplitSettingsStateError.SPLIT_TEST_INVALID_PERCENTAGE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(SplitSettingsStateError.SPLIT_TEST_INVALID_PERCENTAGE));
        }
    }
}

