/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.transformsteps.SampleSettingsStateError;

public class SampleStepOptions
extends AbstractStepOptions {
    private ActivityType at;
    private int caseCount;
    private boolean randomSampling;
    private boolean createTable;
    private boolean sampleByNumberOfCases;
    private Long sampleNumOfCases = null;
    private Double samplePercentage = null;
    private Integer randomSeed = new Integer(12345);
    private boolean equalDistribution;

    public SampleStepOptions() {
    }

    public SampleStepOptions(SampleStepOptions sampleStepOptions) {
        this.init(sampleStepOptions.getActivityType(), sampleStepOptions.getCaseCount(), sampleStepOptions.isRandomSampling(), sampleStepOptions.isCreateTable(), sampleStepOptions.isSampleByNumberOfCases(), sampleStepOptions.getSampleNumOfCases(), sampleStepOptions.getSamplePercentage(), sampleStepOptions.getRandomSeed(), sampleStepOptions.isEqualDistribution());
    }

    public void init(ActivityType activityType) {
        if (activityType == ActivityType.ASSOCIATION_RULES || activityType == ActivityType.SVM_REGRESSION || activityType == ActivityType.SVM_REGRESSION_APPLY || activityType == ActivityType.SVM_SINGLE_CLASS || activityType == ActivityType.SVM_SINGLE_CLASS_APPLY || activityType == ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION || activityType == ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION_APPLY || activityType == ActivityType.O_CLUSTER || activityType == ActivityType.O_CLUSTER_APPLY || activityType == ActivityType.K_MEANS_CLUSTER || activityType == ActivityType.K_MEANS_CLUSTER_APPLY) {
            this.init(activityType, this.caseCount, true, true, true, new Long("10000"), new Double("10"), new Integer(12345), false);
        } else if (activityType == ActivityType.NAIVE_BAYES || activityType == ActivityType.NAIVE_BAYES_APPLY || activityType == ActivityType.DECISION_TREE || activityType == ActivityType.DECISION_TREE_APPLY || activityType == ActivityType.ADAPTIVE_NAIVE_BAYES || activityType == ActivityType.ADAPTIVE_NAIVE_BAYES_APPLY || activityType == ActivityType.ATTRIBUTE_IMPORTANCE || activityType == ActivityType.GLM_CLASSIFICATION || activityType == ActivityType.GLM_CLASSIFICATION_APPLY || activityType == ActivityType.SVM_CLASSIFICATION || activityType == ActivityType.SVM_CLASSIFICATION_APPLY) {
            this.init(activityType, this.caseCount, false, true, true, new Long("10000"), new Double("10"), new Integer(12345), false);
        } else {
            this.init(activityType, this.caseCount, true, true, true, new Long("10000"), new Double("10"), new Integer(12345), false);
        }
    }

    private void init(ActivityType activityType, int n, boolean bl, boolean bl2, boolean bl3, Long l, Double d, Integer n2, boolean bl4) {
        this.at = activityType;
        Long l2 = new Long(10000L);
        this.caseCount = n;
        this.sampleNumOfCases = n == 0 ? l2 : l;
        this.samplePercentage = n == 0 ? null : d;
        this.randomSampling = bl;
        this.createTable = bl2;
        this.sampleByNumberOfCases = n == 0 ? true : bl3;
        this.randomSeed = n2;
        this.equalDistribution = bl4;
    }

    public void restoreSettings(SampleStepOptions sampleStepOptions) {
        this.setActivityType(sampleStepOptions.getActivityType());
        this.setCaseCount(sampleStepOptions.getCaseCount());
        this.setRandomSampling(sampleStepOptions.isRandomSampling());
        this.setCreateTable(sampleStepOptions.isCreateTable());
        this.setSampleByNumberOfCases(sampleStepOptions.isSampleByNumberOfCases());
        this.setSampleNumOfCases(sampleStepOptions.getSampleNumOfCases());
        this.setSamplePercentage(sampleStepOptions.getSamplePercentage());
        this.setRandomSeed(sampleStepOptions.getRandomSeed());
        this.setEqualDistribution(sampleStepOptions.isEqualDistribution());
    }

    public void setActivityType(ActivityType activityType) {
        this.at = activityType;
    }

    public ActivityType getActivityType() {
        return this.at;
    }

    public void setCaseCount(int n) {
        this.caseCount = n;
        int n2 = 10000;
        int n3 = n > n2 ? n2 : (n != 0 ? n : n2);
        this.sampleNumOfCases = new Long(n3);
        this.samplePercentage = n > 0 ? new Double((double)n3 / (double)n * 100.0) : null;
    }

    public int getCaseCount() {
        return this.caseCount;
    }

    public void setCreateTable(boolean bl) {
        this.createTable = bl;
    }

    public boolean isCreateTable() {
        return this.createTable;
    }

    public void setSampleByNumberOfCases(boolean bl) {
        this.sampleByNumberOfCases = bl;
    }

    public boolean isSampleByNumberOfCases() {
        return this.sampleByNumberOfCases;
    }

    public void setSampleNumOfCases(Long l) {
        this.sampleNumOfCases = l;
    }

    public Long getSampleNumOfCases() {
        return this.sampleNumOfCases;
    }

    public void setSamplePercentage(Double d) {
        this.samplePercentage = d;
    }

    public Double getSamplePercentage() {
        return this.samplePercentage;
    }

    public void setRandomSeed(Integer n) {
        this.randomSeed = n;
    }

    public Integer getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSampling(boolean bl) {
        this.randomSampling = bl;
    }

    public boolean isRandomSampling() {
        return this.randomSampling;
    }

    public void setEqualDistribution(boolean bl) {
        this.equalDistribution = bl;
    }

    public boolean isEqualDistribution() {
        return this.equalDistribution;
    }

    public void validate(Vector vector) throws Exception {
        Object object;
        String[] stringArray;
        String string;
        if (this.randomSeed == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_RANDOM_NUMBER_SEED")};
            vector.add(new StateValidation(SampleSettingsStateError.REQUIRED_FIELD, string, stringArray));
        } else {
            int n = this.randomSeed;
            if (n <= 0) {
                stringArray = ResourceUtilities.getstateExceptionMessage("POSITIVE_INTEGER");
                object = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_RANDOM_NUMBER_SEED")};
                vector.add(new StateValidation(SampleSettingsStateError.POSITIVE_INTEGER, (String)stringArray, (String[])object));
            }
        }
        if (this.caseCount > 0) {
            if (this.sampleByNumberOfCases) {
                if (this.sampleNumOfCases == null) {
                    string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                    stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_NUMBER_OF_CASES")};
                    vector.add(new StateValidation(SampleSettingsStateError.REQUIRED_FIELD, string, stringArray));
                } else {
                    long l = this.sampleNumOfCases;
                    if (l <= 0L || l > (long)this.caseCount) {
                        object = ResourceUtilities.getstateExceptionMessage("RANGE_VALIDATION");
                        String[] stringArray2 = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_NUMBER_OF_CASES"), "1", "" + this.caseCount};
                        vector.add(new StateValidation(SampleSettingsStateError.RANGE_VALIDATION, (String)object, stringArray2));
                    }
                }
            } else if (this.samplePercentage == null) {
                string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES")};
                vector.add(new StateValidation(SampleSettingsStateError.REQUIRED_FIELD, string, stringArray));
            } else {
                double d = this.samplePercentage;
                if (d > 100.0 || d <= 0.0) {
                    object = ResourceUtilities.getstateExceptionMessage("RANGE_VALIDATION");
                    String[] stringArray3 = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES"), "0", "100"};
                    vector.add(new StateValidation(SampleSettingsStateError.RANGE_VALIDATION, (String)object, stringArray3));
                }
            }
        }
    }

    public boolean isStratifiedAllowed() {
        return this.at == ActivityType.NAIVE_BAYES || this.at == ActivityType.NAIVE_BAYES_APPLY || this.at == ActivityType.DECISION_TREE || this.at == ActivityType.DECISION_TREE_APPLY || this.at == ActivityType.ADAPTIVE_NAIVE_BAYES || this.at == ActivityType.ADAPTIVE_NAIVE_BAYES_APPLY || this.at == ActivityType.ATTRIBUTE_IMPORTANCE || this.at == ActivityType.GLM_CLASSIFICATION || this.at == ActivityType.GLM_CLASSIFICATION_APPLY || this.at == ActivityType.SVM_CLASSIFICATION || this.at == ActivityType.SVM_CLASSIFICATION_APPLY;
    }
}

