/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.SVMBuildStepOptions;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.SupportVectorMachineAlgorithmStateError;

public class SVMRBuildStepOptions
extends SVMBuildStepOptions {
    private Double complexityFactor;
    private Double epsilon;

    public SVMRBuildStepOptions() {
    }

    public SVMRBuildStepOptions(SVMRBuildStepOptions sVMRBuildStepOptions) {
        super(sVMRBuildStepOptions);
        this.init(sVMRBuildStepOptions.getComplexityFactor(), sVMRBuildStepOptions.getEpsilon());
    }

    public void init(ActivityType activityType) {
        super.init(activityType);
        this.init(null, null);
    }

    private void init(Double d, Double d2) {
        this.complexityFactor = d;
        this.epsilon = d2;
    }

    public void restoreSettings(SVMRBuildStepOptions sVMRBuildStepOptions) {
        super.restoreSettings(sVMRBuildStepOptions);
        this.setComplexityFactor(sVMRBuildStepOptions.getComplexityFactor());
        this.setEpsilon(sVMRBuildStepOptions.getEpsilon());
    }

    public void setComplexityFactor(Double d) {
        this.complexityFactor = d;
    }

    public Double getComplexityFactor() {
        return this.complexityFactor;
    }

    public void setEpsilon(Double d) {
        this.epsilon = d;
    }

    public Double getEpsilon() {
        return this.epsilon;
    }

    protected void validateComplexityFactor(Vector vector) throws Exception {
        Double d = new Double(0.0);
        Double d2 = new Double(Double.MAX_VALUE);
        if (this.complexityFactor != null && (this.complexityFactor.compareTo(d) <= 0 || this.complexityFactor.compareTo(d2) > 0)) {
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_COMPLEXITY_FACTOR_INVALID));
        }
    }

    protected void validateEpsilon(Vector vector) throws Exception {
        Double d = new Double(0.0);
        Double d2 = new Double(Double.MAX_VALUE);
        if (this.epsilon != null && (this.epsilon.compareTo(d) <= 0 || this.epsilon.compareTo(d2) > 0)) {
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_EPSILON_INVALID));
        }
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
        this.validateEpsilon(vector);
        this.validateComplexityFactor(vector);
    }
}

