/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.HashMap;
import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.SVMBuildStepOptions;
import oracle.dmt.dm4j.datasources.TargetValueWeightDataSource;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.SupportVectorMachineAlgorithmStateError;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TargetStateError;

public class SVMCBuildStepOptions
extends SVMBuildStepOptions {
    private Double complexityFactor;
    private HashMap curTargetWeights;
    private boolean curTargetWeighted;
    private String curTargetValue;
    private boolean curBinaryClass;

    public SVMCBuildStepOptions() {
    }

    public SVMCBuildStepOptions(SVMCBuildStepOptions sVMCBuildStepOptions) {
        super(sVMCBuildStepOptions);
        this.setCurTargetWeights(sVMCBuildStepOptions.getCurTargetWeights());
        this.setCurTargetValue(sVMCBuildStepOptions.getCurTargetValue());
        this.setCurTargetWeighted(sVMCBuildStepOptions.isCurTargetWeighted());
        this.setCurBinaryClass(sVMCBuildStepOptions.isCurBinaryClass());
        this.setComplexityFactor(sVMCBuildStepOptions.getComplexityFactor());
    }

    public void init(ActivityType activityType) {
        this.initTargetValues(null, null, false);
        this.initAlgorithms();
    }

    public void initTargetValues(HashMap hashMap, String string, boolean bl) {
        this.setCurTargetWeights(hashMap != null ? new HashMap(hashMap) : null);
        this.setCurBinaryClass(string != null);
        this.setCurTargetValue(string);
        this.setCurTargetWeighted(bl);
    }

    public void initAlgorithms() {
        super.init(null);
        this.setComplexityFactor(null);
    }

    public void restoreToDefaultSettings(AbstractActivity abstractActivity) {
        this.initTargetValues(abstractActivity.getBuildPriors(), abstractActivity.getTargetValue(), abstractActivity.useBuildCostMatrix());
        this.initAlgorithms();
    }

    public void restoreSettings(SVMCBuildStepOptions sVMCBuildStepOptions) {
        super.restoreSettings(sVMCBuildStepOptions);
        this.setCurTargetWeights(sVMCBuildStepOptions.getCurTargetWeights());
        this.setCurTargetValue(sVMCBuildStepOptions.getCurTargetValue());
        this.setCurTargetWeighted(sVMCBuildStepOptions.isCurTargetWeighted());
        this.setCurBinaryClass(sVMCBuildStepOptions.isCurBinaryClass());
        this.setComplexityFactor(sVMCBuildStepOptions.getComplexityFactor());
    }

    public void setComplexityFactor(Double d) {
        this.complexityFactor = d;
    }

    public Double getComplexityFactor() {
        return this.complexityFactor;
    }

    protected void validateComplexityFactor(Vector vector) throws Exception {
        Double d = new Double(0.0);
        Double d2 = new Double(Double.MAX_VALUE);
        if (this.complexityFactor != null && (this.complexityFactor.compareTo(d) <= 0 || this.complexityFactor.compareTo(d2) > 0)) {
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_COMPLEXITY_FACTOR_INVALID));
        }
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
        if (this.isCurBinaryClass() && this.curTargetValue == null) {
            vector.add(new StateValidation(TargetStateError.TARGET_EMPTY));
        }
        this.validateComplexityFactor(vector);
    }

    public void setCurTargetWeights(HashMap hashMap) {
        this.curTargetWeights = hashMap;
    }

    public HashMap getCurTargetWeights() {
        return this.curTargetWeights;
    }

    public void setCurTargetWeighted(boolean bl) {
        this.curTargetWeighted = bl;
    }

    public boolean isCurTargetWeighted() {
        return this.curTargetWeighted;
    }

    public void setTargetValueWeightDataSource(TargetValueWeightDataSource targetValueWeightDataSource) {
        try {
            this.curTargetWeights = targetValueWeightDataSource.getWeights();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TargetValueWeightDataSource getTargetValueWeightDataSource(AbstractActivity abstractActivity) {
        TargetValueWeightDataSource targetValueWeightDataSource = null;
        try {
            targetValueWeightDataSource = new TargetValueWeightDataSource(abstractActivity.getTargetPriors(), this.curTargetWeights, this.isLearningEnabled());
            targetValueWeightDataSource.run();
        }
        catch (Exception exception) {
            targetValueWeightDataSource = null;
        }
        return targetValueWeightDataSource;
    }

    public void setCurTargetValue(String string) {
        this.curTargetValue = string;
    }

    public String getCurTargetValue() {
        return this.curTargetValue;
    }

    public void setCurBinaryClass(boolean bl) {
        this.curBinaryClass = bl;
    }

    public boolean isCurBinaryClass() {
        return this.curBinaryClass;
    }
}

