/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.Vector;
import javax.datamining.algorithm.svm.KernelFunction;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.BuildStepOptions;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.SupportVectorMachineAlgorithmStateError;

public abstract class SVMBuildStepOptions
extends BuildStepOptions {
    private String mkernelFunction;
    private Double tolerance;
    private Double std;
    private Integer kernelCacheSize;
    private boolean learningEnabled;

    public SVMBuildStepOptions() {
    }

    public SVMBuildStepOptions(SVMBuildStepOptions sVMBuildStepOptions) {
        this.init(sVMBuildStepOptions.getKernelFunction(), sVMBuildStepOptions.getTolerance(), sVMBuildStepOptions.getStd(), sVMBuildStepOptions.getKernelCacheSize(), sVMBuildStepOptions.isLearningEnabled());
    }

    public void init(ActivityType activityType) {
        this.init(KernelFunction.systemDetermined, new Double(0.001), null, new Integer(50), true);
    }

    private void init(KernelFunction kernelFunction, Double d, Double d2, Integer n, boolean bl) {
        this.mkernelFunction = kernelFunction.name();
        this.tolerance = d;
        this.std = d2;
        this.kernelCacheSize = n;
        this.learningEnabled = bl;
    }

    public void restoreSettings(SVMBuildStepOptions sVMBuildStepOptions) {
        this.setKernelFunction(sVMBuildStepOptions.getKernelFunction());
        this.setTolerance(sVMBuildStepOptions.getTolerance());
        this.setStd(sVMBuildStepOptions.getStd());
        this.setKernelCacheSize(sVMBuildStepOptions.getKernelCacheSize());
        this.setLearningEnabled(sVMBuildStepOptions.isLearningEnabled());
    }

    public void setMkernelFunction(String string) {
        this.mkernelFunction = string;
    }

    public String getMkernelFunction() {
        return this.mkernelFunction;
    }

    public void setKernelFunction(KernelFunction kernelFunction) {
        this.setMkernelFunction(kernelFunction.name());
    }

    public KernelFunction getKernelFunction() {
        KernelFunction kernelFunction = KernelFunction.systemDetermined;
        try {
            kernelFunction = KernelFunction.valueOf(this.getMkernelFunction());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return kernelFunction;
    }

    public void setTolerance(Double d) {
        this.tolerance = d;
    }

    public Double getTolerance() {
        return this.tolerance;
    }

    public void setStd(Double d) {
        this.std = d;
    }

    public Double getStd() {
        return this.std;
    }

    public void setKernelCacheSize(Integer n) {
        this.kernelCacheSize = n;
    }

    public Integer getKernelCacheSize() {
        return this.kernelCacheSize;
    }

    public void setLearningEnabled(boolean bl) {
        this.learningEnabled = bl;
    }

    public boolean isLearningEnabled() {
        return this.learningEnabled;
    }

    protected void validateStd(Vector vector) throws Exception {
        Double d = new Double(0.0);
        Double d2 = new Double(Double.MAX_VALUE);
        if (this.std != null && (this.std.compareTo(d) <= 0 || this.std.compareTo(d2) > 0)) {
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_STD_INVALID));
        }
    }

    protected void validateTolerance(Vector vector) throws Exception {
        Double d = new Double(0.0);
        Double d2 = new Double(0.1);
        if (this.tolerance == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_SVM_TOLERANCE")};
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_TOLERANCE_EMPTY, string, stringArray));
        } else if (this.tolerance.compareTo(d) <= 0 || this.tolerance.compareTo(d2) > 0) {
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_TOLERANCE_INVALID));
        }
    }

    protected void validateKernelCacheSize(Vector vector) throws Exception {
        Integer n = new Integer(0);
        Integer n2 = new Integer(Integer.MAX_VALUE);
        if (this.kernelCacheSize == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_SVM_KERNEL_CACHE_SIZE")};
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_KERNEL_CACHE_SIZE_EMPTY, string, stringArray));
        } else if (this.kernelCacheSize.compareTo(n) <= 0 || this.kernelCacheSize.compareTo(n2) > 0) {
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_KERNEL_CACHE_SIZE_INVALID));
        }
    }

    public void validate(Vector vector) throws Exception {
        if (this.getKernelFunction().compareTo(KernelFunction.kGaussian) == 0) {
            this.validateStd(vector);
            this.validateKernelCacheSize(vector);
        }
        this.validateTolerance(vector);
    }
}

