/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.Vector;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.BuildStepOptions;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.KMeansAlgorithmStateError;
import oracle.dmt.jdm.algorithm.kmeans.OraClusteringDistanceFunction;
import oracle.dmt.jdm.algorithm.kmeans.OraSplitCriterion;

public class KMeansBuildStepOptions
extends BuildStepOptions {
    private Double minimumErrorTolerance;
    private Double minimumSupportPercentage;
    private Integer maximumIterations;
    private Integer numberOfBins;
    private Integer kmeansNumberOfClusters;
    private String mdistanceFunction;
    private String msplitCriterion;
    private Integer blockGrowth;

    public KMeansBuildStepOptions(KMeansBuildStepOptions kMeansBuildStepOptions) {
        this.init(kMeansBuildStepOptions.getMinimumErrorTolerance(), kMeansBuildStepOptions.getMinimumSupportPercentage(), kMeansBuildStepOptions.getMaximumIterations(), kMeansBuildStepOptions.getNumberOfBins(), kMeansBuildStepOptions.getKmeansNumberOfClusters(), kMeansBuildStepOptions.getDistanceFunction(), kMeansBuildStepOptions.getSplitCriterion(), kMeansBuildStepOptions.getBlockGrowth());
    }

    public KMeansBuildStepOptions() {
        if (this.blockGrowth == null) {
            this.blockGrowth = new Integer(2);
        }
    }

    public void init(ActivityType activityType) {
        this.init(activityType, false);
    }

    public void init(ActivityType activityType, boolean bl) {
        this.init(new Double(0.01), new Double(0.1), new Integer(3), new Integer(10), new Integer(10), bl ? OraClusteringDistanceFunction.cosine : ClusteringDistanceFunction.euclidean, OraSplitCriterion.clusterVariance, new Integer(2));
    }

    private void init(Double d, Double d2, Integer n, Integer n2, Integer n3, ClusteringDistanceFunction clusteringDistanceFunction, OraSplitCriterion oraSplitCriterion, Integer n4) {
        this.minimumErrorTolerance = d;
        this.minimumSupportPercentage = d2;
        this.maximumIterations = n;
        this.numberOfBins = n2;
        this.kmeansNumberOfClusters = n3;
        this.mdistanceFunction = clusteringDistanceFunction.name();
        this.msplitCriterion = oraSplitCriterion.name();
        this.blockGrowth = n4;
    }

    public void restoreSettings(KMeansBuildStepOptions kMeansBuildStepOptions) {
        this.setMinimumErrorTolerance(kMeansBuildStepOptions.getMinimumErrorTolerance());
        this.setMinimumSupportPercentage(kMeansBuildStepOptions.getMinimumSupportPercentage());
        this.setMaximumIterations(kMeansBuildStepOptions.getMaximumIterations());
        this.setNumberOfBins(kMeansBuildStepOptions.getNumberOfBins());
        this.setKmeansNumberOfClusters(kMeansBuildStepOptions.getKmeansNumberOfClusters());
        this.setMdistanceFunction(kMeansBuildStepOptions.getMdistanceFunction());
        this.setMsplitCriterion(kMeansBuildStepOptions.getMsplitCriterion());
        this.setBlockGrowth(kMeansBuildStepOptions.getBlockGrowth());
    }

    public void restoreToDefaultSettings(AbstractActivity abstractActivity) {
        this.init(null, abstractActivity.getTextColumn() != null);
    }

    public void setMinimumErrorTolerance(Double d) {
        this.minimumErrorTolerance = d;
    }

    public Double getMinimumErrorTolerance() {
        return this.minimumErrorTolerance;
    }

    public void setMinimumSupportPercentage(Double d) {
        this.minimumSupportPercentage = d;
    }

    public Double getMinimumSupportPercentage() {
        return this.minimumSupportPercentage;
    }

    public void setMaximumIterations(Integer n) {
        this.maximumIterations = n;
    }

    public Integer getMaximumIterations() {
        return this.maximumIterations;
    }

    public void setNumberOfBins(Integer n) {
        this.numberOfBins = n;
    }

    public Integer getNumberOfBins() {
        return this.numberOfBins;
    }

    public void setKmeansNumberOfClusters(Integer n) {
        this.kmeansNumberOfClusters = n;
    }

    public Integer getKmeansNumberOfClusters() {
        return this.kmeansNumberOfClusters;
    }

    public void setMdistanceFunction(String string) {
        this.mdistanceFunction = string;
    }

    public String getMdistanceFunction() {
        return this.mdistanceFunction;
    }

    public void setDistanceFunction(ClusteringDistanceFunction clusteringDistanceFunction) {
        this.mdistanceFunction = clusteringDistanceFunction.name();
    }

    public ClusteringDistanceFunction getDistanceFunction() {
        ClusteringDistanceFunction clusteringDistanceFunction = ClusteringDistanceFunction.euclidean;
        try {
            if (ClusteringDistanceFunction.euclidean.name().compareTo(this.mdistanceFunction) == 0) {
                clusteringDistanceFunction = ClusteringDistanceFunction.euclidean;
            } else if (OraClusteringDistanceFunction.cosine.name().compareTo(this.mdistanceFunction) == 0) {
                clusteringDistanceFunction = OraClusteringDistanceFunction.cosine;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clusteringDistanceFunction;
    }

    public void setMsplitCriterion(String string) {
        this.msplitCriterion = string;
    }

    public String getMsplitCriterion() {
        return this.msplitCriterion;
    }

    public void setSplitCriterion(OraSplitCriterion oraSplitCriterion) {
        this.msplitCriterion = oraSplitCriterion.name();
    }

    public OraSplitCriterion getSplitCriterion() {
        OraSplitCriterion oraSplitCriterion = OraSplitCriterion.clusterVariance;
        try {
            oraSplitCriterion = OraSplitCriterion.valueOf(this.msplitCriterion);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return oraSplitCriterion;
    }

    public Vector getAvailableDistanceFunctionNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("Cosine");
        vector.add("Euclidean");
        return vector;
    }

    public Vector getAvailableSplitCriterionNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("Size");
        vector.add("Variance");
        return vector;
    }

    public void validateNumberOfClusters(Vector vector) throws Exception {
        if (this.kmeansNumberOfClusters == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("KMEANS_NUMBER_CLUSTERS")};
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_NUMBER_OF_CLUSTERS_EMPTY, string, stringArray));
        } else if (this.kmeansNumberOfClusters < 1 || this.kmeansNumberOfClusters >= Integer.MAX_VALUE) {
            String string = ResourceUtilities.getstateExceptionMessage("ALGO_KMEANS_NUMBER_OF_CLUSTERS_INVALID");
            String[] stringArray = new String[]{String.valueOf(Integer.MAX_VALUE)};
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_NUMBER_OF_CLUSTERS_INVALID, string, stringArray));
        }
    }

    public void validate(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        this.validateNumberOfClusters(vector);
        if (ValidationUtil.validationsContainsErrors(vector)) {
            return;
        }
        if (this.maximumIterations == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_KMEANS_MAXIMUM_ITERATIONS")};
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_MAXIMUM_ITERATIONS_EMPTY, string, stringArray));
        } else if (this.maximumIterations <= 0 || this.maximumIterations > 20) {
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_MAXIMUM_ITERATIONS_INVALID));
        }
        if (this.minimumErrorTolerance == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_KMEANS_MINIMUM_ERROR_TOLERANCE")};
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_MINIMUM_ERROR_TOLERANCE_EMPTY, string, stringArray));
        } else if (!(this.minimumErrorTolerance > 0.0) || !(this.minimumErrorTolerance <= 0.5)) {
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_MINIMUM_ERROR_TOLERANCE_INVALID));
        }
        if (this.numberOfBins == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_KMEANS_NUMBER_OF_BINS")};
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_NUMBER_OF_BINS_EMPTY, string, stringArray));
        } else if (this.numberOfBins <= 0 || this.numberOfBins >= Integer.MAX_VALUE) {
            string = ResourceUtilities.getstateExceptionMessage("ALGO_KMEANS_NUMBER_OF_BINS_INVALID");
            stringArray = new String[]{String.valueOf(Integer.MAX_VALUE)};
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_NUMBER_OF_BINS_INVALID, string, stringArray));
        }
        if (this.blockGrowth == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_KMEANS_BLOCK_GROWTH")};
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_BLOCK_GROWTH_EMPTY, string, stringArray));
        } else if (this.blockGrowth <= 1 || this.blockGrowth > 5) {
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_BLOCK_GROWTH_INVALID));
        }
        if (this.minimumSupportPercentage == null) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_KMEANS_MINIMUM_SUPPORT")};
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_MINIMUM_SUPPORT_EMPTY, string, stringArray));
        } else if (!(this.minimumSupportPercentage >= 0.0) || !(this.minimumSupportPercentage <= 1.0)) {
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_MINIMUM_SUPPORT_INVALID));
        }
    }

    public void setBlockGrowth(Integer n) {
        this.blockGrowth = n;
    }

    public Integer getBlockGrowth() {
        return this.blockGrowth;
    }
}

