/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.HashMap;
import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.GLMBuildStepOptions;
import oracle.dmt.dm4j.datasources.TargetValueWeightDataSource;

public class GLMCBuildStepOptions
extends GLMBuildStepOptions {
    private HashMap curTargetWeights;
    private boolean curTargetWeighted;
    private String curTargetValue;
    private Object referenceTargetClass;

    public GLMCBuildStepOptions() {
    }

    public GLMCBuildStepOptions(GLMCBuildStepOptions gLMCBuildStepOptions) {
        super(gLMCBuildStepOptions);
        this.setCurTargetWeights(gLMCBuildStepOptions.getCurTargetWeights());
        this.setCurTargetValue(gLMCBuildStepOptions.getCurTargetValue());
        this.setCurTargetWeighted(gLMCBuildStepOptions.isCurTargetWeighted());
        this.setReferenceTargetClass(gLMCBuildStepOptions.getReferenceTargetClass());
    }

    public void init(ActivityType activityType) {
        this.initTargetValues(null, null, false);
        this.initAlgorithms();
    }

    public void initTargetValues(HashMap hashMap, String string, boolean bl) {
        this.setCurTargetWeights(hashMap != null ? new HashMap(hashMap) : null);
        this.setCurTargetValue(string);
        this.setCurTargetWeighted(bl);
    }

    public void initAlgorithms() {
        super.init(null);
        this.setReferenceTargetClass(null);
    }

    public void restoreToDefaultSettings(AbstractActivity abstractActivity) {
        this.initTargetValues(abstractActivity.getBuildPriors(), abstractActivity.getTargetValue(), abstractActivity.useBuildCostMatrix());
        this.initAlgorithms();
    }

    public void restoreSettings(GLMCBuildStepOptions gLMCBuildStepOptions) {
        super.restoreSettings(gLMCBuildStepOptions);
        this.setCurTargetWeights(gLMCBuildStepOptions.getCurTargetWeights());
        this.setCurTargetValue(gLMCBuildStepOptions.getCurTargetValue());
        this.setCurTargetWeighted(gLMCBuildStepOptions.isCurTargetWeighted());
        this.setReferenceTargetClass(gLMCBuildStepOptions.getReferenceTargetClass());
    }

    public void setReferenceTargetClass(Object object) {
        this.referenceTargetClass = object;
    }

    public Object getReferenceTargetClass() {
        return this.referenceTargetClass;
    }

    public void setCurTargetWeights(HashMap hashMap) {
        this.curTargetWeights = hashMap;
    }

    public HashMap getCurTargetWeights() {
        return this.curTargetWeights;
    }

    public void setCurTargetValue(String string) {
        this.curTargetValue = string;
    }

    public void setCurTargetWeighted(boolean bl) {
        this.curTargetWeighted = bl;
    }

    public boolean isCurTargetWeighted() {
        return this.curTargetWeighted;
    }

    public String getCurTargetValue() {
        return this.curTargetValue;
    }

    public void setTargetValueWeightDataSource(TargetValueWeightDataSource targetValueWeightDataSource) {
        try {
            this.curTargetWeights = targetValueWeightDataSource.getWeights();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TargetValueWeightDataSource getTargetValueWeightDataSource(AbstractActivity abstractActivity) {
        TargetValueWeightDataSource targetValueWeightDataSource = null;
        try {
            targetValueWeightDataSource = new TargetValueWeightDataSource(abstractActivity.getTargetPriors(), this.curTargetWeights, false);
            targetValueWeightDataSource.run();
        }
        catch (Exception exception) {
            targetValueWeightDataSource = null;
        }
        return targetValueWeightDataSource;
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
    }
}

