/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class DiscretizationStepOptions
extends AbstractStepOptions {
    private ActivityType at;
    private int caseCount;
    private String numericalDiscretizeTreatment;
    private String categoricalDiscretizeTreatment;
    static String QUANTILE_BINNING = ResourceUtilities.getUILabel("QUANTILE_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String EQUAL_WIDTH_BINNING = ResourceUtilities.getUILabel("EQUAL_WIDTH_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String TOPN_BINNING = ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String NONE = ResourceUtilities.getUILabel("NONE");
    private int numericalBinNumber = DiscretizeDataSource.DEFAULT_BIN_NUMBER;
    private int categoricalBinNumber = DiscretizeDataSource.DEFAULT_BIN_NUMBER;

    public DiscretizationStepOptions() {
    }

    public DiscretizationStepOptions(DiscretizationStepOptions discretizationStepOptions) {
        this.init(discretizationStepOptions.getActivityType(), discretizationStepOptions.getCaseCount(), discretizationStepOptions.getNumericalDiscretizeTreatment(), discretizationStepOptions.getCategoricalDiscretizeTreatment(), discretizationStepOptions.getNumericalBinNumber(), discretizationStepOptions.getCategoricalBinNumber());
    }

    public void init(ActivityType activityType) {
        this.numericalBinNumber = this.getDefaultNumbericalBinNumber(activityType);
        this.categoricalBinNumber = this.getDefaultCategoricalBinNumber(activityType);
        if (activityType == ActivityType.ADAPTIVE_NAIVE_BAYES || activityType == ActivityType.ADAPTIVE_NAIVE_BAYES_APPLY || activityType == ActivityType.NAIVE_BAYES || activityType == ActivityType.NAIVE_BAYES_APPLY || activityType == ActivityType.ATTRIBUTE_IMPORTANCE) {
            this.init(activityType, this.caseCount, QUANTILE_BINNING, TOPN_BINNING, this.numericalBinNumber, this.categoricalBinNumber);
        } else if (activityType == ActivityType.ASSOCIATION_RULES || activityType == ActivityType.O_CLUSTER || activityType == ActivityType.O_CLUSTER_APPLY) {
            this.init(activityType, this.caseCount, EQUAL_WIDTH_BINNING, NONE, this.numericalBinNumber, this.categoricalBinNumber);
        } else {
            this.init(activityType, this.caseCount, NONE, NONE, this.numericalBinNumber, this.categoricalBinNumber);
        }
    }

    private void init(ActivityType activityType, int n, String string, String string2, int n2, int n3) {
        this.at = activityType;
        this.caseCount = n;
        this.numericalDiscretizeTreatment = string;
        this.categoricalDiscretizeTreatment = string2;
        this.numericalBinNumber = n2;
        this.categoricalBinNumber = n3;
    }

    public void restoreSettings(DiscretizationStepOptions discretizationStepOptions) {
        this.setActivityType(discretizationStepOptions.getActivityType());
        this.setCaseCount(discretizationStepOptions.getCaseCount());
        this.setNumericalDiscretizeTreatment(discretizationStepOptions.getNumericalDiscretizeTreatment());
        this.setCategoricalDiscretizeTreatment(discretizationStepOptions.getCategoricalDiscretizeTreatment());
        this.setNumericalBinNumber(discretizationStepOptions.getNumericalBinNumber());
        this.setNumericalBinNumber(discretizationStepOptions.getNumericalBinNumber());
    }

    public void setActivityType(ActivityType activityType) {
        this.at = activityType;
    }

    public ActivityType getActivityType() {
        return this.at;
    }

    public void setCaseCount(int n) {
        this.caseCount = n;
    }

    public int getCaseCount() {
        return this.caseCount;
    }

    public void setNumericalDiscretizeTreatment(String string) {
        this.numericalDiscretizeTreatment = string;
    }

    public String getNumericalDiscretizeTreatment() {
        return this.numericalDiscretizeTreatment;
    }

    public void setCategoricalDiscretizeTreatment(String string) {
        this.categoricalDiscretizeTreatment = string;
    }

    public String getCategoricalDiscretizeTreatment() {
        return this.categoricalDiscretizeTreatment;
    }

    public void setNumericalBinNumber(int n) {
        this.numericalBinNumber = n;
    }

    public int getNumericalBinNumber() {
        return this.numericalBinNumber;
    }

    public void setCategoricalBinNumber(int n) {
        this.categoricalBinNumber = n;
    }

    public int getCategoricalBinNumber() {
        return this.categoricalBinNumber;
    }

    public void validate(Vector vector) throws Exception {
    }

    private int getDefaultNumbericalBinNumber(ActivityType activityType) {
        int n = 0;
        n = true == activityType.equals(ActivityType.ADAPTIVE_NAIVE_BAYES) ? (this.numericalBinNumber = DiscretizeDataSource.DEFAULT_ABN_BIN_NUMBER) : DiscretizeDataSource.DEFAULT_BIN_NUMBER;
        return n;
    }

    private int getDefaultCategoricalBinNumber(ActivityType activityType) {
        UserPreferences userPreferences = UserPreferences.getInstance();
        int n = 0;
        n = true == activityType.equals(ActivityType.ADAPTIVE_NAIVE_BAYES) ? Math.min(userPreferences.getMaxABNCategoricalBin(), 125) : Math.min(userPreferences.getMaxCategoricalBin(), 125);
        return n;
    }
}

