/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.HashMap;
import java.util.Vector;
import javax.datamining.NamedObject;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.CostMatrix;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.TestMetricStepOptions;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TargetStateError;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TestMetricsOptionsStateError;

public class ClassificationTestMetricStepOptions
extends TestMetricStepOptions {
    private HashMap targetPrior;
    private String curCostMatrix;
    private String curTargetValue;
    private boolean curWeightedScore;
    private boolean genConfusionMatrix;
    private boolean genROC;
    private boolean genLift;
    private Integer numLiftQuantiles;
    private transient ActivityType activityType;
    private transient TargetValueCostMatrixDataSource costMatrixDataSource;

    public ClassificationTestMetricStepOptions() {
        this.activityType = null;
        this.costMatrixDataSource = null;
    }

    public ClassificationTestMetricStepOptions(ClassificationTestMetricStepOptions classificationTestMetricStepOptions) {
        this.setTargetPrior(classificationTestMetricStepOptions.getTargetPrior());
        this.setCurCostMatrix(classificationTestMetricStepOptions.getCurCostMatrix());
        this.setCurTargetValue(classificationTestMetricStepOptions.getCurTargetValue());
        this.setCurWeightedScore(classificationTestMetricStepOptions.isCurWeightedScore());
        this.setGenConfusionMatrix(classificationTestMetricStepOptions.isGenConfusionMatrix());
        this.setGenROC(classificationTestMetricStepOptions.isGenROC());
        this.setGenLift(classificationTestMetricStepOptions.isGenLift());
        this.setNumLiftQuantiles(classificationTestMetricStepOptions.getNumLiftQuantiles());
        TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = classificationTestMetricStepOptions.getCostMatrixDS();
        if (targetValueCostMatrixDataSource != null) {
            this.costMatrixDataSource = new TargetValueCostMatrixDataSource((Vector)null);
            this.costMatrixDataSource.clone(targetValueCostMatrixDataSource);
        } else {
            this.costMatrixDataSource = null;
        }
    }

    public void init(ActivityType activityType) {
        this.activityType = activityType;
        this.initTargetValues(this.activityType, null, null, null, false);
        this.initOptions(this.activityType, null);
    }

    public void initTargetValues(ActivityType activityType, HashMap hashMap, String string, String string2, boolean bl) {
        this.activityType = activityType;
        this.setTargetPrior(hashMap);
        this.setCurTargetValue(string);
        this.setCurWeightedScore(bl);
        this.setCurCostMatrix(string2);
    }

    public void initOptions(ActivityType activityType, String string) {
        this.activityType = activityType;
        this.setGenConfusionMatrix(true);
        this.setGenROC(string != null);
        this.setGenLift(string != null);
        this.setNumLiftQuantiles(new Integer(10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCostMatrixDS(TargetValueCostMatrixDataSource targetValueCostMatrixDataSource) {
        if (targetValueCostMatrixDataSource == null) return;
        Connection connection = null;
        if (!this.curWeightedScore) return;
        connection = DM4JConnectionManager.getConnection();
        CostMatrix costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(connection);
        connection.saveObject(this.curCostMatrix, costMatrix, true);
        this.costMatrixDataSource = targetValueCostMatrixDataSource;
        Object var5_5 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                Object var5_6 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TargetValueCostMatrixDataSource getCostMatrixDS() {
        if (this.costMatrixDataSource != null) return this.costMatrixDataSource;
        Connection connection = null;
        connection = DM4JConnectionManager.getConnection();
        TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = null;
        CostMatrix costMatrix = (CostMatrix)connection.retrieveObject(this.curCostMatrix, NamedObject.costMatrix);
        targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(new Vector(this.targetPrior.keySet()));
        targetValueCostMatrixDataSource.run();
        targetValueCostMatrixDataSource.setCostMatrix(costMatrix);
        this.costMatrixDataSource = targetValueCostMatrixDataSource;
        Object var5_5 = null;
        if (connection == null) return this.costMatrixDataSource;
        try {
            connection.close();
            return this.costMatrixDataSource;
        }
        catch (Exception exception) {}
        return this.costMatrixDataSource;
        {
            catch (Exception exception) {
                Object var5_6 = null;
                if (connection == null) return this.costMatrixDataSource;
                try {
                    connection.close();
                    return this.costMatrixDataSource;
                }
                catch (Exception exception2) {}
                return this.costMatrixDataSource;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initCostMatrix() {
        Connection connection;
        block11: {
            connection = null;
            CostMatrix costMatrix = null;
            if (this.activityType == ActivityType.ADAPTIVE_NAIVE_BAYES || this.activityType == ActivityType.NAIVE_BAYES || this.activityType == ActivityType.ADAPTIVE_NAIVE_BAYES_TEST || this.activityType == ActivityType.NAIVE_BAYES_TEST) {
                if (this.curWeightedScore) {
                    connection = DM4JConnectionManager.getConnection();
                    TargetValueDataSource targetValueDataSource = new TargetValueDataSource(this.targetPrior);
                    targetValueDataSource.run();
                    TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = null;
                    targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(targetValueDataSource);
                    targetValueCostMatrixDataSource.run();
                    costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(connection);
                    connection.saveObject(this.curCostMatrix, costMatrix, true);
                    this.costMatrixDataSource = targetValueCostMatrixDataSource;
                } else {
                    connection = DM4JConnectionManager.getConnection();
                    TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(new Vector(this.targetPrior.keySet()));
                    targetValueCostMatrixDataSource.run();
                    costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(connection);
                    connection.saveObject(this.curCostMatrix, costMatrix, true);
                    this.costMatrixDataSource = targetValueCostMatrixDataSource;
                }
                break block11;
            }
            if (this.activityType != ActivityType.DECISION_TREE && this.activityType != ActivityType.SVM_CLASSIFICATION && this.activityType != ActivityType.DECISION_TREE_TEST && this.activityType != ActivityType.SVM_CLASSIFICATION_TEST && this.activityType != ActivityType.GLM_CLASSIFICATION && this.activityType != ActivityType.GLM_CLASSIFICATION_TEST) break block11;
            connection = DM4JConnectionManager.getConnection();
            TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(new Vector(this.targetPrior.keySet()));
            targetValueCostMatrixDataSource.run();
            costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(connection);
            connection.saveObject(this.curCostMatrix, costMatrix, true);
            this.costMatrixDataSource = targetValueCostMatrixDataSource;
        }
        Object var6_8 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                Object var6_9 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void restoreToDefaultSettings(AbstractActivity abstractActivity) {
        this.initTargetValues(abstractActivity.getType(), abstractActivity.getTargetPriors(), abstractActivity.getTargetValue(), abstractActivity.getCurTestCostMatrix().getName(), abstractActivity.useTestCostMatrix());
        this.initCostMatrix();
        this.initOptions(abstractActivity.getType(), abstractActivity.getTargetValue());
    }

    public void restoreSettings(ClassificationTestMetricStepOptions classificationTestMetricStepOptions) {
        this.setCostMatrixDS(classificationTestMetricStepOptions.getCostMatrixDS());
        this.setCurTargetValue(classificationTestMetricStepOptions.getCurTargetValue());
        this.setCurWeightedScore(classificationTestMetricStepOptions.isCurWeightedScore());
        this.setGenConfusionMatrix(classificationTestMetricStepOptions.isGenConfusionMatrix());
        this.setGenLift(classificationTestMetricStepOptions.isGenLift());
        this.setGenROC(classificationTestMetricStepOptions.isGenROC());
        this.setNumLiftQuantiles(classificationTestMetricStepOptions.getNumLiftQuantiles());
    }

    public void setGenConfusionMatrix(boolean bl) {
        this.genConfusionMatrix = bl;
    }

    public boolean isGenConfusionMatrix() {
        return this.genConfusionMatrix;
    }

    public void setGenROC(boolean bl) {
        this.genROC = bl;
    }

    public boolean isGenROC() {
        return this.genROC;
    }

    public void setGenLift(boolean bl) {
        this.genLift = bl;
    }

    public boolean isGenLift() {
        return this.genLift;
    }

    public void setNumLiftQuantiles(Integer n) {
        this.numLiftQuantiles = n;
    }

    public Integer getNumLiftQuantiles() {
        return this.numLiftQuantiles;
    }

    public void setTargetPrior(HashMap hashMap) {
        this.targetPrior = hashMap;
    }

    public HashMap getTargetPrior() {
        return this.targetPrior;
    }

    public void setCurCostMatrix(String string) {
        this.curCostMatrix = string;
    }

    public String getCurCostMatrix() {
        return this.curCostMatrix;
    }

    public void setCurTargetValue(String string) {
        this.curTargetValue = string;
    }

    public String getCurTargetValue() {
        return this.curTargetValue;
    }

    public void setCurWeightedScore(boolean bl) {
        this.curWeightedScore = bl;
    }

    public boolean isCurWeightedScore() {
        return this.curWeightedScore;
    }

    public void validate(Vector vector) throws Exception {
        if (this.numLiftQuantiles == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_NB_PAIRWISE_THRESHOLD")};
            vector.add(new StateValidation(TestMetricsOptionsStateError.TM_NUM_LIFT_QUANTILE_EMPTY, string, stringArray));
        } else {
            int n = this.numLiftQuantiles;
            if (n < 2 || n > 100) {
                vector.add(new StateValidation(TestMetricsOptionsStateError.TM_NUM_LIFT_QUANTILE_INVALID));
            }
        }
        if (!(this.genLift || this.genROC || this.genConfusionMatrix)) {
            vector.add(new StateValidation(TestMetricsOptionsStateError.TM_NUM_NO_OPTION_SELECTED));
        }
        if ((this.genLift || this.genROC) && this.curTargetValue == null) {
            vector.add(new StateValidation(TargetStateError.TARGET_EMPTY));
        }
    }
}

