/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.datamining.resource.Connection;
import javax.swing.JOptionPane;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.AbstractApplyActivity;
import oracle.dmt.dm4j.activity.AdaptiveBayesApplyActivity;
import oracle.dmt.dm4j.activity.AnomalyDetectionApplyActivity;
import oracle.dmt.dm4j.activity.DecisionTreeApplyActivity;
import oracle.dmt.dm4j.activity.GLMClassificationApplyActivity;
import oracle.dmt.dm4j.activity.GLMRegressionApplyActivity;
import oracle.dmt.dm4j.activity.KMeansApplyActivity;
import oracle.dmt.dm4j.activity.NMFApplyActivity;
import oracle.dmt.dm4j.activity.NaiveBayesApplyActivity;
import oracle.dmt.dm4j.activity.OClusterApplyActivity;
import oracle.dmt.dm4j.activity.SVMClassificationApplyActivity;
import oracle.dmt.dm4j.activity.SVMRegressionApplyActivity;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.AbstractMiningStep;
import oracle.dmt.dm4j.activity.steps.ApplyStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.activity.AdaptiveBayesNetworkApplyDialog;
import oracle.dmt.dm4j.browser.viewer.activity.ClassSupportVectorMachineApplyDialog;
import oracle.dmt.dm4j.browser.viewer.activity.DecisionTreeApplyDialog;
import oracle.dmt.dm4j.browser.viewer.activity.KMeansApplyDialog;
import oracle.dmt.dm4j.browser.viewer.activity.NMFApplyDialog;
import oracle.dmt.dm4j.browser.viewer.activity.NaiveBayesApplyDialog;
import oracle.dmt.dm4j.browser.viewer.activity.OClusterApplyDialog;
import oracle.dmt.dm4j.codegen.CodeGenContext;
import oracle.dmt.dm4j.codegen.CodeTemplate;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.director.minings.ClassificationModelApplyBuilder;
import oracle.dmt.dm4j.wizard.minings.AnomalyDetectionModelApplyWizard;
import oracle.dmt.dm4j.wizard.minings.ClassificationModelApplyWizard;
import oracle.dmt.dm4j.wizard.minings.ClusteringModelApplyWizard;
import oracle.dmt.dm4j.wizard.minings.FeatureExtractionModelApplyWizard;
import oracle.dmt.dm4j.wizard.minings.RegressionModelApplyWizard;
import oracle.dmt.dm4j.wizard.state.minings.AnomalyDetectionModelApplyState;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelApplyState;
import oracle.dmt.dm4j.wizard.state.minings.ClusteringModelApplyState;
import oracle.dmt.dm4j.wizard.state.minings.FeatureExtractionModelApplyState;
import oracle.dmt.dm4j.wizard.state.minings.RegressionModelApplyState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AppliedOutputTableState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateErrorType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.StateWarningType;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.GeneralError;
import oracle.dmt.jdm.resource.OraConnection;

public class ApplyStep
extends AbstractMiningStep {
    private static String DT_ABN_TOPN_USE_CM_BODY = "  ( \n    WITH \n      AO AS ( \n        SELECT it.DMR$CASE_ID, s.*, \n        EXTRACTVALUE(PREDICTION_DETAILS(<MODEL_NAME> USING *), ''/Node/@id'') node \n        FROM (<INPUT_DATA>) it, \n        TABLE(PREDICTION_SET(<MODEL_NAME> using it.*)) s \n      ), \n      CM AS ( \n        <COST_MATRIX_DEFINITION> \n      ), \n      A1 AS ( \n        SELECT AO.DMR$CASE_ID, \n          CM.predicted_target_value prediction, \n          MAX(DECODE(CM.predicted_target_value, AO.prediction, AO.probability, 0)) PROBABILITY, \n          TO_NUMBER(TO_BINARY_DOUBLE(TO_BINARY_FLOAT(SUM(AO.probability*TO_BINARY_DOUBLE(CM.cost))))) COST, \n          MAX(DECODE(CM.predicted_target_value, AO.prediction, AO.node, 0)) <NODE> \n        FROM CM, AO \n        WHERE AO.prediction = CM.actual_target_value \n        GROUP BY AO.DMR$CASE_ID, CM.predicted_target_value \n      ), \n      A2 AS ( \n        SELECT t.*, \n          ROW_NUMBER() OVER (PARTITION BY t.DMR$CASE_ID ORDER BY t.cost ASC, t.prediction ASC) rank \n        FROM A1 t \n      ) \n    -- main query \n    SELECT t.* \n    FROM A2 t \n    WHERE RANK <= <TopN> \n  ) a \n";
    private static String DT_ABN_TOPN_NO_CM_BODY = "  ( \n    SELECT it.DMR$CASE_ID, s.*, \n      EXTRACTVALUE(PREDICTION_DETAILS(<MODEL_NAME> USING *), ''/Node/@id'') <NODE> \n    FROM (<INPUT_DATA>) it, \n    TABLE(PREDICTION_SET(<MODEL_NAME>, <TopN> using it.*)) s \n  ) a \n";
    private static String DT_ABN_TARGET_USE_CM_BODY = "  ( \n    WITH  \n      AO AS ( \n        select it.DMR$CASE_ID, s.*, \n        EXTRACTVALUE(PREDICTION_DETAILS(<MODEL_NAME> USING *), ''/Node/@id'') <NODE> \n        FROM (<INPUT_DATA>) it, \n        TABLE( PREDICTION_SET (<MODEL_NAME> using it.*)) s \n      ), \n      CM AS ( \n        <COST_MATRIX_DEFINITION> \n      ) \n    SELECT AO.DMR$CASE_ID \n      <TARGET_COLUMN_DEFINITION> \n    FROM CM, AO \n    WHERE AO.prediction = CM.actual_target_value  \n    GROUP BY AO.DMR$CASE_ID \n  ) a \n";
    private static String DT_ABN_TARGET_NO_CM_BODY = "  ( \n    SELECT it.DMR$CASE_ID \n      <TARGET_COLUMN_DEFINITION> \n    FROM (<INPUT_DATA>) it \n  ) a \n";
    private static String NB_SVMC_TOPN_USE_CM_BODY = "  ( \n    WITH \n      AO AS ( \n        SELECT it.DMR$CASE_ID, s.* \n        FROM (<INPUT_DATA>) it, \n        TABLE(PREDICTION_SET(<MODEL_NAME> using it.*)) s \n      ), \n      CM AS ( \n        <COST_MATRIX_DEFINITION> \n      ), \n      A1 AS ( \n        SELECT AO.DMR$CASE_ID, \n          CM.predicted_target_value prediction, \n          MAX(DECODE(CM.predicted_target_value, AO.prediction, AO.probability, 0)) PROBABILITY, \n          TO_NUMBER(TO_BINARY_DOUBLE(TO_BINARY_FLOAT(SUM(AO.probability*TO_BINARY_DOUBLE(CM.cost))))) COST \n        FROM CM, AO \n        WHERE AO.prediction = CM.actual_target_value \n        GROUP BY AO.DMR$CASE_ID, CM.predicted_target_value \n      ), \n      A2 AS ( \n        SELECT t.*, \n          ROW_NUMBER() OVER (PARTITION BY t.DMR$CASE_ID ORDER BY t.cost ASC, t.prediction ASC) rank \n        FROM A1 t \n      ) \n    -- main query \n    SELECT t.* \n    FROM A2 t \n    WHERE RANK <= <TopN> \n  ) a \n";
    private static String NB_SVMC_TOPN_NO_CM_BODY = "  ( \n    SELECT it.DMR$CASE_ID, s.* \n    FROM (<INPUT_DATA>) it, \n    TABLE(PREDICTION_SET(<MODEL_NAME>, <TopN> using it.*)) s \n  ) a \n";
    private static String NB_SVMC_TARGET_USE_CM_BODY = "  ( \n    WITH  \n      AO AS ( \n        select it.DMR$CASE_ID, s.* \n        FROM (<INPUT_DATA>) it, \n        TABLE( PREDICTION_SET (<MODEL_NAME> using it.*)) s \n      ), \n      CM AS ( \n        <COST_MATRIX_DEFINITION> \n      ) \n    SELECT AO.DMR$CASE_ID \n      <TARGET_COLUMN_DEFINITION> \n    FROM CM, AO \n    WHERE AO.prediction = CM.actual_target_value  \n    GROUP BY AO.DMR$CASE_ID \n  ) a \n";
    private static String NB_SVMC_TARGET_NO_CM_BODY = "  ( \n    SELECT it.DMR$CASE_ID \n      <TARGET_COLUMN_DEFINITION> \n    FROM (<INPUT_DATA>) it \n  ) a \n";
    private static String GLMC_TOPN_USE_CM_BODY = "  ( \n    WITH  \n      AO AS ( \n        SELECT it.DMR$CASE_ID, s.* \n        FROM (<INPUT_DATA>) it, \n        TABLE(PREDICTION_SET(<MODEL_NAME> using it.*)) s \n      ), \n      CM AS ( \n        <COST_MATRIX_DEFINITION> \n      ), \n      A1 AS ( \n        SELECT AO.DMR$CASE_ID, \n          CM.predicted_target_value prediction, \n          MAX(DECODE(CM.predicted_target_value, AO.prediction, AO.probability, 0)) probability, \n          TO_NUMBER(TO_BINARY_DOUBLE(TO_BINARY_FLOAT(SUM(AO.probability*TO_BINARY_DOUBLE(CM.cost))))) cost \n        FROM CM, AO \n        WHERE AO.prediction = CM.actual_target_value  \n        GROUP BY AO.DMR$CASE_ID, CM.predicted_target_value \n      ), \n      A2 AS ( \n        SELECT t.*, \n          ROW_NUMBER() OVER (PARTITION BY t.DMR$CASE_ID ORDER BY t.cost ASC, t.prediction ASC) rank \n        FROM A1 t \n      ) \n    -- main query \n    SELECT t.* \n    FROM A2 t \n    WHERE RANK <= <TopN> \n  ) a \n";
    private static String GLMC_TOPN_NO_CM_BODY = "  ( \n    SELECT it.DMR$CASE_ID, s.*, \n      PREDICTION_BOUNDS(<MODEL_NAME>, 0.95, s.prediction USING *).LOWER AS PROBABILITY_LOWER_BOUND, \n      PREDICTION_BOUNDS(<MODEL_NAME>, 0.95, s.prediction USING *).UPPER AS PROBABILITY_UPPER_BOUND \n    FROM (<INPUT_DATA>) it, \n    TABLE(PREDICTION_SET(<MODEL_NAME>, <TopN> using it.*)) s \n  ) a \n";
    private static String GLMC_TARGET_USE_CM_BODY = "  ( \n    WITH  \n      AO AS ( \n        SELECT it.DMR$CASE_ID, s.* \n        FROM (<INPUT_DATA>) it, \n        TABLE(PREDICTION_SET(<MODEL_NAME> using it.*)) s \n      ), \n      CM AS ( \n        <COST_MATRIX_DEFINITION> \n      ) \n    SELECT AO.DMR$CASE_ID \n      <TARGET_COLUMN_DEFINITION> \n    FROM CM, AO \n    WHERE AO.prediction = CM.actual_target_value \n    GROUP BY AO.DMR$CASE_ID \n  ) a \n";
    private static String GLMC_TARGET_NO_CM_BODY = "  ( \n    SELECT it.DMR$CASE_ID \n      <TARGET_COLUMN_DEFINITION> \n    FROM (<INPUT_DATA>) it \n  ) a \n";
    private static String OC_KM_CLUSTERID_BODY = "  ( \n    SELECT it.DMR$CASE_ID \n      <CLUSTERID_COLUMN_DEFINITION> \n    FROM (<INPUT_DATA>) it \n  ) a \n";
    private static String OC_KM_TOPN_BODY = "  ( \n    SELECT it.DMR$CASE_ID, s.* \n    FROM (<INPUT_DATA>) it, \n    TABLE(CLUSTER_SET(<MODEL_NAME>, <TopN> USING it.*)) s \n  ) a \n";
    private static String NMF_MATCH_BODY = "  ( \n    SELECT it.DMR$CASE_ID \n      <MATCH_COLUMN_DEFINITION> \n    FROM (<INPUT_DATA>) it \n  ) a \n";
    private static String NMF_TOPN_BODY = "  ( \n    SELECT it.DMR$CASE_ID, s.* \n    FROM (<INPUT_DATA>) it, \n    TABLE(FEATURE_SET(<MODEL_NAME>, <TopN> USING it.*)) s \n  ) a \n";
    private static String SVMR_BODY = "  ( \n    SELECT it.DMR$CASE_ID, \n    ((PREDICTION(<MODEL_NAME> USING *) * <SCALE>) + <SHIFT>) PREDICTION \n    FROM (<INPUT_DATA>) it \n  ) a \n";
    private static String GLMR_BODY = "  ( \n    SELECT it.DMR$CASE_ID, \n    ((PREDICTION(<MODEL_NAME> USING *) * <SCALE>) + <SHIFT>) PREDICTION, \n    ((PREDICTION_BOUNDS(<MODEL_NAME> USING *).LOWER * <SCALE>) + <SHIFT>) AS PREDICTION_LOWER_BOUND, \n    ((PREDICTION_BOUNDS(<MODEL_NAME> USING *).UPPER * <SCALE>) + <SHIFT>) AS PREDICTION_UPPER_BOUND \n    FROM (<INPUT_DATA>) it \n  ) a \n";
    private static String SVMO_BODY = "  ( \n    SELECT it.DMR$CASE_ID, \n    PREDICTION(<MODEL_NAME> USING *) PREDICTION, \n    PREDICTION_PROBABILITY(<MODEL_NAME> USING *) AS PROBABILITY \n    FROM (<INPUT_DATA>) it \n  ) a \n";

    public ApplyStep() {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        this._title = dM4JListResourceBundle.getString("APPLY_STEP_TITLE");
        this.setStepOptions(new ApplyStepOptions());
    }

    public void launchOptionsDialog(AbstractActivity abstractActivity) {
        Object object;
        Exception exception = null;
        try {
            object = null;
            if (abstractActivity instanceof SVMRegressionApplyActivity || abstractActivity instanceof AnomalyDetectionApplyActivity || abstractActivity instanceof GLMRegressionApplyActivity) {
                DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
                String string = dM4JListResourceBundle.getString("ACTIVITY_NO_OPTION_AVAILABLE");
                JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), string, DM4JVersion.getFullBrowserName(), -1, 2, null, null, null);
            } else {
                ComplexDataStructure complexDataStructure = abstractActivity.findPreviousTransformStepOutput(this);
                ComplexDataStructure complexDataStructure2 = abstractActivity.findPreviousTransformSampledStepOutput(this);
                BrowserContext browserContext = new BrowserContext(LaunchPoint.ACTIVITY_GUIDE, abstractActivity, complexDataStructure, complexDataStructure2, ((AbstractApplyActivity)abstractActivity).getModelName());
                browserContext.setStepOptions(this.getStepOptions());
                if (abstractActivity instanceof DecisionTreeApplyActivity) {
                    object = new DecisionTreeApplyDialog(new DM4JDialog(BrowserFrame.getMainFrame()), browserContext, this.getIsComplete());
                } else if (abstractActivity instanceof NaiveBayesApplyActivity) {
                    object = new NaiveBayesApplyDialog(new DM4JDialog(BrowserFrame.getMainFrame()), browserContext, this.getIsComplete());
                } else if (abstractActivity instanceof AdaptiveBayesApplyActivity) {
                    object = new AdaptiveBayesNetworkApplyDialog(new DM4JDialog(BrowserFrame.getMainFrame()), browserContext, this.getIsComplete());
                } else if (abstractActivity instanceof SVMClassificationApplyActivity || abstractActivity instanceof GLMClassificationApplyActivity) {
                    object = new ClassSupportVectorMachineApplyDialog(new DM4JDialog(BrowserFrame.getMainFrame()), browserContext, this.getIsComplete());
                } else if (abstractActivity instanceof NMFApplyActivity) {
                    object = new NMFApplyDialog(new DM4JDialog(BrowserFrame.getMainFrame()), browserContext, this.getIsComplete());
                } else if (abstractActivity instanceof KMeansApplyActivity) {
                    object = new KMeansApplyDialog(new DM4JDialog(BrowserFrame.getMainFrame()), browserContext, this.getIsComplete());
                } else if (abstractActivity instanceof OClusterApplyActivity) {
                    object = new OClusterApplyDialog(new DM4JDialog(BrowserFrame.getMainFrame()), browserContext, this.getIsComplete());
                }
                if (!((DM4JDialog)object).isCancelled()) {
                    final AbstractActivity abstractActivity2 = abstractActivity;
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class SaveOptionThread
                    extends LongRunningProcess {
                        SaveOptionThread() {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                try {
                                    abstractActivity2.store();
                                }
                                catch (Exception exception) {
                                    this.setException(exception);
                                    Object var3_2 = null;
                                    this.getProgressBar().setDoneStatus();
                                }
                                Object var3_1 = null;
                                this.getProgressBar().setDoneStatus();
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                this.getProgressBar().setDoneStatus();
                                throw throwable;
                            }
                        }
                    }
                    SaveOptionThread saveOptionThread = new SaveOptionThread();
                    ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getActivityUIString("ACTIVITY_OPTION_TITLE"), saveOptionThread, true);
                    saveOptionThread.setProgressBar(progressBar);
                    progressBar.start(DM4JResourceUtilities.getActivityUIString("ACTIVITY_SAVING"), "");
                    if (saveOptionThread.getException() != null) {
                        exception = saveOptionThread.getException();
                    }
                }
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception != null) {
            object = exception.getLocalizedMessage();
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), object, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean launchWizard(AbstractActivity abstractActivity, boolean bl) {
        boolean bl2;
        block45: {
            Object object;
            Statement statement;
            java.sql.Connection connection;
            OraConnection oraConnection;
            AbstractApplyActivity abstractApplyActivity;
            block43: {
                Object object2;
                BrowserContext browserContext;
                block40: {
                    Object object3;
                    String string;
                    abstractApplyActivity = (AbstractApplyActivity)abstractActivity;
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    bl2 = false;
                    ComplexDataStructure complexDataStructure = abstractApplyActivity.findPreviousTransformStepOutput(this);
                    ComplexDataStructure complexDataStructure2 = abstractApplyActivity.findPreviousTransformSampledStepOutput(this);
                    string3 = complexDataStructure.getCaseSchema();
                    string2 = complexDataStructure.getCaseTable();
                    string4 = abstractApplyActivity.getModelName();
                    oraConnection = null;
                    connection = null;
                    statement = null;
                    BrowserFrame browserFrame = BrowserFrame.getMainFrame();
                    browserContext = new BrowserContext(LaunchPoint.ACTIVITY_GUIDE, abstractApplyActivity, complexDataStructure, complexDataStructure2, string4);
                    browserContext.setStepOptions(this.getStepOptions());
                    if (!bl) {
                        this.resetValidations();
                        browserContext.setValidations(this.getValidations());
                    } else {
                        browserContext.setValidations(new Vector());
                    }
                    oraConnection = (OraConnection)DM4JConnectionManager.getConnection();
                    connection = oraConnection.getDatabaseConnection();
                    object = BrowserUtils.getActivityBundleInstance();
                    if (this.getOutputDataDescriptor() == null) {
                        string = ValidationUtil.createUniqueTableName("DM4J$T", connection, "");
                        object3 = new ComplexDataStructure(string, string, DM4JConnectionManager.getUser(), null);
                        this.setOutputDataDescriptor((ComplexDataStructure)object3);
                    }
                    string = complexDataStructure.getSQLComplexQueryViewDefinition(DM4JConnectionManager.getUser(), this.getOutputDataDescriptor().getName());
                    statement = connection.createStatement();
                    statement.executeQuery(string);
                    statement.close();
                    statement = null;
                    if (this.getOutputDataUsageView() == null) {
                        object3 = ValidationUtil.createUniqueTableName("DM4J$T", connection, "");
                        object2 = new Table(DM4JConnectionManager.getUser(), (String)object3);
                        this.setOutputDataUsageView((Table)object2);
                    }
                    object3 = null;
                    if (abstractApplyActivity.getSourceIsActivity()) {
                        object3 = this.getSQLSupplementalViewDefinition(DM4JConnectionManager.getUser(), this.getOutputDataDescriptor().getName(), abstractApplyActivity.getSupplementalView(), abstractApplyActivity.getSupplementalTables(), this.getOutputDataUsageView());
                    }
                    if (object3 != null) {
                        statement = connection.createStatement();
                        statement.executeQuery((String)object3);
                        statement.close();
                        statement = null;
                    } else {
                        this.setOutputDataUsageView(null);
                    }
                    if (BrowserUtils.modelExists(oraConnection.getDatabaseConnection(), string4)) break block40;
                    JOptionPane.showMessageDialog(browserFrame, ((ResourceBundle)object).getString("CANNOT_PROCEED_NOMODEL"), DM4JVersion.getFullBrowserName(), 0);
                    boolean bl3 = false;
                    Object var24_23 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (oraConnection != null) {
                            oraConnection.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl3;
                }
                object2 = this.doApplyWizard(abstractApplyActivity, oraConnection, browserContext, bl);
                bl2 = ((oracle.dmt.dm4j.wizard.state.WizardState)object2).isWizardFinished();
                if (bl2) {
                    this.setIsComplete(true);
                    AppliedOutputTableState appliedOutputTableState = (AppliedOutputTableState)((oracle.dmt.dm4j.wizard.state.WizardState)object2).getStep(StepType.OUTPUT_DATA_STEP);
                    String string = appliedOutputTableState.getOutputTableName();
                    string = DM4JStringUtils.trimDoubleQuotes(string);
                    this.setOutputMiningName("\"" + string + "\"");
                    this.setOutputMiningType(this.getLeafNodeModelType(abstractApplyActivity));
                    FinishState finishState = (FinishState)((oracle.dmt.dm4j.wizard.state.WizardState)object2).getStep(StepType.FINISH_STEP);
                    String string5 = DM4JStringUtils.trimDoubleQuotes(finishState.getCostMatrixName());
                    if (string5 != null) {
                        this.setOutputCostMatrix(new Table(DM4JConnectionManager.getUser(), "\"" + string5 + "\""));
                    }
                    if (!bl) {
                        this.setValidations(((oracle.dmt.dm4j.wizard.state.WizardState)object2).getValidations());
                    } else {
                        this.resetValidations();
                    }
                    abstractApplyActivity.store();
                    break block43;
                }
                if (bl) break block43;
                this.setValidations(((oracle.dmt.dm4j.wizard.state.WizardState)object2).getValidations());
                abstractApplyActivity.store();
            }
            Object var24_24 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (oraConnection != null) {
                    oraConnection.close();
                }
                break block45;
            }
            catch (Exception exception) {}
            break block45;
            {
                catch (Exception exception) {
                    try {
                        object = this.getValidations();
                        ((Vector)object).add(new StateValidation((ValidationType)GeneralError.ABNORMAL_FAILURE, exception));
                        this.setValidations((Vector)object);
                        if (this.getOutputDataDescriptor() != null) {
                            this.getOutputDataDescriptor().drop(connection);
                            this.setOutputDataDescriptor(null);
                        }
                        abstractApplyActivity.store();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (this.getOutputDataUsageView() != null) {
                            DatabaseMetadata.dropView(connection, this.getOutputDataUsageView().getSchema(), this.getOutputDataUsageView().getName());
                            this.setOutputDataUsageView(null);
                        }
                    }
                    catch (Exception exception3) {
                    }
                    Object var24_25 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                    try {
                        if (oraConnection != null) {
                            oraConnection.close();
                        }
                        break block45;
                    }
                    catch (Exception exception4) {}
                }
            }
            catch (Throwable throwable) {
                Object var24_26 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (oraConnection != null) {
                        oraConnection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl2;
    }

    public WizardState doApplyWizard(AbstractActivity abstractActivity, Connection connection, BrowserContext browserContext, boolean bl) throws Exception {
        WizardState wizardState = null;
        if (abstractActivity instanceof NaiveBayesApplyActivity || abstractActivity instanceof AdaptiveBayesApplyActivity || abstractActivity instanceof DecisionTreeApplyActivity || abstractActivity instanceof SVMClassificationApplyActivity || abstractActivity instanceof GLMClassificationApplyActivity) {
            ClassificationModelApplyState classificationModelApplyState = new ClassificationModelApplyState(browserContext, connection, false);
            ClassificationModelApplyWizard classificationModelApplyWizard = new ClassificationModelApplyWizard(classificationModelApplyState, false, bl);
            wizardState = classificationModelApplyState;
        } else if (abstractActivity instanceof SVMRegressionApplyActivity || abstractActivity instanceof GLMRegressionApplyActivity) {
            RegressionModelApplyState regressionModelApplyState = new RegressionModelApplyState(browserContext, connection, false);
            RegressionModelApplyWizard regressionModelApplyWizard = new RegressionModelApplyWizard(regressionModelApplyState, false, bl);
            wizardState = regressionModelApplyState;
        } else if (abstractActivity instanceof NMFApplyActivity) {
            FeatureExtractionModelApplyState featureExtractionModelApplyState = new FeatureExtractionModelApplyState(browserContext, connection, false);
            FeatureExtractionModelApplyWizard featureExtractionModelApplyWizard = new FeatureExtractionModelApplyWizard(featureExtractionModelApplyState, false, bl);
            wizardState = featureExtractionModelApplyState;
        } else if (abstractActivity instanceof OClusterApplyActivity || abstractActivity instanceof KMeansApplyActivity) {
            ClusteringModelApplyState clusteringModelApplyState = new ClusteringModelApplyState(browserContext, connection, false);
            ClusteringModelApplyWizard clusteringModelApplyWizard = new ClusteringModelApplyWizard(clusteringModelApplyState, false, bl);
            wizardState = clusteringModelApplyState;
        } else if (abstractActivity instanceof AnomalyDetectionApplyActivity) {
            AnomalyDetectionModelApplyState anomalyDetectionModelApplyState = new AnomalyDetectionModelApplyState(browserContext, connection, false);
            AnomalyDetectionModelApplyWizard anomalyDetectionModelApplyWizard = new AnomalyDetectionModelApplyWizard(anomalyDetectionModelApplyState, false, bl);
            wizardState = anomalyDetectionModelApplyState;
        }
        return wizardState;
    }

    private String getLeafNodeModelType(AbstractActivity abstractActivity) {
        return "APPLY_RESULT";
    }

    public String getDescription() {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
        return dM4JListResourceBundle.getString("APPLY_STEP_INSTRUCTIONS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void reset() {
        block14: {
            Connection connection = null;
            connection = DM4JConnectionManager.getConnection();
            try {
                if (this.getOutputMiningName() != null) {
                    LeafNodeData.removeApplyResult(connection, this.getOutputMiningName(), true, false);
                    this.setOutputMiningName(null);
                }
            }
            catch (Exception exception) {
            }
            Object var4_4 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block14;
            }
            catch (Exception exception) {}
            break block14;
            {
                catch (Exception exception) {
                    Object var4_5 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block14;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        super.reset();
    }

    public String getSQLSupplementalViewDefinition(String string, String string2, Table table, Vector vector, Table table2) {
        String string3 = null;
        if (table != null && (string.compareTo(table.getSchema()) != 0 || string2.compareTo(table.getName()) != 0)) {
            String string4 = "a";
            String string5 = "b";
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer(string4 + ".*");
            StringBuffer stringBuffer2 = new StringBuffer("\"" + string + "\"" + "." + "\"" + string2 + "\" " + string4 + ", \"" + table.getSchema() + "\"" + "." + "\"" + table.getName() + "\" " + string5);
            StringBuffer stringBuffer3 = new StringBuffer(string4 + ".\"" + ActivityUtils.getCaseIdName() + "\" = " + string5 + ".\"" + ActivityUtils.getCaseIdName() + "\"");
            for (int i = 0; i < vector.size(); ++i) {
                Table table3 = (Table)vector.get(i);
                LinkedHashMap linkedHashMap = table3.getColumns();
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    Column column = (Column)entry.getValue();
                    if (!column.getIsInput()) continue;
                    String string6 = string5 + ".\"" + column.getAlias() + "\"";
                    stringBuffer.append(",  \n");
                    stringBuffer.append(string6);
                    ++n;
                }
            }
            if (n > 0) {
                string3 = "CREATE OR REPLACE VIEW \"" + DM4JStringUtils.trimDoubleQuotes(table2.getSchema()) + "\".\"" + DM4JStringUtils.trimDoubleQuotes(table2.getName()) + "\" \n AS SELECT " + stringBuffer + " \n FROM " + stringBuffer2 + " \n WHERE " + stringBuffer3;
            }
        }
        return string3;
    }

    private Column getTargetColumn(AbstractApplyActivity abstractApplyActivity) throws Exception {
        Column column = null;
        try {
            AbstractActivity abstractActivity = AbstractActivity.restore(abstractApplyActivity.getSourceActivityName());
            column = abstractActivity.getTargetColumn();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        return column;
    }

    private Column getUniqueIdentifier(AbstractApplyActivity abstractApplyActivity) throws Exception {
        Column column = abstractApplyActivity.getUniqueIdentifier();
        if (column == null) {
            try {
                AbstractActivity abstractActivity = AbstractActivity.restore(abstractApplyActivity.getSourceActivityName());
                column = abstractActivity.getUniqueIdentifier();
                abstractApplyActivity.setUniqueIdentifier(column);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
        }
        return column;
    }

    private String generateSupplementalSQL(CodeGenContext codeGenContext, StringBuffer stringBuffer, ArrayList arrayList) throws Exception {
        String string = null;
        String string2 = "caseTable";
        try {
            Vector vector = ((AbstractApplyActivity)codeGenContext.getActivity()).getSupplementalTables();
            if (vector != null) {
                Column column = this.getUniqueIdentifier((AbstractApplyActivity)codeGenContext.getActivity());
                String string3 = column == null ? ActivityUtils.getCaseIdName() : column.getName();
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                StringBuffer stringBuffer4 = new StringBuffer();
                int n = vector.size();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    Object object2;
                    Table table = (Table)vector.get(i);
                    int n3 = codeGenContext.get2dDataPos(table.getFullName());
                    String string4 = null;
                    String string5 = null;
                    if (n3 == -1) {
                        string5 = "(' || v_case_data || ') ";
                        string4 = string2;
                    } else {
                        string5 = "(' || additional_data(" + n3 + ") || ') ";
                        string4 = "t" + i;
                        object2 = ((Column)table.getJoinColumns().get(0)).getName();
                        if (stringBuffer4.length() > 0) {
                            stringBuffer4.append(" AND ");
                        }
                        stringBuffer4.append(string2 + "." + DM4JStringUtils.addDoubleQuotes(string3) + " = " + string4 + "." + DM4JStringUtils.addDoubleQuotes((String)object2) + "(+)");
                    }
                    if (i > 0) {
                        stringBuffer3.append(", ");
                    }
                    stringBuffer3.append(string5 + string4);
                    object2 = table.getColumns();
                    for (Map.Entry entry : ((LinkedHashMap)object2).entrySet()) {
                        Column column2 = (Column)entry.getValue();
                        ++n2;
                        if (!column2.getIsInput()) continue;
                        if (stringBuffer2.length() > 0) {
                            stringBuffer2.append(", ");
                        }
                        String string6 = string4 + "." + DM4JStringUtils.addDoubleQuotes(column2.getName()) + " AS " + DM4JStringUtils.addDoubleQuotes(column2.getAlias() == null ? column2.getName() : column2.getAlias());
                        stringBuffer2.append(string6);
                        if (n2 % 10 == 0) {
                            stringBuffer2.append("\n");
                        }
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(DM4JStringUtils.addDoubleQuotes(column2.getAlias() == null ? column2.getName() : column2.getAlias()));
                        if (n2 % 10 == 0) {
                            stringBuffer.append("\n");
                        }
                        if (arrayList == null) continue;
                        arrayList.add(column2);
                    }
                    if (n3 != -1) continue;
                    if (column == null) {
                        if (stringBuffer2.length() > 0) {
                            stringBuffer2.append(", ");
                        }
                        stringBuffer2.append(string2 + "." + ActivityUtils.getCaseIdName());
                        continue;
                    }
                    if (stringBuffer2.indexOf(" AS " + DM4JStringUtils.addDoubleQuotes(column.getName())) >= 0) continue;
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(", ");
                    }
                    String string7 = string2 + "." + DM4JStringUtils.addDoubleQuotes(column.getName());
                    stringBuffer2.append(string7);
                }
                StringBuffer stringBuffer5 = new StringBuffer(DM4JStringUtils.escapeSingleQuotesForSQL(stringBuffer.toString()));
                stringBuffer.setLength(0);
                stringBuffer.append(stringBuffer5);
                if (stringBuffer2.length() > 0) {
                    string = "SELECT " + DM4JStringUtils.escapeSingleQuotesForSQL(stringBuffer2.toString()) + " FROM " + stringBuffer3;
                    if (stringBuffer4.length() > 0) {
                        string = string + " WHERE " + stringBuffer4;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = null;
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
            }
            if (arrayList != null) {
                arrayList.clear();
            }
            throw exception;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void generateCode_old(CodeGenContext codeGenContext) throws Exception {
        block88: {
            java.sql.Connection connection;
            block87: {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Serializable serializable;
                String string;
                ArrayList<Column> arrayList;
                StringBuffer stringBuffer;
                block92: {
                    AbstractActivity abstractActivity;
                    Column column;
                    StringBuffer stringBuffer2;
                    Integer n;
                    String string2;
                    block89: {
                        Object object5;
                        block91: {
                            String string3;
                            Object object6;
                            Object object7;
                            Serializable serializable2;
                            ApplyStepOptions applyStepOptions;
                            block90: {
                                Object object82222;
                                String string4;
                                block85: {
                                    super.generateCode(codeGenContext);
                                    connection = null;
                                    connection = DM4JConnectionManager.getDbConnection();
                                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
                                    applyStepOptions = (ApplyStepOptions)this.getStepOptions();
                                    string2 = applyStepOptions.getCurApplyOption();
                                    n = applyStepOptions.getCurNumberOfTopNPredictions();
                                    Vector vector = applyStepOptions.getCurPredictions();
                                    stringBuffer2 = new StringBuffer();
                                    if (string2.equals(ApplyStepOptions.SPECIFIC_TARGETS)) {
                                        for (int i = 0; i < vector.size(); ++i) {
                                            if (i > 0) {
                                                stringBuffer2.append(", ");
                                            }
                                            stringBuffer2.append("''" + vector.get(i) + "''");
                                        }
                                    }
                                    stringBuffer = new StringBuffer();
                                    column = null;
                                    arrayList = null;
                                    if (codeGenContext.isGenRealtimeAPI()) {
                                        arrayList = new ArrayList<Column>();
                                    }
                                    StringBuffer stringBuffer3 = new StringBuffer();
                                    string = null;
                                    try {
                                        string = this.generateSupplementalSQL(codeGenContext, stringBuffer3, arrayList);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        serializable = new StateValidation(new StateWarningType(){}, dM4JListResourceBundle.getString("CODEGEN_SUPPLEMENTAL_ATTRIBUTES_NOT_FOUND"), new String[]{codeGenContext.getActivity().getName()});
                                        codeGenContext.getValidations().add(serializable);
                                    }
                                    stringBuffer.append("v_tmp_lstmt.ub := 0; -- initialize \nls_append(v_tmp_lstmt, \n  'SELECT " + (stringBuffer3.length() > 0 ? stringBuffer3.toString() + ", " : "") + "a.* FROM '); \n" + "ls_append(v_tmp_lstmt, ' ( '); \n");
                                    if (codeGenContext.isGenRealtimeAPI()) {
                                        column = new Column(ActivityUtils.getCaseIdName());
                                        column.setDataType("NUMBER");
                                        arrayList.add(column);
                                    }
                                    if (!((abstractActivity = codeGenContext.getActivity()) instanceof NaiveBayesApplyActivity) && !(abstractActivity instanceof AdaptiveBayesApplyActivity) && !(abstractActivity instanceof DecisionTreeApplyActivity) && !(abstractActivity instanceof SVMClassificationApplyActivity) && !(abstractActivity instanceof GLMClassificationApplyActivity)) break block89;
                                    serializable = null;
                                    object4 = "VARCHAR2";
                                    try {
                                        serializable = this.getTargetColumn((AbstractApplyActivity)codeGenContext.getActivity());
                                        object4 = ((Column)serializable).getDataType();
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        StateValidation stateValidation = new StateValidation(new StateWarningType(){}, dM4JListResourceBundle.getString("CODEGEN_TARGET_ATTRIBUTE_NOT_FOUND"), new String[]{codeGenContext.getActivity().getName()});
                                        codeGenContext.getValidations().add(stateValidation);
                                    }
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    object3 = DMEMetadata.getInstance();
                                    String string5 = ((DMEMetadata)object3).getModelAlgoType(connection, ((AbstractApplyActivity)codeGenContext.getActivity()).getModelName());
                                    bl2 = string5.compareTo("DECISION_TREE") == 0;
                                    bl = string5.compareTo("ADAPTIVE_BAYES_NETWORK") == 0;
                                    Table table = this.getOutputCostMatrix();
                                    object2 = null;
                                    object = null;
                                    boolean bl3 = false;
                                    if (table != null) {
                                        bl3 = true;
                                        if (!DatabaseMetadata.datasourceExists(connection, table.getSchema(), table.getName())) {
                                            object5 = new StateValidation(new StateWarningType(){}, dM4JListResourceBundle.getString("CODEGEN_COST_MATRIX_NOT_FOUND"), new String[]{codeGenContext.getActivity().getName()});
                                            codeGenContext.getValidations().add(object5);
                                            bl3 = false;
                                        }
                                    }
                                    object5 = null;
                                    if (bl) {
                                        object5 = ClassificationModelApplyBuilder.RULEID_COLUMN_NAME;
                                    } else if (bl2) {
                                        object5 = ClassificationModelApplyBuilder.NODEID_COLUMN_NAME;
                                    }
                                    stringBuffer.append("ls_append(v_tmp_lstmt, \n  'WITH \n  lv2 AS ( \n    SELECT " + ActivityUtils.getCaseIdName() + ", s.prediction, s.probability" + (abstractActivity instanceof GLMClassificationApplyActivity ? ", PROBABILITY_LOWER_BOUND, PROBABILITY_UPPER_BOUND" : "") + (object5 != null ? ", " + (String)object5 : "") + " \n" + "      FROM (SELECT " + ActivityUtils.getCaseIdName() + ", \n" + "              PREDICTION_SET(' || model_name || '" + (table == null && (string2.equals(ApplyStepOptions.PROBABLE_TARGET) || string2.equals(ApplyStepOptions.TOPN_TARGETS)) ? ", " + n : "") + (bl2 && table == null ? " COST MODEL" : "") + " USING *) pset \n" + (abstractActivity instanceof GLMClassificationApplyActivity ? "              , PREDICTION_BOUNDS(' || model_name || ' USING *).LOWER AS PROBABILITY_LOWER_BOUND, PREDICTION_BOUNDS(' || model_name || ' USING *).UPPER AS PROBABILITY_UPPER_BOUND \n" : "") + (object5 != null ? "              , EXTRACTVALUE(PREDICTION_DETAILS(' || model_name || ' USING *), ''/Node/@id'') " + (String)object5 + " \n" : "") + "            FROM ' \n" + ");  \n" + "ls_append(v_tmp_lstmt, \n" + "            v_2d_view \n" + "); \n" + "ls_append(v_tmp_lstmt, \n" + "          ') t, TABLE(t.pset) s \n" + "      ORDER BY " + ActivityUtils.getCaseIdName() + " \n" + "  )' \n" + "); \n");
                                    if (!bl3) break block90;
                                    serializable2 = new StringBuffer();
                                    object7 = null;
                                    object7 = "select ACTUAL_TARGET_VALUE, PREDICTED_TARGET_VALUE, COST from " + table.getFullName();
                                    object2 = connection.createStatement();
                                    object = object2.executeQuery((String)object7);
                                    while (object.next()) {
                                        String string6 = object.getString("ACTUAL_TARGET_VALUE");
                                        object6 = object.getString("PREDICTED_TARGET_VALUE");
                                        double d = object.getDouble("COST");
                                        if (((StringBuffer)serializable2).length() > 0) {
                                            ((StringBuffer)serializable2).append("  union all \n");
                                        }
                                        ((StringBuffer)serializable2).append("    SELECT ''" + string6 + "'' as actual_target_value, ''" + object6 + "'' as predicted_target_value, " + d + " as cost \n" + "    from dual \n");
                                    }
                                    string4 = null;
                                    try {
                                        if (null != object) {
                                            object.close();
                                        }
                                    }
                                    catch (Exception object82222) {
                                        // empty catch block
                                    }
                                    try {
                                        if (null != object2) {
                                            object2.close();
                                        }
                                        break block85;
                                    }
                                    catch (Exception object82222) {}
                                    break block85;
                                    {
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                            string4 = null;
                                            try {
                                                if (null != object) {
                                                    object.close();
                                                }
                                            }
                                            catch (Exception object82222) {
                                                // empty catch block
                                            }
                                            try {
                                                if (null != object2) {
                                                    object2.close();
                                                }
                                                break block85;
                                            }
                                            catch (Exception object82222) {}
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var33_51 = null;
                                        try {
                                            if (null != object) {
                                                object.close();
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        try {
                                            if (null != object2) {
                                                object2.close();
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        throw throwable;
                                    }
                                }
                                stringBuffer.append("ls_append(v_tmp_lstmt, \n  ',lv0 AS ( ');\n");
                                object7 = DM4JStringUtils.chopString(((StringBuffer)serializable2).toString(), 32700);
                                for (int i = 0; i < ((ArrayList)object7).size(); ++i) {
                                    stringBuffer.append("ls_append(v_tmp_lstmt, '" + ((ArrayList)object7).get(i) + "');\n");
                                }
                                stringBuffer.append("ls_append(v_tmp_lstmt, \n  ') ');\n");
                                if (string2.equals(ApplyStepOptions.SPECIFIC_TARGETS)) {
                                    stringBuffer.append("ls_append(v_tmp_lstmt, \n  ',lv1 AS ( \n    SELECT t." + ActivityUtils.getCaseIdName() + ", \n");
                                    Vector vector = applyStepOptions.getCurPredictions();
                                    object6 = applyStepOptions.getCurPredictionColumns();
                                    for (int i = 0; i < vector.size(); ++i) {
                                        string3 = vector.get(i);
                                        String string7 = (String)((HashMap)object6).get(string3);
                                        string7 = DM4JStringUtils.trimDoubleQuotes(string7);
                                        string4 = "\"" + ClassificationModelApplyBuilder.PROBABILITY_COLUMN_NAME + "_" + string7 + "\"";
                                        object82222 = "\"" + ClassificationModelApplyBuilder.COST_COLUMN_NAME + "_" + string7 + "\"";
                                        if (((String)object4).equals("VARCHAR2") || ((String)object4).equals("CHAR")) {
                                            stringBuffer.append("      MAX(DECODE(t.prediction, ''" + string3 + "'', t.probability, 0)) " + string4 + ", \n" + "      SUM(DECODE(c.predicted_target_value, ''" + string3 + "'', t.probability*c.cost, 0)) " + (String)object82222 + " \n");
                                        } else {
                                            stringBuffer.append("      MAX(DECODE(t.prediction, " + string3 + ", t.probability, 0)) " + string4 + ", \n" + "      SUM(DECODE(c.predicted_target_value, " + string3 + ", t.probability*c.cost, 0)) " + (String)object82222 + " \n");
                                        }
                                        if (!codeGenContext.isGenRealtimeAPI()) continue;
                                        column = new Column(string4);
                                        column.setDataType("NUMBER");
                                        arrayList.add(column);
                                        column = new Column((String)object82222);
                                        column.setDataType("NUMBER");
                                        arrayList.add(column);
                                    }
                                    stringBuffer.append("    FROM lv0 c, lv2 t \n    WHERE t.prediction = c.actual_target_value \n    GROUP BY t." + ActivityUtils.getCaseIdName() + "' \n" + "); \n" + "ls_append(v_tmp_lstmt, \n" + "  -- main query \n" + "  'SELECT t.*" + (object5 != null ? ", s." + (String)object5 + " \n" : " \n") + "  FROM lv1 t" + (object5 != null ? ", lv2 s \n" : " \n") + (object5 != null ? "  WHERE t." + ActivityUtils.getCaseIdName() + " = s." + ActivityUtils.getCaseIdName() + " \n" : " \n") + "'); \n");
                                } else {
                                    stringBuffer.append("ls_append(v_tmp_lstmt, \n  ',lv1 AS ( \n    SELECT /*+ ORDERED USE_HASH(c t) PQ_DISTRIBUTE(t BROADCAST, NONE) */ \n      t." + ActivityUtils.getCaseIdName() + ", \n" + "      c.predicted_target_value prediction, \n" + "      MAX(DECODE(c.predicted_target_value, t.prediction, \n" + "      t.probability, 0)) probability, \n" + "      TO_NUMBER( \n" + "      TO_BINARY_DOUBLE(TO_BINARY_FLOAT( \n" + "      SUM(t.probability*TO_BINARY_DOUBLE(c.cost))))) cost \n" + "    FROM lv0 c, lv2 t \n" + "    WHERE t.prediction = c.actual_target_value \n" + "    GROUP BY t." + ActivityUtils.getCaseIdName() + ", c.predicted_target_value)' \n" + "); \n");
                                    if (codeGenContext.isGenRealtimeAPI()) {
                                        column = new Column("PREDICTION");
                                        column.setDataType((String)object4);
                                        arrayList.add(column);
                                        column = new Column(ClassificationModelApplyBuilder.PROBABILITY_COLUMN_NAME);
                                        column.setDataType("NUMBER");
                                        arrayList.add(column);
                                        column = new Column(ClassificationModelApplyBuilder.COST_COLUMN_NAME);
                                        column.setDataType("NUMBER");
                                        arrayList.add(column);
                                    }
                                    if (string2.equals(ApplyStepOptions.TOPN_TARGETS)) {
                                        stringBuffer.append("ls_append(v_tmp_lstmt, \n  ',lv3 AS ( \n    SELECT t.*, \n      ROW_NUMBER() OVER \n      (PARTITION BY t." + ActivityUtils.getCaseIdName() + " \n" + "      ORDER BY t.cost ASC, t.prediction ASC) rank \n" + "    FROM lv1 t) \n" + "  -- main query \n" + "  SELECT t.*" + (object5 != null ? ", s." + (String)object5 + " \n" : " \n") + "  FROM lv3 t" + (object5 != null ? ", lv2 s \n" : " \n") + "  WHERE RANK <= " + n + (object5 != null ? " AND t." + ActivityUtils.getCaseIdName() + " = s." + ActivityUtils.getCaseIdName() + "' \n" : "' \n") + "); \n");
                                        if (codeGenContext.isGenRealtimeAPI()) {
                                            column = new Column("RANK");
                                            column.setDataType("NUMBER");
                                            arrayList.add(column);
                                        }
                                    } else {
                                        stringBuffer.append("ls_append(v_tmp_lstmt, \n  -- main query \n  'SELECT t.*" + (object5 != null ? ", s." + (String)object5 + " \n" : " \n") + "  FROM lv1 t" + (object5 != null ? ", lv2 s \n" : " \n") + (object5 != null ? "  WHERE t." + ActivityUtils.getCaseIdName() + " = s." + ActivityUtils.getCaseIdName() + "' \n" : "' \n") + "); \n");
                                    }
                                }
                                break block91;
                            }
                            if (string2.equals(ApplyStepOptions.SPECIFIC_TARGETS)) {
                                stringBuffer.append("ls_append(v_tmp_lstmt, \n  -- main query \n  'SELECT t.*, \n");
                                serializable2 = applyStepOptions.getCurPredictions();
                                object7 = applyStepOptions.getCurPredictionColumns();
                                for (int i = 0; i < ((Vector)serializable2).size(); ++i) {
                                    object6 = ((Vector)serializable2).get(i);
                                    String string8 = (String)((HashMap)object7).get(object6);
                                    string8 = DM4JStringUtils.trimDoubleQuotes(string8);
                                    string3 = "\"" + ClassificationModelApplyBuilder.PROBABILITY_COLUMN_NAME + "_" + string8 + "\"";
                                    if (((String)object4).equals("VARCHAR2") || ((String)object4).equals("CHAR")) {
                                        stringBuffer.append("    MAX(DECODE(t.prediction, ''" + object6 + "'', t.probability, 0)) " + string3 + ", \n");
                                    } else {
                                        stringBuffer.append("    MAX(DECODE(t.prediction, " + object6 + ", t.probability, 0)) " + string3 + ", \n");
                                    }
                                    if (!codeGenContext.isGenRealtimeAPI()) continue;
                                    column = new Column(string3);
                                    column.setDataType("NUMBER");
                                    arrayList.add(column);
                                }
                                stringBuffer.append("  FROM lv2 t \n  GROUP BY t." + ActivityUtils.getCaseIdName() + "'); \n");
                            } else {
                                if (codeGenContext.isGenRealtimeAPI()) {
                                    column = new Column("PREDICTION");
                                    column.setDataType((String)object4);
                                    arrayList.add(column);
                                    column = new Column(ClassificationModelApplyBuilder.PROBABILITY_COLUMN_NAME);
                                    column.setDataType("NUMBER");
                                    arrayList.add(column);
                                }
                                if (string2.equals(ApplyStepOptions.TOPN_TARGETS)) {
                                    stringBuffer.append("ls_append(v_tmp_lstmt, \n  ',lv3 AS ( \n    SELECT t.*, \n      ROW_NUMBER() OVER \n      (PARTITION BY t." + ActivityUtils.getCaseIdName() + " \n" + "      ORDER BY t.probability desc, t.prediction asc) rank \n" + "    FROM lv2 t) \n" + "  -- main query \n" + "  SELECT t.*" + (object5 != null ? ", s." + (String)object5 + " \n" : " \n") + "  FROM lv3 t" + (object5 != null ? ", lv2 s \n" : " \n") + "  WHERE RANK <= " + n + (object5 != null ? " AND t." + ActivityUtils.getCaseIdName() + " = s." + ActivityUtils.getCaseIdName() + "' \n" : "' \n") + "); \n");
                                    if (codeGenContext.isGenRealtimeAPI()) {
                                        column = new Column("RANK");
                                        column.setDataType("NUMBER");
                                        arrayList.add(column);
                                    }
                                } else {
                                    stringBuffer.append("ls_append(v_tmp_lstmt, \n  -- main query \n  'SELECT t.*" + (object5 != null ? ", s." + (String)object5 + " \n" : " \n") + "  FROM lv2 t" + (object5 != null ? ", lv2 s \n" : " \n") + (object5 != null ? "  WHERE t." + ActivityUtils.getCaseIdName() + " = s." + ActivityUtils.getCaseIdName() + "' \n" : "' \n") + "); \n");
                                }
                            }
                        }
                        if (codeGenContext.isGenRealtimeAPI()) {
                            if (abstractActivity instanceof GLMClassificationApplyActivity) {
                                column = new Column(ClassificationModelApplyBuilder.PROB_LOWER_COLUMN_NAME);
                                column.setDataType("NUMBER");
                                arrayList.add(column);
                                column = new Column(ClassificationModelApplyBuilder.PROB_UPPER_COLUMN_NAME);
                                column.setDataType("NUMBER");
                                arrayList.add(column);
                            }
                            if (object5 != null) {
                                column = new Column((String)object5);
                                column.setDataType("NUMBER");
                                arrayList.add(column);
                            }
                        }
                        break block92;
                    }
                    if (abstractActivity instanceof SVMRegressionApplyActivity || abstractActivity instanceof GLMRegressionApplyActivity) {
                        serializable = null;
                        object4 = DMEMetadata.getInstance();
                        serializable = ((DMEMetadata)object4).getSVModelShiftScale(connection, ((AbstractApplyActivity)codeGenContext.getActivity()).getModelName());
                        double d = (Double)((Hashtable)serializable).get("SHIFT");
                        double d2 = (Double)((Hashtable)serializable).get("SCALE");
                        if (codeGenContext.isGenRealtimeAPI()) {
                            column = new Column(ActivityUtils.getCaseIdName());
                            column.setDataType("NUMBER");
                            arrayList.add(column);
                            column = new Column("PREDICTION");
                            column.setDataType("NUMBER");
                            arrayList.add(column);
                            if (abstractActivity instanceof GLMRegressionApplyActivity) {
                                column = new Column("PREDICTION_LOWER_BOUND");
                                column.setDataType("NUMBER");
                                arrayList.add(column);
                                column = new Column("PREDICTION_UPPER_BOUND");
                                column.setDataType("NUMBER");
                                arrayList.add(column);
                            }
                        }
                        stringBuffer.append("ls_append(v_tmp_lstmt, \n  'SELECT " + ActivityUtils.getCaseIdName() + ", \n" + "     ((PREDICTION(' || model_name || ' USING *) * " + d2 + ") + " + d + ") prediction \n" + (abstractActivity instanceof GLMRegressionApplyActivity ? "   , ((PREDICTION_BOUNDS(' || model_name || ' USING *).LOWER * " + d2 + ") + " + d + ") PREDICTION_LOWER_BOUND, ((PREDICTION_BOUNDS(' || model_name || ' USING *).UPPER * " + d2 + ") + " + d + ") PREDICTION_UPPER_BOUND \n" : " \n") + "  FROM ' \n" + ");  \n" + "ls_append(v_tmp_lstmt, \n" + "  v_2d_view \n" + "); \n");
                    } else if (abstractActivity instanceof NMFApplyActivity) {
                        if (codeGenContext.isGenRealtimeAPI()) {
                            column = new Column(ActivityUtils.getCaseIdName());
                            column.setDataType("NUMBER");
                            arrayList.add(column);
                            column = new Column("FEATURE_ID");
                            column.setDataType("NUMBER");
                            arrayList.add(column);
                            column = new Column("VALUE");
                            column.setDataType("NUMBER");
                            arrayList.add(column);
                        }
                        stringBuffer.append("ls_append(v_tmp_lstmt, \n  'SELECT " + ActivityUtils.getCaseIdName() + ", s.feature_id, s.value \n" + "    FROM (SELECT " + ActivityUtils.getCaseIdName() + ", \n" + "                 FEATURE_SET(' || model_name || '" + (string2.equals(ApplyStepOptions.PROBABLE_TARGET) || string2.equals(ApplyStepOptions.TOPN_TARGETS) ? ", " + n : "") + " USING *) pset \n" + "          FROM ' \n" + ");  \n" + "ls_append(v_tmp_lstmt, \n" + "          v_2d_view \n" + "); \n" + "ls_append(v_tmp_lstmt, \n" + "         ') t, TABLE(t.pset) s \n" + (stringBuffer2.length() > 0 ? "  WHERE s.feature_id in (" + stringBuffer2 + ")' \n" : "' \n") + "); \n");
                    } else if (abstractActivity instanceof OClusterApplyActivity || abstractActivity instanceof KMeansApplyActivity) {
                        if (codeGenContext.isGenRealtimeAPI()) {
                            column = new Column(ActivityUtils.getCaseIdName());
                            column.setDataType("NUMBER");
                            arrayList.add(column);
                            column = new Column("CLUSTER_ID");
                            column.setDataType("NUMBER");
                            arrayList.add(column);
                            column = new Column("PROBABILITY");
                            column.setDataType("NUMBER");
                            arrayList.add(column);
                        }
                        stringBuffer.append("ls_append(v_tmp_lstmt, \n  'SELECT " + ActivityUtils.getCaseIdName() + ", s.cluster_id, s.probability \n" + "    FROM (SELECT " + ActivityUtils.getCaseIdName() + ", \n" + "                 CLUSTER_SET(' || model_name || '" + (string2.equals(ApplyStepOptions.PROBABLE_TARGET) || string2.equals(ApplyStepOptions.TOPN_TARGETS) ? ", " + n : "") + " USING *) pset \n" + "          FROM ' \n" + ");  \n" + "ls_append(v_tmp_lstmt, \n" + "          v_2d_view \n" + "); \n" + "ls_append(v_tmp_lstmt, \n" + "         ') t, TABLE(t.pset) s \n" + (stringBuffer2.length() > 0 ? "  WHERE s.cluster_id in (" + stringBuffer2 + ")' \n" : "' \n") + "); \n");
                    } else if (abstractActivity instanceof AnomalyDetectionApplyActivity) {
                        if (codeGenContext.isGenRealtimeAPI()) {
                            column = new Column(ActivityUtils.getCaseIdName());
                            column.setDataType("NUMBER");
                            arrayList.add(column);
                            column = new Column("PREDICTION");
                            column.setDataType("NUMBER");
                            arrayList.add(column);
                            column = new Column("PROBABILITY");
                            column.setDataType("NUMBER");
                            arrayList.add(column);
                        }
                        stringBuffer.append("ls_append(v_tmp_lstmt, \n  'SELECT " + ActivityUtils.getCaseIdName() + ", \n" + "     PREDICTION(' || model_name || ' USING *) prediction, \n" + "     PREDICTION_PROBABILITY(' || model_name || ' USING *) probability \n" + "  FROM ' \n" + ");  \n" + "ls_append(v_tmp_lstmt, \n" + "  v_2d_view \n" + "); \n");
                    }
                }
                stringBuffer.append("ls_append(v_tmp_lstmt, ' ) a'); \n");
                if (string != null) {
                    serializable = this.getUniqueIdentifier((AbstractApplyActivity)codeGenContext.getActivity());
                    object4 = serializable == null ? ActivityUtils.getCaseIdName() : DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.escapeSingleQuotesForSQL(((Column)serializable).getName()));
                    stringBuffer.append("ls_append(v_tmp_lstmt, ', (" + string + ") b WHERE b." + (String)object4 + " = a." + ActivityUtils.getCaseIdName() + "'); \n");
                }
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<APPLY OPERATION>", stringBuffer.toString());
                if (!codeGenContext.isGenRealtimeAPI()) break block87;
                serializable = new StringBuffer();
                object4 = new StringBuffer();
                StringBuffer stringBuffer4 = new StringBuffer();
                StringBuffer stringBuffer5 = new StringBuffer();
                object3 = new StringBuffer();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    object2 = (Column)arrayList.get(i);
                    object = DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(((Column)object2).getName()));
                    String string9 = DM4JStringUtils.addDoubleQuotes("v_" + DM4JStringUtils.trimDoubleQuotes(((Column)object2).getName()));
                    if (((Column)object2).getDataType().indexOf("CHAR") >= 0) {
                        ((StringBuffer)serializable).append("  " + (String)object + "\t" + "VARCHAR2" + "(128)");
                    } else {
                        ((StringBuffer)serializable).append("  " + (String)object + "\t" + ((Column)object2).getDataType());
                    }
                    if (i < n - 1) {
                        ((StringBuffer)serializable).append(",");
                    }
                    ((StringBuffer)serializable).append("\n");
                    int n2 = 0;
                    if (((Column)object2).getDataType().indexOf("CHAR") >= 0) {
                        n2 = 128;
                        ((StringBuffer)object4).append("  " + string9 + "\t" + "VARCHAR2" + "(128);\n");
                    } else {
                        n2 = 0;
                        ((StringBuffer)object4).append("  " + string9 + "\t" + ((Column)object2).getDataType() + ";\n");
                    }
                    stringBuffer4.append("  DBMS_SQL.DEFINE_COLUMN(v_cursor, " + (i + 1) + ", " + string9 + (n2 > 0 ? ", " + n2 : "") + ");\n");
                    stringBuffer5.append("      DBMS_SQL.COLUMN_VALUE(v_cursor, " + (i + 1) + ", " + string9 + ");\n");
                    ((StringBuffer)object3).append((String)object + " => " + string9);
                    if (i >= n - 1) continue;
                    ((StringBuffer)object3).append(", ");
                }
                CodeTemplate.updateRecordTypeName(codeGenContext.getTemplates(), codeGenContext.getRecordTypeName());
                CodeTemplate.updateRecordTypeTemplate(codeGenContext.getTemplates(), "<TYPE RECORD NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getRecordTypeName())));
                CodeTemplate.updateRecordTypeTemplate(codeGenContext.getTemplates(), "<APPLY RESULT COLUMNS DEFINITION>", ((StringBuffer)serializable).toString());
                CodeTemplate.updateTableTypeName(codeGenContext.getTemplates(), codeGenContext.getTableTypeName());
                CodeTemplate.updateTableTypeTemplate(codeGenContext.getTemplates(), "<TYPE RECORD NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getRecordTypeName())));
                CodeTemplate.updateTableTypeTemplate(codeGenContext.getTemplates(), "<TYPE TABLE NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getTableTypeName())));
                CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<TYPE TABLE NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getTableTypeName())));
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<TYPE TABLE NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getTableTypeName())));
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<TYPE RECORD NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getRecordTypeName())));
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<APPLY RESULT COLUMNS DECLARATION>", ((StringBuffer)object4).toString());
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<DEFINE APPLY RESULT COLUMNS>", stringBuffer4.toString());
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<RETRIEVE APPLY RESULT COLUMNS>", stringBuffer5.toString());
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<apply_result_type_list>", ((StringBuffer)object3).toString());
            }
            Object var36_57 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block88;
            }
            catch (Exception exception) {}
            break block88;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var36_58 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private StringBuffer getCostMatrixSQL(java.sql.Connection connection, String string) throws Exception {
        StringBuffer stringBuffer;
        block17: {
            Statement statement = null;
            ResultSet resultSet = null;
            stringBuffer = new StringBuffer();
            String string2 = null;
            string2 = "select ACTUAL_TARGET_VALUE, PREDICTED_TARGET_VALUE, COST from " + string;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString("ACTUAL_TARGET_VALUE");
                String string4 = resultSet.getString("PREDICTED_TARGET_VALUE");
                double d = resultSet.getDouble("COST");
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("  union all \n");
                }
                stringBuffer.append("    SELECT ''" + DM4JStringUtils.escapeSingleQuotesForSQL(DM4JStringUtils.escapeSingleQuotesForSQL(string3)) + "'' as actual_target_value, ''" + DM4JStringUtils.escapeSingleQuotesForSQL(DM4JStringUtils.escapeSingleQuotesForSQL(string4)) + "'' as predicted_target_value, " + d + " as cost \n" + "    from dual \n");
            }
            Object var12_11 = null;
            try {
                if (null != resultSet) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (null != statement) {
                    statement.close();
                }
                break block17;
            }
            catch (Exception exception) {}
            break block17;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    if (null != resultSet) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (null != statement) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return stringBuffer;
    }

    private StringBuffer getSpecificTargetSQL(CodeGenContext codeGenContext) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        AbstractApplyActivity abstractApplyActivity = (AbstractApplyActivity)codeGenContext.getActivity();
        ApplyStepOptions applyStepOptions = (ApplyStepOptions)this.getStepOptions();
        Table table = this.getOutputCostMatrix();
        Vector vector = applyStepOptions.getCurPredictions();
        HashMap hashMap = applyStepOptions.getCurPredictionColumns();
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            String string2;
            Object e = vector.get(i);
            String string3 = (String)hashMap.get(e);
            string3 = DM4JStringUtils.trimDoubleQuotes(DM4JStringUtils.escapeSingleQuotesForSQL(string3));
            String string4 = "\"" + ClassificationModelApplyBuilder.PROBABILITY_COLUMN_NAME + "_" + string3 + "\"";
            String string5 = "\"" + ClassificationModelApplyBuilder.COST_COLUMN_NAME + "_" + string3 + "\"";
            String string6 = e + "";
            String string7 = "NUMBER";
            Column column = this.getTargetColumn(abstractApplyActivity);
            if (column != null) {
                string7 = column.getDataType();
            }
            if (string7.equals("VARCHAR2") || string7.equals("CHAR")) {
                string6 = "''" + DM4JStringUtils.escapeSingleQuotesForSQL(DM4JStringUtils.escapeSingleQuotesForSQL(string6)) + "''";
            }
            if (abstractApplyActivity instanceof AdaptiveBayesApplyActivity || abstractApplyActivity instanceof DecisionTreeApplyActivity) {
                string2 = abstractApplyActivity instanceof AdaptiveBayesApplyActivity ? ClassificationModelApplyBuilder.RULEID_COLUMN_NAME : ClassificationModelApplyBuilder.NODEID_COLUMN_NAME;
                string = "\"" + string2 + "_" + string3 + "\"";
                if (table != null) {
                    stringBuffer.append("    , SUM(decode(CM.predicted_target_value, " + string6 + ", AO.probability*CM.cost, 0)) " + string5 + " \n" + "    , MAX(DECODE(AO.prediction, " + string6 + ", AO.probability, 0)) " + string4 + " \n" + "    , MAX(DECODE(CM.predicted_target_value, " + string6 + ", AO." + string2 + ", 0)) " + string + " \n");
                    continue;
                }
                stringBuffer.append("    , PREDICTION_PROBABILITY(' || model_name || ', " + string6 + " USING *) " + string4 + " \n" + "    , EXTRACTVALUE(PREDICTION_DETAILS(' || model_name || ' USING *), ''/Node/@id'') " + string + " \n");
                continue;
            }
            if (abstractApplyActivity instanceof NaiveBayesApplyActivity || abstractApplyActivity instanceof SVMClassificationApplyActivity || abstractApplyActivity instanceof GLMClassificationApplyActivity) {
                if (table != null) {
                    stringBuffer.append("    , SUM(decode(CM.predicted_target_value, " + string6 + ", AO.probability*CM.cost, 0)) " + string5 + " \n" + "    , MAX(DECODE(AO.prediction, " + string6 + ", AO.probability, 0)) " + string4 + " \n");
                    continue;
                }
                if (abstractApplyActivity instanceof NaiveBayesApplyActivity || abstractApplyActivity instanceof SVMClassificationApplyActivity) {
                    stringBuffer.append("    , PREDICTION_PROBABILITY(' || model_name || ', " + string6 + " USING *) " + string4 + " \n");
                    continue;
                }
                string2 = "\"PROB_LOWER_" + string3 + "\"";
                string = "\"PROB_UPPER_" + string3 + "\"";
                stringBuffer.append("    , PREDICTION_PROBABILITY(' || model_name || ', " + string6 + " USING *) " + string4 + " \n" + "    , PREDICTION_BOUNDS(' || model_name || ', 0.95, " + string6 + " USING *).LOWER " + string2 + " \n" + "    , PREDICTION_BOUNDS(' || model_name || ', 0.95, " + string6 + " USING *).UPPER " + string + " \n");
                continue;
            }
            if (abstractApplyActivity instanceof OClusterApplyActivity || abstractApplyActivity instanceof KMeansApplyActivity) {
                string2 = "\"CLUSTER_ID_" + string3 + "\"";
                stringBuffer.append("    , CLUSTER_PROBABILITY(' || model_name || ', " + string6 + " USING *) " + string2 + " \n");
                continue;
            }
            if (!(abstractApplyActivity instanceof NMFApplyActivity)) continue;
            string2 = "\"MATCH_" + string3 + "\"";
            stringBuffer.append("    , FEATURE_VALUE(' || model_name || ', " + string6 + " USING *) " + string2 + " \n");
        }
        return stringBuffer;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateCode(CodeGenContext var1_1) throws Exception {
        block83: {
            block81: {
                super.generateCode(var1_1);
                var2_2 = DM4JConnectionManager.getDbConnection();
                var3_3 = BrowserUtils.getActivityBundleInstance();
                try {
                    try {
                        block82: {
                            block90: {
                                block89: {
                                    block88: {
                                        block87: {
                                            block85: {
                                                block86: {
                                                    block84: {
                                                        var4_4 = (ApplyStepOptions)this.getStepOptions();
                                                        var5_6 = var4_4.getCurApplyOption();
                                                        var6_7 = var4_4.getCurNumberOfTopNPredictions();
                                                        var7_8 = null;
                                                        var8_9 = null;
                                                        if (var1_1.isGenRealtimeAPI()) {
                                                            var8_9 = new ArrayList<Column>();
                                                        }
                                                        var9_10 = new StringBuffer();
                                                        var10_11 = null;
                                                        try {
                                                            var10_11 = this.generateSupplementalSQL(var1_1, var9_10, var8_9);
                                                        }
                                                        catch (Exception var11_12) {
                                                            var11_12.printStackTrace();
                                                            var12_14 /* !! */  = new StateValidation(new StateWarningType(){}, var3_3.getString("CODEGEN_SUPPLEMENTAL_ATTRIBUTES_NOT_FOUND"), new String[]{var1_1.getActivity().getName()});
                                                            var1_1.getValidations().add(var12_14 /* !! */ );
                                                        }
                                                        if (var1_1.isGenRealtimeAPI()) {
                                                            var7_8 = new Column(ActivityUtils.getCaseIdName());
                                                            var7_8.setDataType("NUMBER");
                                                            var8_9.add(var7_8);
                                                        }
                                                        var11_13 = null;
                                                        var12_14 /* !! */  = (AbstractApplyActivity)var1_1.getActivity();
                                                        var13_15 = var12_14 /* !! */ .getModelName();
                                                        var14_16 = this.getOutputCostMatrix();
                                                        if (var14_16 != null && !DatabaseMetadata.datasourceExists(var2_2, var14_16.getSchema(), var14_16.getName())) {
                                                            var15_17 = new StateValidation(new StateErrorType(){}, var3_3.getString("CODEGEN_COST_MATRIX_NOT_FOUND"), new String[]{var1_1.getActivity().getName()});
                                                            var1_1.getValidations().add(var15_17);
                                                            var35_19 = null;
                                                            break block81;
                                                        }
                                                        var15_18 = null;
                                                        var16_25 = this.getTargetColumn(var12_14 /* !! */ );
                                                        if (var16_25 != null) {
                                                            var15_18 = var16_25.getDataType();
                                                        }
                                                        if (!(var12_14 /* !! */  instanceof NaiveBayesApplyActivity) && !(var12_14 /* !! */  instanceof SVMClassificationApplyActivity)) break block84;
                                                        if (var5_6.equals(ApplyStepOptions.TOPN_TARGETS) || var5_6.equals(ApplyStepOptions.PROBABLE_TARGET)) {
                                                            if (var1_1.isGenRealtimeAPI()) {
                                                                var7_8 = new Column("PREDICTION");
                                                                var7_8.setDataType(var15_18);
                                                                var8_9.add(var7_8);
                                                                var7_8 = new Column("PROBABILITY");
                                                                var7_8.setDataType("NUMBER");
                                                                var8_9.add(var7_8);
                                                            }
                                                            if (var14_16 != null) {
                                                                if (var1_1.isGenRealtimeAPI()) {
                                                                    var7_8 = new Column(ClassificationModelApplyBuilder.COST_COLUMN_NAME);
                                                                    var7_8.setDataType("NUMBER");
                                                                    var8_9.add(var7_8);
                                                                    var7_8 = new Column("RANK");
                                                                    var7_8.setDataType("NUMBER");
                                                                    var8_9.add(var7_8);
                                                                }
                                                                var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.NB_SVMC_TOPN_USE_CM_BODY, "<MODEL_NAME>", "' || model_name || '");
                                                                var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<COST_MATRIX_DEFINITION>", this.getCostMatrixSQL(var2_2, var14_16.getFullName()).toString());
                                                            } else {
                                                                var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.NB_SVMC_TOPN_NO_CM_BODY, "<MODEL_NAME>", "' || model_name || '");
                                                            }
                                                            var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<TopN>", var6_7.toString());
                                                            break block82;
                                                        } else if (var5_6.equals(ApplyStepOptions.SPECIFIC_TARGETS)) {
                                                            if (var1_1.isGenRealtimeAPI()) {
                                                                var17_26 = var4_4.getCurPredictions();
                                                                var18_28 = var4_4.getCurPredictionColumns();
                                                                for (var19_30 = 0; var19_30 < var17_26.size(); ++var19_30) {
                                                                    var20_37 = var17_26.get(var19_30);
                                                                    var21_43 = (String)var18_28.get(var20_37);
                                                                    var21_43 = DM4JStringUtils.trimDoubleQuotes(var21_43);
                                                                    var22_51 = "\"" + ClassificationModelApplyBuilder.PROBABILITY_COLUMN_NAME + "_" + var21_43 + "\"";
                                                                    if (var14_16 != null) {
                                                                        var23_52 = "\"" + ClassificationModelApplyBuilder.COST_COLUMN_NAME + "_" + var21_43 + "\"";
                                                                        var7_8 = new Column(var23_52);
                                                                        var7_8.setDataType("NUMBER");
                                                                        var8_9.add(var7_8);
                                                                    }
                                                                    var7_8 = new Column((String)var22_51);
                                                                    var7_8.setDataType("NUMBER");
                                                                    var8_9.add(var7_8);
                                                                }
                                                            }
                                                            if (var14_16 != null) {
                                                                var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.NB_SVMC_TARGET_USE_CM_BODY, "<MODEL_NAME>", "' || model_name || '");
                                                                var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<COST_MATRIX_DEFINITION>", this.getCostMatrixSQL(var2_2, var14_16.getFullName()).toString());
                                                            } else {
                                                                var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.NB_SVMC_TARGET_NO_CM_BODY, "<MODEL_NAME>", "' || model_name || '");
                                                            }
                                                            var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<TARGET_COLUMN_DEFINITION>", this.getSpecificTargetSQL(var1_1).toString());
                                                        }
                                                        break block82;
                                                    }
                                                    if (!(var12_14 /* !! */  instanceof AdaptiveBayesApplyActivity) && !(var12_14 /* !! */  instanceof DecisionTreeApplyActivity)) break block85;
                                                    if (!var5_6.equals(ApplyStepOptions.TOPN_TARGETS) && !var5_6.equals(ApplyStepOptions.PROBABLE_TARGET)) break block86;
                                                    if (var1_1.isGenRealtimeAPI()) {
                                                        var7_8 = new Column("PREDICTION");
                                                        var7_8.setDataType(var15_18);
                                                        var8_9.add(var7_8);
                                                        var7_8 = new Column("PROBABILITY");
                                                        var7_8.setDataType("NUMBER");
                                                        var8_9.add(var7_8);
                                                    }
                                                    v0 = var17_26 = var12_14 /* !! */  instanceof AdaptiveBayesApplyActivity != false ? ClassificationModelApplyBuilder.RULEID_COLUMN_NAME : ClassificationModelApplyBuilder.NODEID_COLUMN_NAME;
                                                    if (var14_16 != null) {
                                                        if (var1_1.isGenRealtimeAPI()) {
                                                            var7_8 = new Column(ClassificationModelApplyBuilder.COST_COLUMN_NAME);
                                                            var7_8.setDataType("NUMBER");
                                                            var8_9.add(var7_8);
                                                            var7_8 = new Column((String)var17_26);
                                                            var7_8.setDataType("NUMBER");
                                                            var8_9.add(var7_8);
                                                            var7_8 = new Column("RANK");
                                                            var7_8.setDataType("NUMBER");
                                                            var8_9.add(var7_8);
                                                        }
                                                        var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.DT_ABN_TOPN_USE_CM_BODY, "<MODEL_NAME>", "' || model_name || '");
                                                        var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<COST_MATRIX_DEFINITION>", this.getCostMatrixSQL(var2_2, var14_16.getFullName()).toString());
                                                    } else {
                                                        if (var1_1.isGenRealtimeAPI()) {
                                                            var7_8 = new Column((String)var17_26);
                                                            var7_8.setDataType("NUMBER");
                                                            var8_9.add(var7_8);
                                                        }
                                                        var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.DT_ABN_TOPN_NO_CM_BODY, "<MODEL_NAME>", "' || model_name || '");
                                                    }
                                                    var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<NODE>", (String)var17_26);
                                                    var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<TopN>", var6_7.toString());
                                                    break block82;
                                                }
                                                if (var5_6.equals(ApplyStepOptions.SPECIFIC_TARGETS)) {
                                                    v1 = var17_26 = var12_14 /* !! */  instanceof AdaptiveBayesApplyActivity != false ? ClassificationModelApplyBuilder.RULEID_COLUMN_NAME : ClassificationModelApplyBuilder.NODEID_COLUMN_NAME;
                                                    if (var1_1.isGenRealtimeAPI()) {
                                                        var18_28 = var4_4.getCurPredictions();
                                                        var19_31 = var4_4.getCurPredictionColumns();
                                                        for (var20_38 = 0; var20_38 < var18_28.size(); ++var20_38) {
                                                            var21_44 = var18_28.get(var20_38);
                                                            var22_51 = (String)var19_31.get(var21_44);
                                                            var22_51 = DM4JStringUtils.trimDoubleQuotes((String)var22_51);
                                                            var23_52 = "\"" + ClassificationModelApplyBuilder.PROBABILITY_COLUMN_NAME + "_" + (String)var22_51 + "\"";
                                                            var24_55 = "\"" + (String)var17_26 + "_" + (String)var22_51 + "\"";
                                                            if (var14_16 != null) {
                                                                var25_56 = "\"" + ClassificationModelApplyBuilder.COST_COLUMN_NAME + "_" + (String)var22_51 + "\"";
                                                                var7_8 = new Column((String)var25_56);
                                                                var7_8.setDataType("NUMBER");
                                                                var8_9.add(var7_8);
                                                            }
                                                            var7_8 = new Column(var23_52);
                                                            var7_8.setDataType("NUMBER");
                                                            var8_9.add(var7_8);
                                                            var7_8 = new Column((String)var24_55);
                                                            var7_8.setDataType("NUMBER");
                                                            var8_9.add(var7_8);
                                                        }
                                                    }
                                                    if (var14_16 != null) {
                                                        var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.DT_ABN_TARGET_USE_CM_BODY, "<MODEL_NAME>", "' || model_name || '");
                                                        var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<NODE>", (String)var17_26);
                                                        var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<COST_MATRIX_DEFINITION>", this.getCostMatrixSQL(var2_2, var14_16.getFullName()).toString());
                                                        var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<TARGET_COLUMN_DEFINITION>", this.getSpecificTargetSQL(var1_1).toString());
                                                        break block82;
                                                    } else {
                                                        var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.DT_ABN_TARGET_NO_CM_BODY, "<TARGET_COLUMN_DEFINITION>", this.getSpecificTargetSQL(var1_1).toString());
                                                    }
                                                }
                                                break block82;
                                            }
                                            if (!(var12_14 /* !! */  instanceof GLMClassificationApplyActivity)) break block87;
                                            if (var5_6.equals(ApplyStepOptions.TOPN_TARGETS) || var5_6.equals(ApplyStepOptions.PROBABLE_TARGET)) {
                                                if (var1_1.isGenRealtimeAPI()) {
                                                    var7_8 = new Column("PREDICTION");
                                                    var7_8.setDataType(var15_18);
                                                    var8_9.add(var7_8);
                                                    var7_8 = new Column("PROBABILITY");
                                                    var7_8.setDataType("NUMBER");
                                                    var8_9.add(var7_8);
                                                }
                                                if (var14_16 != null) {
                                                    if (var1_1.isGenRealtimeAPI()) {
                                                        var7_8 = new Column(ClassificationModelApplyBuilder.COST_COLUMN_NAME);
                                                        var7_8.setDataType("NUMBER");
                                                        var8_9.add(var7_8);
                                                        var7_8 = new Column("RANK");
                                                        var7_8.setDataType("NUMBER");
                                                        var8_9.add(var7_8);
                                                    }
                                                    var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.GLMC_TOPN_USE_CM_BODY, "<MODEL_NAME>", "' || model_name || '");
                                                    var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<COST_MATRIX_DEFINITION>", this.getCostMatrixSQL(var2_2, var14_16.getFullName()).toString());
                                                } else {
                                                    if (var1_1.isGenRealtimeAPI()) {
                                                        var7_8 = new Column("PROBABILITY_LOWER_BOUND");
                                                        var7_8.setDataType("NUMBER");
                                                        var8_9.add(var7_8);
                                                        var7_8 = new Column("PROBABILITY_UPPER_BOUND");
                                                        var7_8.setDataType("NUMBER");
                                                        var8_9.add(var7_8);
                                                    }
                                                    var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.GLMC_TOPN_NO_CM_BODY, "<MODEL_NAME>", "' || model_name || '");
                                                }
                                                var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<TopN>", var6_7.toString());
                                                break block82;
                                            } else if (var5_6.equals(ApplyStepOptions.SPECIFIC_TARGETS)) {
                                                if (var1_1.isGenRealtimeAPI()) {
                                                    var17_26 = var4_4.getCurPredictions();
                                                    var18_28 = var4_4.getCurPredictionColumns();
                                                    for (var19_32 = 0; var19_32 < var17_26.size(); ++var19_32) {
                                                        var20_39 = var17_26.get(var19_32);
                                                        var21_45 = (String)var18_28.get(var20_39);
                                                        var21_45 = DM4JStringUtils.trimDoubleQuotes(var21_45);
                                                        var22_51 = "\"" + ClassificationModelApplyBuilder.PROBABILITY_COLUMN_NAME + "_" + var21_45 + "\"";
                                                        var23_52 = "\"" + ClassificationModelApplyBuilder.PROB_LOWER_COLUMN_NAME + "_" + var21_45 + "\"";
                                                        var24_55 = "\"" + ClassificationModelApplyBuilder.PROB_UPPER_COLUMN_NAME + "_" + var21_45 + "\"";
                                                        if (var14_16 != null) {
                                                            var25_56 = "\"" + ClassificationModelApplyBuilder.COST_COLUMN_NAME + "_" + var21_45 + "\"";
                                                            var7_8 = new Column((String)var25_56);
                                                            var7_8.setDataType("NUMBER");
                                                            var8_9.add(var7_8);
                                                        }
                                                        var7_8 = new Column((String)var22_51);
                                                        var7_8.setDataType("NUMBER");
                                                        var8_9.add(var7_8);
                                                        var7_8 = new Column(var23_52);
                                                        var7_8.setDataType("NUMBER");
                                                        var8_9.add(var7_8);
                                                        var7_8 = new Column((String)var24_55);
                                                        var7_8.setDataType("NUMBER");
                                                        var8_9.add(var7_8);
                                                    }
                                                }
                                                if (var14_16 != null) {
                                                    var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.GLMC_TARGET_USE_CM_BODY, "<MODEL_NAME>", "' || model_name || '");
                                                    var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<COST_MATRIX_DEFINITION>", this.getCostMatrixSQL(var2_2, var14_16.getFullName()).toString());
                                                } else {
                                                    var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.GLMC_TARGET_NO_CM_BODY, "<MODEL_NAME>", "' || model_name || '");
                                                }
                                                var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<TARGET_COLUMN_DEFINITION>", this.getSpecificTargetSQL(var1_1).toString());
                                            }
                                            break block82;
                                        }
                                        if (!(var12_14 /* !! */  instanceof SVMRegressionApplyActivity) && !(var12_14 /* !! */  instanceof GLMRegressionApplyActivity)) break block88;
                                        var17_26 = null;
                                        var18_28 = DMEMetadata.getInstance();
                                        var17_26 = var18_28.getSVModelShiftScale(var2_2, ((AbstractApplyActivity)var1_1.getActivity()).getModelName());
                                        var19_33 = (Double)var17_26.get("SHIFT");
                                        var21_46 = (Double)var17_26.get("SCALE");
                                        if (var1_1.isGenRealtimeAPI()) {
                                            var7_8 = new Column("PREDICTION");
                                            var7_8.setDataType(var15_18);
                                            var8_9.add(var7_8);
                                        }
                                        if (var12_14 /* !! */  instanceof SVMRegressionApplyActivity) {
                                            var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.SVMR_BODY, "<MODEL_NAME>", "' || model_name || '");
                                        } else {
                                            if (var1_1.isGenRealtimeAPI()) {
                                                var7_8 = new Column("PREDICTION_LOWER_BOUND");
                                                var7_8.setDataType("NUMBER");
                                                var8_9.add(var7_8);
                                                var7_8 = new Column("PREDICTION_UPPER_BOUND");
                                                var7_8.setDataType("NUMBER");
                                                var8_9.add(var7_8);
                                            }
                                            var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.GLMR_BODY, "<MODEL_NAME>", "' || model_name || '");
                                        }
                                        var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<SCALE>", var21_46 + "");
                                        var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<SHIFT>", var19_33 + "");
                                        break block82;
                                    }
                                    if (!(var12_14 /* !! */  instanceof OClusterApplyActivity) && !(var12_14 /* !! */  instanceof KMeansApplyActivity)) break block89;
                                    if (var5_6.equals(ApplyStepOptions.TOPN_TARGETS) || var5_6.equals(ApplyStepOptions.PROBABLE_TARGET)) {
                                        if (var1_1.isGenRealtimeAPI()) {
                                            var7_8 = new Column("CLUSTER_ID");
                                            var7_8.setDataType("NUMBER");
                                            var8_9.add(var7_8);
                                            var7_8 = new Column("PROBABILITY");
                                            var7_8.setDataType("NUMBER");
                                            var8_9.add(var7_8);
                                        }
                                        var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.OC_KM_TOPN_BODY, "<MODEL_NAME>", "' || model_name || '");
                                        var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<TopN>", var6_7.toString());
                                        break block82;
                                    } else if (var5_6.equals(ApplyStepOptions.SPECIFIC_TARGETS)) {
                                        if (var1_1.isGenRealtimeAPI()) {
                                            var17_26 = var4_4.getCurPredictions();
                                            var18_28 = var4_4.getCurPredictionColumns();
                                            for (var19_34 = 0; var19_34 < var17_26.size(); ++var19_34) {
                                                var20_40 = var17_26.get(var19_34);
                                                var21_47 = (String)var18_28.get(var20_40);
                                                var21_47 = DM4JStringUtils.trimDoubleQuotes(var21_47);
                                                var22_51 = "\"CLUSTER_ID_" + var21_47 + "\"";
                                                var7_8 = new Column((String)var22_51);
                                                var7_8.setDataType("NUMBER");
                                                var8_9.add(var7_8);
                                            }
                                        }
                                        var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.OC_KM_CLUSTERID_BODY, "<CLUSTERID_COLUMN_DEFINITION>", this.getSpecificTargetSQL(var1_1).toString());
                                    }
                                    break block82;
                                }
                                if (!(var12_14 /* !! */  instanceof NMFApplyActivity)) break block90;
                                if (var5_6.equals(ApplyStepOptions.TOPN_TARGETS) || var5_6.equals(ApplyStepOptions.PROBABLE_TARGET)) {
                                    if (var1_1.isGenRealtimeAPI()) {
                                        var7_8 = new Column("FEATURE_ID");
                                        var7_8.setDataType("NUMBER");
                                        var8_9.add(var7_8);
                                        var7_8 = new Column("VALUE");
                                        var7_8.setDataType("NUMBER");
                                        var8_9.add(var7_8);
                                    }
                                    var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.NMF_TOPN_BODY, "<MODEL_NAME>", "' || model_name || '");
                                    var11_13 = DM4JStringUtils.getReplacedString(var11_13, "<TopN>", var6_7.toString());
                                    break block82;
                                } else if (var5_6.equals(ApplyStepOptions.SPECIFIC_TARGETS)) {
                                    if (var1_1.isGenRealtimeAPI()) {
                                        var17_26 = var4_4.getCurPredictions();
                                        var18_28 = var4_4.getCurPredictionColumns();
                                        for (var19_35 = 0; var19_35 < var17_26.size(); ++var19_35) {
                                            var20_41 = var17_26.get(var19_35);
                                            var21_48 = (String)var18_28.get(var20_41);
                                            var21_48 = DM4JStringUtils.trimDoubleQuotes(var21_48);
                                            var22_51 = "\"MATCH_" + var21_48 + "\"";
                                            var7_8 = new Column((String)var22_51);
                                            var7_8.setDataType("NUMBER");
                                            var8_9.add(var7_8);
                                        }
                                    }
                                    var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.NMF_MATCH_BODY, "<MATCH_COLUMN_DEFINITION>", this.getSpecificTargetSQL(var1_1).toString());
                                }
                                break block82;
                            }
                            if (var12_14 /* !! */  instanceof AnomalyDetectionApplyActivity) {
                                if (var1_1.isGenRealtimeAPI()) {
                                    var7_8 = new Column("PREDICTION");
                                    var7_8.setDataType("NUMBER");
                                    var8_9.add(var7_8);
                                    var7_8 = new Column("PROBABILITY");
                                    var7_8.setDataType("NUMBER");
                                    var8_9.add(var7_8);
                                }
                                var11_13 = DM4JStringUtils.getReplacedString(ApplyStep.SVMO_BODY, "<MODEL_NAME>", "' || model_name || '");
                            }
                        }
                        if (var10_11 != null) {
                            var11_13 = "SELECT " + (var9_10.length() > 0 ? var9_10.toString() + ", " : "") + "a.* FROM" + var11_13;
                            var17_26 = this.getUniqueIdentifier(var12_14 /* !! */ );
                            var18_28 = var17_26 == null ? ActivityUtils.getCaseIdName() : DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.escapeSingleQuotesForSQL(var17_26.getName()));
                            var11_13 = var11_13 + ", (" + var10_11 + ") b WHERE b." + (String)var18_28 + " = a." + ActivityUtils.getCaseIdName();
                        } else {
                            var11_13 = "SELECT a.* FROM " + var11_13;
                        }
                        var17_27 = var11_13.lastIndexOf("<INPUT_DATA>");
                        var18_29 = new String("<INPUT_DATA>").length();
                        var19_36 = var11_13.substring(0, var17_27);
                        var20_42 = var11_13.substring(var17_27 + var18_29);
                        var21_50 = new StringBuffer("v_tmp_lstmt.ub := 0; \n");
                        var22_51 = DM4JStringUtils.chopString(var19_36, 32700);
                        for (var23_53 = 0; var23_53 < var22_51.size(); ++var23_53) {
                            var21_50.append("ls_append(v_tmp_lstmt, '" + var22_51.get(var23_53) + "');\n");
                        }
                        var21_50.append("ls_append(v_tmp_lstmt, v_2d_view);\n");
                        var22_51 = DM4JStringUtils.chopString(var20_42, 32700);
                        for (var23_53 = 0; var23_53 < var22_51.size(); ++var23_53) {
                            var21_50.append("ls_append(v_tmp_lstmt, '" + var22_51.get(var23_53) + "');\n");
                        }
                        CodeTemplate.updateBodyTemplate(var1_1.getTemplates(), "<APPLY OPERATION>", var21_50.toString());
                        if (var1_1.isGenRealtimeAPI()) {
                            var23_54 = new StringBuffer();
                            var24_55 = new StringBuffer();
                            var25_56 = new StringBuffer();
                            var26_57 = new StringBuffer();
                            var27_58 = new StringBuffer();
                            var28_59 = var8_9.size();
                            for (var29_60 = 0; var29_60 < var28_59; ++var29_60) {
                                var30_61 = (Column)var8_9.get(var29_60);
                                var31_62 = DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(var30_61.getAlias() == null ? var30_61.getName() : var30_61.getAlias()));
                                var32_63 = DM4JStringUtils.addDoubleQuotes("v_" + DM4JStringUtils.trimDoubleQuotes(var30_61.getAlias() == null ? var30_61.getName() : var30_61.getAlias()));
                                if (var30_61.getDataType().indexOf("CHAR") >= 0) {
                                    var23_54.append("  " + var31_62 + "\t" + "VARCHAR2" + "(128)");
                                } else {
                                    var23_54.append("  " + var31_62 + "\t" + var30_61.getDataType());
                                }
                                if (var29_60 < var28_59 - 1) {
                                    var23_54.append(",");
                                }
                                var23_54.append("\n");
                                var33_64 = 0;
                                if (var30_61.getDataType().indexOf("CHAR") >= 0) {
                                    var33_64 = 128;
                                    var24_55.append("  " + var32_63 + "\t" + "VARCHAR2" + "(128);\n");
                                } else {
                                    var33_64 = 0;
                                    var24_55.append("  " + var32_63 + "\t" + var30_61.getDataType() + ";\n");
                                }
                                var25_56.append("  DBMS_SQL.DEFINE_COLUMN(v_cursor, " + (var29_60 + 1) + ", " + var32_63 + (var33_64 > 0 ? ", " + var33_64 : "") + ");\n");
                                var26_57.append("      DBMS_SQL.COLUMN_VALUE(v_cursor, " + (var29_60 + 1) + ", " + var32_63 + ");\n");
                                var27_58.append(var31_62 + " => " + var32_63);
                                if (var29_60 < var28_59 - 1) {
                                    var27_58.append(", ");
                                }
                                if ((var29_60 + 1) % 10 != 0) continue;
                                var27_58.append("\n");
                            }
                            CodeTemplate.updateRecordTypeName(var1_1.getTemplates(), var1_1.getRecordTypeName());
                            CodeTemplate.updateRecordTypeTemplate(var1_1.getTemplates(), "<TYPE RECORD NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(var1_1.getRecordTypeName())));
                            CodeTemplate.updateRecordTypeTemplate(var1_1.getTemplates(), "<APPLY RESULT COLUMNS DEFINITION>", var23_54.toString());
                            CodeTemplate.updateTableTypeName(var1_1.getTemplates(), var1_1.getTableTypeName());
                            CodeTemplate.updateTableTypeTemplate(var1_1.getTemplates(), "<TYPE RECORD NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(var1_1.getRecordTypeName())));
                            CodeTemplate.updateTableTypeTemplate(var1_1.getTemplates(), "<TYPE TABLE NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(var1_1.getTableTypeName())));
                            CodeTemplate.updateHdrTemplate(var1_1.getTemplates(), "<TYPE TABLE NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(var1_1.getTableTypeName())));
                            CodeTemplate.updateBodyTemplate(var1_1.getTemplates(), "<TYPE TABLE NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(var1_1.getTableTypeName())));
                            CodeTemplate.updateBodyTemplate(var1_1.getTemplates(), "<TYPE RECORD NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(var1_1.getRecordTypeName())));
                            CodeTemplate.updateBodyTemplate(var1_1.getTemplates(), "<APPLY RESULT COLUMNS DECLARATION>", var24_55.toString());
                            CodeTemplate.updateBodyTemplate(var1_1.getTemplates(), "<DEFINE APPLY RESULT COLUMNS>", var25_56.toString());
                            CodeTemplate.updateBodyTemplate(var1_1.getTemplates(), "<RETRIEVE APPLY RESULT COLUMNS>", var26_57.toString());
                            CodeTemplate.updateBodyTemplate(var1_1.getTemplates(), "<apply_result_type_list>", var27_58.toString());
                        }
                        break block83;
                    }
                    catch (Exception var4_5) {
                        var4_5.printStackTrace();
                        throw var4_5;
                    }
                }
                catch (Throwable var34_65) {
                    var35_21 = null;
                    try {
                        if (var2_2 == null) throw var34_65;
                        var2_2.close();
                        throw var34_65;
                    }
                    catch (Exception var36_24) {
                        // empty catch block
                    }
                    throw var34_65;
                }
            }
            ** try [egrp 3[TRYBLOCK] [6 : 4420->4433)] { 
lbl447:
            // 1 sources

            if (var2_2 == null) return;
            var2_2.close();
            return;
lbl450:
            // 1 sources

            catch (Exception var36_22) {
                // empty catch block
            }
            return;
        }
        var35_20 = null;
        try {}
        catch (Exception var36_23) {}
        if (var2_2 == null) return;
        var2_2.close();
        return;
    }
}

