/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.SVMBuildStepOptions;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.SupportVectorMachineAlgorithmStateError;

public class AnomalyDetectionBuildStepOptions
extends SVMBuildStepOptions {
    private Double outliner;

    public AnomalyDetectionBuildStepOptions() {
    }

    public AnomalyDetectionBuildStepOptions(AnomalyDetectionBuildStepOptions anomalyDetectionBuildStepOptions) {
        super(anomalyDetectionBuildStepOptions);
        this.init(anomalyDetectionBuildStepOptions.getOutliner());
    }

    public void init(ActivityType activityType) {
        super.init(activityType);
        this.init(new Double(0.1));
    }

    private void init(Double d) {
        this.outliner = d;
    }

    public void restoreSettings(AnomalyDetectionBuildStepOptions anomalyDetectionBuildStepOptions) {
        super.restoreSettings(anomalyDetectionBuildStepOptions);
        this.setOutliner(anomalyDetectionBuildStepOptions.getOutliner());
    }

    public void setOutliner(Double d) {
        this.outliner = d;
    }

    public Double getOutliner() {
        return this.outliner;
    }

    private void validateOutlierRate(Vector vector) throws Exception {
        if (this.outliner == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_SVM_OUTLINER")};
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_OUTLINER_EMPTY, string, stringArray));
            return;
        }
        if (this.outliner <= 0.0 || this.outliner > 1.0) {
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_OUTLINER_INVALID));
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateOutlierRate(vector);
    }
}

