/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity.steps;

import java.util.HashMap;
import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.BuildStepOptions;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.AdaptiveBayesNetworkAlgorithmStateError;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TargetStateError;
import oracle.dmt.jdm.algorithm.abn.OraABNModelType;

public class ABNBuildStepOptions
extends BuildStepOptions {
    private HashMap curTargetPriors;
    private String curTargetValue;
    private boolean curWeightedScore;
    private boolean curBinaryClass;
    private String mmodelBuildType;
    private Integer runTime;
    private Integer networkFeatureDepth;
    private Integer numberOfNetworkFeatures;
    private Integer numberOfNBNetworkFeatures;
    private Integer prunedNetworkFeatures;

    public ABNBuildStepOptions() {
    }

    public ABNBuildStepOptions(ABNBuildStepOptions aBNBuildStepOptions) {
        this.setCurTargetPriors(aBNBuildStepOptions.getCurTargetPriors());
        this.setCurTargetValue(aBNBuildStepOptions.getCurTargetValue());
        this.setCurWeightedScore(aBNBuildStepOptions.isCurWeightedScore());
        this.setCurBinaryClass(aBNBuildStepOptions.isCurBinaryClass());
        this.setModelBuildType(aBNBuildStepOptions.getModelBuildType());
        this.setRunTime(aBNBuildStepOptions.getRunTime());
        this.setNetworkFeatureDepth(aBNBuildStepOptions.getNetworkFeatureDepth());
        this.setNumberOfNetworkFeatures(aBNBuildStepOptions.getNumberOfNetworkFeatures());
        this.setNumberOfNBNetworkFeatures(aBNBuildStepOptions.getNumberOfNBNetworkFeatures());
        this.setPrunedNetworkFeatures(aBNBuildStepOptions.getPrunedNetworkFeatures());
    }

    public void init(ActivityType activityType) {
        this.initTargetValues(null, null, false);
        this.initAlgorithms();
    }

    public void initTargetValues(HashMap hashMap, String string, boolean bl) {
        this.setCurTargetPriors(hashMap != null ? new HashMap(hashMap) : null);
        this.setCurBinaryClass(string != null);
        this.setCurTargetValue(string);
        this.setCurWeightedScore(bl);
    }

    public void initAlgorithms() {
        this.setModelBuildType(OraABNModelType.singleFeature);
        this.setRunTime(null);
        this.setNetworkFeatureDepth(new Integer(10));
        this.setNumberOfNetworkFeatures(new Integer(25));
        this.setNumberOfNBNetworkFeatures(new Integer(10));
        this.setPrunedNetworkFeatures(new Integer(1));
    }

    public void restoreToDefaultSettings(AbstractActivity abstractActivity) {
        this.initTargetValues(abstractActivity.getBuildPriors(), abstractActivity.getTargetValue(), abstractActivity.useBuildCostMatrix());
        this.initAlgorithms();
    }

    public void restoreSettings(ABNBuildStepOptions aBNBuildStepOptions) {
        this.setCurTargetPriors(aBNBuildStepOptions.getCurTargetPriors());
        this.setCurTargetValue(aBNBuildStepOptions.getCurTargetValue());
        this.setCurWeightedScore(aBNBuildStepOptions.isCurWeightedScore());
        this.setCurBinaryClass(aBNBuildStepOptions.isCurBinaryClass());
        this.setModelBuildType(aBNBuildStepOptions.getModelBuildType());
        this.setRunTime(aBNBuildStepOptions.getRunTime());
        this.setNetworkFeatureDepth(aBNBuildStepOptions.getNetworkFeatureDepth());
        this.setNumberOfNetworkFeatures(aBNBuildStepOptions.getNetworkFeatureDepth());
        this.setNumberOfNBNetworkFeatures(aBNBuildStepOptions.getNumberOfNBNetworkFeatures());
        this.setPrunedNetworkFeatures(aBNBuildStepOptions.getPrunedNetworkFeatures());
        this.setCurTargetPriors(aBNBuildStepOptions.getCurTargetPriors());
    }

    public void setMmodelBuildType(String string) {
        this.mmodelBuildType = string;
    }

    public String getMmodelBuildType() {
        return this.mmodelBuildType;
    }

    public void setModelBuildType(OraABNModelType oraABNModelType) {
        this.setMmodelBuildType(oraABNModelType.name());
    }

    public OraABNModelType getModelBuildType() {
        OraABNModelType oraABNModelType = OraABNModelType.singleFeature;
        try {
            oraABNModelType = OraABNModelType.valueOf(this.getMmodelBuildType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return oraABNModelType;
    }

    public void setRunTime(Integer n) {
        this.runTime = n;
    }

    public Integer getRunTime() {
        return this.runTime;
    }

    public void setNetworkFeatureDepth(Integer n) {
        this.networkFeatureDepth = n;
    }

    public Integer getNetworkFeatureDepth() {
        return this.networkFeatureDepth;
    }

    public void setNumberOfNetworkFeatures(Integer n) {
        this.numberOfNetworkFeatures = n;
    }

    public Integer getNumberOfNetworkFeatures() {
        return this.numberOfNetworkFeatures;
    }

    public void setNumberOfNBNetworkFeatures(Integer n) {
        this.numberOfNBNetworkFeatures = n;
    }

    public Integer getNumberOfNBNetworkFeatures() {
        return this.numberOfNBNetworkFeatures;
    }

    public void setPrunedNetworkFeatures(Integer n) {
        this.prunedNetworkFeatures = n;
    }

    public Integer getPrunedNetworkFeatures() {
        return this.prunedNetworkFeatures;
    }

    private void validateRunTime(Vector vector) throws Exception {
        Integer n = new Integer(0);
        Integer n2 = new Integer(Integer.MAX_VALUE);
        if (this.runTime != null && (this.runTime.compareTo(n) <= 0 || this.runTime.compareTo(n2) > 0)) {
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_RUN_TIME_INVALID));
        }
    }

    private void validateNetworkFeatureDepth(Vector vector) throws Exception {
        Integer n = new Integer(0);
        Integer n2 = new Integer(Integer.MAX_VALUE);
        if (this.networkFeatureDepth == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_ABN_NETWORK_FEATURE_DEPTH")};
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NETWORK_FEATURE_DEPTH_EMPTY, string, stringArray));
        } else if (this.networkFeatureDepth.compareTo(n) <= 0 || this.networkFeatureDepth.compareTo(n2) > 0) {
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NETWORK_FEATURE_DEPTH_INVALID));
        }
    }

    private void validateNumberOfNetworkFeatures(Vector vector) throws Exception {
        Integer n = new Integer(0);
        Integer n2 = new Integer(Integer.MAX_VALUE);
        if (this.numberOfNetworkFeatures == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_ABN_NUMBER_OF_NETWORK_FEATURES")};
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NUMBER_OF_NETWORK_FEATURES_EMPTY, string, stringArray));
        } else if (this.numberOfNetworkFeatures.compareTo(n) <= 0 || this.numberOfNetworkFeatures.compareTo(n2) > 0) {
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NUMBER_OF_NETWORK_FEATURES_INVALID));
        }
    }

    private void validateNumberOfNBNetworkFeatures(Vector vector) throws Exception {
        Integer n = new Integer(0);
        Integer n2 = new Integer(Integer.MAX_VALUE);
        if (this.numberOfNBNetworkFeatures == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_ABN_NB_NUMBER_OF_NETWORK_FEATURES")};
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NB_NUMBER_OF_NETWORK_FEATURES_EMPTY, string, stringArray));
        } else if (this.numberOfNBNetworkFeatures.compareTo(n) <= 0 || this.numberOfNBNetworkFeatures.compareTo(n2) > 0) {
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NB_NUMBER_OF_NETWORK_FEATURES_INVALID));
        }
    }

    private void validatePrunedNetworkFeatures(Vector vector) throws Exception {
        Integer n = new Integer(0);
        Integer n2 = new Integer(Integer.MAX_VALUE);
        if (this.prunedNetworkFeatures == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_ABN_PRUNED_NETWORK_FEATURES")};
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_PRUNED_NETWORK_FEATURES_EMPTY, string, stringArray));
        } else if (this.prunedNetworkFeatures.compareTo(n) <= 0 || this.prunedNetworkFeatures.compareTo(n2) > 0) {
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_PRUNED_NETWORK_FEATURES_INVALID));
        }
    }

    public void validate(Vector vector) throws Exception {
        if (this.isCurBinaryClass() && this.curTargetValue == null) {
            vector.add(new StateValidation(TargetStateError.TARGET_EMPTY));
        }
        if (this.getModelBuildType().compareTo(OraABNModelType.multiFeature) == 0) {
            this.validateNumberOfNetworkFeatures(vector);
            this.validateNumberOfNBNetworkFeatures(vector);
            this.validatePrunedNetworkFeatures(vector);
        } else if (this.getModelBuildType().compareTo(OraABNModelType.singleFeature) == 0) {
            this.validateNumberOfNBNetworkFeatures(vector);
            this.validateNumberOfNetworkFeatures(vector);
        }
        if (this.getModelBuildType().compareTo(OraABNModelType.naiveBayes) == 0) {
            this.validateNumberOfNBNetworkFeatures(vector);
        }
        this.validateRunTime(vector);
    }

    public void setCurTargetPriors(HashMap hashMap) {
        this.curTargetPriors = hashMap;
    }

    public HashMap getCurTargetPriors() {
        return this.curTargetPriors;
    }

    public void setCurTargetValue(String string) {
        this.curTargetValue = string;
    }

    public String getCurTargetValue() {
        return this.curTargetValue;
    }

    public void setCurBinaryClass(boolean bl) {
        this.curBinaryClass = bl;
    }

    public boolean isCurBinaryClass() {
        return this.curBinaryClass;
    }

    public void setTargetValueDataSource(TargetValueDataSource targetValueDataSource) {
        try {
            this.curTargetPriors = targetValueDataSource.getTargetPriorPct();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TargetValueDataSource getTargetValueDataSource(AbstractActivity abstractActivity) {
        TargetValueDataSource targetValueDataSource = null;
        try {
            targetValueDataSource = new TargetValueDataSource(abstractActivity.getTargetPriors(), this.getCurTargetPriors());
            targetValueDataSource.run();
        }
        catch (Exception exception) {
            targetValueDataSource = null;
        }
        return targetValueDataSource;
    }

    public void setCurWeightedScore(boolean bl) {
        this.curWeightedScore = bl;
    }

    public boolean isCurWeightedScore() {
        return this.curWeightedScore;
    }
}

