/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.activity;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.XMLPersistence;
import oracle.dmt.dm4j.activity.AbstractApplyActivity;
import oracle.dmt.dm4j.activity.AbstractTestActivity;
import oracle.dmt.dm4j.activity.Activity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.AdaptiveBayesActivity;
import oracle.dmt.dm4j.activity.AdaptiveBayesApplyActivity;
import oracle.dmt.dm4j.activity.AdaptiveBayesTestActivity;
import oracle.dmt.dm4j.activity.AnomalyDetectionActivity;
import oracle.dmt.dm4j.activity.AnomalyDetectionApplyActivity;
import oracle.dmt.dm4j.activity.AttributeImportanceActivity;
import oracle.dmt.dm4j.activity.DecisionTreeActivity;
import oracle.dmt.dm4j.activity.DecisionTreeApplyActivity;
import oracle.dmt.dm4j.activity.DecisionTreeTestActivity;
import oracle.dmt.dm4j.activity.KMeansActivity;
import oracle.dmt.dm4j.activity.KMeansApplyActivity;
import oracle.dmt.dm4j.activity.NMFActivity;
import oracle.dmt.dm4j.activity.NMFApplyActivity;
import oracle.dmt.dm4j.activity.NaiveBayesActivity;
import oracle.dmt.dm4j.activity.NaiveBayesApplyActivity;
import oracle.dmt.dm4j.activity.NaiveBayesTestActivity;
import oracle.dmt.dm4j.activity.OClusterActivity;
import oracle.dmt.dm4j.activity.OClusterApplyActivity;
import oracle.dmt.dm4j.activity.SVMClassificationActivity;
import oracle.dmt.dm4j.activity.SVMClassificationApplyActivity;
import oracle.dmt.dm4j.activity.SVMClassificationTestActivity;
import oracle.dmt.dm4j.activity.SVMRegressionActivity;
import oracle.dmt.dm4j.activity.SVMRegressionApplyActivity;
import oracle.dmt.dm4j.activity.SVMRegressionTestActivity;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Mapping;
import oracle.dmt.dm4j.activity.data.RelationshipType;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.AbstractMiningStep;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.activity.steps.AbstractTransformationStep;
import oracle.dmt.dm4j.activity.steps.ApplyStep;
import oracle.dmt.dm4j.activity.steps.BuildStep;
import oracle.dmt.dm4j.activity.steps.DiscretizationStep;
import oracle.dmt.dm4j.activity.steps.DiscretizationStepOptions;
import oracle.dmt.dm4j.activity.steps.MissingValuesStep;
import oracle.dmt.dm4j.activity.steps.MissingValuesStepOptions;
import oracle.dmt.dm4j.activity.steps.NormalizeStep;
import oracle.dmt.dm4j.activity.steps.NormalizeStepOptions;
import oracle.dmt.dm4j.activity.steps.ODMrTextStep;
import oracle.dmt.dm4j.activity.steps.ODMrTextTestStep;
import oracle.dmt.dm4j.activity.steps.OutlierTreatmentStepOptions;
import oracle.dmt.dm4j.activity.steps.ResidualPlotStep;
import oracle.dmt.dm4j.activity.steps.SampleStep;
import oracle.dmt.dm4j.activity.steps.SampleStepOptions;
import oracle.dmt.dm4j.activity.steps.SplitStep;
import oracle.dmt.dm4j.activity.steps.SplitStepOptions;
import oracle.dmt.dm4j.activity.steps.TestMetricStep;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.codegen.CodeGenContext;
import oracle.dmt.dm4j.codegen.CodeTemplate;
import oracle.dmt.dm4j.codegen.ProgressDispatcher;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.validation.StateErrorType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.OPAQUE;
import oracle.xdb.XMLType;

public abstract class AbstractActivity
implements Activity,
Serializable {
    protected Vector _steps = new Vector();
    protected String _name = null;
    protected String _comment = null;
    protected Date _timestamp = null;
    private int _version = 0;
    protected ComplexDataStructure _inputDataDescriptor = new ComplexDataStructure();
    protected ComplexDataStructure _sampledInputDataDescriptor;
    protected Table _twodDataSource;
    protected Table _caseTable = null;
    protected Table _sampledCaseTable;
    protected Column _caseColumn = null;
    protected Column _uniqueIdentifier = null;
    protected Table _persistedCaseTable = null;
    protected int _caseCount = 0;
    protected LinkedHashSet _tables = null;
    protected Table _targetTable = null;
    protected Column _targetColumn = null;
    protected String _targetValue = null;
    protected Column _textColumn = null;
    protected Table _textTable = null;
    protected Table _curBuildCostMatrix = null;
    protected boolean _useBuildCostMatrix = false;
    protected Table _curTestCostMatrix = null;
    protected boolean _useTestCostMatrix = false;
    protected Table _thresholdCostMatrix;
    protected HashMap _priors = null;
    protected HashMap _targetPriors;
    public static final int VERSION = 5;

    public abstract void construct();

    public abstract String getTitle();

    public abstract ActivityType getType();

    public abstract String getDescription();

    public void initDefaults() {
        int n = this._steps.size();
        for (int i = 0; i < n; ++i) {
            AbstractStep abstractStep = (AbstractStep)this._steps.get(i);
            AbstractStepOptions abstractStepOptions = abstractStep.getStepOptions();
            abstractStepOptions.init(this.getType());
            if (this._caseCount == 0) continue;
            if (abstractStepOptions instanceof SampleStepOptions) {
                ((SampleStepOptions)abstractStepOptions).setCaseCount(this._caseCount);
                continue;
            }
            if (abstractStepOptions instanceof MissingValuesStepOptions) {
                ((MissingValuesStepOptions)abstractStepOptions).setCaseCount(this._caseCount);
                continue;
            }
            if (abstractStepOptions instanceof DiscretizationStepOptions) {
                ((DiscretizationStepOptions)abstractStepOptions).setCaseCount(this._caseCount);
                continue;
            }
            if (abstractStepOptions instanceof NormalizeStepOptions) {
                ((NormalizeStepOptions)abstractStepOptions).setCaseCount(this._caseCount);
                continue;
            }
            if (abstractStepOptions instanceof OutlierTreatmentStepOptions) {
                ((OutlierTreatmentStepOptions)abstractStepOptions).setCaseCount(this._caseCount);
                continue;
            }
            if (!(abstractStepOptions instanceof SplitStepOptions)) continue;
            ((SplitStepOptions)abstractStepOptions).setCaseCount(this._caseCount);
        }
    }

    public ComplexDataStructure getInputDataDescriptor() {
        return this._inputDataDescriptor;
    }

    public void setInputDataDescriptor(ComplexDataStructure complexDataStructure) {
        this._inputDataDescriptor = complexDataStructure;
    }

    public ComplexDataStructure getSampledInputDataDescriptor() {
        return this._sampledInputDataDescriptor;
    }

    public void setSampledInputDataDescriptor(ComplexDataStructure complexDataStructure) {
        this._sampledInputDataDescriptor = complexDataStructure;
    }

    public void addMissingValuesStep() {
        if (this instanceof AdaptiveBayesActivity || this instanceof AdaptiveBayesApplyActivity || this instanceof AdaptiveBayesTestActivity || this instanceof NaiveBayesActivity || this instanceof NaiveBayesApplyActivity || this instanceof NaiveBayesTestActivity || this instanceof AttributeImportanceActivity || this instanceof DecisionTreeActivity || this instanceof DecisionTreeApplyActivity || this instanceof DecisionTreeTestActivity || this instanceof OClusterActivity || this instanceof OClusterApplyActivity) {
            SampleStep sampleStep = this.findSampleStep();
            MissingValuesStep missingValuesStep = this.findMissingValuesStep();
            if (null == missingValuesStep) {
                missingValuesStep = new MissingValuesStep();
                int n = 0;
                if (sampleStep != null) {
                    n = this._steps.indexOf(sampleStep) + 1;
                }
                this._steps.insertElementAt(missingValuesStep, n);
            }
        }
    }

    public void addTextStep(ODMrTextStep oDMrTextStep) {
        if (this instanceof SVMRegressionActivity || this instanceof SVMRegressionApplyActivity || this instanceof SVMRegressionTestActivity || this instanceof SVMClassificationActivity || this instanceof SVMClassificationApplyActivity || this instanceof SVMClassificationTestActivity || this instanceof KMeansActivity || this instanceof KMeansApplyActivity || this instanceof AnomalyDetectionActivity || this instanceof AnomalyDetectionApplyActivity || this instanceof NMFApplyActivity || this instanceof NMFActivity) {
            BuildStep buildStep = this.findBuildStep();
            ApplyStep applyStep = this.findApplyStep();
            SplitStep splitStep = this.findSplitStep();
            TestMetricStep testMetricStep = this.findTestMetricStep();
            int n = 0;
            if (buildStep != null) {
                n = this._steps.indexOf(buildStep);
                this._steps.insertElementAt(new ODMrTextStep(), n);
                if (splitStep != null && testMetricStep != null) {
                    n = this._steps.indexOf(testMetricStep);
                    this._steps.insertElementAt(new ODMrTextTestStep(), n);
                }
            } else if (applyStep != null) {
                n = this._steps.indexOf(applyStep);
                this._steps.insertElementAt(oDMrTextStep, n);
            } else if (testMetricStep != null) {
                n = this._steps.indexOf(testMetricStep);
                this._steps.insertElementAt(oDMrTextStep, n);
            }
        }
    }

    public void addTextStep() {
        this.addTextStep(new ODMrTextStep());
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(Date date) {
        this._timestamp = date;
    }

    public String getInputSchemaName() {
        return this._twodDataSource.getSchema();
    }

    public Table getTargetTable() {
        return this._targetTable;
    }

    public Table getTwodDataSource() {
        return this._twodDataSource;
    }

    public void setTwodDataSource(Table table) {
        this._twodDataSource = table;
    }

    public void setTargetTable(Table table) {
        this._targetTable = table;
    }

    public Column getTargetColumn() {
        return this._targetColumn;
    }

    public void setTargetColumn(Column column) {
        this._targetColumn = column;
    }

    public String getTargetValue() {
        return this._targetValue;
    }

    public void setTargetValue(String string) {
        this._targetValue = string;
    }

    public Column getTextColumn() {
        return this._textColumn;
    }

    public void setTextColumn(Column column) {
        this._textColumn = column;
    }

    public Table getTextTable() {
        return this._textTable;
    }

    public void setTextTable(Table table) {
        this._textTable = table;
    }

    public Table getCurBuildCostMatrix() {
        return this._curBuildCostMatrix;
    }

    public void setCurBuildCostMatrix(Table table) {
        this._curBuildCostMatrix = table;
    }

    public boolean useBuildCostMatrix() {
        return this._useBuildCostMatrix;
    }

    public void setUseBuildCostMatrix(boolean bl) {
        this._useBuildCostMatrix = bl;
    }

    public boolean getUseBuildCostMatrix() {
        return this._useBuildCostMatrix;
    }

    public Table getCurTestCostMatrix() {
        return this._curTestCostMatrix;
    }

    public void setCurTestCostMatrix(Table table) {
        this._curTestCostMatrix = table;
    }

    public boolean useTestCostMatrix() {
        return this._useTestCostMatrix;
    }

    public void setUseTestCostMatrix(boolean bl) {
        this._useTestCostMatrix = bl;
    }

    public boolean getUseTestCostMatrix() {
        return this._useTestCostMatrix;
    }

    public HashMap getBuildPriors() {
        return this._priors;
    }

    public void setBuildPriors(HashMap hashMap) {
        this._priors = hashMap;
    }

    public void setTargetPriors(HashMap hashMap) {
        this._targetPriors = hashMap;
    }

    public HashMap getTargetPriors() {
        return this._targetPriors;
    }

    public Vector getSteps() {
        return this._steps;
    }

    public void setSteps(Vector vector) {
        this._steps = vector;
    }

    public Table getCaseTable() {
        return this._caseTable;
    }

    public void setCaseTable(Table table) {
        this._caseTable = table;
    }

    public void setSampledCaseTable(Table table) {
        this._sampledCaseTable = table;
    }

    public Table getSampledCaseTable() {
        return this._sampledCaseTable;
    }

    public void setPersistedCaseTable(Table table) {
        this._persistedCaseTable = table;
    }

    public Table getPersistedCaseTable() {
        return this._persistedCaseTable;
    }

    public Column getCaseColumn() {
        return this._caseColumn;
    }

    public void setCaseColumn(Column column) {
        this._caseColumn = column;
    }

    public void setUniqueIdentifier(Column column) {
        this._uniqueIdentifier = column;
    }

    public Column getUniqueIdentifier() {
        return this._uniqueIdentifier;
    }

    public int getCaseCount() {
        return this._caseCount;
    }

    public void setCaseCount(int n) {
        this._caseCount = n;
    }

    public LinkedHashSet getTables() {
        return this._tables;
    }

    public void setTables(LinkedHashSet linkedHashSet) {
        this._tables = linkedHashSet;
    }

    public AbstractStep getStep(int n) {
        return (AbstractStep)this._steps.get(n);
    }

    public int findStepIndex(AbstractStep abstractStep) {
        int n = -1;
        for (int i = 0; i < this._steps.size(); ++i) {
            AbstractStep abstractStep2 = (AbstractStep)this._steps.get(i);
            if (abstractStep != abstractStep2) continue;
            n = i;
            break;
        }
        return n;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setComment(String string) {
        this._comment = string;
    }

    public String getComment() {
        return this._comment;
    }

    /*
     * Loose catch block
     */
    public static AbstractActivity restore(String string) throws Exception {
        Object object;
        Timestamp timestamp;
        String string2;
        String string3;
        block16: {
            Exception exception2222;
            OraclePreparedStatement oraclePreparedStatement;
            Connection connection;
            block15: {
                block14: {
                    connection = null;
                    oraclePreparedStatement = null;
                    OracleResultSet oracleResultSet = null;
                    XMLType xMLType = null;
                    string3 = null;
                    String string4 = null;
                    String string5 = null;
                    string2 = null;
                    timestamp = null;
                    Object var10_10 = null;
                    connection = DM4JConnectionManager.getDbConnection();
                    object = "select NAME, TYPE, ACTIVITY, COMMENTS,CREATION_DATE from DM4J$ACTIVITIES where NAME = ?";
                    oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement((String)object);
                    oraclePreparedStatement.setString(1, string);
                    oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
                    if (!oracleResultSet.next()) break block14;
                    int n = 1;
                    string4 = oracleResultSet.getString(n++);
                    string5 = oracleResultSet.getString(n++);
                    OPAQUE oPAQUE = oracleResultSet.getOPAQUE(n++);
                    xMLType = XMLType.createXML(oPAQUE);
                    string3 = xMLType.getStringVal();
                    string2 = oracleResultSet.getString(n++);
                    timestamp = oracleResultSet.getTimestamp(n++);
                }
                Object var15_15 = null;
                if (null == oraclePreparedStatement) break block15;
                try {
                    oraclePreparedStatement.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            break block16;
            {
                catch (Exception exception3) {
                    throw exception3;
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var15_16 = null;
                if (null != oraclePreparedStatement) {
                    try {
                        oraclePreparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        exception42222.printStackTrace();
                    }
                }
                if (null != connection) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception42222) {
                        exception42222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        object = (AbstractActivity)XMLPersistence.fromXML(string3);
        if (timestamp != null) {
            ((AbstractActivity)object).setTimestamp(new Date(timestamp.getTime()));
        }
        ((AbstractActivity)object).setComment(string2);
        return object;
    }

    public ComplexDataStructure findPreviousTransformStepOutput(AbstractStep abstractStep) {
        AbstractStep abstractStep2 = this.findPreviousTransformStep(abstractStep);
        if (abstractStep2 != null) {
            return abstractStep2.getOutputDataDescriptor();
        }
        return this.getInputDataDescriptor();
    }

    public ComplexDataStructure findPreviousTransformSampledStepOutput(AbstractStep abstractStep) {
        AbstractStep abstractStep2 = this.findPreviousTransformStep(abstractStep);
        if (abstractStep2 != null) {
            return abstractStep2.getSampledOutputDataDescriptor();
        }
        return this.getSampledInputDataDescriptor();
    }

    public AbstractStep findPreviousTransformStep(AbstractStep abstractStep) {
        int n;
        int n2 = n = this.findStepIndex(abstractStep);
        AbstractStep abstractStep2 = null;
        while (n2 > 0) {
            AbstractStep abstractStep3;
            if (!((abstractStep3 = this.getStep(--n2)) instanceof AbstractTransformationStep) && !(abstractStep3 instanceof ODMrTextStep) || !abstractStep3.getIsComplete()) continue;
            abstractStep2 = abstractStep3;
            break;
        }
        return abstractStep2;
    }

    public AbstractStep findLastCompletedStep() {
        int n;
        int n2 = n = this._steps.size();
        AbstractStep abstractStep = null;
        while (n2 > 0) {
            AbstractStep abstractStep2;
            if (!((abstractStep2 = this.getStep(--n2)) instanceof AbstractStep) || !abstractStep2.getIsComplete() || abstractStep2.hasDataMinerErrors()) continue;
            abstractStep = abstractStep2;
            break;
        }
        return abstractStep;
    }

    public AbstractTransformationStep findLastCompletedTransformStep() {
        int n;
        int n2 = n = this._steps.size();
        AbstractTransformationStep abstractTransformationStep = null;
        while (n2 > 0) {
            AbstractStep abstractStep;
            if (!((abstractStep = this.getStep(--n2)) instanceof AbstractTransformationStep) || !abstractStep.getIsComplete() || abstractStep.hasDataMinerErrors()) continue;
            abstractTransformationStep = (AbstractTransformationStep)abstractStep;
            break;
        }
        return abstractTransformationStep;
    }

    public ComplexDataStructure findSplitTestOutput(AbstractStep abstractStep) {
        int n;
        int n2 = n = this.findStepIndex(abstractStep);
        ComplexDataStructure complexDataStructure = null;
        while (n2 > 0) {
            AbstractStep abstractStep2;
            if (!((abstractStep2 = this.getStep(--n2)) instanceof SplitStep) || !abstractStep2.getIsComplete()) continue;
            SplitStep splitStep = (SplitStep)abstractStep2;
            complexDataStructure = splitStep.getTestOutputDataDescriptor();
            break;
        }
        return complexDataStructure;
    }

    public Hashtable findModelStepOutput() {
        Hashtable<String, String> hashtable = null;
        BuildStep buildStep = this.findBuildStep();
        if (buildStep != null && buildStep.getIsComplete()) {
            hashtable = new Hashtable<String, String>(2);
            hashtable.put("SCHEMA", DM4JConnectionManager.getUser());
            hashtable.put("MODEL", buildStep.getOutputMiningName());
            return hashtable;
        }
        return hashtable;
    }

    public AbstractStep findStep(String string) {
        Vector vector = this.getSteps();
        AbstractStep abstractStep = null;
        for (AbstractStep abstractStep2 : vector) {
            if (!abstractStep2.getClass().getName().equals(string)) continue;
            abstractStep = abstractStep2;
            break;
        }
        return abstractStep;
    }

    public SplitStep findSplitStep() {
        return (SplitStep)this.findStep(SplitStep.class.getName());
    }

    public BuildStep findBuildStep() {
        return (BuildStep)this.findStep(BuildStep.class.getName());
    }

    public ApplyStep findApplyStep() {
        return (ApplyStep)this.findStep(ApplyStep.class.getName());
    }

    public TestMetricStep findTestStep() {
        return (TestMetricStep)this.findStep(TestMetricStep.class.getName());
    }

    public SampleStep findSampleStep() {
        return (SampleStep)this.findStep(SampleStep.class.getName());
    }

    public TestMetricStep findTestMetricStep() {
        return (TestMetricStep)this.findStep(TestMetricStep.class.getName());
    }

    public ResidualPlotStep findResidualPlotStep() {
        return (ResidualPlotStep)this.findStep(ResidualPlotStep.class.getName());
    }

    public ODMrTextStep findTextStep() {
        return (ODMrTextStep)this.findStep(ODMrTextStep.class.getName());
    }

    protected AbstractStep findTransformStepOfType(AbstractStep abstractStep) {
        Iterator iterator = this._steps.iterator();
        AbstractStep abstractStep2 = null;
        while (iterator.hasNext()) {
            String string;
            AbstractStep abstractStep3 = (AbstractStep)iterator.next();
            String string2 = abstractStep.getClass().getName();
            if (!string2.equals(string = abstractStep3.getClass().getName())) continue;
            abstractStep2 = abstractStep3;
            break;
        }
        return abstractStep2;
    }

    public MissingValuesStep findMissingValuesStep() {
        return (MissingValuesStep)this.findStep(MissingValuesStep.class.getName());
    }

    public DiscretizationStep findDiscretizationStep() {
        return (DiscretizationStep)this.findStep(DiscretizationStep.class.getName());
    }

    public NormalizeStep findNormalizeStep() {
        return (NormalizeStep)this.findStep(NormalizeStep.class.getName());
    }

    public boolean isSubsequentStepComplete(AbstractStep abstractStep) {
        boolean bl = false;
        int n = this.findStepIndex(abstractStep);
        for (int i = n + 1; i < this._steps.size(); ++i) {
            AbstractStep abstractStep2 = (AbstractStep)this._steps.get(i);
            if (!abstractStep2.getIsComplete()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isSubsequentStepError(AbstractStep abstractStep) {
        boolean bl = false;
        int n = this.findStepIndex(abstractStep);
        for (int i = n + 1; i < this._steps.size(); ++i) {
            AbstractStep abstractStep2 = (AbstractStep)this._steps.get(i);
            if (!abstractStep2.hasDataMinerErrors()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isDataPrepared() throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this._steps.size(); ++i) {
            AbstractStep abstractStep = (AbstractStep)this._steps.get(i);
            if (!(abstractStep instanceof DiscretizationStep)) continue;
            bl2 = true;
            if (!abstractStep.getIsComplete()) break;
            bl = true;
            break;
        }
        if (!bl2) {
            throw new Exception("Activity does not contain a data preparation step");
        }
        return bl;
    }

    public void resetAllSteps() throws Exception {
        this.resetAllSteps(true);
    }

    public boolean resetAllSteps(boolean bl) throws Exception {
        AbstractStep abstractStep = this.getStep(0);
        return this.resetSteps(abstractStep, bl);
    }

    public boolean resetSteps(AbstractStep abstractStep) throws Exception {
        return this.resetSteps(abstractStep, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean resetSteps(AbstractStep var1_1, boolean var2_2) throws Exception {
        var3_3 = BrowserFrame.getMainFrame();
        var4_4 = BrowserUtils.getBundleInstance();
        var5_5 = BrowserUtils.getActivityBundleInstance();
        if (var2_2) {
            block19: {
                var6_6 = JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), var4_4.getString("COMMON_RESET_STEPS_QUESTION"), DM4JVersion.getFullBrowserName(), 0, 2, null, null, null);
                if (var6_6 != 0) {
                    return false;
                }
                var7_8 = this.findStepIndex(var1_1);
                var8_10 = 0;
                var9_12 = false;
                var10_13 = 0;
                var11_14 = this.findBuildStep();
                if (var11_14 != null && (var9_12 = var11_14.getIsComplete()) && var7_8 <= (var8_10 = this.findStepIndex(var11_14))) {
                    var12_15 = DMEMetadata.getInstance();
                    var13_16 = null;
                    try {
                        var13_16 = DM4JConnectionManager.getDbConnection();
                        var10_13 = var12_15.objectOwnedByActivityCount(var13_16, "BUILD", var11_14.getOutputMiningName(), this.getName());
                        var16_17 = null;
                        ** if (null == var13_16) goto lbl-1000
                    }
                    catch (Throwable var15_24) {
                        var16_19 = null;
                        if (null != var13_16) {
                            try {
                                var13_16.close();
                            }
                            catch (Exception var17_22) {
                                var17_22.printStackTrace();
                            }
                        }
                        throw var15_24;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var13_16.close();
                        }
                        catch (Exception var17_20) {
                            var17_20.printStackTrace();
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block19;
                        catch (Exception var14_23) {
                            var14_23.printStackTrace();
                            var16_18 = null;
                            if (null != var13_16) {
                                try {
                                    var13_16.close();
                                }
                                catch (Exception var17_21) {
                                    var17_21.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
            if (var9_12 && var7_8 <= var8_10 && var10_13 > 0 && (var6_6 = JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), var4_4.getString("COMMON_RESET_STEPS_DEL_BUILD_QUESTION"), DM4JVersion.getFullBrowserName(), 0, 2, null, null, null)) != 0) {
                return false;
            }
        }
        var6_7 = new ResetStepThread(var1_1);
        var7_9 = new ProgressBar(BrowserFrame.getMainFrame(), var5_5.getString("ACTIVITY_RESET"), var6_7, true);
        var6_7.setProgressBar(var7_9);
        var7_9.start(var5_5.getString("ACTIVITY_RESETTING_STEPS"), null);
        if (var6_7.getException() != null) {
            JOptionPane.showMessageDialog(var3_3, var5_5.getString("ACTIVITY_FAILED_RESET"), DM4JVersion.getFullBrowserName(), 0);
            throw var6_7.getException();
        }
        if (!var7_9.hasUserCancelled()) {
            try {
                this.store();
            }
            catch (Exception var8_11) {
                JOptionPane.showMessageDialog(var3_3, var5_5.getString("CANNOT_STORE"), DM4JVersion.getFullBrowserName(), 0);
                throw var8_11;
            }
        }
        return true;
    }

    public void removeTransformSteps() throws Exception {
        if (this instanceof AbstractApplyActivity || this instanceof AbstractTestActivity) {
            for (int i = this._steps.size() - 1; i >= 0; --i) {
                AbstractStep abstractStep = (AbstractStep)this._steps.get(i);
                if (!(abstractStep instanceof ODMrTextStep) && !(abstractStep instanceof AbstractTransformationStep)) continue;
                this._steps.remove(i);
            }
        } else {
            throw new Exception("Activity type is not valid for transform step removal");
        }
    }

    /*
     * Loose catch block
     */
    public static HashMap getNamesHash(Connection connection, ActivityType[] activityTypeArray) throws Exception {
        HashMap<String, String> hashMap;
        block18: {
            Exception exception2222;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block17: {
                String string = " WHERE TYPE IN (";
                if (null != activityTypeArray) {
                    for (int i = 0; i < activityTypeArray.length; ++i) {
                        string = i == activityTypeArray.length - 1 ? string + "'" + activityTypeArray[i] + "'" + ")" : string + "'" + activityTypeArray[i] + "'" + ", ";
                    }
                }
                Connection connection2 = connection;
                preparedStatement = null;
                resultSet = null;
                hashMap = new HashMap<String, String>();
                String string2 = "select NAME from DM4J$ACTIVITIES";
                if (activityTypeArray != null) {
                    string2 = string2 + string;
                }
                preparedStatement = connection2.prepareStatement(string2);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    hashMap.put(string3, string3);
                }
                Object var10_11 = null;
                if (null == preparedStatement) break block17;
                try {
                    preparedStatement.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            break block18;
            {
                catch (Exception exception3) {
                    throw exception3;
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var10_12 = null;
                if (null != preparedStatement) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        exception42222.printStackTrace();
                    }
                }
                if (null != resultSet) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        exception42222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        return hashMap;
    }

    public static HashMap getNamesHash(Connection connection) throws Exception {
        return AbstractActivity.getNamesHash(connection, null);
    }

    public static String[] getNames(Connection connection) throws Exception {
        return AbstractActivity.getNames(connection, null);
    }

    /*
     * Loose catch block
     */
    public static String[] getNames(Connection connection, ActivityType[] activityTypeArray) throws Exception {
        Vector<String> vector;
        block18: {
            Exception exception2222;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block17: {
                String string = " WHERE TYPE IN (";
                if (null != activityTypeArray) {
                    for (int i = 0; i < activityTypeArray.length; ++i) {
                        string = i == activityTypeArray.length - 1 ? string + "'" + activityTypeArray[i] + "'" + ")" : string + "'" + activityTypeArray[i] + "'" + ", ";
                    }
                }
                Connection connection2 = connection;
                preparedStatement = null;
                resultSet = null;
                vector = new Vector<String>();
                String string2 = "select NAME from DM4J$ACTIVITIES";
                if (activityTypeArray != null) {
                    string2 = string2 + string + " order by " + "NAME" + " asc";
                }
                preparedStatement = connection2.prepareStatement(string2);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    vector.add(resultSet.getString(1));
                }
                Object var9_10 = null;
                if (null == preparedStatement) break block17;
                try {
                    preparedStatement.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            break block18;
            {
                catch (Exception exception3) {
                    throw exception3;
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var9_11 = null;
                if (null != preparedStatement) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        exception42222.printStackTrace();
                    }
                }
                if (null != resultSet) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        exception42222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        return vector.toArray(new String[0]);
    }

    /*
     * Loose catch block
     */
    public void store() throws Exception {
        block16: {
            Exception exception2222;
            Statement statement;
            Connection connection;
            block15: {
                connection = null;
                statement = null;
                connection = DM4JConnectionManager.getDbConnection();
                String string = XMLPersistence.toXML(this);
                XMLType xMLType = XMLType.createXML(connection, string);
                String string2 = null;
                int n = 1;
                if (AbstractActivity.activityExists(connection, this.getName())) {
                    string2 = "update DM4J$ACTIVITIES set ACTIVITY = ?, COMMENTS = ?  where NAME = ?";
                    statement = (OraclePreparedStatement)connection.prepareStatement(string2);
                    statement.setObject(n++, xMLType);
                    statement.setString(n++, this.getComment());
                    statement.setString(n++, this.getName());
                } else {
                    string2 = "insert into DM4J$ACTIVITIES values (?, ?, ?, ?, ?)";
                    statement = (OraclePreparedStatement)connection.prepareStatement(string2);
                    statement.setString(n++, this.getName());
                    statement.setString(n++, this.getType().toString());
                    statement.setObject(n++, xMLType);
                    statement.setString(n++, this.getComment());
                    statement.setTimestamp(n++, new Timestamp(this.getTimestamp().getTime()));
                }
                statement.executeUpdate();
                connection.commit();
                Object var8_8 = null;
                if (null == statement) break block15;
                try {
                    statement.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            break block16;
            {
                catch (Exception exception3) {
                    throw exception3;
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var8_9 = null;
                if (null != statement) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception42222) {
                        exception42222.printStackTrace();
                    }
                }
                if (null != connection) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception42222) {
                        exception42222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public static boolean activityExists(Connection connection, String string) throws Exception {
        boolean bl;
        block15: {
            Exception exception2222;
            ResultSet resultSet;
            OraclePreparedStatement oraclePreparedStatement;
            block14: {
                block13: {
                    oraclePreparedStatement = null;
                    resultSet = null;
                    bl = false;
                    String string2 = "select NAME from DM4J$ACTIVITIES where NAME = ?";
                    oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string2);
                    oraclePreparedStatement.setString(1, string);
                    oraclePreparedStatement.executeQuery();
                    resultSet = oraclePreparedStatement.executeQuery();
                    if (!resultSet.next()) break block13;
                    bl = true;
                }
                Object var7_7 = null;
                if (null == oraclePreparedStatement) break block14;
                try {
                    oraclePreparedStatement.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    exception2222.printStackTrace();
                }
            }
            break block15;
            {
                catch (Exception exception3) {
                    throw exception3;
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var7_8 = null;
                if (null != oraclePreparedStatement) {
                    try {
                        oraclePreparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        exception42222.printStackTrace();
                    }
                }
                if (null != resultSet) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        exception42222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        return bl;
    }

    public void reset(Connection connection, AbstractActivity abstractActivity) {
        try {
            if (abstractActivity.getInputDataDescriptor() != null) {
                abstractActivity.getInputDataDescriptor().drop(connection);
            }
            abstractActivity.setInputDataDescriptor(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (abstractActivity.getSampledInputDataDescriptor() != null) {
                abstractActivity.getSampledInputDataDescriptor().drop(connection);
            }
            abstractActivity.setSampledInputDataDescriptor(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (abstractActivity.getCurBuildCostMatrix() != null) {
                DatabaseMetadata.dropTable(connection, DM4JConnectionManager.getUser(), abstractActivity.getCurBuildCostMatrix().getName());
            }
            abstractActivity.setCurBuildCostMatrix(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (abstractActivity.getCurTestCostMatrix() != null) {
                DatabaseMetadata.dropTable(connection, DM4JConnectionManager.getUser(), abstractActivity.getCurTestCostMatrix().getName());
            }
            abstractActivity.setCurTestCostMatrix(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (abstractActivity.getPersistedCaseTable() != null) {
                DatabaseMetadata.dropTable(connection, DM4JConnectionManager.getUser(), abstractActivity.getPersistedCaseTable().getName());
            }
            abstractActivity.setPersistedCaseTable(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (abstractActivity.getSampledCaseTable() != null) {
                DatabaseMetadata.dropTable(connection, DM4JConnectionManager.getUser(), abstractActivity.getSampledCaseTable().getName());
            }
            abstractActivity.setSampledCaseTable(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    public static void delete(String string, boolean bl) throws Exception {
        block17: {
            Exception exception3222;
            Statement statement;
            Connection connection;
            block16: {
                connection = null;
                statement = null;
                OraclePreparedStatement oraclePreparedStatement = null;
                AbstractActivity abstractActivity = AbstractActivity.restore(string);
                Vector vector = abstractActivity.getSteps();
                for (int i = 0; i < vector.size(); ++i) {
                    AbstractStep abstractStep = (AbstractStep)vector.get(i);
                    try {
                        if (!abstractStep.getIsComplete()) continue;
                        abstractStep.reset();
                        continue;
                    }
                    catch (Exception exception2) {
                        System.out.println("Could not reset " + abstractStep.getTitle() + " step.");
                    }
                }
                connection = DM4JConnectionManager.getDbConnection();
                abstractActivity.reset(connection, abstractActivity);
                String string2 = "delete from DM4J$ACTIVITIES where NAME = ?";
                oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string2);
                oraclePreparedStatement.setString(1, string);
                oraclePreparedStatement.executeUpdate();
                connection.commit();
                Object var11_12 = null;
                if (null == statement) break block16;
                try {
                    statement.close();
                }
                catch (Exception exception3222) {
                    exception3222.printStackTrace();
                }
            }
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception exception3222) {
                    exception3222.printStackTrace();
                }
            }
            break block17;
            {
                catch (Exception exception4) {
                    exception4.printStackTrace();
                    throw exception4;
                }
            }
            catch (Throwable throwable) {
                Exception exception52222;
                Object var11_13 = null;
                if (null != statement) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception52222) {
                        exception52222.printStackTrace();
                    }
                }
                if (null != connection) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception52222) {
                        exception52222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    protected void generateAPISignature(CodeGenContext codeGenContext) throws Exception {
        Object object;
        LinkedHashSet linkedHashSet = codeGenContext.getActivity().getTables();
        if (linkedHashSet == null) {
            object = codeGenContext.getActivity().getCaseTable();
            Vector<Object[]> vector = new Vector<Object[]>();
            vector.add((Object[])object);
            codeGenContext.getActivity().setTables(new LinkedHashSet(vector));
            linkedHashSet = codeGenContext.getActivity().getTables();
        }
        object = linkedHashSet.toArray();
        int n = 0;
        Table table = null;
        if (codeGenContext.isGenWorkflowAPI()) {
            CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<API NAME WF>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_WF"));
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<API NAME WF>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_WF"));
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<PACKAGE NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getPackageName())));
        }
        if (ActivityType.isAssociationRulesActivity(codeGenContext.getActivity().getType())) {
            Table table2 = null;
            for (n = 0; n < ((Object[])object).length; ++n) {
                table = (Table)object[n];
                if (!table.getRelationship().equals(RelationshipType.getRelationship(2))) continue;
                table2 = table;
                break;
            }
            CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<API NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName())));
            CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<case_table default>", DM4JStringUtils.addSingleQuotes(DM4JStringUtils.getReplacedString(table2.getFullName(), "'", "''")));
            CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<drop_output default>", codeGenContext.isDropResult() ? "TRUE" : "FALSE");
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<CASEID>", ActivityUtils.getCaseIdName());
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<API NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName())));
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<case_table default>", DM4JStringUtils.addSingleQuotes(DM4JStringUtils.getReplacedString(table2.getFullName(), "'", "''")));
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<drop_output default>", codeGenContext.isDropResult() ? "TRUE" : "FALSE");
        } else {
            ODMrTextStep oDMrTextStep = codeGenContext.getActivity().findTextStep();
            if (oDMrTextStep == null) {
                CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<feature_table_name default>", "NULL");
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<feature_table_name default>", "NULL");
                CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<mapping_table_name default>", "NULL");
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<mapping_table_name default>", "NULL");
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            StringBuffer stringBuffer4 = new StringBuffer();
            StringBuffer stringBuffer5 = new StringBuffer();
            StringBuffer stringBuffer6 = new StringBuffer();
            int n2 = 1;
            for (n = 0; n < ((Object[])object).length; ++n) {
                table = (Table)object[n];
                if (table.getRelationship().equals(RelationshipType.getRelationship(0))) continue;
                if (table.getRelationship().equals(RelationshipType.getRelationship(2))) {
                    codeGenContext.setTxnDataPos(table.getFullName(), n2);
                } else if (table.getRelationship().equals(RelationshipType.getRelationship(1))) {
                    codeGenContext.set2dDataPos(table.getFullName(), n2);
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("additional_table_" + n2 + " IN VARCHAR2 ");
                stringBuffer.append("DEFAULT " + DM4JStringUtils.addSingleQuotes(DM4JStringUtils.getReplacedString(table.getFullName(), "'", "''")));
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append("additional_table_" + n2);
                if (codeGenContext.isGenWorkflowAPI()) {
                    stringBuffer3.append("  additional_table_" + n2 + "\tVARCHAR2(62);\n");
                    stringBuffer4.append("    additional_table_" + n2 + " := wf_engine.GetItemAttrText (\n" + "                          itemtype => itemtype,\n" + "                          itemkey => itemkey,\n" + "                          aname => '" + "ADDITIONAL_TABLE_" + n2 + "');\n");
                    if (this instanceof AbstractApplyActivity) {
                        stringBuffer5.append("  additional_sql_" + n2 + "\tVARCHAR2(32767);\n");
                        stringBuffer6.append("    additional_sql_" + n2 + " := wf_engine.GetItemAttrText (\n" + "                          itemtype => itemtype,\n" + "                          itemkey => itemkey,\n" + "                          aname => '" + "ADDITIONAL_SQL_" + n2 + "');\n");
                    }
                }
                ++n2;
            }
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<generate caseid default>", this.getPersistedCaseTable() == null ? "FALSE" : "TRUE");
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<generate text default>", codeGenContext.getActivity().getTextColumn() == null ? "FALSE" : "TRUE");
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<CASEID>", ActivityUtils.getCaseIdName());
            if (stringBuffer.length() == 0) {
                stringBuffer.append("additional_table_1 IN VARCHAR2 DEFAULT NULL");
                stringBuffer2.append("additional_table_1");
            }
            CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<API NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName())));
            CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<case_table default>", DM4JStringUtils.addSingleQuotes(DM4JStringUtils.getReplacedString(this.getCaseTable().getFullName(), "'", "''")));
            CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<additional_table_params>", stringBuffer.toString());
            CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<drop_output default>", codeGenContext.isDropResult() ? "TRUE" : "FALSE");
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<API NAME>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName())));
            CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<API NAME TT>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_TT"));
            CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<API NAME ST>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_ST"));
            if (codeGenContext.isGenRealtimeAPI()) {
                CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<API NAME SR>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_SR"));
                CodeTemplate.updateHdrTemplate(codeGenContext.getTemplates(), "<API NAME SC>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_SC"));
            }
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<API NAME HP>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_HP"));
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<API NAME BT>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_BT"));
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<API NAME TT>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_TT"));
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<API NAME ST>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_ST"));
            if (codeGenContext.isGenRealtimeAPI()) {
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<API NAME RT>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_RT"));
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<API NAME SR>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_SR"));
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<API NAME SC>", DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(codeGenContext.getProcedureName()) + "_SC"));
            }
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<case_table default>", DM4JStringUtils.addSingleQuotes(DM4JStringUtils.getReplacedString(this.getCaseTable().getFullName(), "'", "''")));
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<additional_table_params>", stringBuffer.toString());
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<additional_table_array>", stringBuffer2.toString());
            CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<drop_output default>", codeGenContext.isDropResult() ? "TRUE" : "FALSE");
            if (codeGenContext.isGenWorkflowAPI()) {
                if (stringBuffer3.length() == 0) {
                    stringBuffer3.append("  additional_table_1\tVARCHAR2(62);\n");
                }
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<WF ADDITIONAL TABLES DECLARATION>", stringBuffer3.toString());
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<WF RETRIEVE ADDITIONAL TABLES>", stringBuffer4.toString());
                if (stringBuffer5.length() == 0) {
                    stringBuffer5.append("  additional_sql_1\tVARCHAR2(32767);\n");
                }
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<WF ADDITIONAL SQLS DECLARATION>", stringBuffer5.toString());
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<WF RETRIEVE ADDITIONAL SQLS>", stringBuffer6.toString());
            }
        }
    }

    /*
     * Loose catch block
     */
    protected void generateInputDataPreparation(CodeGenContext codeGenContext) throws Exception {
        block27: {
            Connection connection;
            block26: {
                int n;
                Serializable serializable;
                ComplexDataStructure complexDataStructure = codeGenContext.getActivity().getInputDataDescriptor();
                String string = complexDataStructure.getCaseSchema();
                String string2 = complexDataStructure.getCaseTable();
                connection = null;
                String string3 = null;
                StringBuffer stringBuffer = new StringBuffer("  ----- Start: Input Data Preparation -----\n");
                boolean bl = ActivityType.isApplyActivity(codeGenContext.getActivity().getType());
                boolean bl2 = ActivityType.isBuildActivity(codeGenContext.getActivity().getType());
                boolean bl3 = bl2 && (ActivityType.isClassificationActivity(codeGenContext.getActivity().getType()) || ActivityType.isRegressionActivity(codeGenContext.getActivity().getType()));
                Table table = null;
                connection = DM4JConnectionManager.getDbConnection();
                string3 = DatabaseMetadata.getViewText(connection, string, string2);
                string3 = DM4JStringUtils.escapeSingleQuotesForSQL(string3);
                if (ActivityType.isAssociationRulesActivity(codeGenContext.getActivity().getType())) {
                    Object object;
                    LinkedHashSet linkedHashSet = codeGenContext.getActivity().getTables();
                    Object[] objectArray = linkedHashSet.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        object = (Table)objectArray[i];
                        if (!((Table)object).getRelationship().equals(RelationshipType.getRelationship(2))) continue;
                        table = object;
                        break;
                    }
                    string3 = DM4JStringUtils.getReplacedString(string3, DM4JStringUtils.escapeSingleQuotesForSQL(table.getFullName()), "(' || v_case_data || ')");
                    stringBuffer.append("  v_2d_temp_view := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));\n  ls_append(v_tmp_lstmt, 'CREATE VIEW ');\n  ls_append(v_tmp_lstmt, v_2d_temp_view);\n  ls_append(v_tmp_lstmt, ' AS ');\n");
                    stringBuffer.append("  ls_append(v_tmp_lstmt, '" + string3 + "');\n");
                    stringBuffer.append("  create_table_from_query(v_tmp_lstmt);\n  v_2d_view := v_2d_temp_view;\n");
                    stringBuffer.append("\n");
                    TreeMap treeMap = complexDataStructure.getColumnMap();
                    if (treeMap != null && !treeMap.isEmpty()) {
                        stringBuffer.append("  v_txn_views.EXTEND(1);\n");
                        stringBuffer.append("  v_txn_temp_views.EXTEND(1);\n");
                        stringBuffer.append("\n");
                        object = treeMap.values().iterator();
                        TXColumn tXColumn = (TXColumn)object.next();
                        String string4 = tXColumn.getTxSchemaName();
                        String string5 = tXColumn.getTxTableName();
                        string3 = DatabaseMetadata.getViewText(connection, string4, string5);
                        string3 = DM4JStringUtils.escapeSingleQuotesForSQL(string3);
                        string3 = DM4JStringUtils.getReplacedString(string3, DM4JStringUtils.escapeSingleQuotesForSQL(table.getFullName()), "(' || v_case_data || ')");
                        stringBuffer.append("  v_tmp_lstmt.ub := 0; -- initialize\n");
                        stringBuffer.append("  v_txn_temp_views(1) := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));\n  ls_append(v_tmp_lstmt, 'CREATE VIEW ');\n  ls_append(v_tmp_lstmt, v_txn_temp_views(1));\n  ls_append(v_tmp_lstmt, ' AS ');\n");
                        stringBuffer.append("  ls_append(v_tmp_lstmt,\n  '" + string3 + "'\n" + "  );\n");
                        stringBuffer.append("  create_table_from_query(v_tmp_lstmt);\n  v_txn_views(1) := v_txn_temp_views(1);\n");
                        stringBuffer.append("\n");
                    }
                    CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<INPUT DATA PREPARATION>", stringBuffer.toString());
                    break block26;
                }
                table = this.getPersistedCaseTable() == null ? this.getCaseTable() : this.getPersistedCaseTable();
                string3 = DM4JStringUtils.getReplacedString(string3, DM4JStringUtils.escapeSingleQuotesForSQL(table.getFullName()), "(' || v_case_data || ') " + DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.escapeSingleQuotesForSQL(table.getName())));
                LinkedHashSet linkedHashSet = codeGenContext.getActivity().getTables();
                Iterator iterator = linkedHashSet.iterator();
                int n2 = 1;
                while (iterator.hasNext()) {
                    serializable = (Table)iterator.next();
                    if (!((Table)serializable).getRelationship().equals(RelationshipType.getRelationship(1))) continue;
                    n = codeGenContext.get2dDataPos(((Table)serializable).getFullName());
                    string3 = DM4JStringUtils.getReplacedString(string3, DM4JStringUtils.escapeSingleQuotesForSQL(((Table)serializable).getFullName()), "(' || additional_data(" + n + ") || ') " + DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.escapeSingleQuotesForSQL(((Table)serializable).getName())));
                }
                serializable = DM4JStringUtils.chopString(string3, 32700);
                if (!bl) {
                    stringBuffer.append("  v_2d_temp_view := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));\n  ls_append(v_tmp_lstmt, 'CREATE VIEW ');\n  ls_append(v_tmp_lstmt, v_2d_temp_view);\n  ls_append(v_tmp_lstmt, ' AS ');\n");
                }
                stringBuffer.append("  ls_append(v_tmp_lstmt, ' ( ');\n");
                for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                    stringBuffer.append("  ls_append(v_tmp_lstmt, '" + ((ArrayList)serializable).get(i) + "');\n");
                }
                stringBuffer.append("  ls_append(v_tmp_lstmt, ' ) ');\n");
                if (!bl) {
                    stringBuffer.append("  create_table_from_query(v_tmp_lstmt);\n  v_2d_view := v_2d_temp_view;\n");
                } else {
                    stringBuffer.append("  v_2d_view := v_tmp_lstmt;\n");
                }
                stringBuffer.append("\n");
                TreeMap treeMap = complexDataStructure.getColumnMap();
                if (treeMap != null && !treeMap.isEmpty()) {
                    stringBuffer.append("  v_txn_views.EXTEND(" + treeMap.size() + ");\n");
                    if (bl3) {
                        stringBuffer.append("  v_txn_views_build.EXTEND(" + treeMap.size() + ");\n" + "  v_txn_views_test.EXTEND(" + treeMap.size() + ");\n");
                    }
                    if (!bl) {
                        stringBuffer.append("  v_txn_temp_views.EXTEND(" + treeMap.size() + ");\n");
                    }
                    stringBuffer.append("\n");
                    for (TXColumn tXColumn : treeMap.values()) {
                        String string6 = tXColumn.getTxSchemaName();
                        String string7 = tXColumn.getTxTableName();
                        string3 = DatabaseMetadata.getViewText(connection, string6, string7);
                        string3 = DM4JStringUtils.escapeSingleQuotesForSQL(string3);
                        string3 = DM4JStringUtils.getReplacedString(string3, DM4JStringUtils.escapeSingleQuotesForSQL(table.getFullName()), "(' || v_case_data || ') " + DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.escapeSingleQuotesForSQL(table.getName())));
                        String string8 = tXColumn.getUniqueName();
                        iterator = linkedHashSet.iterator();
                        Table table2 = null;
                        String string9 = null;
                        boolean bl4 = false;
                        block11: while (!bl4) {
                            table2 = (Table)iterator.next();
                            ArrayList arrayList = table2.getTxnMappings();
                            for (int i = 0; i < arrayList.size(); ++i) {
                                String string10;
                                Mapping mapping = (Mapping)arrayList.get(i);
                                String string11 = string10 = mapping.getAlias() != null ? mapping.getAlias() : mapping.getName();
                                if (!string10.equals(string8)) continue;
                                bl4 = true;
                                string9 = table2.getFullName();
                                continue block11;
                            }
                        }
                        n = codeGenContext.getTxnDataPos(string9);
                        string3 = DM4JStringUtils.getReplacedString(string3, DM4JStringUtils.escapeSingleQuotesForSQL(table2.getFullName()), "(' || additional_data(" + n + ") || ')");
                        stringBuffer.append("  v_tmp_lstmt.ub := 0; -- initialize\n");
                        if (!bl) {
                            stringBuffer.append("  v_txn_temp_views(" + n2 + ") := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));\n" + "  ls_append(v_tmp_lstmt, 'CREATE VIEW ');\n" + "  ls_append(v_tmp_lstmt, v_txn_temp_views(" + n2 + "));\n" + "  ls_append(v_tmp_lstmt, ' AS ');\n");
                        }
                        stringBuffer.append("  ls_append(v_tmp_lstmt, '(');\n  ls_append(v_tmp_lstmt,\n  '" + string3 + "'\n" + "  );\n" + "  ls_append(v_tmp_lstmt, ')');\n");
                        if (!bl) {
                            stringBuffer.append("  create_table_from_query(v_tmp_lstmt);\n  v_txn_views(" + n2 + ") := v_txn_temp_views(" + n2 + ");\n");
                        } else {
                            stringBuffer.append("  v_txn_views(" + n2 + ") := v_tmp_lstmt;\n");
                        }
                        stringBuffer.append("\n");
                        ++n2;
                    }
                }
                stringBuffer.append("  ----- End: Input Data Preparation -----\n\n");
                CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<INPUT DATA PREPARATION>", stringBuffer.toString());
            }
            Object var31_40 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block27;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block27;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var31_41 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCode(CodeGenContext codeGenContext, ProgressDispatcher progressDispatcher, int n, String string) {
        int n2 = n;
        try {
            try {
                this.generateAPISignature(codeGenContext);
                this.generateInputDataPreparation(codeGenContext);
                Vector vector = this.getSteps();
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    AbstractStep abstractStep;
                    if (progressDispatcher != null) {
                        progressDispatcher.beginProcessActivity(n2, string);
                    }
                    if ((abstractStep = (AbstractStep)iterator.next()) instanceof AbstractMiningStep) {
                        CodeTemplate.updateBodyTemplate(codeGenContext.getTemplates(), "<DATA TRANSFORMATIONS>", "");
                    }
                    if (abstractStep.isSkipped(codeGenContext.getActivity()) && !(abstractStep instanceof TestMetricStep) && !(abstractStep instanceof ResidualPlotStep)) {
                        if (progressDispatcher != null) {
                            progressDispatcher.finishedProcessActivity(n2, string);
                        }
                        ++n2;
                        continue;
                    }
                    abstractStep.generateCode(codeGenContext);
                    if (progressDispatcher != null) {
                        progressDispatcher.finishedProcessActivity(n2, string);
                    }
                    ++n2;
                }
                Object var10_13 = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getActivityBundleInstance();
                    StateValidation stateValidation = new StateValidation(new StateErrorType(){}, dM4JListResourceBundle.getString("CODEGEN_CODE_GENERATION_ERROR"), new String[]{codeGenContext.getActivity().getName(), exception.getLocalizedMessage()});
                    codeGenContext.getValidations().add(stateValidation);
                }
                catch (Exception exception2) {
                }
                Object var10_14 = null;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            throw throwable;
        }
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int n) {
        this._version = n;
    }
}

