/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.resource.OraConnectionFactory;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;

public class DM4JConnectionManager {
    private static boolean _initialized = false;
    private static String _username = null;
    private static String _host = null;
    private static String _port = null;
    private static String _sid = null;
    private static String _url = null;
    private static boolean _isUsingServiceName = false;
    private static Locale _locale = null;
    private static boolean _logger = false;
    private static FileHandler _fileHandler = null;
    private static OraConnectionFactory _dmeConnFactory = null;
    private static OracleConnectionPoolDataSource _ocpds = null;

    private DM4JConnectionManager() {
    }

    public static void initialize(String string, String string2, String string3, boolean bl, String string4, char[] cArray, Locale locale) throws Exception {
        if (string == null || string2 == null || string3 == null || string4 == null || cArray == null || locale == null) {
            throw new Exception("One or more parameters is null");
        }
        _isUsingServiceName = bl;
        _url = bl ? "jdbc:oracle:thin:@//" + string + ":" + string2 + "/" + string3 : "jdbc:oracle:thin:@" + string + ":" + string2 + ":" + string3;
        _username = string4;
        _host = string;
        _port = string2;
        _sid = string3;
        _locale = locale;
        _dmeConnFactory = null;
        _ocpds = null;
        _initialized = true;
        DM4JConnectionManager.initConnectionFactory(_url, _username, cArray);
        UserPreferences userPreferences = UserPreferences.getInstance();
        if (userPreferences == null) {
            return;
        }
        _logger = userPreferences.getBooleanValue("JDMLogger");
        if (_logger && _fileHandler == null) {
            String string5 = userPreferences.getApplicationDir() + "ODMiner.log";
            _fileHandler = new FileHandler(string5);
            _fileHandler.setFormatter(new SimpleFormatter());
        }
    }

    public static void close() {
        if (_ocpds == null) {
            return;
        }
        try {
            _ocpds.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static javax.datamining.resource.Connection getConnection() throws Exception {
        if (!_initialized) {
            throw new Exception("DM4JConnectionManager.initialize() must be called before getting a connection");
        }
        javax.datamining.resource.Connection connection = _dmeConnFactory.getConnection();
        DM4JConnectionManager.fixNUMERICCHARACTERS(connection);
        if (_logger) {
            Logger logger = ((OraConnection)connection).getLogger();
            logger.setLevel(Level.FINEST);
            logger.addHandler(_fileHandler);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixNUMERICCHARACTERS(javax.datamining.resource.Connection connection) {
        PreparedStatement preparedStatement = null;
        try {
            String string = "alter session set NLS_NUMERIC_CHARACTERS=\".,\"";
            preparedStatement = ((OraConnection)connection).getDatabaseConnection().prepareStatement(string);
            boolean bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Connection getDbConnection() throws Exception {
        if (!_initialized) {
            throw new Exception("DM4JConnectionManager.initialize() must be called before getting a connection");
        }
        return _ocpds.getConnection();
    }

    private static void initConnectionFactory(String string, String string2, char[] cArray) throws Exception {
        _ocpds = new OracleConnectionPoolDataSource();
        _ocpds.setURL(string);
        _ocpds.setUser(string2);
        _ocpds.setPassword(new String(cArray));
        _ocpds.getDataSourceName();
        _dmeConnFactory = new OraConnectionFactory(_ocpds);
    }

    public static String getUser() {
        return _username;
    }

    public static String getUrl() {
        return _url;
    }

    public static String getHost() {
        return _host;
    }

    public static String getPort() {
        return _port;
    }

    public static String getSid() {
        return _sid;
    }

    public static boolean isInitialized() {
        return _initialized;
    }

    public static boolean isIsUsingServiceName() {
        return _isUsingServiceName;
    }
}

