/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.c;
import oracle.security.crypto.util.d;

public final class UnsyncHashtable
extends Dictionary
implements Cloneable,
Serializable {
    private transient d[] a;
    private transient int b;
    private int c;
    private float d;

    public UnsyncHashtable(int n, float f2) {
        if (n <= 0 || (double)f2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.d = f2;
        this.a = new d[n];
        this.c = (int)((float)n * f2);
    }

    public UnsyncHashtable(int n) {
        this(n, 0.75f);
    }

    public UnsyncHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.b;
    }

    public boolean isEmpty() {
        return this.b == 0;
    }

    public Enumeration keys() {
        return new c(this, this.a, true);
    }

    public Enumeration elements() {
        return new c(this, this.a, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        d[] dArray = this.a;
        int n = dArray.length;
        while (n-- > 0) {
            d d2 = dArray[n];
            while (d2 != null) {
                if (d2.c.equals(object)) {
                    return true;
                }
                d2 = d2.d;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        d[] dArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % dArray.length;
        d d2 = dArray[n2];
        while (d2 != null) {
            if (d2.a == n && d2.b.equals(object)) {
                return true;
            }
            d2 = d2.d;
        }
        return false;
    }

    public Object get(Object object) {
        d[] dArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % dArray.length;
        d d2 = dArray[n2];
        while (d2 != null) {
            if (d2.a == n && d2.b.equals(object)) {
                return d2.c;
            }
            d2 = d2.d;
        }
        return null;
    }

    protected void a() {
        int n = this.a.length;
        d[] dArray = this.a;
        int n2 = n * 2 + 1;
        d[] dArray2 = new d[n2];
        this.c = (int)((float)n2 * this.d);
        this.a = dArray2;
        int n3 = n;
        while (n3-- > 0) {
            d d2 = dArray[n3];
            while (d2 != null) {
                d d3 = d2;
                d2 = d2.d;
                int n4 = (d3.a & Integer.MAX_VALUE) % n2;
                d3.d = dArray2[n4];
                dArray2[n4] = d3;
            }
        }
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        d[] dArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % dArray.length;
        d d2 = dArray[n2];
        while (d2 != null) {
            if (d2.a == n && d2.b.equals(object)) {
                Object object3 = d2.c;
                d2.c = object2;
                return object3;
            }
            d2 = d2.d;
        }
        if (this.b >= this.c) {
            this.a();
            return this.put(object, object2);
        }
        d2 = new d(this, null);
        d2.a = n;
        d2.b = object;
        d2.c = object2;
        d2.d = dArray[n2];
        dArray[n2] = d2;
        ++this.b;
        return null;
    }

    public Object remove(Object object) {
        d[] dArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % dArray.length;
        d d2 = dArray[n2];
        d d3 = null;
        while (d2 != null) {
            if (d2.a == n && d2.b.equals(object)) {
                if (d3 != null) {
                    d3.d = d2.d;
                } else {
                    dArray[n2] = d2.d;
                }
                --this.b;
                return d2.c;
            }
            d3 = d2;
            d2 = d2.d;
        }
        return null;
    }

    public void clear() {
        d[] dArray = this.a;
        int n = dArray.length;
        while (--n >= 0) {
            dArray[n] = null;
        }
        this.b = 0;
    }

    public Object clone() {
        try {
            UnsyncHashtable unsyncHashtable = (UnsyncHashtable)super.clone();
            unsyncHashtable.a = new d[this.a.length];
            int n = this.a.length;
            while (n-- > 0) {
                unsyncHashtable.a[n] = this.a[n] != null ? (d)this.a[n].clone() : null;
            }
            return unsyncHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i2 = 0; i2 <= n; ++i2) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i2 >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.a.length);
        objectOutputStream.writeInt(this.b);
        for (int i2 = this.a.length - 1; i2 >= 0; --i2) {
            d d2 = this.a[i2];
            while (d2 != null) {
                objectOutputStream.writeObject(d2.b);
                objectOutputStream.writeObject(d2.c);
                d2 = d2.d;
            }
        }
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.d) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.a = new d[n3];
        this.b = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

