/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.fips.FIPS_140_2;

public class UnsyncByteArrayInputStream
extends InputStream {
    protected byte[] a;
    protected int b;
    protected int c;
    protected int d;
    private boolean e;

    public UnsyncByteArrayInputStream(byte[] byArray) {
        this.a = byArray;
        this.d = byArray.length;
    }

    public UnsyncByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.a = byArray;
        this.b = this.c = n;
        this.d = Math.min(n + n2, byArray.length);
    }

    public int read() throws IOException {
        this.a();
        return this.b < this.d ? this.a[this.b++] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.a();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.b >= this.d) {
            return -1;
        }
        if (this.b + n2 > this.d) {
            n2 = this.d - this.b;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.a, this.b, byArray, n, n2);
        this.b += n2;
        return n2;
    }

    public long skip(long l) throws IOException {
        this.a();
        if ((long)this.b + l > (long)this.d) {
            l = this.d - this.b;
        }
        if (l <= 0L) {
            return 0L;
        }
        this.b = (int)((long)this.b + l);
        return l;
    }

    public int available() throws IOException {
        this.a();
        return this.d - this.b;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.c = this.b;
    }

    public void reset() throws IOException {
        this.a();
        this.b = this.c;
    }

    public void close() throws IOException {
        this.e = true;
    }

    private void a() throws IOException {
        if (this.e) {
            throw new IOException("input stream closed");
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

