/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import oracle.security.crypto.core.EntropySource;
import oracle.security.crypto.fips.FIPS_140_2;

public class SREntropySource
extends EntropySource {
    private Method a;
    private Object b;

    public SREntropySource() {
        this(new SecureRandom());
    }

    public SREntropySource(SecureRandom secureRandom) {
        FIPS_140_2.assertReadyState();
        try {
            Class<?> clazz = secureRandom.getClass();
            Class[] classArray = new Class[]{Integer.TYPE};
            Method method = null;
            try {
                method = clazz.getMethod("generateSeed", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method != null) {
                this.a = method;
                this.b = secureRandom;
            } else {
                this.a = clazz.getMethod("getSeed", classArray);
                this.b = null;
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Problems locating a method: " + exception.toString());
        }
    }

    public byte generateByte() {
        FIPS_140_2.assertReadyState();
        try {
            Object object = this.a.invoke(this.b, new Integer(1));
            return Array.getByte(object, 0);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Problems invoking the method: " + this.a + ": " + exception.toString());
        }
    }

    public void clear() {
    }

    public synchronized byte[] generateBytes(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        try {
            Object object = this.a.invoke(this.b, new Integer(byArray.length));
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray[i2] = Array.getByte(object, i2);
            }
            return byArray;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Problems invoking the method: " + this.a + ": " + exception.toString());
        }
    }
}

