/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RSAKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class RSAPrivateKey
extends RSAKey
implements PrivateKey {
    private AlgorithmIdentifier a;
    private BigInt b;
    private BigInt c;
    private BigInt d;
    private BigInt e;
    private BigInt f;
    private BigInt g;
    private boolean h = true;
    private ASN1Sequence i;
    private ASN1Sequence j;
    private byte[] k;

    public RSAPrivateKey() {
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger, bigInteger2);
    }

    RSAPrivateKey(BigInt bigInt, BigInt bigInt2) {
        super(bigInt, bigInt2);
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3), BigInt.getInstance(bigInteger4), BigInt.getInstance(bigInteger5), BigInt.getInstance(bigInteger6), BigInt.getInstance(bigInteger7), BigInt.getInstance(bigInteger8));
    }

    RSAPrivateKey(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, BigInt bigInt4, BigInt bigInt5, BigInt bigInt6, BigInt bigInt7, BigInt bigInt8) {
        super(bigInt, bigInt2);
        this.b = bigInt3;
        this.c = bigInt4;
        this.d = bigInt5;
        this.e = bigInt6;
        this.f = bigInt7;
        this.g = bigInt8;
        this.e();
        this.m();
    }

    public RSAPrivateKey(File file) throws FileNotFoundException, IOException {
        this(new FileInputStream(file));
    }

    public RSAPrivateKey(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public RSAPrivateKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public byte[] getEncoded() {
        this.a();
        return (byte[])this.d().clone();
    }

    byte[] d() {
        FIPS_140_2.assertReadyState();
        if (this.k == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(0L));
            aSN1Sequence.addElement(this.getAlgID());
            aSN1Sequence.addElement(new ASN1OctetString(Utils.toBytes(this.e())));
            this.k = Utils.toBytes(aSN1Sequence);
        }
        return this.k;
    }

    private void l() {
        if (this.k != null) {
            Utils.setArray(this.k, (byte)0);
            this.k = null;
        }
        this.i = null;
        if (this.j != null) {
            ((ASN1Integer)this.j.elementAt(3)).erase();
            ((ASN1Integer)this.j.elementAt(4)).erase();
            ((ASN1Integer)this.j.elementAt(5)).erase();
            ((ASN1Integer)this.j.elementAt(6)).erase();
            ((ASN1Integer)this.j.elementAt(7)).erase();
            ((ASN1Integer)this.j.elementAt(8)).erase();
            this.j = null;
        }
    }

    public boolean getAllowExport() {
        return this.h;
    }

    public void setAllowExport(boolean bl) {
        this.h = bl;
    }

    public void erase() {
        super.erase();
        this.l();
        this.b = null;
        if (this.c != null) {
            this.c.erase();
            this.c = null;
        }
        if (this.d != null) {
            this.d.erase();
            this.d = null;
        }
        if (this.e != null) {
            this.e.erase();
            this.e = null;
        }
        if (this.f != null) {
            this.f.erase();
            this.f = null;
        }
        if (this.g != null) {
            this.g.erase();
            this.g = null;
        }
    }

    public void finalize() {
        this.erase();
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public Object clone() {
        BigInt bigInt;
        FIPS_140_2.assertReadyState();
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
        try {
            if (this.a != null) {
                rSAPrivateKey.a = new AlgorithmIdentifier(Utils.toStream(this.a));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        BigInt bigInt2 = this.b();
        if (bigInt2 != null) {
            bigInt2 = BigInt.getInstance(bigInt2);
        }
        if ((bigInt = this.c()) != null) {
            bigInt = BigInt.getInstance(bigInt);
        }
        rSAPrivateKey.a(bigInt2, bigInt);
        if (this.b != null) {
            rSAPrivateKey.b = BigInt.getInstance(this.b);
        }
        if (this.c != null) {
            rSAPrivateKey.c = BigInt.getInstance(this.c);
        }
        if (this.d != null) {
            rSAPrivateKey.d = BigInt.getInstance(this.d);
        }
        if (this.e != null) {
            rSAPrivateKey.e = BigInt.getInstance(this.e);
        }
        if (this.f != null) {
            rSAPrivateKey.f = BigInt.getInstance(this.f);
        }
        if (this.g != null) {
            rSAPrivateKey.g = BigInt.getInstance(this.g);
        }
        rSAPrivateKey.h = this.h;
        return rSAPrivateKey;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
        if (aSN1Object2 != null && !(aSN1Object2 instanceof ASN1Null)) {
            throw new AlgorithmIdentifierException();
        }
        this.a(aSN1Object);
        this.a = algorithmIdentifier;
    }

    private void a(ASN1Object aSN1Object) throws InvalidInputException {
        this.erase();
        try {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Object;
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!aSN1Integer.equals(0)) {
                throw new VersionException(aSN1Integer.getValue(), 0);
            }
            BigInt bigInt = ((ASN1Integer)aSN1Sequence.elementAt(1)).getBigIntValue();
            BigInt bigInt2 = ((ASN1Integer)aSN1Sequence.elementAt(3)).getBigIntValue();
            this.a(bigInt, bigInt2);
            this.b = ((ASN1Integer)aSN1Sequence.elementAt(2)).getBigIntValue();
            this.c = ((ASN1Integer)aSN1Sequence.elementAt(4)).getBigIntValue();
            this.d = ((ASN1Integer)aSN1Sequence.elementAt(5)).getBigIntValue();
            this.e = ((ASN1Integer)aSN1Sequence.elementAt(6)).getBigIntValue();
            this.f = ((ASN1Integer)aSN1Sequence.elementAt(7)).getBigIntValue();
            this.g = ((ASN1Integer)aSN1Sequence.elementAt(8)).getBigIntValue();
        }
        catch (VersionException versionException) {
            throw new InvalidInputException(versionException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidInputException(arrayIndexOutOfBoundsException.toString());
        }
        this.a = null;
        this.e();
        this.m();
    }

    private void m() {
        if (this.c.compareTo(this.d) < 0) {
            BigInt bigInt = this.c;
            this.c = this.d;
            this.d = bigInt;
            bigInt = this.e;
            this.e = this.f;
            this.f = bigInt;
            this.g = this.d.modInverse(this.c);
        }
    }

    public ASN1Object getContents() {
        this.a();
        FIPS_140_2.assertReadyState();
        if (this.i == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)this.e();
            int n = aSN1Sequence2.size();
            for (int i2 = 0; i2 < n; ++i2) {
                ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence2.elementAt(i2);
                aSN1Sequence.addElement(new ASN1Integer(BigInt.getInstance(aSN1Integer.getBigIntValue())));
            }
            this.i = aSN1Sequence;
        }
        return this.i;
    }

    ASN1Object e() {
        FIPS_140_2.assertReadyState();
        if (this.j == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            try {
                aSN1Sequence.addElement(new ASN1Integer(0L));
                aSN1Sequence.addElement(new ASN1Integer(this.b()));
                aSN1Sequence.addElement(new ASN1Integer(this.b));
                aSN1Sequence.addElement(new ASN1Integer(this.c()));
                aSN1Sequence.addElement(new ASN1Integer(this.c));
                aSN1Sequence.addElement(new ASN1Integer(this.d));
                aSN1Sequence.addElement(new ASN1Integer(this.e));
                aSN1Sequence.addElement(new ASN1Integer(this.f));
                aSN1Sequence.addElement(new ASN1Integer(this.g));
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalStateException("Complete CRT representation required for ASN.1 output");
            }
            this.j = aSN1Sequence;
        }
        return this.j;
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            this.a = AlgID.rsaEncryption;
        }
        return this.a;
    }

    public boolean isPublic() {
        return false;
    }

    public RSAPublicKey getPublicKey() {
        return new RSAPublicKey(this.b(), this.f());
    }

    public BigInteger getPublicExponent() {
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.b.toByteArray());
    }

    BigInt f() {
        FIPS_140_2.assertReadyState();
        return this.b;
    }

    public BigInteger getPrimeP() {
        this.a();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.c.toByteArray());
    }

    BigInt g() {
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    public BigInteger getPrimeQ() {
        this.a();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.d.toByteArray());
    }

    BigInt h() {
        FIPS_140_2.assertReadyState();
        return this.d;
    }

    public BigInteger getPrimeExponentP() {
        this.a();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.e.toByteArray());
    }

    BigInt i() {
        FIPS_140_2.assertReadyState();
        return this.e;
    }

    public BigInteger getPrimeExponentQ() {
        this.a();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.f.toByteArray());
    }

    BigInt j() {
        FIPS_140_2.assertReadyState();
        return this.f;
    }

    public BigInteger getCrtCoefficient() {
        this.a();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.g.toByteArray());
    }

    BigInt k() {
        FIPS_140_2.assertReadyState();
        return this.g;
    }

    public void input(InputStream inputStream) throws IOException {
        block6: {
            FIPS_140_2.assertReadyState();
            try {
                ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
                if (aSN1Sequence.size() == 3 || aSN1Sequence.size() == 4) {
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
                    if (!aSN1Integer.equals(0)) {
                        throw new VersionException(aSN1Integer.getValue(), 0);
                    }
                    AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
                    ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1OctetString)aSN1Sequence.elementAt(2)).getValue());
                    this.initialize(algorithmIdentifier, aSN1Object);
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Object;
                    ((ASN1Integer)aSN1Sequence2.elementAt(3)).erase();
                    ((ASN1Integer)aSN1Sequence2.elementAt(4)).erase();
                    ((ASN1Integer)aSN1Sequence2.elementAt(5)).erase();
                    ((ASN1Integer)aSN1Sequence2.elementAt(6)).erase();
                    ((ASN1Integer)aSN1Sequence2.elementAt(7)).erase();
                    ((ASN1Integer)aSN1Sequence2.elementAt(8)).erase();
                    break block6;
                }
                if (aSN1Sequence.size() == 9) {
                    this.a(aSN1Sequence);
                    ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                    ((ASN1Integer)aSN1Sequence.elementAt(4)).erase();
                    ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
                    ((ASN1Integer)aSN1Sequence.elementAt(6)).erase();
                    ((ASN1Integer)aSN1Sequence.elementAt(7)).erase();
                    ((ASN1Integer)aSN1Sequence.elementAt(8)).erase();
                    break block6;
                }
                throw new ASN1FormatException("Sequence has wrong number of components.");
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new InvalidInputException(algorithmIdentifierException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new InvalidInputException(classCastException.toString());
            }
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public int length() {
        return this.d().length;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "{ modulus = " + this.getAlgID() + ", " + "publicExponent = " + this.f() + " }";
    }
}

