/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.DigestInfo;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.Signature;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.Utils;

public final class RSAMDSignature
extends Signature {
    public static final ASN1ObjectID rsaKeyOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 1);
    public static final ASN1ObjectID rsaMD2SigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 2);
    public static final ASN1ObjectID rsaMD5SigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 4);
    public static final ASN1ObjectID rsaSHASigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 5);
    public static final ASN1ObjectID rsaSHASigOldOID = new ASN1ObjectID(ASN1Utils.oiwAlgID, 29);
    private RSAPublicKey c;
    private RSAPrivateKey d;
    private AlgorithmIdentifier e;
    private static AlgorithmIdentifier f = AlgID.md5;
    private RandomBitsSource g;
    private byte[] h = null;

    public RSAMDSignature() {
        this.e = f;
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey) {
        this(rSAPublicKey, f);
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, AlgorithmIdentifier algorithmIdentifier) {
        this.c = rSAPublicKey;
        this.setMessageDigestAlgID(algorithmIdentifier);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey) {
        this(rSAPrivateKey, f);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.d = rSAPrivateKey;
        this.setMessageDigestAlgID(algorithmIdentifier);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this(rSAPrivateKey, f, byArray);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws SignatureException {
        this(rSAPrivateKey, algorithmIdentifier);
        this.setDocument(byArray);
        this.sign();
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, byte[] byArray, byte[] byArray2) {
        this(rSAPublicKey);
        this.setSigBytes(byArray);
        this.setDocument(byArray2);
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier.equals(AlgID.md2WithRSAEncryption)) {
            this.e = AlgID.md2;
        } else if (algorithmIdentifier.equals(AlgID.md5WithRSAEncryption)) {
            this.e = AlgID.md5;
        } else if (algorithmIdentifier.equals(AlgID.sha_1WithRSAEncryption)) {
            this.e = AlgID.sha_1;
        } else {
            throw new AlgorithmIdentifierException("Invalid AlgorithmIdentifier for RSAMDSignature");
        }
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.e.equals(AlgID.md2)) {
            return AlgID.md2WithRSAEncryption;
        }
        if (this.e.equals(AlgID.md5)) {
            return AlgID.md5WithRSAEncryption;
        }
        if (this.e.equals(AlgID.sha_1)) {
            return AlgID.sha_1WithRSAEncryption;
        }
        throw new IllegalStateException("No appropriate algorithm identifier.");
    }

    public AlgorithmIdentifier getDigestEncryptionAlgID() {
        FIPS_140_2.assertReadyState();
        return AlgID.rsaEncryption;
    }

    public void setMessageDigestAlgID(AlgorithmIdentifier algorithmIdentifier) {
        FIPS_140_2.assertReadyState();
        this.e = algorithmIdentifier;
    }

    public AlgorithmIdentifier getMessageDigestAlgID() {
        FIPS_140_2.assertReadyState();
        return this.e;
    }

    public String algName() {
        if (this.e.equals(AlgID.md2)) {
            return "RSA/MD2";
        }
        if (this.e.equals(AlgID.md5)) {
            return "RSA/MD5";
        }
        if (this.e.equals(AlgID.sha_1)) {
            return "RSA/SHA";
        }
        throw new IllegalStateException("No appropriate algorithm identifier.");
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.c = (RSAPublicKey)publicKey;
    }

    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.d = (RSAPrivateKey)privateKey;
    }

    public void setHash(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        this.h = byArray;
        this.b = null;
    }

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.g = randomBitsSource;
    }

    /*
     * Exception decompiling
     */
    public boolean verify() throws AuthenticationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] sign() throws SignatureException {
        FIPS_140_2.assertReadyState();
        try {
            Object object;
            byte[] byArray = null;
            if (this.h != null) {
                byArray = this.h;
            } else {
                object = MessageDigest.getInstance(this.e);
                ((MessageDigest)object).computeDigest(this.getDocument());
                byArray = Utils.toBytes(new DigestInfo(((MessageDigest)object).getAlgID(), ((MessageDigest)object).a()));
            }
            object = Cipher.getInstance(AlgID.rsaEncryption, this.d, this.g);
            this.setSigBytes(((Cipher)object).encrypt(byArray));
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
        catch (CipherException cipherException) {
            throw new SignatureException(cipherException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        return this.getSigBytes();
    }
}

