/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.j;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public abstract class MessageDigest
implements Cloneable {
    public byte[] digestBits;
    public boolean digestValid;
    protected AlgorithmIdentifier a;

    protected MessageDigest() {
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        this.a = algorithmIdentifier;
    }

    public abstract AlgorithmIdentifier getAlgID();

    public abstract int blockSize();

    public static MessageDigest getInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        MessageDigest messageDigest;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "messageDigest");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        try {
            messageDigest = (MessageDigest)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement Message Digest.");
        }
        messageDigest.setAlgID(algorithmIdentifier);
        return messageDigest;
    }

    public abstract void init();

    public abstract void update(byte var1);

    public void update(boolean bl) {
        if (bl) {
            this.update((byte)1);
        } else {
            this.update((byte)0);
        }
    }

    public void update(short s) {
        this.update(Utils.shortToBytes(s));
    }

    public void update(int n) {
        this.update(Utils.wordToBytes(n));
    }

    public void update(long l) {
        this.update(Utils.longToBytes(l));
    }

    public void update(byte[] byArray, int n, int n2) {
        for (int i2 = n; i2 < n + n2; ++i2) {
            this.update(byArray[i2]);
        }
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(short[] sArray) {
        byte[] byArray = new byte[sArray.length << 1];
        Utils.shortsToBytes(sArray, byArray);
        this.update(byArray);
    }

    public void update(int[] nArray) {
        byte[] byArray = new byte[nArray.length << 2];
        Utils.wordsToBytes(nArray, byArray);
        this.update(byArray);
    }

    public void update(long[] lArray) {
        byte[] byArray = new byte[lArray.length << 3];
        Utils.longsToBytes(lArray, byArray);
        this.update(byArray);
    }

    public void update(String string) {
        this.update(Utils.unicodeToBytes(string));
    }

    public void update(SymmetricKey symmetricKey) {
        this.update(symmetricKey.d());
    }

    public void updateASCII(String string) {
        try {
            byte[] byArray = string.getBytes("ASCII");
            this.update(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException.toString());
        }
    }

    public void update(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            this.update(byArray, 0, n);
        }
    }

    public abstract void computeCurrent();

    public byte[] getDigestBits() {
        return (byte[])this.a().clone();
    }

    byte[] a() {
        FIPS_140_2.assertReadyState();
        return this.digestBits;
    }

    public boolean isValid() {
        return this.digestValid;
    }

    public byte[] computeDigest(byte[] byArray) {
        this.init();
        this.update(byArray);
        this.computeCurrent();
        return this.getDigestBits();
    }

    public byte[] computeDigest(Streamable streamable) throws IOException {
        if (streamable instanceof PrivateKey) {
            return this.computeDigest(j.a((PrivateKey)streamable));
        }
        return this.computeDigest(Utils.toBytes(streamable));
    }

    public boolean isEqual(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        return Utils.areEqual(this.digestBits, byArray);
    }

    public abstract String algName();

    public abstract int getDigestLength();

    public String toString() {
        FIPS_140_2.assertReadyState();
        return this.algName() + (this.digestValid ? " " + Utils.toHexString(this.digestBits) : "");
    }

    public abstract Object clone();

    protected abstract MDState b();

    protected abstract void a(MDState var1);

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public abstract class MDState {
        private final MessageDigest a;

        protected MDState(MessageDigest messageDigest) {
            this.a = messageDigest;
        }

        public abstract void init();

        public abstract Object clone();

        public abstract void copyTo(MDState var1);
    }
}

