/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.KeyPair;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.OIDManager;

public abstract class KeyPairGenerator {
    protected RandomBitsSource a;

    protected KeyPairGenerator() {
    }

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.a = randomBitsSource != null ? randomBitsSource : RandomBitsSource.getDefault();
    }

    public abstract void initialize(int var1, RandomBitsSource var2);

    public abstract void setAlgID(AlgorithmIdentifier var1) throws AlgorithmIdentifierException;

    public abstract KeyPair generateKeyPair();

    public abstract String getAlgorithm();

    public static KeyPairGenerator getInstance(AlgorithmIdentifier algorithmIdentifier) throws IllegalArgumentException {
        KeyPairGenerator keyPairGenerator;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "keyPairGenerator");
        if (clazz == null) {
            throw new IllegalArgumentException("Can not find a key pair generator for this algorithm ID.");
        }
        try {
            keyPairGenerator = (KeyPairGenerator)clazz.newInstance();
            keyPairGenerator.setAlgID(algorithmIdentifier);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Unable to access " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.toString());
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalArgumentException(algorithmIdentifierException.toString());
        }
        return keyPairGenerator;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

