/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.SpinnerEntropySource;
import oracle.security.crypto.fips.FIPS_140_2;

public abstract class EntropySource {
    private static EntropySource a;
    private static final Object b;

    protected EntropySource() {
    }

    public abstract byte generateByte();

    public synchronized byte[] generateBytes(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = this.generateByte();
        }
        return byArray;
    }

    public abstract void clear();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntropySource getDefault() {
        FIPS_140_2.assertReadyState();
        if (a == null) {
            Object object = b;
            synchronized (object) {
                if (a == null) {
                    a = new SpinnerEntropySource();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(EntropySource entropySource) {
        FIPS_140_2.assertReadyState();
        Object object = b;
        synchronized (object) {
            a = entropySource;
        }
    }

    static {
        b = new Object();
        FIPS_140_2.powerUpSelfTest();
    }
}

