/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DSA;
import oracle.security.crypto.core.DSAParams;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class DSAPublicKey
implements PublicKey,
ASN1Object {
    private ASN1ObjectID a = DSA.dsaKeyOID;
    private DSAParams b;
    private BigInt c;
    private byte[] d;

    public DSAPublicKey() {
    }

    public DSAPublicKey(BigInteger bigInteger, DSAParams dSAParams) {
        this(BigInt.getInstance(bigInteger), dSAParams);
    }

    DSAPublicKey(BigInt bigInt, DSAParams dSAParams) {
        FIPS_140_2.assertReadyState();
        this.c = bigInt;
        this.b = dSAParams;
    }

    public DSAPublicKey(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public DSAPublicKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public DSAPublicKey(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toStream(aSN1Sequence));
    }

    public byte[] getEncoded() {
        FIPS_140_2.assertReadyState();
        if (this.d == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            aSN1Sequence2.addElement(this.a);
            aSN1Sequence2.addElement(this.b);
            aSN1Sequence.addElement(aSN1Sequence2);
            aSN1Sequence.addElement(new ASN1BitString(Utils.toBytes(this.getContents())));
            this.d = Utils.toBytes(aSN1Sequence);
        }
        return this.d;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        if (this.b == null || this.b.getP() == null) {
            return 0;
        }
        return this.b.getP().bitLength();
    }

    public String getFormat() {
        return "X.509";
    }

    public void erase() {
        this.b = null;
        this.c = null;
        this.d = null;
    }

    public void finalize() {
        this.erase();
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        DSAPublicKey dSAPublicKey = new DSAPublicKey();
        try {
            if (this.a != null) {
                dSAPublicKey.a = new ASN1ObjectID(Utils.toStream(this.a));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        try {
            if (this.b != null) {
                dSAPublicKey.b = new DSAParams(Utils.toStream(this.b));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key DSA parameters to stream");
        }
        if (this.c != null) {
            dSAPublicKey.c = BigInt.getInstance(this.c);
        }
        return dSAPublicKey;
    }

    public boolean getAllowExport() {
        return true;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        this.a = algorithmIdentifier.getOID();
        try {
            this.b = new DSAParams((ASN1Sequence)algorithmIdentifier.getParameters());
        }
        catch (IOException iOException) {
            throw new AlgorithmIdentifierException("Invalid DSA parameters.");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Invalid DSA parameters.");
        }
        if (this.b == null) {
            throw new AlgorithmIdentifierException("DSA parameters missing.");
        }
        try {
            this.c = ((ASN1Integer)aSN1Object).getBigIntValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException("Contents invalid.");
        }
        this.d = null;
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(this.a, this.b);
    }

    public ASN1Object getContents() {
        FIPS_140_2.assertReadyState();
        return new ASN1Integer(this.c);
    }

    public ASN1ObjectID getKeyAlgOID() {
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public void setKeyAlgOID(ASN1ObjectID aSN1ObjectID) {
        FIPS_140_2.assertReadyState();
        this.a = aSN1ObjectID;
        this.d = null;
    }

    public BigInteger getY() {
        return new BigInteger(this.a().toByteArray());
    }

    BigInt a() {
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    public void setParams(DSAParams dSAParams) {
        FIPS_140_2.assertReadyState();
        this.b = dSAParams;
        this.d = null;
    }

    public DSAParams getParams() {
        FIPS_140_2.assertReadyState();
        return this.b;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "y = " + this.c + ", params = {" + this.b + "}";
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1SequenceInputStream);
        ASN1Integer aSN1Integer = new ASN1Integer(new UnsyncByteArrayInputStream(ASN1BitString.inputValue(aSN1SequenceInputStream)));
        aSN1SequenceInputStream.terminate();
        try {
            this.initialize(algorithmIdentifier, aSN1Integer);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public int length() {
        return this.getEncoded().length;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

